/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.service.layout.jlayout;

import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.service.layout.jlayout.AccessiblityUtils;
import com.tomsawyer.editor.service.layout.jlayout.TSEHierarchicalTab;
import com.tomsawyer.service.TSServiceInputData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class TSEHierarchicalTabExt
extends TSEHierarchicalTab {
    public static TSEResourceBundleWrapper tsBundle = TSEResourceBundleWrapper.getSystemLabelBundle();

    public TSEHierarchicalTabExt(TSEGraph tSEGraph, TSServiceInputData tSServiceInputData, JDialog jDialog) {
        super(tSEGraph, tSServiceInputData, jDialog);
        this.setA11yFeatures();
    }

    protected JPanel makeOrientationPanel() {
        JPanel jPanel = this.createBoxLayoutPanel(0);
        JPanel jPanel2 = this.createBoxLayoutPanel(1);
        this.orientationTopToBottom = this.createRadioButton("Top_To_Bottom", "ORIENTATION_TOP_TO_BOTTOM");
        this.orientationLeftToRight = this.createRadioButton("Left_To_Right", "ORIENTATION_LEFT_TO_RIGHT");
        this.orientationBottomToTop = this.createRadioButton("Bottom_To_Top", "ORIENTATION_BOTTOM_TO_TOP");
        this.orientationRightToLeft = this.createRadioButton("Right_To_Left", "ORIENTATION_RIGHT_TO_LEFT");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.orientationTopToBottom);
        buttonGroup.add(this.orientationLeftToRight);
        buttonGroup.add(this.orientationBottomToTop);
        buttonGroup.add(this.orientationRightToLeft);
        jPanel2.add(this.orientationTopToBottom);
        jPanel2.add(this.createVerticalRigidArea(5));
        jPanel2.add(this.orientationLeftToRight);
        jPanel2.add(this.createVerticalRigidArea(5));
        jPanel2.add(this.orientationBottomToTop);
        jPanel2.add(this.createVerticalRigidArea(5));
        jPanel2.add(this.orientationRightToLeft);
        jPanel.add(jPanel2);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.createCompoundBorder(jPanel, "Orientation", 0, 5, 5, 5);
        return jPanel;
    }

    protected JPanel makeLevelAlignmentPanel() {
        JPanel jPanel = this.createBoxLayoutPanel(0);
        JPanel jPanel2 = this.createBoxLayoutPanel(1);
        this.alignmentTop = this.createRadioButton("Top");
        this.alignmentCenter = this.createRadioButton("Center");
        this.alignmentBottom = this.createRadioButton("Bottom");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.alignmentTop);
        buttonGroup.add(this.alignmentCenter);
        buttonGroup.add(this.alignmentBottom);
        jPanel2.add(this.alignmentTop);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel2.add(this.alignmentCenter);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel2.add(this.alignmentBottom);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel.add(jPanel2);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.createCompoundBorder(jPanel, "Level_Alignment", 0, 5, 5, 5);
        return jPanel;
    }

    protected JPanel makeHorizontalSpacingPanel() {
        JPanel jPanel = this.createBoxLayoutPanel(0);
        JPanel jPanel2 = this.createBoxLayoutPanel(1);
        JPanel jPanel3 = this.createBoxLayoutPanel(1);
        this.horizontalSpacingBetweenNodesField = this.createDoubleField(4, 0.0, 9999.0);
        this.horizontalSpacingBetweenEdgesField = this.createDoubleField(4, 0.0, 9999.0);
        JLabel jLabel = this.createLabel("Spacing_Between_Nodes", "Horizontal_Spacing_Between_Nodes_1", (Component)this.horizontalSpacingBetweenNodesField);
        JLabel jLabel2 = this.createLabel("Spacing_Between_Edges", null, (Component)this.horizontalSpacingBetweenEdgesField);
        jPanel2.add(jLabel);
        jPanel2.add(this.createVerticalRigidArea(9));
        jPanel2.add(jLabel2);
        jPanel3.add((Component)this.horizontalSpacingBetweenNodesField);
        jPanel3.add(this.createVerticalRigidArea(5));
        jPanel3.add((Component)this.horizontalSpacingBetweenEdgesField);
        jPanel.add(jPanel2);
        jPanel.add(this.createHorizontalRigidArea(15));
        jPanel.add(jPanel3);
        this.createCompoundBorder(jPanel, "Horizontal_Spacing", 0, 5, 5, 5);
        return jPanel;
    }

    protected JPanel makeVerticalSpacingPanel() {
        JPanel jPanel = this.createBoxLayoutPanel(0);
        JPanel jPanel2 = this.createBoxLayoutPanel(1);
        JPanel jPanel3 = this.createBoxLayoutPanel(1);
        this.verticalSpacingBetweenNodesField = this.createDoubleField(4, 0.0, 9999.0);
        this.verticalSpacingBetweenEdgesField = this.createDoubleField(4, 0.0, 9999.0);
        JLabel jLabel = this.createLabel("Spacing_Between_Nodes", "Vertical_Spacing_Between_Nodes_2", (Component)this.verticalSpacingBetweenNodesField);
        JLabel jLabel2 = this.createLabel("Spacing_Between_Edges", null, (Component)this.verticalSpacingBetweenEdgesField);
        jPanel2.add(jLabel);
        jPanel2.add(this.createVerticalRigidArea(9));
        jPanel2.add(jLabel2);
        jPanel3.add((Component)this.verticalSpacingBetweenNodesField);
        jPanel3.add(this.createVerticalRigidArea(5));
        jPanel3.add((Component)this.verticalSpacingBetweenEdgesField);
        jPanel.add(jPanel2);
        jPanel.add(this.createHorizontalRigidArea(15));
        jPanel.add(jPanel3);
        this.createCompoundBorder(jPanel, "Vertical_Spacing", 0, 5, 5, 5);
        return jPanel;
    }

    protected JPanel makePolylineRoutingPanel() {
        JPanel jPanel = this.createBoxLayoutPanel(0);
        this.spacingBetweenBendsField = this.createDoubleField(4, 0.0, 9999.0);
        this.spacingBetweenBendsField.setAlignmentY(0.0f);
        JLabel jLabel = this.createLabel("Spacing_Between_Bends", "Spacing_Between_Bends", (Component)this.spacingBetweenBendsField);
        jPanel.add(jLabel);
        jPanel.add(this.createHorizontalRigidArea(15));
        jPanel.add((Component)this.spacingBetweenBendsField);
        this.createCompoundBorder(jPanel, "Polyline_Routing", 0, 5, 5, 5);
        return jPanel;
    }

    protected JPanel createBoxLayoutPanel(int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, n));
        jPanel.setAlignmentX(0.0f);
        jPanel.setAlignmentY(0.0f);
        return jPanel;
    }

    protected JLabel createLabel(String string, String string2, Component component) {
        JLabel jLabel = new JLabel(tsBundle.getStringSafely(string) + ":");
        jLabel.setForeground(this.labelColor);
        jLabel.setAlignmentX(0.0f);
        jLabel.setAlignmentY(0.0f);
        jLabel.setLabelFor(component);
        if (string2 != null) {
            jLabel.setDisplayedMnemonic(AccessiblityUtils.getMnemonic(string2));
        }
        return jLabel;
    }

    public void createCompoundBorder(JPanel jPanel, String string, int n, int n2, int n3, int n4) {
        String string2 = tsBundle.getStringSafely(string);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string2);
        titledBorder.setTitleColor(this.labelColor);
        jPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(n, n2, n3, n4)));
    }

    protected int normalizeComponentDimensions(List list, boolean bl, boolean bl2) {
        int n = -1;
        return n;
    }

    public void setA11yFeatures() {
        Font font = this.getFont();
        this.orientationBottomToTop.setMnemonic(AccessiblityUtils.getMnemonic("Bottom_To_Top"));
        this.alignmentTop.setMnemonic(AccessiblityUtils.getMnemonic("Top"));
        this.qualityDraftRadioButton.setMnemonic(AccessiblityUtils.getMnemonic("Draft"));
        this.routingOrthogonalRadioButton.setMnemonic(AccessiblityUtils.getMnemonic("Orthogonal"));
        this.variableLevelSpacing.setMnemonic(AccessiblityUtils.getMnemonic("Variable_Level_Spacing"));
        this.orientationLeftToRight.setFont(font);
        this.orientationBottomToTop.setFont(font);
        this.orientationRightToLeft.setFont(font);
        this.orientationTopToBottom.setFont(font);
        this.alignmentTop.setFont(font);
        this.alignmentCenter.setFont(font);
        this.alignmentBottom.setFont(font);
        this.qualityDraftRadioButton.setFont(font);
        this.qualityDefaultRadioButton.setFont(font);
        this.qualityProofRadioButton.setFont(font);
        this.routingOrthogonalRadioButton.setFont(font);
        this.routingPolylineRadioButton.setFont(font);
        this.fixNodeSizesCheckBox.setFont(font);
        this.variableLevelSpacing.setFont(font);
        this.undirected.setFont(font);
        AccessiblityUtils.setAccessibleProperties(this.orientationLeftToRight, null, "Left_To_Right");
        AccessiblityUtils.setAccessibleProperties(this.orientationBottomToTop, null, "Bottom_To_Top");
        AccessiblityUtils.setAccessibleProperties(this.orientationRightToLeft, null, "Right_To_Left");
        AccessiblityUtils.setAccessibleProperties(this.orientationTopToBottom, null, "Top_To_Bottom");
        AccessiblityUtils.setAccessibleProperties(this.alignmentTop, null, "Top");
        AccessiblityUtils.setAccessibleProperties(this.alignmentCenter, null, "Center");
        AccessiblityUtils.setAccessibleProperties(this.alignmentBottom, null, "Bottom");
        AccessiblityUtils.setAccessibleProperties(this.qualityDraftRadioButton, null, "Draft");
        AccessiblityUtils.setAccessibleProperties(this.qualityDefaultRadioButton, null, "Default");
        AccessiblityUtils.setAccessibleProperties(this.qualityProofRadioButton, null, "Proof");
        AccessiblityUtils.setAccessibleProperties(this.routingOrthogonalRadioButton, null, "Orthogonal");
        AccessiblityUtils.setAccessibleProperties(this.routingPolylineRadioButton, null, "Polyline");
        AccessiblityUtils.setAccessibleProperties(this.fixNodeSizesCheckBox, null, "Fix_Node_Sizes");
        AccessiblityUtils.setAccessibleProperties(this.variableLevelSpacing, null, "Variable_Level_Spacing");
        AccessiblityUtils.setAccessibleProperties(this.undirected, null, "Undirected_Layout");
        AccessiblityUtils.setAccessibleProperties((Component)this.horizontalSpacingBetweenEdgesField, null, "Horizontal_Spacing_Between_Edges");
        AccessiblityUtils.setAccessibleProperties((Component)this.horizontalSpacingBetweenNodesField, null, "Horizontal_Spacing_Between_Nodes");
        AccessiblityUtils.setAccessibleProperties((Component)this.verticalSpacingBetweenEdgesField, null, "Vertical_Spacing_Between_Edges");
        AccessiblityUtils.setAccessibleProperties((Component)this.verticalSpacingBetweenNodesField, null, "Vertical_Spacing_Between_Nodes");
        AccessiblityUtils.setAccessibleProperties((Component)this.spacingBetweenBendsField, null, "Spacing_Between_Bends");
        this.getAccessibleContext().setAccessibleDescription(this.getAccessibleContext().getAccessibleName());
    }
}

