/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.netbeans.api.java.source.JavaSource;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public abstract class HintAction
extends AbstractAction
implements PropertyChangeListener {
    protected HintAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
        this.updateEnabled();
    }

    private void updateEnabled() {
        this.setEnabled(this.getCurrentFile(null) != null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.doPerform();
        if (string != null) {
            String string2 = NbBundle.getMessage(HintAction.class, (String)string);
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
        }
    }

    private String doPerform() {
        int[] nArray = new int[2];
        FileObject fileObject = this.getCurrentFile(nArray);
        if (fileObject == null) {
            if (nArray[0] != nArray[1]) {
                return "ERR_Not_Selected";
            }
            return "ERR_No_Selection";
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource == null) {
            return "ERR_Not_Supported";
        }
        this.perform(javaSource, nArray);
        return null;
    }

    protected abstract void perform(JavaSource var1, int[] var2);

    private FileObject getCurrentFile(int[] nArray) {
        Document document;
        Object object;
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        JEditorPane jEditorPane = null;
        if (topComponent instanceof CloneableEditorSupport.Pane) {
            jEditorPane = ((CloneableEditorSupport.Pane)topComponent).getEditorPane();
        }
        if (jEditorPane == null) {
            return null;
        }
        if (nArray != null) {
            nArray[0] = jEditorPane.getSelectionStart();
            nArray[1] = jEditorPane.getSelectionEnd();
            if (nArray[0] == nArray[1] && this.requiresSelection()) {
                return null;
            }
        }
        Object object2 = object = (document = jEditorPane.getDocument()) != null ? document.getProperty("stream") : null;
        if (!(object instanceof DataObject)) {
            return null;
        }
        DataObject dataObject = (DataObject)object;
        FileObject fileObject = dataObject.getPrimaryFile();
        if ("text/x-java".equals(FileUtil.getMIMEType((FileObject)fileObject))) {
            return fileObject;
        }
        return null;
    }

    protected boolean requiresSelection() {
        return true;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateEnabled();
    }
}

