/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.semantic.RemoveUnusedImportFix;
import org.netbeans.modules.java.hints.ForbiddenImportsCustomizer;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Imports
extends AbstractHint
implements PreferenceChangeListener {
    private static final String DEFAULT_PACKAGE = "java.lang";
    private static final List<Fix> NO_FIXES = Collections.emptyList();
    private static Imports delegate;
    private Imports duplicate;
    private Imports defaultPackage;
    private Imports samePackage;
    private Imports forbiddenPackage;
    private Imports unused;
    private Imports star;
    private String IMPORTS_ID = "Imports_";
    private Set<Tree.Kind> treeKinds;
    private ImportHintKind kind;

    private Imports(ImportHintKind importHintKind) {
        super(importHintKind.defaultOn(), true, AbstractHint.HintSeverity.WARNING, new String[0]);
        this.kind = importHintKind;
        this.treeKinds = importHintKind == ImportHintKind.DELEGATE ? EnumSet.of(Tree.Kind.COMPILATION_UNIT) : EnumSet.noneOf(Tree.Kind.class);
    }

    public static Imports createDelegate() {
        return Imports.getDelegate();
    }

    public static Imports createDuplicate() {
        Imports imports = Imports.getDelegate();
        imports.duplicate = new Imports(ImportHintKind.DUPLICATE);
        return Imports.getDelegate();
    }

    public static Imports createDefaultPackage() {
        Imports imports = Imports.getDelegate();
        imports.defaultPackage = new Imports(ImportHintKind.DEFAULT_PACKAGE);
        return imports.defaultPackage;
    }

    public static Imports createForbidden() {
        Imports imports = Imports.getDelegate();
        imports.forbiddenPackage = new Imports(ImportHintKind.FORBIDDEN);
        return imports.forbiddenPackage;
    }

    public static Imports createSamePackage() {
        Imports imports = Imports.getDelegate();
        imports.samePackage = new Imports(ImportHintKind.SAME_PACKAGE);
        return imports.samePackage;
    }

    public static Imports createUnused() {
        Imports imports = Imports.getDelegate();
        imports.unused = new Imports(ImportHintKind.UNUSED);
        imports.unused.getPreferences(null);
        return imports.unused;
    }

    public static Imports createStar() {
        Imports imports = Imports.getDelegate();
        imports.star = new Imports(ImportHintKind.STAR);
        return imports.star;
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return this.treeKinds;
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        return this.analyseImports(compilationInfo);
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return this.IMPORTS_ID + this.kind.toString();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(Imports.class, (String)("LBL_Imports_" + this.kind.toString()));
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(Imports.class, (String)("DSC_Imports_" + this.kind.toString()));
    }

    @Override
    public Preferences getPreferences(String string) {
        Preferences preferences = super.getPreferences(string);
        if (this.kind == ImportHintKind.UNUSED) {
            try {
                preferences.removePreferenceChangeListener(this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            preferences.addPreferenceChangeListener(this);
        }
        return preferences;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        if (this.kind == ImportHintKind.FORBIDDEN) {
            return new ForbiddenImportsCustomizer(preferences);
        }
        return super.getCustomizer(preferences);
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (this.kind == ImportHintKind.UNUSED) {
            RemoveUnusedImportFix.setEnabled((boolean)this.isEnabled());
        }
    }

    private static synchronized Imports getDelegate() {
        if (delegate == null) {
            delegate = new Imports(ImportHintKind.DELEGATE);
        }
        return delegate;
    }

    /*
     * WARNING - void declaration
     */
    private List<ErrorDescription> analyseImports(CompilationInfo compilationInfo) {
        ArrayList<Object> arrayList;
        CompilationUnitTree compilationUnitTree = compilationInfo.getCompilationUnit();
        ExpressionTree expressionTree = compilationUnitTree.getPackageName();
        List<? extends ImportTree> list = compilationUnitTree.getImports();
        ArrayList<ImportTree> arrayList2 = new ArrayList<ImportTree>(3);
        ArrayList<ImportTree> arrayList3 = new ArrayList<ImportTree>(3);
        ArrayList<ImportTree> arrayList4 = new ArrayList<ImportTree>(3);
        ArrayList<ImportTree> arrayList5 = new ArrayList<ImportTree>(3);
        String[] stringArray = this.getRegexps(this.forbiddenPackage.getPreferences(null));
        for (ImportTree importTree2 : list) {
            if (importTree2.isStatic() || !(importTree2.getQualifiedIdentifier() instanceof MemberSelectTree)) continue;
            Iterator iterator = (MemberSelectTree)importTree2.getQualifiedIdentifier();
            if (this.defaultPackage != null && this.defaultPackage.isEnabled() && iterator.getExpression().toString().equals(DEFAULT_PACKAGE)) {
                arrayList2.add(importTree2);
                continue;
            }
            if (this.samePackage != null && this.samePackage.isEnabled() && expressionTree != null && iterator.getExpression().toString().equals(expressionTree.toString())) {
                arrayList3.add(importTree2);
                continue;
            }
            if (this.forbiddenPackage != null && this.forbiddenPackage.isEnabled() && Imports.isForbidden(iterator.getExpression().toString(), stringArray)) {
                arrayList4.add(importTree2);
                continue;
            }
            if (this.star == null || !this.star.isEnabled() || !"*".equals(iterator.getIdentifier().toString())) continue;
            arrayList5.add(importTree2);
        }
        ArrayList arrayList6 = new ArrayList();
        Object var11_12 = null;
        if (arrayList2.size() > 1) {
            Fix fix = this.createFix(compilationInfo, arrayList2, ImportHintKind.DEFAULT_PACKAGE);
        }
        for (ImportTree importTree : arrayList2) {
            void var11_14;
            arrayList = new ArrayList<Object>();
            arrayList.add(this.createFix(compilationInfo, importTree, ImportHintKind.DEFAULT_PACKAGE));
            if (var11_14 != null) {
                arrayList.add(var11_14);
            }
            arrayList6.add(ErrorDescriptionFactory.createErrorDescription((Severity)this.defaultPackage.getSeverity().toEditorSeverity(), (String)this.defaultPackage.getDisplayName(), arrayList, (FileObject)compilationInfo.getFileObject(), (int)((int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), importTree)), (int)((int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), importTree))));
        }
        Object var11_15 = null;
        if (arrayList3.size() > 1) {
            Fix fix = this.createFix(compilationInfo, arrayList3, ImportHintKind.SAME_PACKAGE);
        }
        for (ImportTree importTree : arrayList3) {
            void var11_17;
            arrayList = new ArrayList();
            arrayList.add(this.createFix(compilationInfo, importTree, ImportHintKind.SAME_PACKAGE));
            if (var11_17 != null) {
                arrayList.add(var11_17);
            }
            arrayList6.add(ErrorDescriptionFactory.createErrorDescription((Severity)this.samePackage.getSeverity().toEditorSeverity(), (String)this.samePackage.getDisplayName(), arrayList, (FileObject)compilationInfo.getFileObject(), (int)((int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), importTree)), (int)((int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), importTree))));
        }
        for (ImportTree importTree : arrayList4) {
            arrayList6.add(ErrorDescriptionFactory.createErrorDescription((Severity)this.forbiddenPackage.getSeverity().toEditorSeverity(), (String)this.forbiddenPackage.getDisplayName(), NO_FIXES, (FileObject)compilationInfo.getFileObject(), (int)((int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), importTree)), (int)((int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), importTree))));
        }
        for (ImportTree importTree : arrayList5) {
            arrayList6.add(ErrorDescriptionFactory.createErrorDescription((Severity)this.star.getSeverity().toEditorSeverity(), (String)this.star.getDisplayName(), NO_FIXES, (FileObject)compilationInfo.getFileObject(), (int)((int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), importTree)), (int)((int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), importTree))));
        }
        return arrayList6;
    }

    private Fix createFix(CompilationInfo compilationInfo, ImportTree importTree, ImportHintKind importHintKind) {
        return this.createFix(compilationInfo, Collections.singletonList(importTree), importHintKind);
    }

    private Fix createFix(CompilationInfo compilationInfo, List<ImportTree> list, ImportHintKind importHintKind) {
        ArrayList<TreePathHandle> arrayList = new ArrayList<TreePathHandle>();
        Trees trees = compilationInfo.getTrees();
        CompilationUnitTree compilationUnitTree = compilationInfo.getCompilationUnit();
        for (ImportTree importTree : list) {
            arrayList.add(TreePathHandle.create((TreePath)trees.getPath(compilationUnitTree, importTree), (CompilationInfo)compilationInfo));
        }
        return new ImportsFix(compilationInfo.getFileObject(), arrayList, importHintKind);
    }

    private String[] getRegexps(Preferences preferences) {
        String[] stringArray = ForbiddenImportsCustomizer.getForbiddenImports(preferences);
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            string = string.replace(".", "\\.");
            string = string.replace("**", ";;");
            string = string.replace("*", "[^\\.]*");
            stringArray2[i] = string = string.replace(";;", ".*");
        }
        return stringArray2;
    }

    private static boolean isForbidden(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            if (!Pattern.matches(string2, string)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImportsFix
    implements Fix,
    Task<WorkingCopy> {
        FileObject file;
        List<TreePathHandle> tphList;
        ImportHintKind ihk;

        public ImportsFix(FileObject fileObject, List<TreePathHandle> list, ImportHintKind importHintKind) {
            this.file = fileObject;
            this.tphList = list;
            this.ihk = importHintKind;
        }

        public String getText() {
            if (this.tphList.size() == 1) {
                return NbBundle.getMessage(Imports.class, (String)("LBL_Imports_Fix_One_" + this.ihk.toString()));
            }
            return NbBundle.getMessage(Imports.class, (String)("LBL_Imports_Fix_All_" + this.ihk.toString()));
        }

        public ChangeInfo implement() throws IOException {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)this.file);
            javaSource.runModificationTask((Task)this).commit();
            return null;
        }

        public void run(WorkingCopy workingCopy) throws Exception {
            workingCopy.toPhase(JavaSource.Phase.PARSED);
            CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            CompilationUnitTree compilationUnitTree2 = compilationUnitTree;
            for (TreePathHandle treePathHandle : this.tphList) {
                TreePath treePath = treePathHandle.resolve((CompilationInfo)workingCopy);
                if (treePath == null || !(treePath.getLeaf() instanceof ImportTree)) continue;
                compilationUnitTree2 = treeMaker.removeCompUnitImport(compilationUnitTree2, (ImportTree)treePath.getLeaf());
            }
            workingCopy.rewrite((Tree)compilationUnitTree, (Tree)compilationUnitTree2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ImportHintKind {
        DELEGATE,
        UNUSED,
        DUPLICATE,
        SAME_PACKAGE,
        DEFAULT_PACKAGE,
        FORBIDDEN,
        STAR;


        boolean defaultOn() {
            switch (this) {
                case DELEGATE: 
                case FORBIDDEN: 
                case SAME_PACKAGE: 
                case DEFAULT_PACKAGE: 
                case UNUSED: {
                    return true;
                }
            }
            return false;
        }
    }
}

