/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.refactoring;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Fault;
import org.netbeans.modules.xml.wsdl.model.Input;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Output;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPAddress;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPBinding;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPBody;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPComponent;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPFault;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPHeader;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPHeaderFault;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPOperation;
import org.netbeans.modules.xml.wsdl.model.visitor.DefaultVisitor;
import org.netbeans.modules.xml.wsdl.model.visitor.WSDLVisitor;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Reference;
import org.netbeans.modules.xml.xam.Referenceable;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLRenameReferenceVisitor
extends DefaultVisitor
implements WSDLVisitor {
    RenameRefactoring request;
    String oldName;
    Referenceable target;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refactor(Model model, Set<RefactoringElementImplementation> set, RenameRefactoring renameRefactoring) throws IOException {
        if (renameRefactoring == null || set == null || model == null) {
            return;
        }
        if (!(model instanceof WSDLModel)) {
            return;
        }
        this.request = renameRefactoring;
        this.target = (Referenceable)renameRefactoring.getRefactoringSource().lookup(Referenceable.class);
        this.oldName = (String)renameRefactoring.getContext().lookup(String.class);
        WSDLModel wSDLModel = (WSDLModel)model;
        boolean bl = !wSDLModel.isIntransaction();
        try {
            if (bl) {
                wSDLModel.startTransaction();
            }
            for (RefactoringElementImplementation refactoringElementImplementation : set) {
                assert (refactoringElementImplementation.getLookup().lookup(WSDLComponent.class) != null) : "Wrong component type in WSDL usage group";
                ((WSDLComponent)refactoringElementImplementation.getLookup().lookup(WSDLComponent.class)).accept((WSDLVisitor)this);
            }
        }
        finally {
            if (bl && wSDLModel.isIntransaction()) {
                wSDLModel.endTransaction();
            }
        }
    }

    private <T extends ReferenceableWSDLComponent> NamedComponentReference<T> createReference(Class<T> clazz, WSDLComponent wSDLComponent) {
        ReferenceableWSDLComponent referenceableWSDLComponent = (ReferenceableWSDLComponent)clazz.cast(this.target);
        return wSDLComponent.createReferenceTo(referenceableWSDLComponent, clazz);
    }

    public void visit(BindingOperation bindingOperation) {
        assert (this.target instanceof Operation) : "Invalid type, expect Operation";
        bindingOperation.setName(this.request.getNewName());
    }

    public void visit(Input input) {
        input.setMessage(this.createReference(Message.class, (WSDLComponent)input));
    }

    public void visit(Output output) {
        output.setMessage(this.createReference(Message.class, (WSDLComponent)output));
    }

    public void visit(Fault fault) {
        fault.setMessage(this.createReference(Message.class, (WSDLComponent)fault));
    }

    public void visit(Port port) {
        port.setBinding(this.createReference(Binding.class, (WSDLComponent)port));
    }

    private boolean isOverloaded(BindingOperation bindingOperation) {
        assert (!bindingOperation.getOperation().isBroken()) : "Broken operation reference: " + bindingOperation.getName();
        Operation operation = (Operation)bindingOperation.getOperation().get();
        PortType portType = (PortType)operation.getParent();
        assert (portType != null) : "Operation not in tree";
        for (Operation operation2 : portType.getOperations()) {
            if (operation2 == operation || !operation.getName().equals(operation2.getName())) continue;
            return true;
        }
        return false;
    }

    public void visit(BindingInput bindingInput) {
        if (bindingInput.getName() != null && bindingInput.getName().equals(this.oldName) || this.isOverloaded((BindingOperation)bindingInput.getParent())) {
            bindingInput.setName(this.request.getNewName());
        }
    }

    public void visit(BindingOutput bindingOutput) {
        if (bindingOutput.getName() != null && bindingOutput.getName().equals(this.oldName) || this.isOverloaded((BindingOperation)bindingOutput.getParent())) {
            bindingOutput.setName(this.request.getNewName());
        }
    }

    public void visit(BindingFault bindingFault) {
        bindingFault.setName(this.request.getNewName());
    }

    public void visit(Binding binding) {
        binding.setType(this.createReference(PortType.class, (WSDLComponent)binding));
    }

    public void visit(ExtensibilityElement extensibilityElement) {
        if (extensibilityElement instanceof SOAPComponent) {
            ((SOAPComponent)extensibilityElement).accept((SOAPComponent.Visitor)new SOAPReferencingVisitor());
        }
    }

    public class SOAPReferencingVisitor
    implements SOAPComponent.Visitor {
        public void visit(SOAPHeader sOAPHeader) {
            if (WSDLRenameReferenceVisitor.this.target instanceof Message) {
                sOAPHeader.setMessage(WSDLRenameReferenceVisitor.this.createReference(Message.class, (WSDLComponent)sOAPHeader));
            } else if (WSDLRenameReferenceVisitor.this.target instanceof Part) {
                sOAPHeader.setPartRef((Reference)WSDLRenameReferenceVisitor.this.createReference(Part.class, (WSDLComponent)sOAPHeader));
            }
        }

        public void visit(SOAPFault sOAPFault) {
            sOAPFault.setFault((Reference)WSDLRenameReferenceVisitor.this.createReference(Fault.class, (WSDLComponent)sOAPFault));
        }

        public void visit(SOAPHeaderFault sOAPHeaderFault) {
            if (WSDLRenameReferenceVisitor.this.target instanceof Message) {
                sOAPHeaderFault.setMessage(WSDLRenameReferenceVisitor.this.createReference(Message.class, (WSDLComponent)sOAPHeaderFault));
            } else if (WSDLRenameReferenceVisitor.this.target instanceof Part) {
                sOAPHeaderFault.setPartRef((Reference)WSDLRenameReferenceVisitor.this.createReference(Part.class, (WSDLComponent)sOAPHeaderFault));
            }
        }

        public void visit(SOAPOperation sOAPOperation) {
        }

        public void visit(SOAPBinding sOAPBinding) {
        }

        public void visit(SOAPBody sOAPBody) {
            if (WSDLRenameReferenceVisitor.this.target instanceof Part) {
                List list = sOAPBody.getParts();
                int n = list.indexOf(WSDLRenameReferenceVisitor.this.oldName);
                list.remove(n);
                list.add(n, WSDLRenameReferenceVisitor.this.request.getNewName());
                sOAPBody.setParts(list);
            }
        }

        public void visit(SOAPAddress sOAPAddress) {
        }
    }
}

