/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.modules.xml.refactoring.ErrorItem;
import org.netbeans.modules.xml.refactoring.FauxRefactoringElement;
import org.netbeans.modules.xml.refactoring.XMLRefactoringPlugin;
import org.netbeans.modules.xml.refactoring.XMLRefactoringTransaction;
import org.netbeans.modules.xml.refactoring.spi.RefactoringUtil;
import org.netbeans.modules.xml.refactoring.spi.SharedUtils;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.refactoring.WSDLRefactoringElement;
import org.netbeans.modules.xml.wsdl.refactoring.WSDLRefactoringEngine;
import org.netbeans.modules.xml.wsdl.refactoring.WSDLRefactoringPlugin;
import org.netbeans.modules.xml.wsdl.refactoring.WSDLRenameReferenceVisitor;
import org.netbeans.modules.xml.wsdl.refactoring.xsd.RenameSchemaReferenceVisitor;
import org.netbeans.modules.xml.wsdl.refactoring.xsd.SchemaUsageRefactoringEngine;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Nameable;
import org.netbeans.modules.xml.xam.Referenceable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLRenameRefactoringPlugin
extends WSDLRefactoringPlugin {
    private RenameRefactoring rename;

    public void cancelRequest() {
    }

    public Problem fastCheckParameters() {
        Referenceable referenceable = (Referenceable)this.rename.getRefactoringSource().lookup(Referenceable.class);
        ErrorItem errorItem = null;
        if (referenceable instanceof Model) {
            errorItem = RefactoringUtil.precheck((Model)((Model)referenceable), (String)this.rename.getNewName());
        } else if (referenceable instanceof Nameable) {
            errorItem = RefactoringUtil.precheck((Nameable)((Nameable)referenceable), (String)this.rename.getNewName());
        }
        if (errorItem != null) {
            Problem problem = new Problem(true, errorItem.getMessage());
            return problem;
        }
        return null;
    }

    public WSDLRenameRefactoringPlugin(RenameRefactoring renameRefactoring) {
        this.rename = renameRefactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        Referenceable referenceable = (Referenceable)this.rename.getRefactoringSource().lookup(Referenceable.class);
        if (referenceable == null) {
            return null;
        }
        if (!(referenceable instanceof Model) && !(referenceable instanceof Nameable)) {
            return null;
        }
        Model model = SharedUtils.getModel((Referenceable)referenceable);
        ErrorItem errorItem = RefactoringUtil.precheckTarget((Model)model, (boolean)true);
        if (errorItem != null) {
            return new Problem(this.isFatal(errorItem), errorItem.getMessage());
        }
        if (referenceable instanceof Model) {
            errorItem = RefactoringUtil.precheck((Model)model, (String)this.rename.getNewName());
        } else if (referenceable instanceof Nameable) {
            errorItem = RefactoringUtil.precheck((Nameable)((Nameable)referenceable), (String)this.rename.getNewName());
        }
        if (errorItem != null) {
            return new Problem(this.isFatal(errorItem), errorItem.getMessage());
        }
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        Object object;
        Object object2;
        Referenceable referenceable = (Referenceable)this.rename.getRefactoringSource().lookup(Referenceable.class);
        if (referenceable == null) {
            return null;
        }
        if (!(referenceable instanceof Model) && !(referenceable instanceof Nameable)) {
            return null;
        }
        this.session = refactoringElementsBag.getSession();
        this.transaction = (XMLRefactoringTransaction)this.rename.getContext().lookup(XMLRefactoringTransaction.class);
        this.fireProgressListenerStart(1, -1);
        this.findErrors = new ArrayList();
        Set<Object> set = new HashSet();
        if (this.transaction.isLocal()) {
            set = SharedUtils.getLocalSearchRoots((Referenceable)referenceable);
        } else {
            object2 = (Component)this.rename.getContext().lookup(Component.class);
            if (object2 == null) {
                set = this.getSearchRoots(referenceable);
            } else {
                set.add(object2);
            }
        }
        object2 = new ArrayList();
        Model model = set.iterator();
        while (model.hasNext()) {
            object = (Component)model.next();
            List<WSDLRefactoringElement> list = this.find(referenceable, (Component)object);
            if (list == null || list.size() <= 0) continue;
            object2.addAll(list);
        }
        if (object2.size() > 0 && (object = RefactoringUtil.precheckUsageModels((List)(model = this.getModels((List<WSDLRefactoringElement>)object2)), (boolean)true)) != null && object.size() > 0) {
            return this.processErrors((List<ErrorItem>)object);
        }
        this.transaction.register((XMLRefactoringPlugin)this, (List)object2);
        refactoringElementsBag.registerTransaction((Transaction)this.transaction);
        model = object2.iterator();
        while (model.hasNext()) {
            object = (WSDLRefactoringElement)((Object)model.next());
            refactoringElementsBag.add((AbstractRefactoring)this.rename, (RefactoringElementImplementation)object);
            ((WSDLRefactoringElement)((Object)object)).addTransactionObject(this.transaction);
            this.fireProgressListenerStep();
        }
        model = SharedUtils.getModel((Referenceable)referenceable);
        object = (FileObject)model.getModelSource().getLookup().lookup(FileObject.class);
        if ("text/x-wsdl+xml".equals(FileUtil.getMIMEType((FileObject)object))) {
            refactoringElementsBag.add((AbstractRefactoring)this.rename, (RefactoringElementImplementation)new FauxRefactoringElement(referenceable, NbBundle.getMessage(WSDLRenameRefactoringPlugin.class, (String)"LBL_Rename")));
        }
        if (this.findErrors.size() > 0) {
            return this.processErrors(this.findErrors);
        }
        this.fireProgressListenerStop();
        return null;
    }

    public void doRefactoring(List<RefactoringElementImplementation> list) throws IOException {
        Map<Model, Set<RefactoringElementImplementation>> map = this.getModelMap(list);
        Set<Model> set = map.keySet();
        Referenceable referenceable = (Referenceable)this.rename.getRefactoringSource().lookup(Referenceable.class);
        for (Model model : set) {
            if (!(model instanceof WSDLModel)) continue;
            if (referenceable instanceof WSDLComponent) {
                new WSDLRenameReferenceVisitor().refactor(model, map.get(model), this.rename);
                continue;
            }
            if (referenceable instanceof WSDLModel) {
                new WSDLRefactoringEngine()._refactorUsages(model, map.get(model), (AbstractRefactoring)this.rename);
                continue;
            }
            if (referenceable instanceof ReferenceableSchemaComponent) {
                new RenameSchemaReferenceVisitor().rename(model, map.get(model), this.rename);
                continue;
            }
            new SchemaUsageRefactoringEngine()._refactorUsages(model, map.get(model), (AbstractRefactoring)this.rename);
        }
    }

    @Override
    public String getModelReference(Component component) {
        if (component instanceof Import) {
            return ((Import)component).getLocation();
        }
        return null;
    }
}

