/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.tmap.model.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Nameable;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.Attribute;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xslt.tmap.model.api.ExNamespaceContext;
import org.netbeans.modules.xslt.tmap.model.api.Param;
import org.netbeans.modules.xslt.tmap.model.api.PartnerLinkTypeReference;
import org.netbeans.modules.xslt.tmap.model.api.TMapComponent;
import org.netbeans.modules.xslt.tmap.model.api.TMapModel;
import org.netbeans.modules.xslt.tmap.model.api.Transform;
import org.netbeans.modules.xslt.tmap.model.api.Variable;
import org.netbeans.modules.xslt.tmap.model.api.VariableReference;
import org.netbeans.modules.xslt.tmap.model.api.WSDLReference;
import org.netbeans.modules.xslt.tmap.model.impl.AbstractNamedComponentReference;
import org.netbeans.modules.xslt.tmap.model.impl.AttributesType;
import org.netbeans.modules.xslt.tmap.model.impl.GlobalWSDLReferenceImpl;
import org.netbeans.modules.xslt.tmap.model.impl.TMapComponentAbstract;
import org.netbeans.modules.xslt.tmap.model.impl.VariableReferenceImpl;
import org.netbeans.modules.xslt.tmap.model.impl.WSDLReferenceImpl;
import org.netbeans.modules.xslt.tmap.model.spi.ExternalModelRetriever;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLReferenceBuilder {
    private static final WSDLReferenceBuilder INSTANCE = new WSDLReferenceBuilder();
    private static Collection<? extends ExternalModelRetriever> myRetrievers;
    private Collection<WSDLReferenceFactory> myCollection;

    private WSDLReferenceBuilder() {
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(ExternalModelRetriever.class));
        myRetrievers = result.allInstances();
        this.myCollection = new LinkedList<WSDLReferenceFactory>();
        this.myCollection.add(new PartnerLinkTypeResolver());
        this.myCollection.add(new RoleResolver());
        this.myCollection.add(new OperationResolver());
        this.myCollection.add(new PartResolver());
    }

    public static WSDLReferenceBuilder getInstance() {
        return INSTANCE;
    }

    public <T extends ReferenceableWSDLComponent> WSDLReference<T> build(Class<T> clazz, TMapComponentAbstract tMapComponentAbstract, Attribute attribute) {
        WSDLReference<T> wSDLReference = this.build(clazz, (AbstractDocumentComponent)tMapComponentAbstract, tMapComponentAbstract.getAttribute(attribute));
        return wSDLReference;
    }

    public <T extends ReferenceableWSDLComponent> WSDLReference<T> build(Class<T> clazz, AbstractDocumentComponent abstractDocumentComponent, String string) {
        if (string == null) {
            return null;
        }
        for (WSDLReferenceFactory wSDLReferenceFactory : this.myCollection) {
            if (!wSDLReferenceFactory.isApplicable(clazz)) continue;
            return wSDLReferenceFactory.createUnresolvedReference(clazz, abstractDocumentComponent, string);
        }
        return null;
    }

    public <T extends ReferenceableWSDLComponent> WSDLReference<T> build(T t, Class<T> clazz, AbstractDocumentComponent abstractDocumentComponent) {
        for (WSDLReferenceFactory wSDLReferenceFactory : this.myCollection) {
            if (!wSDLReferenceFactory.isApplicable(clazz)) continue;
            return wSDLReferenceFactory.create(t, clazz, abstractDocumentComponent);
        }
        return null;
    }

    public AttributesType.AttrType getAttributeType(Attribute attribute) {
        Class clazz = null;
        clazz = List.class.isAssignableFrom(attribute.getType()) ? attribute.getMemberType() : attribute.getType();
        for (WSDLReferenceFactory wSDLReferenceFactory : this.myCollection) {
            if (!wSDLReferenceFactory.isApplicable(clazz)) continue;
            return wSDLReferenceFactory.getAttributeType();
        }
        assert (false);
        return null;
    }

    static Collection<WSDLModel> getWSDLModels(AbstractDocumentComponent abstractDocumentComponent, String string) {
        assert (abstractDocumentComponent instanceof TMapComponent);
        ExNamespaceContext exNamespaceContext = ((TMapComponent)abstractDocumentComponent).getNamespaceContext();
        Collection<WSDLModel> collection = WSDLReferenceBuilder.getWSDLModels(((TMapComponent)abstractDocumentComponent).getModel(), exNamespaceContext.getNamespaceURI(string));
        return collection;
    }

    static Collection<WSDLModel> getWSDLModels(TMapModel tMapModel, String string) {
        return WSDLReferenceBuilder.getInstance().getModels(tMapModel, string);
    }

    private Collection<WSDLModel> getModels(TMapModel tMapModel, String string) {
        LinkedList<WSDLModel> linkedList = new LinkedList<WSDLModel>();
        if (myRetrievers.size() == 1) {
            return myRetrievers.iterator().next().getWSDLModels(tMapModel, string);
        }
        for (ExternalModelRetriever externalModelRetriever : myRetrievers) {
            Collection<WSDLModel> collection = externalModelRetriever.getWSDLModels(tMapModel, string);
            linkedList.addAll(collection);
        }
        return linkedList;
    }

    public static void splitQName(String string, String[] stringArray) {
        String string2;
        String string3;
        assert (string != null);
        assert (stringArray != null);
        String[] stringArray2 = string.split(":");
        if (stringArray2.length == 2) {
            string3 = stringArray2[0];
            string2 = stringArray2[1];
        } else {
            string3 = null;
            string2 = stringArray2[0];
        }
        if (stringArray.length > 0) {
            stringArray[0] = string3;
        }
        if (stringArray.length > 1) {
            stringArray[1] = string2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PartResolver
    extends AbstractGlobalReferenceFactory {
        PartResolver() {
        }

        @Override
        public <T extends ReferenceableWSDLComponent> boolean isApplicable(Class<T> clazz) {
            return Part.class.isAssignableFrom(clazz);
        }

        @Override
        public <T extends ReferenceableWSDLComponent> T resolve(AbstractNamedComponentReference<T> abstractNamedComponentReference) {
            String string = abstractNamedComponentReference.getRefString();
            Class clazz = abstractNamedComponentReference.getType();
            AbstractDocumentComponent abstractDocumentComponent = abstractNamedComponentReference.getParent();
            Part part = null;
            if (abstractDocumentComponent instanceof Transform) {
                part = this.resolveByTransform(abstractDocumentComponent, string);
            }
            if (abstractDocumentComponent instanceof Param) {
                part = this.resolveByParam(abstractDocumentComponent, string);
            }
            return (T)(part != null ? (ReferenceableWSDLComponent)clazz.cast(part) : null);
        }

        private Part resolveByParam(AbstractDocumentComponent abstractDocumentComponent, String string) {
            if (!(abstractDocumentComponent instanceof Param) || string == null) {
                return null;
            }
            return this.resolveByVarRef(((Param)abstractDocumentComponent).getVariableReference(), string);
        }

        private Part resolveByTransform(AbstractDocumentComponent abstractDocumentComponent, String string) {
            if (!(abstractDocumentComponent instanceof Transform) || string == null) {
                return null;
            }
            VariableReference variableReference = ((Transform)abstractDocumentComponent).getResult();
            if (variableReference == null || !string.equals(variableReference.getRefString())) {
                variableReference = ((Transform)abstractDocumentComponent).getSource();
            }
            if (!string.equals(variableReference.getRefString())) {
                return null;
            }
            return this.resolveByVarRef(variableReference, string);
        }

        private Part resolveByVarRef(VariableReference variableReference, String string) {
            Object object;
            if (variableReference == null) {
                return null;
            }
            Part part = null;
            Variable variable = variableReference == null ? null : variableReference.getReferencedVariable();
            Message message = null;
            if (variable != null) {
                object = variable.getMessage();
                message = object == null ? null : (Message)object.get();
            }
            object = null;
            if (message != null) {
                object = message.getParts();
            }
            String string2 = VariableReferenceImpl.getPartName(string);
            if (object != null && string2 != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Part part2 = (Part)iterator.next();
                    if (part2 == null || !string2.equals(part2.getName())) continue;
                    part = part2;
                    break;
                }
            }
            return part;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class OperationResolver
    extends AbstractNamedReferenceFactory {
        OperationResolver() {
        }

        @Override
        public <T extends ReferenceableWSDLComponent> boolean isApplicable(Class<T> clazz) {
            return Operation.class.isAssignableFrom(clazz);
        }

        @Override
        public <T extends ReferenceableWSDLComponent> T resolve(AbstractNamedComponentReference<T> abstractNamedComponentReference) {
            String string = abstractNamedComponentReference.getRefString();
            Class clazz = abstractNamedComponentReference.getType();
            AbstractDocumentComponent abstractDocumentComponent = abstractNamedComponentReference.getParent();
            Collection<Operation> collection = null;
            if (abstractDocumentComponent instanceof org.netbeans.modules.xslt.tmap.model.api.Operation) {
                collection = this.resolveByTransformOperation(abstractDocumentComponent);
            }
            if (abstractDocumentComponent instanceof PartnerLinkTypeReference) {
                collection = this.resolveByPartnerLink(abstractDocumentComponent);
            }
            if (collection == null) {
                return null;
            }
            for (Operation operation : collection) {
                if (!string.equals(operation.getName())) continue;
                return (T)((ReferenceableWSDLComponent)clazz.cast(operation));
            }
            return null;
        }

        private Collection<Operation> resolveByTransformOperation(AbstractDocumentComponent abstractDocumentComponent) {
            Component component;
            Component component2 = component = abstractDocumentComponent == null ? null : abstractDocumentComponent.getParent();
            if (component == null) {
                return null;
            }
            assert (component instanceof AbstractDocumentComponent);
            return this.resolveByPartnerLink((AbstractDocumentComponent)component);
        }

        private Collection<Operation> resolveByPartnerLink(AbstractDocumentComponent abstractDocumentComponent) {
            NamedComponentReference namedComponentReference;
            if (!(abstractDocumentComponent instanceof PartnerLinkTypeReference)) {
                return null;
            }
            WSDLReference<Role> wSDLReference = ((PartnerLinkTypeReference)abstractDocumentComponent).getRole();
            Role role = null;
            if (wSDLReference != null) {
                role = (Role)wSDLReference.get();
            }
            PortType portType = null;
            if (role != null && (namedComponentReference = role.getPortType()) != null) {
                portType = (PortType)namedComponentReference.get();
            }
            if (portType == null) {
                return null;
            }
            Collection collection = portType.getOperations();
            return collection;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RoleResolver
    extends AbstractNamedReferenceFactory {
        RoleResolver() {
        }

        @Override
        public <T extends ReferenceableWSDLComponent> boolean isApplicable(Class<T> clazz) {
            return Role.class.isAssignableFrom(clazz);
        }

        @Override
        public <T extends ReferenceableWSDLComponent> T resolve(AbstractNamedComponentReference<T> abstractNamedComponentReference) {
            String string = abstractNamedComponentReference.getRefString();
            Class clazz = abstractNamedComponentReference.getType();
            AbstractDocumentComponent abstractDocumentComponent = abstractNamedComponentReference.getParent();
            assert (abstractDocumentComponent instanceof PartnerLinkTypeReference);
            WSDLReference<PartnerLinkType> wSDLReference = ((PartnerLinkTypeReference)abstractDocumentComponent).getPartnerLinkType();
            if (wSDLReference == null) {
                return null;
            }
            PartnerLinkType partnerLinkType = (PartnerLinkType)wSDLReference.get();
            if (partnerLinkType == null) {
                return null;
            }
            Role role = partnerLinkType.getRole1();
            if (role != null && string.equals(role.getName())) {
                return (T)((ReferenceableWSDLComponent)clazz.cast(role));
            }
            role = partnerLinkType.getRole2();
            if (role != null && string.equals(role.getName())) {
                return (T)((ReferenceableWSDLComponent)clazz.cast(role));
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PartnerLinkTypeResolver
    extends AbstractGlobalReferenceFactory {
        PartnerLinkTypeResolver() {
        }

        @Override
        public <T extends ReferenceableWSDLComponent> boolean isApplicable(Class<T> clazz) {
            return PartnerLinkType.class.isAssignableFrom(clazz);
        }

        @Override
        public <T extends ReferenceableWSDLComponent> T resolve(AbstractNamedComponentReference<T> abstractNamedComponentReference) {
            String string = abstractNamedComponentReference.getRefString();
            Class clazz = abstractNamedComponentReference.getType();
            AbstractDocumentComponent abstractDocumentComponent = abstractNamedComponentReference.getParent();
            String[] stringArray = new String[2];
            WSDLReferenceBuilder.splitQName(string, stringArray);
            Collection<WSDLModel> collection = WSDLReferenceBuilder.getWSDLModels(abstractDocumentComponent, stringArray[0]);
            for (WSDLModel wSDLModel : collection) {
                List list = wSDLModel.getDefinitions().getExtensibilityElements(PartnerLinkType.class);
                for (PartnerLinkType partnerLinkType : list) {
                    if (!stringArray[1].equals(partnerLinkType.getName())) continue;
                    return (T)((ReferenceableWSDLComponent)clazz.cast(partnerLinkType));
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AbstractNamedReferenceFactory
    implements WSDLReferenceFactory {
        AbstractNamedReferenceFactory() {
        }

        @Override
        public <T extends ReferenceableWSDLComponent> WSDLReference<T> createUnresolvedReference(Class<T> clazz, AbstractDocumentComponent abstractDocumentComponent, String string) {
            return new WSDLReferenceImpl<Object>(null, clazz, abstractDocumentComponent, string, this);
        }

        @Override
        public <T extends ReferenceableWSDLComponent> WSDLReference<T> create(T t, Class<T> clazz, AbstractDocumentComponent abstractDocumentComponent, String string) {
            return new WSDLReferenceImpl<T>(t, clazz, abstractDocumentComponent, string, this);
        }

        @Override
        public <T extends ReferenceableWSDLComponent> WSDLReference<T> create(T t, Class<T> clazz, AbstractDocumentComponent abstractDocumentComponent) {
            assert (t instanceof Nameable);
            return new WSDLReferenceImpl<T>(t, clazz, abstractDocumentComponent, t.getName(), this);
        }

        @Override
        public AttributesType.AttrType getAttributeType() {
            return AttributesType.AttrType.NCNAME;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AbstractGlobalReferenceFactory
    implements WSDLReferenceFactory {
        AbstractGlobalReferenceFactory() {
        }

        @Override
        public <T extends ReferenceableWSDLComponent> WSDLReference<T> createUnresolvedReference(Class<T> clazz, AbstractDocumentComponent abstractDocumentComponent, String string) {
            return new GlobalWSDLReferenceImpl<T>(clazz, abstractDocumentComponent, string, (WSDLResolver)this);
        }

        @Override
        public <T extends ReferenceableWSDLComponent> WSDLReference<T> create(T t, Class<T> clazz, AbstractDocumentComponent abstractDocumentComponent, String string) {
            return this.create(t, clazz, abstractDocumentComponent);
        }

        @Override
        public <T extends ReferenceableWSDLComponent> WSDLReference<T> create(T t, Class<T> clazz, AbstractDocumentComponent abstractDocumentComponent) {
            return new GlobalWSDLReferenceImpl<T>(t, clazz, abstractDocumentComponent, (WSDLResolver)this);
        }

        @Override
        public AttributesType.AttrType getAttributeType() {
            return AttributesType.AttrType.QNAME;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface WSDLReferenceFactory
    extends WSDLResolver {
        public <T extends ReferenceableWSDLComponent> boolean isApplicable(Class<T> var1);

        public <T extends ReferenceableWSDLComponent> WSDLReference<T> create(T var1, Class<T> var2, AbstractDocumentComponent var3);

        public <T extends ReferenceableWSDLComponent> WSDLReference<T> createUnresolvedReference(Class<T> var1, AbstractDocumentComponent var2, String var3);

        public <T extends ReferenceableWSDLComponent> WSDLReference<T> create(T var1, Class<T> var2, AbstractDocumentComponent var3, String var4);

        public AttributesType.AttrType getAttributeType();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface WSDLResolver {
        public <T extends ReferenceableWSDLComponent> T resolve(AbstractNamedComponentReference<T> var1);
    }
}

