/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.tmap;

import java.awt.EventQueue;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.StyledDocument;
import org.netbeans.api.xml.cookies.CookieObserver;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.modules.soa.ui.UndoRedoManagerProvider;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.validation.ShowCookie;
import org.netbeans.modules.xml.validation.ui.ValidationAnnotation;
import org.netbeans.modules.xml.xam.AbstractModel;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.netbeans.modules.xml.xam.ui.undo.QuietUndoManager;
import org.netbeans.modules.xslt.tmap.TMapDataObject;
import org.netbeans.modules.xslt.tmap.model.api.TMapModel;
import org.netbeans.modules.xslt.tmap.model.spi.TMapModelFactory;
import org.netbeans.modules.xslt.tmap.multiview.TMapMultiViewSupport;
import org.openide.ErrorManager;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.UserCancelException;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TMapDataEditorSupport
extends DataEditorSupport
implements OpenCookie,
EditCookie,
EditorCookie.Observable,
ShowCookie,
UndoRedoManagerProvider {
    private transient Task prepareTask;
    private ValidationAnnotation myAnnotation = new ValidationAnnotation();

    public TMapDataEditorSupport(TMapDataObject tMapDataObject) {
        super((DataObject)tMapDataObject, (CloneableEditorSupport.Env)new TMapEnv(tMapDataObject));
        this.setMIMEType("text/x-tmap+xml");
    }

    public UndoRedo.Manager getUndoRedoManager() {
        return this.getUndoManager();
    }

    public void saveDocument() throws IOException {
        super.saveDocument();
        this.syncModel();
        this.getDataObject().setModified(false);
    }

    public void syncModel() {
        try {
            TMapModel tMapModel = this.getTMapModel();
            if (tMapModel != null) {
                tMapModel.sync();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    public QuietUndoManager getUndoManager() {
        return (QuietUndoManager)this.getUndoRedo();
    }

    public TMapModel getTMapModel() {
        TMapDataObject tMapDataObject = this.getEnv().getTMapDataObject();
        ModelSource modelSource = Utilities.getModelSource((FileObject)tMapDataObject.getPrimaryFile(), (boolean)true);
        return this.getModelFactory().getModel(modelSource);
    }

    public void show(final Validator.ResultItem resultItem) {
        if (!(resultItem.getModel() instanceof AbstractModel)) {
            return;
        }
        Component component = resultItem.getComponents();
        DataObject dataObject = this.getDataObject();
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        final EditCookie editCookie = (EditCookie)dataObject.getCookie(EditCookie.class);
        if (lineCookie == null || editCookie == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                editCookie.edit();
                TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
                MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
                if (multiViewHandler == null) {
                    return;
                }
                if (resultItem.getModel().getState().equals((Object)Model.State.NOT_WELL_FORMED) || resultItem.getComponents() == null) {
                    for (int i = 0; i < multiViewHandler.getPerspectives().length; ++i) {
                        if (!multiViewHandler.getPerspectives()[i].preferredID().equals("tmapsource")) continue;
                        multiViewHandler.requestActive(multiViewHandler.getPerspectives()[i]);
                    }
                }
            }
        });
    }

    private List<TopComponent> getAssociatedTopComponents() {
        ArrayList<TopComponent> arrayList = new ArrayList<TopComponent>();
        DataObject dataObject = this.getDataObject();
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent != null && dataObject == (DataObject)topComponent.getLookup().lookup(DataObject.class)) {
            arrayList.add(topComponent);
        }
        Set set = TopComponent.getRegistry().getOpened();
        for (Object e : set) {
            TopComponent topComponent2 = (TopComponent)e;
            if (dataObject != (DataObject)topComponent2.getLookup().lookup(DataObject.class)) continue;
            arrayList.add(topComponent2);
        }
        return arrayList;
    }

    public boolean validateXML(CookieObserver cookieObserver) {
        return true;
    }

    protected CloneableEditorSupport.Pane createPane() {
        CloneableTopComponent cloneableTopComponent = TMapMultiViewSupport.createMultiView((TMapDataObject)this.getDataObject());
        Mode mode = WindowManager.getDefault().findMode("editor");
        if (mode != null) {
            mode.dockInto((TopComponent)cloneableTopComponent);
        }
        return (CloneableEditorSupport.Pane)cloneableTopComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyClosed() {
        QuietUndoManager quietUndoManager = this.getUndoManager();
        StyledDocument styledDocument = this.getDocument();
        QuietUndoManager quietUndoManager2 = quietUndoManager;
        synchronized (quietUndoManager2) {
            TMapModel tMapModel;
            if (styledDocument != null) {
                styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                quietUndoManager.endCompound();
                quietUndoManager.setDocument(null);
            }
            if ((tMapModel = this.getTMapModel()) != null) {
                tMapModel.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
            }
            quietUndoManager.setModel(null);
        }
        super.notifyClosed();
        this.getUndoManager().discardAllEdits();
        this.prepareTask = null;
    }

    protected boolean notifyModified() {
        boolean bl = super.notifyModified();
        if (!bl) {
            return false;
        }
        TMapDataObject tMapDataObject = this.getEnv().getTMapDataObject();
        if (tMapDataObject.getCookie(SaveCookie.class) == null) {
            tMapDataObject.addSaveCookie(new SaveCookie(){

                public void save() throws IOException {
                    try {
                        TMapDataEditorSupport.this.saveDocument();
                    }
                    catch (UserCancelException userCancelException) {
                        // empty catch block
                    }
                }
            });
        }
        return true;
    }

    protected void updateTitles() {
        super.updateTitles();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                List list = TMapDataEditorSupport.this.getAssociatedTopComponents();
                for (TopComponent topComponent : list) {
                    MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
                    if (multiViewHandler == null || topComponent == null) continue;
                    topComponent.setHtmlDisplayName(TMapDataEditorSupport.this.messageHtmlName());
                    String string = TMapDataEditorSupport.this.messageName();
                    topComponent.setDisplayName(string);
                    topComponent.setName(string);
                    topComponent.setToolTipText(TMapDataEditorSupport.this.messageToolTip());
                }
            }
        });
    }

    protected TMapEnv getEnv() {
        return (TMapEnv)this.env;
    }

    protected UndoRedo.Manager createUndoRedoManager() {
        return new QuietUndoManager(super.createUndoRedoManager());
    }

    public void initializeCloneableEditor(CloneableEditor cloneableEditor) {
        super.initializeCloneableEditor(cloneableEditor);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TMapDataEditorSupport.this.updateTitles();
            }
        });
    }

    public Task prepareDocument() {
        Task task = super.prepareDocument();
        if (task == this.prepareTask) {
            return task;
        }
        task.addTaskListener(new TaskListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void taskFinished(Task task) {
                QuietUndoManager quietUndoManager = (QuietUndoManager)TMapDataEditorSupport.this.getUndoRedo();
                StyledDocument styledDocument = TMapDataEditorSupport.this.getDocument();
                QuietUndoManager quietUndoManager2 = quietUndoManager;
                synchronized (quietUndoManager2) {
                    quietUndoManager.setDocument((AbstractDocument)((Object)styledDocument));
                    if (!quietUndoManager.isCompound()) {
                        styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                        TMapDataEditorSupport.this.addUndoManagerToModel(quietUndoManager);
                    }
                }
            }
        });
        return task;
    }

    public Task reloadDocument() {
        Task task = super.reloadDocument();
        task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                EventQueue.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        QuietUndoManager quietUndoManager = TMapDataEditorSupport.this.getUndoManager();
                        StyledDocument styledDocument = TMapDataEditorSupport.this.getDocument();
                        QuietUndoManager quietUndoManager2 = quietUndoManager;
                        synchronized (quietUndoManager2) {
                            if (!quietUndoManager.isCompound() && styledDocument != null) {
                                styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                            }
                        }
                    }
                });
            }
        });
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUndoManagerToDocument() {
        QuietUndoManager quietUndoManager = this.getUndoManager();
        StyledDocument styledDocument = this.getDocument();
        QuietUndoManager quietUndoManager2 = quietUndoManager;
        synchronized (quietUndoManager2) {
            this.removeUndoManagerFromModel();
            if (styledDocument != null) {
                styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                styledDocument.addUndoableEditListener((UndoableEditListener)quietUndoManager);
                quietUndoManager.beginCompound();
            }
        }
    }

    public void addUndoManagerToModel(QuietUndoManager quietUndoManager) {
        TMapModel tMapModel = this.getTMapModel();
        if (tMapModel != null) {
            this.removeUndoManagerFromModel();
            tMapModel.addUndoableEditListener((UndoableEditListener)quietUndoManager);
            quietUndoManager.setModel((Model)tMapModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUndoManagerFromDocument() {
        QuietUndoManager quietUndoManager = this.getUndoManager();
        StyledDocument styledDocument = this.getDocument();
        QuietUndoManager quietUndoManager2 = quietUndoManager;
        synchronized (quietUndoManager2) {
            if (styledDocument != null) {
                styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                quietUndoManager.endCompound();
            }
            this.addUndoManagerToModel(quietUndoManager);
        }
    }

    private void removeUndoManagerFromModel() {
        TMapModel tMapModel = this.getTMapModel();
        if (tMapModel != null) {
            QuietUndoManager quietUndoManager = this.getUndoManager();
            tMapModel.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
            quietUndoManager.setModel(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean suspendUndoRedo() {
        boolean bl;
        QuietUndoManager quietUndoManager;
        QuietUndoManager quietUndoManager2 = quietUndoManager = this.getUndoManager();
        synchronized (quietUndoManager2) {
            bl = quietUndoManager.isCompound();
            if (bl) {
                this.removeUndoManagerFromDocument();
            }
            this.removeUndoManagerFromModel();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeUndoRedo(boolean bl) {
        if (bl) {
            this.addUndoManagerToDocument();
        } else {
            QuietUndoManager quietUndoManager;
            QuietUndoManager quietUndoManager2 = quietUndoManager = this.getUndoManager();
            synchronized (quietUndoManager2) {
                this.addUndoManagerToModel(quietUndoManager);
            }
        }
    }

    private TMapModelFactory getModelFactory() {
        TMapModelFactory tMapModelFactory = (TMapModelFactory)Lookup.getDefault().lookup(TMapModelFactory.class);
        return tMapModelFactory;
    }

    public boolean silentClose() {
        return super.close(false);
    }

    public static class CloseHandler
    implements CloseOperationHandler,
    Serializable {
        private static final long serialVersionUID = -4621077799099893176L;
        private TMapDataObject myDataObject;

        private CloseHandler() {
        }

        public CloseHandler(TMapDataObject tMapDataObject) {
            this.myDataObject = tMapDataObject;
        }

        public boolean resolveCloseOperation(CloseOperationState[] closeOperationStateArray) {
            TMapDataEditorSupport tMapDataEditorSupport;
            TMapDataEditorSupport tMapDataEditorSupport2 = tMapDataEditorSupport = this.myDataObject == null ? null : (TMapDataEditorSupport)this.myDataObject.getCookie(TMapDataEditorSupport.class);
            if (tMapDataEditorSupport == null) {
                return true;
            }
            boolean bl = tMapDataEditorSupport.canClose();
            if (bl) {
                if (this.myDataObject.isValid()) {
                    tMapDataEditorSupport.reloadDocument().waitFinished();
                }
                this.myDataObject.setModified(false);
            }
            return bl;
        }
    }

    private static class TMapEnv
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = 835762240381934851L;

        public TMapEnv(TMapDataObject tMapDataObject) {
            super((DataObject)tMapDataObject);
        }

        public TMapDataObject getTMapDataObject() {
            return (TMapDataObject)this.getDataObject();
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((MultiDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }
    }
}

