/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.netbeans.modules.web.core.jsploader.JspServletDataObject;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.PrintCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.windows.CloneableOpenSupport;

public class ServletEditor
extends CloneableEditorSupport
implements EditorCookie.Observable,
CloseCookie,
PrintCookie,
PropertyChangeListener {
    static final String ATTR_FILE_ENCODING = "Content-Encoding";

    public ServletEditor(JspDataObject jspDataObject) {
        super((CloneableEditorSupport.Env)new JspEnv(jspDataObject));
        jspDataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jspDataObject));
    }

    protected CloneableEditor createCloneableEditor() {
        return new ServletEditorComponent(this);
    }

    protected JspEnv jspEnv() {
        return (JspEnv)this.env;
    }

    protected void loadFromStreamToKit(StyledDocument styledDocument, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
        FileObject fileObject = this.getServlet().getPrimaryFile();
        String string = (String)fileObject.getAttribute(ATTR_FILE_ENCODING);
        if (string == null) {
            string = "ISO-8859-1";
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
        editorKit.read(inputStreamReader, (Document)styledDocument, 0);
    }

    protected JspServletDataObject getServlet() {
        return this.jspEnv().getJspDataObject().getServletDataObject();
    }

    protected String messageSave() {
        return "";
    }

    protected String messageName() {
        JspServletDataObject jspServletDataObject = this.getServlet();
        if (jspServletDataObject == null) {
            return "...";
        }
        if (!jspServletDataObject.isValid()) {
            return "";
        }
        if (DataNode.getShowFileExtensions()) {
            return jspServletDataObject.getPrimaryFile().getNameExt();
        }
        return jspServletDataObject.getPrimaryFile().getName();
    }

    protected String messageToolTip() {
        JspServletDataObject jspServletDataObject = this.getServlet();
        if (jspServletDataObject != null) {
            return FileUtil.getFileDisplayName((FileObject)jspServletDataObject.getPrimaryFile());
        }
        return "...";
    }

    protected String messageOpening() {
        JspServletDataObject jspServletDataObject = this.getServlet();
        if (jspServletDataObject == null) {
            return "";
        }
        return NbBundle.getMessage(ServletEditor.class, (String)"CTL_ObjectOpen", (Object)jspServletDataObject.getPrimaryFile().getNameExt(), (Object)FileUtil.getFileDisplayName((FileObject)jspServletDataObject.getPrimaryFile()));
    }

    protected String messageOpened() {
        JspServletDataObject jspServletDataObject = this.getServlet();
        if (jspServletDataObject == null) {
            return "";
        }
        return NbBundle.getMessage(ServletEditor.class, (String)"CTL_ObjectOpened", (Object)jspServletDataObject.getPrimaryFile().getNameExt(), (Object)FileUtil.getFileDisplayName((FileObject)jspServletDataObject.getPrimaryFile()));
    }

    MultiDataObject.Entry getJavaEntry() {
        return this.getServlet().getPrimaryEntry();
    }

    protected StyledDocument createStyledDocument(EditorKit editorKit) {
        StyledDocument styledDocument = super.createStyledDocument(editorKit);
        this.setDocumentProperties(styledDocument);
        return styledDocument;
    }

    void setDocumentProperties(Document document) {
        JspServletDataObject jspServletDataObject = this.getServlet();
        if (jspServletDataObject != null) {
            document.putProperty("title", jspServletDataObject.getPrimaryFile().getPath());
            document.putProperty("stream", (Object)jspServletDataObject);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        StyledDocument styledDocument;
        if (propertyChangeEvent.getPropertyName().equals("servlet_do") && (styledDocument = this.getDocument()) != null) {
            this.setDocumentProperties(styledDocument);
        }
    }

    private static class JspEnv
    extends FileChangeAdapter
    implements CloneableEditorSupport.Env,
    Serializable,
    PropertyChangeListener {
        private static final long serialVersionUID = -5748207023470614141L;
        protected JspDataObject jspdo;
        private DataObject servlet;
        private transient PropertyChangeSupport propSupp;

        public JspEnv(JspDataObject jspDataObject) {
            this.jspdo = jspDataObject;
            this.init();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DataObject getServlet() {
            JspDataObject jspDataObject = this.jspdo;
            synchronized (jspDataObject) {
                JspServletDataObject jspServletDataObject = this.jspdo.getServletDataObject();
                if (this.servlet != jspServletDataObject) {
                    if (this.servlet != null) {
                        this.servlet.getPrimaryFile().removeFileChangeListener((FileChangeListener)this);
                    }
                    if (jspServletDataObject != null) {
                        jspServletDataObject.getPrimaryFile().addFileChangeListener((FileChangeListener)this);
                    }
                    this.servlet = jspServletDataObject;
                }
                return this.servlet;
            }
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.init();
        }

        private void init() {
            this.jspdo.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.jspdo));
        }

        public JspDataObject getJspDataObject() {
            return this.jspdo;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("servlet_do".equals(propertyChangeEvent.getPropertyName())) {
                DataObject dataObject = this.getServlet();
                if (dataObject == null) {
                    this.firePropertyChange("valid", Boolean.TRUE, Boolean.FALSE);
                } else {
                    this.firePropertyChange("time", null, null);
                }
            }
            this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }

        protected void firePropertyChange(String string, Object object, Object object2) {
            this.prop().firePropertyChange(string, object, object2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PropertyChangeSupport prop() {
            if (this.propSupp == null) {
                JspEnv jspEnv = this;
                synchronized (jspEnv) {
                    if (this.propSupp == null) {
                        this.propSupp = new PropertyChangeSupport(this);
                    }
                }
            }
            return this.propSupp;
        }

        public InputStream inputStream() throws IOException {
            DataObject dataObject = this.getServlet();
            if (dataObject != null) {
                return dataObject.getPrimaryFile().getInputStream();
            }
            return null;
        }

        public OutputStream outputStream() throws IOException {
            return null;
        }

        public Date getTime() {
            return null;
        }

        public String getMimeType() {
            return "text/x-java";
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.prop().addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.prop().removePropertyChangeListener(propertyChangeListener);
        }

        public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        }

        public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        }

        public boolean isValid() {
            DataObject dataObject = this.getServlet();
            return dataObject != null;
        }

        public boolean isModified() {
            return false;
        }

        public void markModified() throws IOException {
        }

        public void unmarkModified() {
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.jspdo.getServletEditor();
        }

        public void fileDeleted(FileEvent fileEvent) {
            fileEvent.getFile().removeFileChangeListener((FileChangeListener)this);
            this.jspdo.refreshPlugin(true);
        }

        public void fileChanged(FileEvent fileEvent) {
            this.firePropertyChange("time", null, null);
        }
    }

    public static class ServletEditorComponent
    extends CloneableEditor {
        static final int SELECTED_NODES_DELAY = 1000;
        Timer timerSelNodes;
        CaretListener caretListener;
        int lastCaretOffset = -1;

        public ServletEditorComponent() {
        }

        public ServletEditorComponent(ServletEditor servletEditor) {
            super((CloneableEditorSupport)servletEditor);
            this.init();
        }

        protected void componentShowing() {
            super.componentShowing();
            this.pane.setEditable(false);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            super.readExternal(objectInput);
            this.init();
        }

        protected JEditorPane getPane() {
            return this.pane;
        }

        private void init() {
            ServletEditor servletEditor;
            if (null != this.getPane()) {
                this.getPane().setEditable(false);
            }
            if ((servletEditor = (ServletEditor)this.cloneableEditorSupport()) != null) {
                servletEditor.jspEnv().addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("time".equals(propertyChangeEvent.getPropertyName())) {
                            ServletEditorComponent.this.initializeJavaNodes();
                        }
                        ServletEditorComponent.this.updateName();
                    }
                });
            }
            this.initializeJavaNodes();
        }

        protected void componentActivated() {
            this.pane.addCaretListener(this.caretListener);
            super.componentActivated();
        }

        void selectElementsAtOffset(int n) {
            ServletEditor servletEditor = (ServletEditor)this.cloneableEditorSupport();
            if (servletEditor != null) {
                JspDataObject jspDataObject = servletEditor.jspEnv().getJspDataObject();
                if (SwingUtilities.isEventDispatchThread()) {
                    this.setNodes(jspDataObject, n);
                } else {
                    SwingUtilities.invokeLater(new NodesThread(jspDataObject, n));
                }
            }
        }

        private void setNodes(JspDataObject jspDataObject, int n) {
            JspServletDataObject jspServletDataObject = jspDataObject.getServletDataObject();
            if (jspServletDataObject == null) {
                this.setActivatedNodes(new Node[]{jspDataObject.getNodeDelegate()});
                return;
            }
        }

        private void initializeJavaNodes() {
            Caret caret;
            ServletEditor servletEditor = (ServletEditor)this.cloneableEditorSupport();
            if (servletEditor != null) {
                this.timerSelNodes = new Timer(100, new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Caret caret;
                        if (ServletEditorComponent.this.lastCaretOffset == -1 && ServletEditorComponent.this.pane != null && (caret = ServletEditorComponent.this.pane.getCaret()) != null) {
                            ServletEditorComponent.this.lastCaretOffset = caret.getDot();
                        }
                        ServletEditorComponent.this.selectElementsAtOffset(ServletEditorComponent.this.lastCaretOffset);
                    }
                });
                this.timerSelNodes.setInitialDelay(100);
                this.timerSelNodes.setRepeats(false);
                this.timerSelNodes.restart();
                this.caretListener = new CaretListener(){

                    public void caretUpdate(CaretEvent caretEvent) {
                        ServletEditorComponent.this.restartTimerSelNodes(caretEvent.getDot());
                    }
                };
            }
            if (this.lastCaretOffset == -1 && this.pane != null && (caret = this.pane.getCaret()) != null) {
                this.lastCaretOffset = caret.getDot();
            }
            this.selectElementsAtOffset(this.lastCaretOffset);
        }

        public SystemAction[] getSystemActions() {
            this.selectElementsAtOffset(this.lastCaretOffset);
            this.timerSelNodes.stop();
            return super.getSystemActions();
        }

        void restartTimerSelNodes(int n) {
            this.timerSelNodes.setInitialDelay(1000);
            this.timerSelNodes.restart();
            this.lastCaretOffset = n;
        }

        private class NodesThread
        implements Runnable {
            JspDataObject jspdo;
            int offset;

            NodesThread(JspDataObject jspDataObject, int n) {
                this.jspdo = jspDataObject;
                this.offset = n;
            }

            public void run() {
                ServletEditorComponent.this.setNodes(this.jspdo, this.offset);
            }
        }
    }
}

