/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Date;
import java.util.EventListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.web.core.QueryStringCookie;
import org.netbeans.modules.web.core.WebExecSupport;
import org.netbeans.modules.web.core.jsploader.BaseJspEditorSupport;
import org.netbeans.modules.web.core.jsploader.CompileData;
import org.netbeans.modules.web.core.jsploader.JspNode;
import org.netbeans.modules.web.core.jsploader.JspServletDataLoader;
import org.netbeans.modules.web.core.jsploader.JspServletDataObject;
import org.netbeans.modules.web.core.jsploader.ServletEditor;
import org.netbeans.modules.web.core.jsploader.TagLibParseSupport;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.UniFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class JspDataObject
extends MultiDataObject
implements QueryStringCookie {
    public static final String EA_JSP_ERRORPAGE = "jsp_errorpage";
    public static final String PROP_SERVLET_DATAOBJECT = "servlet_do";
    public static final String PROP_CONTENT_LANGUAGE = "contentLanguage";
    public static final String PROP_SCRIPTING_LANGUAGE = "scriptingLanguage";
    public static final String PROP_SERVER_CHANGE = "PROP_SERVER_CHANGE";
    public static final String PROP_REQUEST_PARAMS = "PROP_REQUEST_PARAMS";
    static final String ATTR_FILE_ENCODING = "Content-Encoding";
    private static final String DEFAULT_ENCODING = "ISO-8559-1";
    private static final Logger LOGGER = Logger.getLogger(JspDataObject.class.getName());
    private transient EditorCookie servletEdit;
    protected transient JspServletDataObject servletDataObject;
    private transient Date servletDataObjectDate;
    private transient CompileData compileData;
    private transient boolean firstStart;
    private transient Listener listener;
    private transient BaseJspEditorSupport editorSupport;
    private static final transient boolean debug = false;
    private volatile transient Lookup currentLookup;
    private volatile transient boolean useEditorForEncoding = false;
    private volatile transient boolean reparseEncoding = false;
    private final transient AtomicBoolean resolvingEncoding = new AtomicBoolean(false);
    private boolean isEncodingRetrieved = false;
    private static final String CORRECT_WINDOWS_31J = "windows-31j";
    private static final String CORRECT_EUC_JP = "EUC-JP";
    private static final String CORRECT_GB2312 = "GB2312";
    private static final String CORRECT_BIG5 = "BIG5";

    public JspDataObject(FileObject fileObject, UniFileLoader uniFileLoader) throws DataObjectExistsException {
        super(fileObject, (MultiFileLoader)uniFileLoader);
        CookieSet cookieSet = this.getCookieSet();
        this.initialize();
    }

    public Lookup getLookup() {
        return this.currentLookup;
    }

    public CookieSet getCookieSet0() {
        return super.getCookieSet();
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz.isAssignableFrom(BaseJspEditorSupport.class)) {
            return this.getJspEditorSupport();
        }
        return super.getCookie(clazz);
    }

    protected Node createNodeDelegate() {
        return new JspNode(this);
    }

    private synchronized BaseJspEditorSupport getJspEditorSupport() {
        if (this.editorSupport == null) {
            this.editorSupport = new BaseJspEditorSupport(this);
        }
        return this.editorSupport;
    }

    protected EditorCookie createServletEditor() {
        return new ServletEditor(this);
    }

    public synchronized CompileData getPlugin() {
        if (this.compileData == null) {
            if (this.firstStart) {
                this.firstStart = false;
            }
            this.compileData = new CompileData(this);
            this.checkRefreshServlet();
        }
        return this.compileData;
    }

    public synchronized void refreshPlugin(boolean bl) {
        this.compileData = null;
        if (bl) {
            this.getPlugin();
        }
    }

    public void refreshPlugin() {
        this.refreshPlugin(true);
    }

    public JspServletDataObject getServletDataObject() {
        this.getPlugin();
        return this.servletDataObject;
    }

    public String getContentLanguage() {
        return "text/html";
    }

    public String getScriptingLanguage() {
        return "text/x-java";
    }

    public String getFileEncoding() {
        String string;
        if (!this.isEncodingRetrieved) {
            this.updateFileEncoding(false);
            this.isEncodingRetrieved = true;
        }
        String string2 = string = (string = (String)this.getPrimaryFile().getAttribute(ATTR_FILE_ENCODING)) != null ? string : DEFAULT_ENCODING;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "Retrieved encoding for " + this.getPrimaryFile().getNameExt() + " is " + string);
        }
        return string;
    }

    void updateFileEncoding(boolean bl) {
        TagLibParseSupport tagLibParseSupport = (TagLibParseSupport)this.getCookie(TagLibParseSupport.class);
        if (tagLibParseSupport != null) {
            String string = tagLibParseSupport.getCachedOpenInfo(true, bl).getEncoding();
            try {
                this.getPrimaryFile().setAttribute(ATTR_FILE_ENCODING, (Object)string);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, null, iOException);
            }
        }
    }

    private static String canonizeEncoding(String string) {
        if (Charset.isSupported(string)) {
            Charset charset = Charset.forName(string);
            string = charset.name();
        }
        if (string.equalsIgnoreCase("MS932")) {
            return CORRECT_WINDOWS_31J;
        }
        if (string.equalsIgnoreCase("euc-jp-linux")) {
            return CORRECT_EUC_JP;
        }
        if (string.equalsIgnoreCase("EUC-CN")) {
            return CORRECT_GB2312;
        }
        if (string.equalsIgnoreCase("GBK")) {
            return CORRECT_GB2312;
        }
        if (string.equalsIgnoreCase("GB18030")) {
            return CORRECT_GB2312;
        }
        if (string.equalsIgnoreCase("EUC-TW")) {
            return CORRECT_BIG5;
        }
        return string;
    }

    private void initialize() {
        this.firstStart = true;
        this.listener = new Listener();
        this.listener.register(this.getPrimaryFile());
        this.refreshPlugin(false);
        this.createLookup();
        assert (this.currentLookup != null);
    }

    private void checkRefreshServlet() {
        JspServletDataObject jspServletDataObject = this.servletDataObject;
        try {
            FileObject fileObject = this.updateServletFileObject();
            if (fileObject != null) {
                String string;
                if (jspServletDataObject != null && jspServletDataObject.getPrimaryFile() == fileObject && fileObject.lastModified().equals(this.servletDataObjectDate)) {
                    return;
                }
                JspServletDataObject.setSourceJspPage(fileObject, (DataObject)this);
                DataLoaderPool.setPreferredLoader((FileObject)fileObject, (DataLoader)DataLoader.getLoader(JspServletDataLoader.class));
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                if (dataObject instanceof JspServletDataObject) {
                    this.servletDataObject = (JspServletDataObject)dataObject;
                    this.servletDataObjectDate = dataObject.getPrimaryFile().lastModified();
                }
                if ((string = this.compileData.getServletEncoding()) != null) {
                    if (!"".equals(string)) {
                        try {
                            Charset.forName(string);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            IOException iOException = new IOException(NbBundle.getMessage(JspDataObject.class, (String)"FMT_UnsupportedEncoding", (Object)string));
                            iOException.initCause(illegalArgumentException);
                            Logger.getLogger("global").log(Level.INFO, null, iOException);
                        }
                    } else {
                        string = null;
                    }
                }
                try {
                    fileObject.setAttribute(ATTR_FILE_ENCODING, (Object)string);
                }
                catch (IOException iOException) {
                    Logger.getLogger("global").log(Level.INFO, null, iOException);
                }
            } else {
                this.servletDataObject = null;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, null, iOException);
            this.servletDataObject = null;
        }
        if (jspServletDataObject != null) {
            RequestProcessor.postRequest((Runnable)new Runnable(){

                public void run() {
                    JspDataObject.this.updateServletEditor();
                    JspDataObject.this.firePropertyChange0(JspDataObject.PROP_SERVLET_DATAOBJECT, null, (Object)JspDataObject.this.getServletDataObject());
                    JspDataObject.this.firePropertyChange0("cookie", null, null);
                }
            });
        }
    }

    public void firePropertyChange0(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    public EditorCookie getServletEditor() {
        JspServletDataObject jspServletDataObject = this.getServletDataObject();
        if (jspServletDataObject == null != (this.servletEdit == null)) {
            this.updateServletEditor();
        }
        return this.servletEdit;
    }

    private void updateServletEditor() {
        if (this.servletDataObject == null) {
            if (this.servletEdit != null) {
                this.servletEdit.close();
                this.servletEdit = null;
            }
        } else if (this.servletEdit == null) {
            this.servletEdit = this.createServletEditor();
        }
    }

    private FileObject updateServletFileObject() throws IOException {
        return this.compileData.getServletFileObject();
    }

    public void setQueryString(String string) throws IOException {
        WebExecSupport.setQueryString(this.getPrimaryEntry().getFile(), string);
        this.firePropertyChange(PROP_REQUEST_PARAMS, null, null);
    }

    protected FileObject handleRename(String string) throws IOException {
        if ("".equals(string)) {
            throw new IOException(NbBundle.getMessage(JspDataObject.class, (String)"FMT_Not_Valid_FileName"));
        }
        FileObject fileObject = super.handleRename(string);
        return fileObject;
    }

    public void addSaveCookie(SaveCookie saveCookie) {
        this.getCookieSet().add((Node.Cookie)saveCookie);
    }

    public void removeSaveCookie() {
        Node.Cookie cookie = this.getCookie(SaveCookie.class);
        if (cookie != null) {
            this.getCookieSet().remove(cookie);
        }
    }

    protected FileObject handleMove(DataFolder dataFolder) throws IOException {
        FileObject fileObject = super.handleMove(dataFolder);
        TagLibParseSupport tagLibParseSupport = null;
        tagLibParseSupport = (TagLibParseSupport)this.getCookie(TagLibParseSupport.class);
        if (tagLibParseSupport != null) {
            this.getCookieSet().remove((Node.Cookie)tagLibParseSupport);
            tagLibParseSupport = new TagLibParseSupport(fileObject);
            this.getCookieSet().add((Node.Cookie)tagLibParseSupport);
        }
        return fileObject;
    }

    private void createLookup() {
        Lookup lookup = super.getLookup();
        FileEncodingQueryImplementation fileEncodingQueryImplementation = new FileEncodingQueryImplementation(){

            public Charset getEncoding(FileObject fileObject) {
                assert (fileObject != null);
                assert (fileObject.equals(JspDataObject.this.getPrimaryFile()));
                String string = JspDataObject.this.getFileEncoding();
                try {
                    return Charset.forName(string);
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    Boolean bl = (Boolean)fileObject.getAttribute("template");
                    if (bl == null || !bl.booleanValue()) {
                        Logger.getLogger("global").log(Level.INFO, "Detected illegal charset name in file " + fileObject.getNameExt() + " (" + illegalCharsetNameException.getMessage() + ")");
                    }
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    Logger.getLogger("global").log(Level.INFO, "Detected unsupported charset name in file " + fileObject.getNameExt() + " (" + unsupportedCharsetException.getMessage() + ")");
                }
                return null;
            }
        };
        this.currentLookup = new ProxyLookup(new Lookup[]{lookup, Lookups.singleton((Object)fileEncodingQueryImplementation)});
    }

    private class Listener
    extends FileChangeAdapter
    implements PropertyChangeListener {
        WeakReference weakListener;

        Listener() {
        }

        private void register(FileObject fileObject) {
            EventListener eventListener = WeakListeners.create(FileChangeListener.class, (EventListener)this, (Object)fileObject);
            fileObject.addFileChangeListener((FileChangeListener)eventListener);
            this.weakListener = new WeakReference<EventListener>(eventListener);
        }

        private void unregister(FileObject fileObject) {
            FileChangeListener fileChangeListener = (FileChangeListener)this.weakListener.get();
            if (fileChangeListener != null) {
                fileObject.removeFileChangeListener(fileChangeListener);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DataObject dataObject;
            if ("modified".equals(propertyChangeEvent.getPropertyName()) && Boolean.FALSE.equals(propertyChangeEvent.getNewValue())) {
                JspDataObject.this.refreshPlugin(false);
            }
            if ("primaryFile".equals(propertyChangeEvent.getPropertyName()) || "files".equals(propertyChangeEvent.getPropertyName())) {
                if (propertyChangeEvent.getOldValue() instanceof FileObject) {
                    this.unregister((FileObject)propertyChangeEvent.getOldValue());
                }
                if (propertyChangeEvent.getNewValue() instanceof FileObject) {
                    this.register((FileObject)propertyChangeEvent.getNewValue());
                }
                JspDataObject.this.refreshPlugin(true);
            }
            if ("valid".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getSource() instanceof DataObject && (dataObject = (DataObject)propertyChangeEvent.getSource()).getPrimaryFile().getPackageNameExt('/', '.').equals("")) {
                dataObject.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            JspDataObject.this.refreshPlugin(true);
        }

        private void serverChange() {
            JspDataObject.this.refreshPlugin(true);
            JspDataObject.this.firePropertyChange0(JspDataObject.PROP_SERVER_CHANGE, null, null);
        }
    }
}

