/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.io.File;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.deployment.devmodules.api.JSPServletFinder;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.core.jsploader.JspCompileUtil;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

public class CompileData {
    private JspDataObject jspPage;
    private FileObject docRoot;
    private String servletEncoding;
    private static final boolean debug = false;
    private File servletJavaRoot;
    private String servletResourceName;

    public CompileData(JspDataObject jspDataObject) {
        this.jspPage = jspDataObject;
        WebModule webModule = WebModule.getWebModule((FileObject)jspDataObject.getPrimaryFile());
        if (webModule != null) {
            this.docRoot = webModule.getDocumentBase();
            String string = JspCompileUtil.findRelativeContextPath(this.docRoot, jspDataObject.getPrimaryFile());
            JSPServletFinder jSPServletFinder = JSPServletFinder.findJSPServletFinder((FileObject)this.docRoot);
            this.servletJavaRoot = jSPServletFinder.getServletTempDirectory();
            this.servletResourceName = jSPServletFinder.getServletResourcePath(string);
            this.servletEncoding = jSPServletFinder.getServletEncoding(string);
        }
    }

    public FileObject getServletJavaRoot() {
        if (this.servletJavaRoot != null && this.servletJavaRoot.exists()) {
            return FileUtil.toFileObject((File)this.servletJavaRoot);
        }
        return null;
    }

    public String getServletResourceName() {
        return this.servletResourceName;
    }

    private File getServletFile() {
        if (this.servletJavaRoot == null) {
            return null;
        }
        URI uRI = this.servletJavaRoot.toURI();
        URI uRI2 = uRI.resolve(this.servletResourceName);
        return new File(uRI2);
    }

    public FileObject getServletFileObject() {
        FileObject fileObject = this.getServletJavaRoot();
        if (fileObject == null) {
            return null;
        }
        File file = this.getServletFile();
        if (file == null || !file.exists()) {
            return null;
        }
        FileObject fileObject2 = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        if (fileObject2 != null) {
            return fileObject2;
        }
        try {
            FileSystem fileSystem = fileObject.getFileSystem();
            fileObject.getFileSystem().refresh(false);
            return fileObject.getFileObject(this.getServletResourceName());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Logger.getLogger("global").log(Level.INFO, null, fileStateInvalidException);
            return null;
        }
    }

    public String getServletEncoding() {
        return this.servletEncoding;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("--COMPILE DATA--");
        stringBuffer.append("\n");
        stringBuffer.append("JSP page        : " + FileUtil.getFileDisplayName((FileObject)this.jspPage.getPrimaryFile()));
        stringBuffer.append("\n");
        stringBuffer.append("servletJavaRoot : " + this.servletJavaRoot + ", exists= " + (this.servletJavaRoot == null ? "false" : "" + this.servletJavaRoot.exists()));
        stringBuffer.append("\n");
        stringBuffer.append("servletResource : " + this.servletResourceName + ", fileobject exists= " + (this.getServletFileObject() != null));
        stringBuffer.append("\n");
        File file = this.getServletFile();
        if (file != null) {
            stringBuffer.append("servletFile : " + file.getAbsolutePath() + ", exists= " + this.getServletFile().exists());
        } else {
            stringBuffer.append("servletFile : null");
        }
        stringBuffer.append("\n");
        stringBuffer.append("--end COMPILE DATA--");
        return stringBuffer.toString();
    }
}

