/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints.options;

import java.util.prefs.Preferences;
import org.netbeans.modules.ruby.hints.infrastructure.RulesManager;
import org.netbeans.modules.ruby.hints.spi.HintSeverity;
import org.netbeans.modules.ruby.hints.spi.UserConfigurableRule;

public class HintsSettings {
    static final HintSeverity SEVERITY_DEFAUT = HintSeverity.WARNING;
    static final boolean IN_TASK_LIST_DEFAULT = true;
    static final String ENABLED_KEY = "enabled";
    static final String SEVERITY_KEY = "severity";
    static final String IN_TASK_LIST_KEY = "inTaskList";
    private static final String DEFAULT_PROFILE = "default";

    private HintsSettings() {
    }

    public static String getCurrentProfileId() {
        return DEFAULT_PROFILE;
    }

    public static boolean isEnabled(UserConfigurableRule userConfigurableRule) {
        Preferences preferences = RulesManager.getInstance().getPreferences(userConfigurableRule, HintsSettings.getCurrentProfileId());
        return HintsSettings.isEnabled(userConfigurableRule, preferences);
    }

    public static boolean isShowInTaskList(UserConfigurableRule userConfigurableRule) {
        Preferences preferences = RulesManager.getInstance().getPreferences(userConfigurableRule, HintsSettings.getCurrentProfileId());
        return HintsSettings.isShowInTaskList(userConfigurableRule, preferences);
    }

    public static boolean isEnabled(UserConfigurableRule userConfigurableRule, Preferences preferences) {
        return preferences.getBoolean(ENABLED_KEY, userConfigurableRule.getDefaultEnabled());
    }

    public static void setEnabled(Preferences preferences, boolean bl) {
        preferences.putBoolean(ENABLED_KEY, bl);
    }

    public static boolean isShowInTaskList(UserConfigurableRule userConfigurableRule, Preferences preferences) {
        return preferences.getBoolean(IN_TASK_LIST_KEY, userConfigurableRule.showInTasklist());
    }

    public static void setShowInTaskList(Preferences preferences, boolean bl) {
        preferences.putBoolean(IN_TASK_LIST_KEY, bl);
    }

    public static HintSeverity getSeverity(UserConfigurableRule userConfigurableRule, Preferences preferences) {
        String string = preferences.get(SEVERITY_KEY, null);
        return string == null ? userConfigurableRule.getDefaultSeverity() : HintSeverity.valueOf(string);
    }

    public static void setSeverity(Preferences preferences, HintSeverity hintSeverity) {
        preferences.put(SEVERITY_KEY, hintSeverity.name());
    }
}

