/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints.infrastructure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.jruby.ast.NodeType;
import org.jruby.common.IRubyWarnings;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.ruby.hints.infrastructure.Pair;
import org.netbeans.modules.ruby.hints.options.HintsSettings;
import org.netbeans.modules.ruby.hints.spi.AstRule;
import org.netbeans.modules.ruby.hints.spi.ErrorRule;
import org.netbeans.modules.ruby.hints.spi.HintSeverity;
import org.netbeans.modules.ruby.hints.spi.Rule;
import org.netbeans.modules.ruby.hints.spi.SelectionRule;
import org.netbeans.modules.ruby.hints.spi.UserConfigurableRule;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesManager {
    public static final Logger LOG = Logger.getLogger("org.netbeans.modules.ruby.hints");
    private static final String INSTANCE_EXT = ".instance";
    private static final String NON_GUI = "nonGUI";
    private static final String RULES_FOLDER = "org-netbeans-modules-ruby-hints/rules/";
    private static final String ERRORS = "errors";
    private static final String HINTS = "hints";
    private static final String SUGGESTIONS = "suggestions";
    private static final String SELECTION = "selection";
    private static Map<IRubyWarnings.ID, List<ErrorRule>> errors = new HashMap<IRubyWarnings.ID, List<ErrorRule>>();
    private static Map<NodeType, List<AstRule>> hints = new HashMap<NodeType, List<AstRule>>();
    private static Map<NodeType, List<AstRule>> suggestions = new HashMap<NodeType, List<AstRule>>();
    private static List<SelectionRule> selectionHints = new ArrayList<SelectionRule>();
    private static TreeModel errorsTreeModel;
    private static TreeModel hintsTreeModel;
    private static TreeModel suggestionsTreeModel;
    private static RulesManager INSTANCE;

    private RulesManager() {
        RulesManager.initErrors();
        RulesManager.initHints();
        RulesManager.initSuggestions();
        RulesManager.initSelectionHints();
    }

    public static synchronized RulesManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RulesManager();
        }
        return INSTANCE;
    }

    public HintSeverity getSeverity(UserConfigurableRule userConfigurableRule) {
        return HintsSettings.getSeverity(userConfigurableRule, this.getPreferences(userConfigurableRule, HintsSettings.getCurrentProfileId()));
    }

    public Preferences getPreferences(UserConfigurableRule userConfigurableRule, String string) {
        string = string == null ? HintsSettings.getCurrentProfileId() : string;
        return NbPreferences.forModule(this.getClass()).node(string).node(userConfigurableRule.getId());
    }

    public Map<IRubyWarnings.ID, List<ErrorRule>> getErrors() {
        return errors;
    }

    public Map<NodeType, List<AstRule>> getHints() {
        return hints;
    }

    public List<SelectionRule> getSelectionHints() {
        return selectionHints;
    }

    public Map<NodeType, List<AstRule>> getHints(boolean bl, CompilationInfo compilationInfo) {
        HashMap<NodeType, List<AstRule>> hashMap = new HashMap<NodeType, List<AstRule>>();
        for (Map.Entry<NodeType, List<AstRule>> entry : this.getHints().entrySet()) {
            LinkedList<AstRule> linkedList = new LinkedList<AstRule>();
            for (AstRule astRule : entry.getValue()) {
                Preferences preferences = this.getPreferences(astRule, null);
                if (preferences == null) {
                    if (bl || !astRule.appliesTo(compilationInfo)) continue;
                    linkedList.add(astRule);
                    continue;
                }
                if (this.getSeverity(astRule) == HintSeverity.CURRENT_LINE_WARNING) {
                    if (!bl || !astRule.appliesTo(compilationInfo)) continue;
                    linkedList.add(astRule);
                    continue;
                }
                if (bl || !astRule.appliesTo(compilationInfo)) continue;
                linkedList.add(astRule);
            }
            if (linkedList.isEmpty()) continue;
            hashMap.put(entry.getKey(), linkedList);
        }
        return hashMap;
    }

    public Map<NodeType, List<AstRule>> getSuggestions() {
        return suggestions;
    }

    public TreeModel getErrorsTreeModel() {
        return errorsTreeModel;
    }

    public TreeModel getHintsTreeModel() {
        return hintsTreeModel;
    }

    public TreeModel getSuggestionsTreeModel() {
        return suggestionsTreeModel;
    }

    private static void initErrors() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        errorsTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.getRoot().getFileObject("org-netbeans-modules-ruby-hints/rules/errors");
        List<Pair<Rule, FileObject>> list = RulesManager.readRules(fileObject);
        RulesManager.categorizeErrorRules(list, errors, fileObject, defaultMutableTreeNode);
    }

    private static void initHints() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        hintsTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.getRoot().getFileObject("org-netbeans-modules-ruby-hints/rules/hints");
        List<Pair<Rule, FileObject>> list = RulesManager.readRules(fileObject);
        RulesManager.categorizeAstRules(list, hints, fileObject, defaultMutableTreeNode);
    }

    private static void initSuggestions() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        suggestionsTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.getRoot().getFileObject("org-netbeans-modules-ruby-hints/rules/suggestions");
        List<Pair<Rule, FileObject>> list = RulesManager.readRules(fileObject);
        RulesManager.categorizeAstRules(list, suggestions, fileObject, defaultMutableTreeNode);
    }

    private static void initSelectionHints() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        suggestionsTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.getRoot().getFileObject("org-netbeans-modules-ruby-hints/rules/selection");
        List<Pair<Rule, FileObject>> list = RulesManager.readRules(fileObject);
        RulesManager.categorizeSelectionRules(list, selectionHints, fileObject, defaultMutableTreeNode);
    }

    private static List<Pair<Rule, FileObject>> readRules(FileObject fileObject) {
        LinkedList<Pair<Rule, FileObject>> linkedList = new LinkedList<Pair<Rule, FileObject>>();
        if (fileObject == null) {
            return linkedList;
        }
        Enumeration enumeration = fileObject.getData(true);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            String string = fileObject2.getNameExt().toLowerCase();
            if (!fileObject2.canRead()) continue;
            Rule rule = null;
            if (string.endsWith(INSTANCE_EXT)) {
                rule = RulesManager.instantiateRule(fileObject2);
            }
            if (rule == null) continue;
            linkedList.add(new Pair<Rule, FileObject>(rule, fileObject2));
        }
        return linkedList;
    }

    private static void categorizeErrorRules(List<Pair<Rule, FileObject>> list, Map<IRubyWarnings.ID, List<ErrorRule>> map, FileObject fileObject, DefaultMutableTreeNode defaultMutableTreeNode) {
        HashMap<FileObject, DefaultMutableTreeNode> hashMap = new HashMap<FileObject, DefaultMutableTreeNode>();
        hashMap.put(fileObject, defaultMutableTreeNode);
        for (Pair<Rule, FileObject> pair : list) {
            Rule rule = pair.getA();
            FileObject fileObject2 = pair.getB();
            if (rule instanceof ErrorRule) {
                RulesManager.addRule((ErrorRule)rule, map);
                FileObject fileObject3 = fileObject2.getParent();
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)hashMap.get(fileObject3);
                if (defaultMutableTreeNode2 == null) {
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(fileObject3);
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                    hashMap.put(fileObject3, defaultMutableTreeNode2);
                }
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(rule, false));
                continue;
            }
            LOG.log(Level.WARNING, "The rule defined in " + fileObject2.getPath() + "is not instance of ErrorRule");
        }
    }

    private static void categorizeAstRules(List<Pair<Rule, FileObject>> list, Map<NodeType, List<AstRule>> map, FileObject fileObject, DefaultMutableTreeNode defaultMutableTreeNode) {
        HashMap<FileObject, DefaultMutableTreeNode> hashMap = new HashMap<FileObject, DefaultMutableTreeNode>();
        hashMap.put(fileObject, defaultMutableTreeNode);
        for (Pair<Rule, FileObject> pair : list) {
            Rule rule = pair.getA();
            FileObject fileObject2 = pair.getB();
            if (rule instanceof AstRule) {
                Object object = fileObject2.getAttribute(NON_GUI);
                boolean bl = true;
                if (object != null && object instanceof Boolean && ((Boolean)object).booleanValue()) {
                    bl = false;
                }
                RulesManager.addRule((AstRule)rule, map);
                FileObject fileObject3 = fileObject2.getParent();
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)hashMap.get(fileObject3);
                if (defaultMutableTreeNode2 == null) {
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(fileObject3);
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                    hashMap.put(fileObject3, defaultMutableTreeNode2);
                }
                if (!bl) continue;
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(rule, false));
                continue;
            }
            LOG.log(Level.WARNING, "The rule defined in " + fileObject2.getPath() + "is not instance of AstRule");
        }
    }

    private static void categorizeSelectionRules(List<Pair<Rule, FileObject>> list, List<SelectionRule> list2, FileObject fileObject, DefaultMutableTreeNode defaultMutableTreeNode) {
        HashMap<FileObject, DefaultMutableTreeNode> hashMap = new HashMap<FileObject, DefaultMutableTreeNode>();
        hashMap.put(fileObject, defaultMutableTreeNode);
        for (Pair<Rule, FileObject> pair : list) {
            Rule rule = pair.getA();
            FileObject fileObject2 = pair.getB();
            if (rule instanceof SelectionRule) {
                RulesManager.addRule((SelectionRule)rule, list2);
                FileObject fileObject3 = fileObject2.getParent();
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)hashMap.get(fileObject3);
                if (defaultMutableTreeNode2 == null) {
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(fileObject3);
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                    hashMap.put(fileObject3, defaultMutableTreeNode2);
                }
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(rule, false));
                continue;
            }
            LOG.log(Level.WARNING, "The rule defined in " + fileObject2.getPath() + "is not instance of SelectionRule");
        }
    }

    private static void addRule(AstRule astRule, Map<NodeType, List<AstRule>> map) {
        for (NodeType nodeType : astRule.getKinds()) {
            List<AstRule> list = map.get(nodeType);
            if (list == null) {
                list = new LinkedList<AstRule>();
                map.put(nodeType, list);
            }
            list.add(astRule);
        }
    }

    private static void addRule(ErrorRule errorRule, Map<IRubyWarnings.ID, List<ErrorRule>> map) {
        for (IRubyWarnings.ID iD : errorRule.getCodes()) {
            List<ErrorRule> list = map.get(iD);
            if (list == null) {
                list = new LinkedList<ErrorRule>();
                map.put(iD, list);
            }
            list.add(errorRule);
        }
    }

    private static void addRule(SelectionRule selectionRule, List<SelectionRule> list) {
        list.add(selectionRule);
    }

    private static Rule instantiateRule(FileObject fileObject) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
            Object object = instanceCookie.instanceCreate();
            if (object instanceof Rule) {
                return (Rule)object;
            }
            return null;
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, null, iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.log(Level.INFO, null, classNotFoundException);
        }
        return null;
    }
}

