/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.hints.ConvertConditionals;
import org.netbeans.modules.ruby.hints.spi.AstRule;
import org.netbeans.modules.ruby.hints.spi.Description;
import org.netbeans.modules.ruby.hints.spi.Fix;
import org.netbeans.modules.ruby.hints.spi.HintSeverity;
import org.netbeans.modules.ruby.hints.spi.RuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetryOutsideRescue
implements AstRule {
    @Override
    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.RETRYNODE);
    }

    @Override
    public void run(RuleContext ruleContext, List<Description> list) {
        Node node = ruleContext.node;
        AstPath astPath = ruleContext.path;
        CompilationInfo compilationInfo = ruleContext.compilationInfo;
        if (!astPath.contains(NodeType.RESCUEBODYNODE)) {
            OffsetRange offsetRange = AstUtilities.getNameRange((Node)node);
            if ((offsetRange = LexUtilities.getLexerOffsets((CompilationInfo)compilationInfo, (OffsetRange)offsetRange)) != OffsetRange.NONE) {
                String string = NbBundle.getMessage(ConvertConditionals.class, (String)"RetryOutsideRescueMsg");
                Description description = new Description(this, string, compilationInfo.getFileObject(), offsetRange, Collections.<Fix>emptyList(), 100);
                list.add(description);
            }
        }
    }

    @Override
    public String getId() {
        return "RetryOutsideRescue";
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(ConvertConditionals.class, (String)"RetryOutsideRescueDesc");
    }

    @Override
    public boolean getDefaultEnabled() {
        return true;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    @Override
    public boolean appliesTo(CompilationInfo compilationInfo) {
        return true;
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(ConvertConditionals.class, (String)"RetryOutsideRescue");
    }

    @Override
    public boolean showInTasklist() {
        return true;
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }
}

