/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.ruby.Arity;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.NestedLocal;
import org.netbeans.modules.ruby.hints.spi.AstRule;
import org.netbeans.modules.ruby.hints.spi.Description;
import org.netbeans.modules.ruby.hints.spi.Fix;
import org.netbeans.modules.ruby.hints.spi.HintSeverity;
import org.netbeans.modules.ruby.hints.spi.RuleContext;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RailsViews
implements AstRule {
    @Override
    public boolean appliesTo(CompilationInfo compilationInfo) {
        return compilationInfo.getFileObject().getName().endsWith("_controller");
    }

    @Override
    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.DEFNNODE);
    }

    @Override
    public void run(RuleContext ruleContext, List<Description> list) {
        Node node = ruleContext.node;
        CompilationInfo compilationInfo = ruleContext.compilationInfo;
        FileObject fileObject = compilationInfo.getFileObject();
        assert (fileObject.getName().endsWith("_controller"));
        Arity arity = Arity.getDefArity((Node)node);
        if (arity.getMinArgs() != 0 || arity.getMaxArgs() != 0) {
            return;
        }
        String string = ((INameNode)node).getName();
        FileObject fileObject2 = RubyUtils.getRailsViewFor((FileObject)fileObject, (String)string, (boolean)false, (boolean)true);
        if (fileObject2 == null && this.shouldHaveView(compilationInfo, node)) {
            String string2 = NbBundle.getMessage(RailsViews.class, (String)"MissingView");
            OffsetRange offsetRange = AstUtilities.getNameRange((Node)node);
            List<Fix> list2 = Collections.singletonList(new CreateViewFix(fileObject, string));
            Description description = new Description(this, string2, fileObject, offsetRange, list2, 400);
            list.add(description);
        }
    }

    private boolean shouldHaveView(CompilationInfo compilationInfo, Node node) {
        Object object;
        if (node.nodeId == NodeType.FCALLNODE && ((String)(object = ((INameNode)node).getName())).startsWith("redirect_")) {
            return false;
        }
        object = node.childNodes();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            boolean bl = this.shouldHaveView(compilationInfo, node2);
            if (bl) continue;
            return bl;
        }
        return true;
    }

    @Override
    public String getId() {
        return "Rails_Views";
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(RailsViews.class, (String)"FindActionViews");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(RailsViews.class, (String)"FindActionViewsDesc");
    }

    @Override
    public boolean getDefaultEnabled() {
        return false;
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    @Override
    public boolean showInTasklist() {
        return false;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    private static class CreateViewFix
    implements Fix {
        private FileObject controller;
        private String action;

        CreateViewFix(FileObject fileObject, String string) {
            this.controller = fileObject;
            this.action = string;
        }

        public String getDescription() {
            return NbBundle.getMessage(NestedLocal.class, (String)"CreateView");
        }

        public void implement() throws Exception {
            String string = RubyUtils.getControllerName((FileObject)this.controller);
            Project project = FileOwnerQuery.getOwner((FileObject)this.controller);
            if (project == null) {
                return;
            }
            try {
                Class<?> clazz = Class.forName("org.netbeans.modules.ruby.railsprojects.GenerateAction", true, Thread.currentThread().getContextClassLoader());
                if (clazz != null) {
                    SystemAction systemAction = SystemAction.get(clazz);
                    Method method = clazz.getMethod("generate", Project.class, String.class, String.class, String.class);
                    method.invoke((Object)systemAction, project, "controller", string, this.action);
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }

        public boolean isSafe() {
            return false;
        }

        public boolean isInteractive() {
            return true;
        }
    }
}

