/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jruby.ast.Node;
import org.jruby.common.IRubyWarnings;
import org.jruby.lexer.yacc.ISourcePosition;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyParser;
import org.netbeans.modules.ruby.hints.spi.Description;
import org.netbeans.modules.ruby.hints.spi.EditList;
import org.netbeans.modules.ruby.hints.spi.ErrorRule;
import org.netbeans.modules.ruby.hints.spi.Fix;
import org.netbeans.modules.ruby.hints.spi.HintSeverity;
import org.netbeans.modules.ruby.hints.spi.PreviewableFix;
import org.netbeans.modules.ruby.hints.spi.RuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertParens
implements ErrorRule {
    @Override
    public Set<IRubyWarnings.ID> getCodes() {
        return Collections.singleton(IRubyWarnings.ID.PARENTHISE_ARGUMENTS);
    }

    @Override
    public void run(RuleContext ruleContext, RubyParser.RubyError rubyError, List<Description> list) {
        int n;
        AstPath astPath;
        Node node;
        CompilationInfo compilationInfo = ruleContext.compilationInfo;
        Node node2 = AstUtilities.getRoot((CompilationInfo)compilationInfo);
        if (node2 != null && (node = (astPath = new AstPath(node2, n = rubyError.getStartPosition())).leaf()) != null) {
            OffsetRange offsetRange = AstUtilities.getRange((Node)node);
            Node node3 = null;
            if (AstUtilities.isCall((Node)astPath.leafParent())) {
                node3 = astPath.leafParent();
            } else if (astPath.leafGrandParent() != null && AstUtilities.isCall((Node)astPath.leafGrandParent())) {
                node3 = astPath.leafGrandParent();
            } else if (AstUtilities.isCall((Node)node)) {
                node3 = node;
            }
            if (node3 != null) {
                InsertParenFix insertParenFix = new InsertParenFix(compilationInfo, node3);
                List<Fix> list2 = Collections.singletonList(insertParenFix);
                if ((offsetRange = LexUtilities.getLexerOffsets((CompilationInfo)compilationInfo, (OffsetRange)offsetRange)) != OffsetRange.NONE) {
                    Description description = new Description(this, this.getDisplayName(), compilationInfo.getFileObject(), offsetRange, list2, 500);
                    list.add(description);
                }
            }
        }
    }

    @Override
    public boolean appliesTo(CompilationInfo compilationInfo) {
        return compilationInfo.getFileObject().getMIMEType().equals("text/x-ruby");
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(InsertParens.class, (String)"InsertParens");
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    @Override
    public boolean showInTasklist() {
        return false;
    }

    private static class InsertParenFix
    implements PreviewableFix {
        private final CompilationInfo info;
        private final Node node;

        InsertParenFix(CompilationInfo compilationInfo, Node node) {
            this.info = compilationInfo;
            this.node = node;
        }

        public String getDescription() {
            return NbBundle.getMessage(InsertParens.class, (String)"InsertParenFix");
        }

        public void implement() throws Exception {
            this.getEditList().apply();
        }

        public EditList getEditList() throws Exception {
            ISourcePosition iSourcePosition = this.node.getPosition();
            int n = iSourcePosition.getEndOffset();
            BaseDocument baseDocument = (BaseDocument)this.info.getDocument();
            EditList editList = new EditList(baseDocument);
            if (n > baseDocument.getLength()) {
                return editList;
            }
            assert (AstUtilities.isCall((Node)this.node));
            OffsetRange offsetRange = AstUtilities.getCallRange((Node)this.node);
            OffsetRange offsetRange2 = LexUtilities.getLexerOffsets((CompilationInfo)this.info, (OffsetRange)offsetRange);
            if (offsetRange2 == OffsetRange.NONE) {
                return editList;
            }
            int n2 = offsetRange2.getEnd();
            if (Character.isWhitespace(baseDocument.getText(n2, 1).charAt(0))) {
                editList.replace(n2, 1, "(", false, 0);
            } else {
                editList.replace(n2, 0, "(", false, 0);
                ++n;
            }
            for (int i = n - 1; i >= 0; --i) {
                char c = baseDocument.getText(i, 1).charAt(0);
                if (Character.isWhitespace(c)) continue;
                n = i + 1;
                break;
            }
            editList.replace(n, 0, ")", false, 1);
            return editList;
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean canPreview() {
            return true;
        }
    }
}

