/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import org.jruby.ast.HashNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.ruby.hints.Deprecations;
import org.netbeans.modules.ruby.hints.spi.AstRule;
import org.netbeans.modules.ruby.hints.spi.Description;
import org.netbeans.modules.ruby.hints.spi.EditList;
import org.netbeans.modules.ruby.hints.spi.Fix;
import org.netbeans.modules.ruby.hints.spi.HintSeverity;
import org.netbeans.modules.ruby.hints.spi.PreviewableFix;
import org.netbeans.modules.ruby.hints.spi.RuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashListConvert
implements AstRule {
    @Override
    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.HASHNODE);
    }

    @Override
    public void run(RuleContext ruleContext, List<Description> list) {
        Node node = ruleContext.node;
        CompilationInfo compilationInfo = ruleContext.compilationInfo;
        HashNode hashNode = (HashNode)node;
        ListNode listNode = hashNode.getListNode();
        if (listNode == null) {
            return;
        }
        if (listNode.size() < 2) {
            return;
        }
        int n = HashListConvert.getCommaOffset(ruleContext, listNode, 0);
        if (n == -1) {
            return;
        }
        OffsetRange offsetRange = new OffsetRange(n, n + 1);
        String string = NbBundle.getMessage(HashListConvert.class, (String)"HashListConvertGutter");
        List<Fix> list2 = Collections.singletonList(new HashFix(ruleContext, listNode));
        Description description = new Description(this, string, compilationInfo.getFileObject(), offsetRange, list2, 140);
        list.add(description);
    }

    private static int getCommaOffset(RuleContext ruleContext, ListNode listNode, int n) {
        int n2;
        int n3 = listNode.get(2 * n).getPosition().getEndOffset();
        OffsetRange offsetRange = LexUtilities.getLexerOffsets((CompilationInfo)ruleContext.compilationInfo, (OffsetRange)new OffsetRange(n3, n2 = listNode.get(2 * n + 1).getPosition().getStartOffset()));
        if (offsetRange == OffsetRange.NONE) {
            return -1;
        }
        try {
            String string = ruleContext.doc.getText(offsetRange.getStart(), offsetRange.getLength());
            int n4 = string.indexOf(44);
            if (n4 == -1 || string.indexOf("=>") != -1) {
                return -1;
            }
            return offsetRange.getStart() + n4;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    @Override
    public String getId() {
        return "HashListConvert";
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(HashListConvert.class, (String)"HashListConvertDesc");
    }

    @Override
    public boolean getDefaultEnabled() {
        return true;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    @Override
    public boolean appliesTo(CompilationInfo compilationInfo) {
        return true;
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(HashListConvert.class, (String)"HashListConvert");
    }

    @Override
    public boolean showInTasklist() {
        return true;
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    private static class HashFix
    implements PreviewableFix {
        private RuleContext context;
        private ListNode listNode;

        public HashFix(RuleContext ruleContext, ListNode listNode) {
            this.context = ruleContext;
            this.listNode = listNode;
        }

        public String getDescription() {
            return NbBundle.getMessage(Deprecations.class, (String)"HashListConvertFix");
        }

        public void implement() throws Exception {
            this.getEditList().apply();
        }

        public EditList getEditList() throws Exception {
            BaseDocument baseDocument = this.context.doc;
            EditList editList = new EditList(baseDocument);
            int n = this.listNode.size() / 2;
            for (int i = 0; i < n; ++i) {
                int n2 = HashListConvert.getCommaOffset(this.context, this.listNode, i);
                if (n2 == -1) continue;
                String string = baseDocument.getText(n2, 3);
                StringBuilder stringBuilder = new StringBuilder();
                if (!Character.isWhitespace(baseDocument.getText(n2 - 1, 1).charAt(0))) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append("=>");
                if (n2 < baseDocument.getLength() - 2 && !Character.isWhitespace(baseDocument.getText(n2 + 1, 1).charAt(0))) {
                    stringBuilder.append(' ');
                }
                editList.replace(n2, 1, stringBuilder.toString(), false, 0);
            }
            return editList;
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean canPreview() {
            return true;
        }
    }
}

