/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.lexer.yacc.ISourcePosition;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.hints.spi.AstRule;
import org.netbeans.modules.ruby.hints.spi.Description;
import org.netbeans.modules.ruby.hints.spi.EditList;
import org.netbeans.modules.ruby.hints.spi.Fix;
import org.netbeans.modules.ruby.hints.spi.HintSeverity;
import org.netbeans.modules.ruby.hints.spi.PreviewableFix;
import org.netbeans.modules.ruby.hints.spi.RuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandSameLineDef
implements AstRule {
    @Override
    public boolean appliesTo(CompilationInfo compilationInfo) {
        return compilationInfo.getFileObject().getMIMEType().equals("text/x-ruby");
    }

    @Override
    public Set<NodeType> getKinds() {
        HashSet<NodeType> hashSet = new HashSet<NodeType>();
        hashSet.add(NodeType.CLASSNODE);
        hashSet.add(NodeType.DEFNNODE);
        hashSet.add(NodeType.DEFSNODE);
        return hashSet;
    }

    @Override
    public void run(RuleContext ruleContext, List<Description> list) {
        Node node = ruleContext.node;
        AstPath astPath = ruleContext.path;
        CompilationInfo compilationInfo = ruleContext.compilationInfo;
        BaseDocument baseDocument = ruleContext.doc;
        if (node.nodeId == NodeType.DEFNNODE || node.nodeId == NodeType.DEFSNODE || node.nodeId == NodeType.CLASSNODE) {
            ISourcePosition iSourcePosition = node.getPosition();
            try {
                if (baseDocument == null) {
                    return;
                }
                int n = iSourcePosition.getStartOffset();
                int n2 = iSourcePosition.getEndOffset();
                int n3 = baseDocument.getLength();
                if (Utilities.getRowEnd((BaseDocument)baseDocument, (int)Math.min(n, n3)) == Utilities.getRowEnd((BaseDocument)baseDocument, (int)Math.min(n2, n3))) {
                    Node node2 = AstUtilities.getRoot((CompilationInfo)compilationInfo);
                    if (astPath.leaf() != node) {
                        astPath = new AstPath(node2, node);
                    }
                    List<Fix> list2 = Collections.singletonList(new ExpandLineFix(compilationInfo, astPath));
                    OffsetRange offsetRange = new OffsetRange(iSourcePosition.getStartOffset(), iSourcePosition.getEndOffset());
                    Description description = new Description(this, this.getDisplayName(), compilationInfo.getFileObject(), offsetRange, list2, 150);
                    list.add(description);
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
    }

    public void cancel() {
    }

    @Override
    public String getId() {
        return "Expand_Same_Line_Def";
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(ExpandSameLineDef.class, (String)"ExpandLine");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(ExpandSameLineDef.class, (String)"ExpandLineDesc");
    }

    @Override
    public boolean getDefaultEnabled() {
        return true;
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.CURRENT_LINE_WARNING;
    }

    @Override
    public boolean showInTasklist() {
        return false;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExpandLineFix
    implements PreviewableFix {
        private CompilationInfo info;
        private AstPath path;

        ExpandLineFix(CompilationInfo compilationInfo, AstPath astPath) {
            this.info = compilationInfo;
            this.path = astPath;
        }

        @Override
        public String getDescription() {
            String string = this.path.leaf().nodeId == NodeType.DEFNNODE ? "def" : "class";
            return NbBundle.getMessage(ExpandSameLineDef.class, (String)"ExpandLineFix", (Object)string);
        }

        private void findLineBreaks(Node node, Set<Integer> set) {
            if (node.nodeId == NodeType.NEWLINENODE) {
                set.add(node.getPosition().getStartOffset());
            }
            List list = node.childNodes();
            for (Node node2 : list) {
                this.findLineBreaks(node2, set);
            }
        }

        @Override
        public void implement() throws Exception {
            this.getEditList().apply();
        }

        @Override
        public EditList getEditList() throws Exception {
            EditList editList;
            Token token;
            BaseDocument baseDocument = (BaseDocument)this.info.getDocument();
            ISourcePosition iSourcePosition = this.path.leaf().getPosition();
            int n = iSourcePosition.getStartOffset();
            int n2 = iSourcePosition.getEndOffset();
            if (n2 > baseDocument.getLength()) {
                if (n > baseDocument.getLength()) {
                    n = baseDocument.getLength();
                }
                n2 = baseDocument.getLength();
            }
            HashSet<Integer> hashSet = new HashSet<Integer>();
            this.findLineBreaks(this.path.leaf(), hashSet);
            TokenSequence tokenSequence = LexUtilities.getRubyTokenSequence((BaseDocument)baseDocument, (int)n2);
            if (tokenSequence != null) {
                tokenSequence.move(n2);
                while (tokenSequence.movePrevious() && tokenSequence.offset() > n) {
                    token = tokenSequence.token();
                    editList = token.id();
                    if (editList == RubyTokenId.IDENTIFIER && ";".equals(((Object)token.text()).toString())) {
                        hashSet.add(tokenSequence.offset());
                        continue;
                    }
                    if (editList != RubyTokenId.CLASS && editList != RubyTokenId.DEF && editList != RubyTokenId.END) continue;
                    hashSet.add(tokenSequence.offset());
                }
            }
            token = new ArrayList(hashSet);
            Collections.sort(token);
            Collections.reverse(token);
            editList = new EditList(baseDocument);
            if (token.size() > 0) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                try {
                    int n3 = -1;
                    Iterator iterator = token.iterator();
                    while (iterator.hasNext()) {
                        int n4 = (Integer)iterator.next();
                        if (n4 == n3) continue;
                        n3 = n4;
                        if (";".equals(baseDocument.getText(n4, 1))) {
                            editList.replace(n4, 1, null, false, 1);
                            if (arrayList.contains(n4 + 2)) continue;
                        }
                        if (arrayList.contains(n4 + 1) || arrayList.contains(n4)) continue;
                        editList.replace(n4, 0, "\n", false, 2);
                        arrayList.add(n4);
                    }
                    editList.format();
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
            return editList;
        }

        @Override
        public boolean isSafe() {
            return true;
        }

        @Override
        public boolean isInteractive() {
            return false;
        }

        @Override
        public boolean canPreview() {
            return true;
        }
    }
}

