/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.jruby.ast.FCallNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.StrNode;
import org.jruby.ast.types.INameNode;
import org.jruby.util.ByteList;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.hints.spi.AstRule;
import org.netbeans.modules.ruby.hints.spi.Description;
import org.netbeans.modules.ruby.hints.spi.EditList;
import org.netbeans.modules.ruby.hints.spi.Fix;
import org.netbeans.modules.ruby.hints.spi.HintSeverity;
import org.netbeans.modules.ruby.hints.spi.PreviewableFix;
import org.netbeans.modules.ruby.hints.spi.RuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.awt.HtmlBrowser;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Deprecations
implements AstRule {
    static Set<NodeType> kinds = new HashSet<NodeType>();
    private static Map<String, Deprecation> deprecatedMethods = new HashMap<String, Deprecation>();
    private static Map<String, Deprecation> deprecatedRequires = new HashMap<String, Deprecation>();

    @Override
    public boolean appliesTo(CompilationInfo compilationInfo) {
        return true;
    }

    @Override
    public Set<NodeType> getKinds() {
        return kinds;
    }

    @Override
    public void run(RuleContext ruleContext, List<Description> list) {
        String string;
        boolean bl;
        Node node = ruleContext.node;
        CompilationInfo compilationInfo = ruleContext.compilationInfo;
        String string2 = ((INameNode)node).getName();
        Deprecation deprecation = null;
        if ("require".equals(string2)) {
            bl = true;
            string = Deprecations.getStringArg(node);
            if (string != null) {
                deprecation = deprecatedRequires.get(string);
            }
        } else if (deprecatedMethods.containsKey(string2)) {
            bl = false;
            deprecation = deprecatedMethods.get(string2);
        } else {
            return;
        }
        if (deprecation != null) {
            string = AstUtilities.getNameRange((Node)node);
            if ((string = LexUtilities.getLexerOffsets((CompilationInfo)compilationInfo, (OffsetRange)string)) != OffsetRange.NONE) {
                String string3 = bl ? "DeprecatedRequire" : "DeprecatedMethodUse";
                String string4 = NbBundle.getMessage(Deprecations.class, (String)(deprecation.descriptionKey != null ? deprecation.descriptionKey : string3), (Object)deprecation.oldName, (Object)deprecation.newName);
                ArrayList<Fix> arrayList = new ArrayList<Fix>();
                if (!bl) {
                    arrayList.add(new DeprecationCallFix(compilationInfo, node, deprecation, false));
                }
                if (deprecation.helpUrl != null) {
                    arrayList.add(new DeprecationCallFix(compilationInfo, node, deprecation, true));
                }
                Description description = new Description(this, string4, compilationInfo.getFileObject(), (OffsetRange)string, arrayList, 100);
                list.add(description);
            }
        }
    }

    private static String getStringArg(Node node) {
        ByteList byteList;
        Node node2;
        ListNode listNode;
        Node node3;
        if (node.nodeId == NodeType.FCALLNODE && (node3 = ((FCallNode)node).getArgsNode()) instanceof ListNode && (listNode = (ListNode)node3).size() > 0 && (node2 = listNode.get(0)) instanceof StrNode && (byteList = ((StrNode)node2).getValue()) != null && byteList.length() > 0) {
            return byteList.toString();
        }
        return null;
    }

    public void cancel() {
    }

    @Override
    public String getId() {
        return "Deprecations";
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(Deprecations.class, (String)"Deprecation");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(Deprecations.class, (String)"DeprecationDesc");
    }

    @Override
    public boolean getDefaultEnabled() {
        return true;
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    @Override
    public boolean showInTasklist() {
        return true;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    static {
        kinds.add(NodeType.FCALLNODE);
        kinds.add(NodeType.VCALLNODE);
        kinds.add(NodeType.CALLNODE);
        Deprecation deprecation = new Deprecation("require_gem", "gem", "HELP_require_gem", "http://www.ruby-forum.com/topic/136010");
        deprecatedMethods.put(deprecation.oldName, deprecation);
        Deprecation deprecation2 = new Deprecation("assert_raises", "assert_raise", "HELP_assert_raises", "http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-talk/155815");
        deprecatedMethods.put(deprecation2.oldName, deprecation2);
        Deprecation deprecation3 = new Deprecation("getopts", "optparse", null, null);
        deprecatedRequires.put(deprecation3.oldName, deprecation3);
        deprecation3 = new Deprecation("cgi-lib", "cgi", null, null);
        deprecatedRequires.put(deprecation3.oldName, deprecation3);
        deprecation3 = new Deprecation("importenv", "(no replacement)", null, null);
        deprecatedRequires.put(deprecation3.oldName, deprecation3);
        deprecation3 = new Deprecation("parsearg", "optparse", null, null);
        deprecatedRequires.put(deprecation3.oldName, deprecation3);
        deprecation3 = new Deprecation("ftools", "fileutils", "HELP_ftools", null);
        deprecatedRequires.put(deprecation3.oldName, deprecation3);
    }

    private static class DeprecationCallFix
    implements PreviewableFix {
        private CompilationInfo info;
        private Node node;
        private Deprecation deprecation;
        private boolean help;

        public DeprecationCallFix(CompilationInfo compilationInfo, Node node, Deprecation deprecation, boolean bl) {
            this.info = compilationInfo;
            this.node = node;
            this.deprecation = deprecation;
            this.help = bl;
        }

        public String getDescription() {
            if (this.help) {
                return NbBundle.getMessage(Deprecations.class, (String)"ShowDeprecationHelp");
            }
            return NbBundle.getMessage(Deprecations.class, (String)"DeprecationFix", (Object)this.deprecation.oldName, (Object)this.deprecation.newName);
        }

        public void implement() throws Exception {
            if (this.help) {
                URL uRL = new URL(this.deprecation.helpUrl);
                HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
            } else {
                EditList editList = this.getEditList();
                if (editList != null) {
                    editList.apply();
                }
            }
        }

        public EditList getEditList() throws Exception {
            BaseDocument baseDocument = (BaseDocument)this.info.getDocument();
            OffsetRange offsetRange = AstUtilities.getCallRange((Node)this.node);
            EditList editList = new EditList(baseDocument);
            if (offsetRange != OffsetRange.NONE) {
                if ("require_gem".equals(this.deprecation.oldName)) {
                    String string = Deprecations.getStringArg(this.node);
                    int n = Utilities.getRowEnd((BaseDocument)baseDocument, (int)offsetRange.getStart());
                    editList.replace(offsetRange.getStart(), offsetRange.getLength(), this.deprecation.newName, false, 0);
                    if (string != null) {
                        editList.replace(n, 0, "\nrequire \"" + string + "\"", false, 1);
                    }
                    editList.format();
                } else {
                    editList.replace(offsetRange.getStart(), offsetRange.getLength(), this.deprecation.newName, false, 0);
                }
            }
            return editList;
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean canPreview() {
            return !this.help;
        }
    }

    private static class Deprecation {
        private String oldName;
        private String newName;
        private String descriptionKey;
        private String helpUrl;

        public Deprecation(String string, String string2, String string3, String string4) {
            this.oldName = string;
            this.newName = string2;
            this.descriptionKey = string3;
            this.helpUrl = string4;
        }
    }
}

