/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.jruby.ast.IterNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.EditRegions;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.hints.spi.AstRule;
import org.netbeans.modules.ruby.hints.spi.Description;
import org.netbeans.modules.ruby.hints.spi.EditList;
import org.netbeans.modules.ruby.hints.spi.Fix;
import org.netbeans.modules.ruby.hints.spi.HintSeverity;
import org.netbeans.modules.ruby.hints.spi.PreviewableFix;
import org.netbeans.modules.ruby.hints.spi.RuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockVarReuse
implements AstRule {
    @Override
    public boolean appliesTo(CompilationInfo compilationInfo) {
        return true;
    }

    @Override
    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.ITERNODE);
    }

    public void cancel() {
    }

    @Override
    public String getId() {
        return "Block_Var_Reuse";
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(BlockVarReuse.class, (String)"UnintentionalSideEffect");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(BlockVarReuse.class, (String)"UnintentionalSideEffectDesc");
    }

    @Override
    public void run(RuleContext ruleContext, List<Description> list) {
        Node node = ruleContext.node;
        CompilationInfo compilationInfo = ruleContext.compilationInfo;
        if (node.nodeId == NodeType.ITERNODE) {
            List list2 = node.childNodes();
            for (Node node2 : list2) {
                if (node2.nodeId != NodeType.LOCALASGNNODE) continue;
                OffsetRange offsetRange = AstUtilities.getNameRange((Node)node2);
                ArrayList<Fix> arrayList = new ArrayList<Fix>(2);
                Node node3 = AstUtilities.getRoot((CompilationInfo)compilationInfo);
                AstPath astPath = new AstPath(node3, node2);
                arrayList.add(new RenameVarFix(compilationInfo, astPath, false));
                arrayList.add(new RenameVarFix(compilationInfo, astPath, true));
                if ((offsetRange = LexUtilities.getLexerOffsets((CompilationInfo)compilationInfo, (OffsetRange)offsetRange)) == OffsetRange.NONE) continue;
                Description description = new Description(this, this.getDisplayName(), compilationInfo.getFileObject(), offsetRange, arrayList, 100);
                list.add(description);
            }
        }
    }

    @Override
    public boolean getDefaultEnabled() {
        return true;
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    @Override
    public boolean showInTasklist() {
        return true;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RenameVarFix
    implements PreviewableFix {
        private CompilationInfo info;
        private AstPath path;
        private boolean renameLocal;

        RenameVarFix(CompilationInfo compilationInfo, AstPath astPath, boolean bl) {
            this.info = compilationInfo;
            this.path = astPath;
            this.renameLocal = bl;
        }

        @Override
        public String getDescription() {
            if (this.renameLocal) {
                return NbBundle.getMessage(BlockVarReuse.class, (String)"ChangeLocalVarName");
            }
            return NbBundle.getMessage(BlockVarReuse.class, (String)"ChangeBlockVarName");
        }

        @Override
        public void implement() throws Exception {
            Set<OffsetRange> set = this.findRegionsToEdit();
            int n = Integer.MAX_VALUE;
            for (OffsetRange offsetRange : set) {
                if (offsetRange.getStart() >= n) continue;
                n = offsetRange.getStart();
            }
            EditRegions.getInstance().edit(this.info.getFileObject(), set, n);
        }

        private void addNonBlockRefs(Node node, String string, Set<OffsetRange> set) {
            List list;
            if ((node.nodeId == NodeType.LOCALASGNNODE || node.nodeId == NodeType.LOCALVARNODE) && string.equals(((INameNode)node).getName())) {
                list = AstUtilities.getNameRange((Node)node);
                if ((list = LexUtilities.getLexerOffsets((CompilationInfo)this.info, (OffsetRange)list)) != OffsetRange.NONE) {
                    set.add((OffsetRange)list);
                }
            }
            list = node.childNodes();
            for (Node node2 : list) {
                if (node2.nodeId == NodeType.DEFNNODE || node2.nodeId == NodeType.DEFSNODE || node2.nodeId == NodeType.ITERNODE && node2 == this.path.leafParent()) continue;
                this.addNonBlockRefs(node2, string, set);
            }
        }

        private Set<OffsetRange> findRegionsToEdit() {
            HashSet<OffsetRange> hashSet = new HashSet<OffsetRange>();
            assert (this.path.leaf() instanceof INameNode);
            String string = ((INameNode)this.path.leaf()).getName();
            if (this.renameLocal) {
                Node node = AstUtilities.findLocalScope((Node)this.path.leaf(), (AstPath)this.path);
                this.addNonBlockRefs(node, string, hashSet);
            } else {
                Node node = this.path.leafParent();
                assert (node instanceof IterNode);
                this.addNonBlockRefs(node, string, hashSet);
            }
            return hashSet;
        }

        @Override
        public boolean isSafe() {
            return false;
        }

        @Override
        public boolean isInteractive() {
            return true;
        }

        @Override
        public EditList getEditList() throws Exception {
            BaseDocument baseDocument = (BaseDocument)this.info.getDocument();
            EditList editList = new EditList(baseDocument);
            Set<OffsetRange> set = this.findRegionsToEdit();
            String string = ((INameNode)this.path.leaf()).getName();
            int n = string.length();
            String string2 = "new_name";
            for (OffsetRange offsetRange : set) {
                editList.replace(offsetRange.getStart(), n, string2, false, 0);
            }
            return editList;
        }

        @Override
        public boolean canPreview() {
            return true;
        }
    }
}

