/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.wizards.importstep;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JComponent;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnFileNode;
import org.netbeans.modules.subversion.ui.commit.CommitTable;
import org.netbeans.modules.subversion.ui.wizards.AbstractStep;
import org.netbeans.modules.subversion.ui.wizards.importstep.PreviewPanel;
import org.netbeans.modules.subversion.util.Context;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ImportPreviewStep
extends AbstractStep {
    private PreviewPanel previewPanel;
    private Context context;
    private CommitTable table;

    public ImportPreviewStep(Context context) {
        this.context = context;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(ImportPreviewStep.class);
    }

    protected JComponent createComponent() {
        if (this.previewPanel == null) {
            this.previewPanel = new PreviewPanel();
            this.table = new CommitTable(this.previewPanel.tableLabel, CommitTable.IMPORT_COLUMNS, new String[]{"path"});
            JComponent jComponent = this.table.getComponent();
            this.previewPanel.tablePanel.setLayout(new BorderLayout());
            this.previewPanel.tablePanel.add((Component)jComponent, "Center");
        }
        return this.previewPanel;
    }

    protected void validateBeforeNext() {
        this.validateUserInput();
    }

    public void validateUserInput() {
        if (this.table != null && this.table.getCommitFiles().size() > 0) {
            this.valid();
        } else {
            this.invalid(NbBundle.getMessage(ImportPreviewStep.class, (String)"CTL_Import_NothingToImport"));
        }
    }

    public void setup(String string, String string2) {
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        File[] fileArray = fileStatusCache.listFiles(this.context, 6612);
        if (fileArray.length == 0) {
            return;
        }
        if (string != null) {
            this.table.setRootFile(string, string2);
        }
        ArrayList<SvnFileNode> arrayList = new ArrayList<SvnFileNode>(fileArray.length);
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            SvnFileNode svnFileNode = new SvnFileNode(file);
            arrayList.add(svnFileNode);
        }
        SvnFileNode[] svnFileNodeArray = arrayList.toArray(new SvnFileNode[fileArray.length]);
        this.table.setNodes(svnFileNodeArray);
        this.validateUserInput();
    }

    public Map getCommitFiles() {
        return this.table.getCommitFiles();
    }

    public void storeTableSorter() {
    }
}

