/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.wizards.checkoutstep;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.net.MalformedURLException;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.ui.browser.RepositoryPaths;
import org.netbeans.modules.subversion.ui.wizards.AbstractStep;
import org.netbeans.modules.subversion.ui.wizards.CheckoutWizard;
import org.netbeans.modules.subversion.ui.wizards.checkoutstep.CheckoutPanel;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class CheckoutStep
extends AbstractStep
implements ActionListener,
DocumentListener,
FocusListener {
    public static final String CHECKOUT_DIRECTORY = "checkoutStep.checkoutDirectory";
    private CheckoutPanel workdirPanel;
    private RepositoryPaths repositoryPaths;

    public HelpCtx getHelp() {
        return new HelpCtx(CheckoutStep.class);
    }

    protected JComponent createComponent() {
        if (this.workdirPanel == null) {
            this.workdirPanel = new CheckoutPanel();
            this.workdirPanel.browseWorkdirButton.addActionListener(this);
            this.workdirPanel.browseRepositoryButton.addActionListener(this);
            this.workdirPanel.scanForProjectsCheckBox.addActionListener(this);
            this.workdirPanel.workdirTextField.setText(this.defaultWorkingDirectory().getPath());
            this.workdirPanel.workdirTextField.getDocument().addDocumentListener(this);
            this.workdirPanel.workdirTextField.addFocusListener(this);
            this.workdirPanel.repositoryPathTextField.getDocument().addDocumentListener(this);
            this.workdirPanel.repositoryPathTextField.addFocusListener(this);
            this.workdirPanel.revisionTextField.getDocument().addDocumentListener(this);
            this.workdirPanel.revisionTextField.addFocusListener(this);
        }
        this.validateUserInput(true);
        return this.workdirPanel;
    }

    public void setup(RepositoryFile repositoryFile) {
        if (this.repositoryPaths == null) {
            this.repositoryPaths = new RepositoryPaths(repositoryFile, this.workdirPanel.repositoryPathTextField, this.workdirPanel.browseRepositoryButton, this.workdirPanel.revisionTextField, this.workdirPanel.searchRevisionButton);
            String string = NbBundle.getMessage(CheckoutStep.class, (String)"LBL_BrowserMessage");
            int n = 9;
            this.repositoryPaths.setupBehavior(string, n, "org.netbeans.modules.subversion.ui.browser.checkout", "org.netbeans.modules.subversion.ui.search.checkout");
        } else {
            this.repositoryPaths.setRepositoryFile(repositoryFile);
        }
        this.workdirPanel.repositoryPathTextField.setText(repositoryFile.getPath());
        if (!repositoryFile.getRevision().equals((Object)SVNRevision.HEAD)) {
            this.workdirPanel.revisionTextField.setText(repositoryFile.getRevision().toString());
        } else {
            this.workdirPanel.revisionTextField.setText("");
        }
        this.workdirPanel.scanForProjectsCheckBox.setSelected(SvnModuleConfig.getDefault().getShowCheckoutCompleted());
    }

    protected void validateBeforeNext() {
        boolean bl;
        String string;
        File file;
        if (this.validateUserInput(true) && !(file = new File(string = this.workdirPanel.workdirTextField.getText())).exists() && !(bl = file.mkdirs())) {
            this.invalid(NbBundle.getMessage(CheckoutWizard.class, (String)"BK2013") + file.getPath());
        }
    }

    private boolean validateUserInput(boolean bl) {
        String string;
        if (this.repositoryPaths != null) {
            try {
                this.repositoryPaths.getRepositoryFiles();
            }
            catch (NumberFormatException numberFormatException) {
                this.invalid(NbBundle.getMessage(CheckoutStep.class, (String)"BK2018"));
                return false;
            }
            catch (MalformedURLException malformedURLException) {
                this.invalid(NbBundle.getMessage(CheckoutStep.class, (String)"BK2015"));
                return false;
            }
        }
        if ((string = this.workdirPanel.workdirTextField.getText()) == null || string.length() == 0) {
            this.invalid(NbBundle.getMessage(CheckoutStep.class, (String)"BK2014"));
            return false;
        }
        String string2 = null;
        if (bl) {
            File file = new File(string);
            if (!file.exists()) {
                for (File file2 = file.getParentFile(); file2 != null; file2 = file2.getParentFile()) {
                    if (!file2.exists()) continue;
                    if (!file2.canWrite()) {
                        string2 = NbBundle.getMessage(CheckoutStep.class, (String)"BK2016") + file2.getPath();
                    }
                    break;
                }
            } else if (file.isFile()) {
                string2 = NbBundle.getMessage(CheckoutStep.class, (String)"BK2017");
            }
        }
        if (string2 == null) {
            this.valid();
        } else {
            this.invalid(string2);
        }
        return string2 == null;
    }

    private void onBrowseWorkdir() {
        File file = this.defaultWorkingDirectory();
        AccessibleJFileChooser accessibleJFileChooser = new AccessibleJFileChooser(NbBundle.getMessage(CheckoutStep.class, (String)"ACSD_BrowseFolder"), file);
        accessibleJFileChooser.setDialogTitle(NbBundle.getMessage(CheckoutStep.class, (String)"BK0010"));
        accessibleJFileChooser.setMultiSelectionEnabled(false);
        FileFilter[] fileFilterArray = accessibleJFileChooser.getChoosableFileFilters();
        for (int i = 0; i < fileFilterArray.length; ++i) {
            FileFilter fileFilter = fileFilterArray[i];
            accessibleJFileChooser.removeChoosableFileFilter(fileFilter);
        }
        accessibleJFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }

            public String getDescription() {
                return NbBundle.getMessage(CheckoutStep.class, (String)"BK0008");
            }
        });
        accessibleJFileChooser.setFileSelectionMode(1);
        accessibleJFileChooser.showDialog(this.workdirPanel, NbBundle.getMessage(CheckoutStep.class, (String)"BK0009"));
        File file2 = accessibleJFileChooser.getSelectedFile();
        if (file2 != null) {
            this.workdirPanel.workdirTextField.setText(file2.getAbsolutePath());
        }
    }

    private File defaultWorkingDirectory() {
        Object object;
        Object object2 = null;
        String string = this.workdirPanel.workdirTextField.getText();
        if (string != null && !string.trim().equals("")) {
            for (object = new File(string); object != null && !((File)object).exists(); object = ((File)object).getParentFile()) {
            }
            if (object != null) {
                object2 = ((File)object).isFile() ? ((File)object).getParentFile() : object;
            }
        }
        if (object2 == null && (object = SvnModuleConfig.getDefault().getPreferences().get(CHECKOUT_DIRECTORY, null)) != null) {
            object2 = new File((String)object);
        }
        if (object2 == null && ((File)(object = ProjectChooser.getProjectsFolder())).exists() && ((File)object).isDirectory()) {
            object2 = object;
        }
        if (object2 == null) {
            object2 = new File(System.getProperty("user.home"));
        }
        return object2;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.validateUserInput(false);
        this.refreshSkipLabel();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.validateUserInput(false);
        this.refreshSkipLabel();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.validateUserInput(true);
        this.refreshSkipLabel();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.workdirPanel.browseWorkdirButton) {
            this.onBrowseWorkdir();
        } else if (actionEvent.getSource() == this.workdirPanel.scanForProjectsCheckBox) {
            SvnModuleConfig.getDefault().setShowCheckoutCompleted(this.workdirPanel.scanForProjectsCheckBox.isSelected());
        }
    }

    public File getWorkdir() {
        return new File(this.workdirPanel.workdirTextField.getText());
    }

    public RepositoryFile[] getRepositoryFiles() {
        try {
            return this.repositoryPaths.getRepositoryFiles(".");
        }
        catch (MalformedURLException malformedURLException) {
            Subversion.LOG.log(Level.INFO, null, malformedURLException);
            return null;
        }
    }

    public boolean isAtWorkingDirLevel() {
        return this.workdirPanel.atWorkingDirLevelCheckBox.isSelected();
    }

    private void refreshSkipLabel() {
        if (this.workdirPanel.repositoryPathTextField.getText().trim().equals("")) {
            this.resetWorkingDirLevelCheckBox();
            return;
        }
        RepositoryFile[] repositoryFileArray = null;
        try {
            repositoryFileArray = this.repositoryPaths.getRepositoryFiles();
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (repositoryFileArray == null || repositoryFileArray.length > 1) {
            this.resetWorkingDirLevelCheckBox();
            return;
        }
        String string = repositoryFileArray[0].getFileUrl().getLastPathSegment().trim();
        if (string.equals("") || string.equals(".")) {
            this.resetWorkingDirLevelCheckBox();
            return;
        }
        this.workdirPanel.atWorkingDirLevelCheckBox.setText(NbBundle.getMessage(CheckoutStep.class, (String)"CTL_Checkout_CheckoutContentFolder", (Object[])new Object[]{string}));
        this.workdirPanel.atWorkingDirLevelCheckBox.setEnabled(true);
    }

    private void resetWorkingDirLevelCheckBox() {
        this.workdirPanel.atWorkingDirLevelCheckBox.setText(NbBundle.getMessage(CheckoutStep.class, (String)"CTL_Checkout_CheckoutContentEmpty"));
        this.workdirPanel.atWorkingDirLevelCheckBox.setEnabled(false);
    }
}

