/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.update;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.update.FileUpdateInfo;
import org.netbeans.modules.subversion.ui.update.UpdateResults;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningOutputManager;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.utils.SVNStatusUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateAction
extends ContextAction {
    @Override
    protected String getBaseName(Node[] nodeArray) {
        return "CTL_MenuItem_Update";
    }

    @Override
    protected int getFileEnabledStatus() {
        return 4088;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    @Override
    protected void performContextAction(Node[] nodeArray) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        this.performUpdate(nodeArray);
    }

    private void performUpdate(final Node[] nodeArray) {
        final Context context = this.getContext(nodeArray);
        ContextAction.ProgressSupport progressSupport = new ContextAction.ProgressSupport(this, nodeArray){

            public void perform() {
                UpdateAction.update(context, this, UpdateAction.this.getContextDisplayName(nodeArray));
            }
        };
        progressSupport.start(this.createRequestProcessor(nodeArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void update(Context context, SvnProgressSupport svnProgressSupport, String string) {
        SvnClient svnClient;
        int n;
        SVNUrl sVNUrl;
        File[] fileArray = context.getRootFiles();
        try {
            sVNUrl = SvnUtils.getRepositoryRootUrl(fileArray[0]);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        fileStatusCache.refreshCached(context);
        File[][] fileArray2 = Utils.splitFlatOthers((File[])fileArray);
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        for (n = 0; n < fileArray2[1].length; ++n) {
            arrayList.add(fileArray2[1][n]);
        }
        for (n = 0; n < fileArray2[0].length; ++n) {
            arrayList2.add(fileArray2[0][n]);
        }
        UpdateOutputListener updateOutputListener = new UpdateOutputListener();
        try {
            svnClient = Subversion.getInstance().getClient(sVNUrl);
            svnClient.addNotifyListener(updateOutputListener);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        try {
            UpdateAction.updateRoots(arrayList, svnProgressSupport, svnClient, true);
            if (svnProgressSupport.isCanceled()) {
                return;
            }
            UpdateAction.updateRoots(arrayList2, svnProgressSupport, svnClient, false);
        }
        catch (SVNClientException sVNClientException) {
            svnProgressSupport.annotate(sVNClientException);
        }
        finally {
            UpdateAction.openResults(updateOutputListener.getResults(), sVNUrl, string);
        }
    }

    private static void openResults(final List<FileUpdateInfo> list, final SVNUrl sVNUrl, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UpdateResults updateResults = new UpdateResults(list, sVNUrl, string);
                VersioningOutputManager versioningOutputManager = VersioningOutputManager.getInstance();
                versioningOutputManager.addComponent(sVNUrl.toString() + "-UpdateExecutor", (JComponent)updateResults);
            }
        });
    }

    private static void updateRoots(List<File> list, SvnProgressSupport svnProgressSupport, SvnClient svnClient, boolean bl) throws SVNClientException {
        boolean bl2 = false;
        for (File file : list) {
            ISVNStatus[] iSVNStatusArray;
            if (svnProgressSupport.isCanceled()) break;
            svnClient.update(file, SVNRevision.HEAD, bl);
            if (bl) {
                SvnUtils.refreshRecursively(file);
            } else {
                ISVNStatus iSVNStatus;
                iSVNStatusArray = Subversion.getInstance().getStatusCache();
                iSVNStatusArray.onNotify(file, null);
                if (file.isDirectory() && (iSVNStatus = file.listFiles()) != null) {
                    for (ISVNStatus iSVNStatus2 : iSVNStatus) {
                        iSVNStatusArray.onNotify((File)iSVNStatus2, null);
                    }
                }
            }
            iSVNStatusArray = svnClient.getStatus(file, true, false);
            for (int i = 0; i < iSVNStatusArray.length; ++i) {
                ISVNStatus iSVNStatus = iSVNStatusArray[i];
                if (!SVNStatusUtils.isTextConflicted((ISVNStatus)iSVNStatus) && !SVNStatusUtils.isPropConflicted((ISVNStatus)iSVNStatus)) continue;
                bl2 = true;
            }
        }
        if (bl2) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(UpdateAction.class, (String)"MSG_Update_Conflicts"));
        } else {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(UpdateAction.class, (String)"MSG_Update_Completed"));
        }
    }

    public static void performUpdate(final Context context, final String string) {
        SVNUrl sVNUrl;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        if (context == null || context.getRoots().size() == 0) {
            return;
        }
        try {
            sVNUrl = UpdateAction.getSvnUrl(context);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        RequestProcessor requestProcessor = Subversion.getInstance().getRequestProcessor(sVNUrl);
        SvnProgressSupport svnProgressSupport = new SvnProgressSupport(){

            public void perform() {
                UpdateAction.update(context, this, string);
            }
        };
        svnProgressSupport.start(requestProcessor, sVNUrl, NbBundle.getMessage(UpdateAction.class, (String)"MSG_Update_Progress"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpdateOutputListener
    implements ISVNNotifyListener {
        private List<FileUpdateInfo> results;

        private UpdateOutputListener() {
        }

        public void setCommand(int n) {
        }

        public void logCommandLine(String string) {
        }

        public void logMessage(String string) {
            FileUpdateInfo[] fileUpdateInfoArray = FileUpdateInfo.createFromLogMsg(string);
            if (fileUpdateInfoArray != null) {
                for (FileUpdateInfo fileUpdateInfo : fileUpdateInfoArray) {
                    if (fileUpdateInfo == null) continue;
                    this.getResults().add(fileUpdateInfo);
                }
            }
        }

        public void logError(String string) {
        }

        public void logRevision(long l, String string) {
        }

        public void logCompleted(String string) {
        }

        public void onNotify(File file, SVNNodeKind sVNNodeKind) {
        }

        List<FileUpdateInfo> getResults() {
            if (this.results == null) {
                this.results = new ArrayList<FileUpdateInfo>();
            }
            return this.results;
        }
    }
}

