/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.io.File;
import java.util.Calendar;
import java.util.Date;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.history.SearchHistoryTopComponent;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SearchHistoryAction
extends ContextAction {
    static final int DIRECTORY_ENABLED_STATUS = -8;
    static final int FILE_ENABLED_STATUS = -8;

    protected String getBaseName(Node[] nodeArray) {
        return "CTL_MenuItem_SearchHistory";
    }

    protected int getFileEnabledStatus() {
        return -8;
    }

    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performContextAction(Node[] nodeArray) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        String string = NbBundle.getMessage(SearchHistoryAction.class, (String)"CTL_SearchHistory_Title", (Object)this.getContextDisplayName(nodeArray));
        this.openHistory(this.getContext(nodeArray), string);
    }

    private void openHistory(final Context context, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchHistoryTopComponent searchHistoryTopComponent = new SearchHistoryTopComponent(context);
                searchHistoryTopComponent.setDisplayName(string);
                searchHistoryTopComponent.open();
                searchHistoryTopComponent.requestActive();
                File[] fileArray = context.getFiles();
                if (fileArray.length == 1 && fileArray[0].isFile() || fileArray.length > 1 && Utils.shareCommonDataObject((File[])fileArray)) {
                    searchHistoryTopComponent.search();
                }
            }
        });
    }

    public static void openSearch(String string, String string2, String string3, Date date) {
        SearchHistoryAction.openSearch(SearchHistoryAction.getDefaultContext(), string, string2, string3, date);
    }

    public static void openSearch(Context context, String string, String string2, String string3, Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        Date date2 = calendar.getTime();
        calendar.setTime(date);
        calendar.add(5, -1);
        Date date3 = calendar.getTime();
        if (string2 != null && string2.indexOf(10) != -1) {
            string2 = string2.substring(0, string2.indexOf(10));
        }
        SearchHistoryTopComponent searchHistoryTopComponent = new SearchHistoryTopComponent(context, string2, string3, date3, date2);
        String string4 = NbBundle.getMessage(SearchHistoryAction.class, (String)"CTL_SearchHistory_Title", (Object)string);
        searchHistoryTopComponent.setDisplayName(string4);
        searchHistoryTopComponent.open();
        searchHistoryTopComponent.requestActive();
        searchHistoryTopComponent.search();
    }

    private static Context getDefaultContext() {
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        return SvnUtils.getProjectsContext(projectArray);
    }

    public static void openSearch(SVNUrl sVNUrl, File file, long l) {
        SearchHistoryTopComponent searchHistoryTopComponent = new SearchHistoryTopComponent(sVNUrl, file, l);
        String string = NbBundle.getMessage(SearchHistoryAction.class, (String)"CTL_SearchHistory_Title", (Object)sVNUrl);
        searchHistoryTopComponent.setDisplayName(string);
        searchHistoryTopComponent.open();
        searchHistoryTopComponent.requestActive();
        searchHistoryTopComponent.search();
    }
}

