/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.browser;

import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.browser.BrowserAction;
import org.netbeans.modules.subversion.ui.browser.BrowserClient;
import org.netbeans.modules.subversion.ui.browser.BrowserPanel;
import org.netbeans.modules.subversion.ui.browser.RepositoryPathNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Browser
implements VetoableChangeListener,
BrowserClient,
TreeExpansionListener {
    public static final int BROWSER_SHOW_FILES = 1;
    public static final int BROWSER_SINGLE_SELECTION_ONLY = 2;
    public static final int BROWSER_FILES_SELECTION_ONLY = 4;
    public static final int BROWSER_FOLDERS_SELECTION_ONLY = 8;
    public static final int BROWSER_SELECT_ANYTHING = 12;
    public static final String BROWSER_HELP_ID_SEARCH_HISTORY = "org.netbeans.modules.subversion.ui.browser.searchhistory";
    public static final String BROWSER_HELP_ID_CHECKOUT = "org.netbeans.modules.subversion.ui.browser.checkout";
    public static final String BROWSER_HELP_ID_URL_PATTERN = "org.netbeans.modules.subversion.ui.browser.urlpattern";
    public static final String BROWSER_HELP_ID_MERGE = "org.netbeans.modules.subversion.ui.browser.merge";
    public static final String BROWSER_HELP_ID_SWITCH_TO = "org.netbeans.modules.subversion.ui.browser.switchto";
    public static final String BROWSER_HELP_ID_COPY = "org.netbeans.modules.subversion.ui.browser.copy";
    public static final String BROWSER_HELP_ID_IMPORT = "org.netbeans.modules.subversion.ui.browser.import";
    private final int mode;
    private final String helpID;
    private static final RepositoryFile[] EMPTY_ROOT = new RepositoryFile[0];
    private static final Action[] EMPTY_ACTIONS = new Action[0];
    private final BrowserPanel panel;
    private RepositoryFile repositoryRoot;
    private Action[] nodeActions;
    private boolean keepWarning = false;
    private boolean initialSelection = true;
    private List<SvnProgressSupport> supportList = new ArrayList<SvnProgressSupport>();
    private volatile boolean cancelled = false;

    public Browser(String string, int n, RepositoryFile repositoryFile, RepositoryFile[] repositoryFileArray, BrowserAction[] browserActionArray, String string2) {
        this.mode = n;
        this.helpID = string2;
        this.panel = new BrowserPanel(string, NbBundle.getMessage(Browser.class, (String)"ACSN_RepositoryTree"), NbBundle.getMessage(Browser.class, (String)"ACSD_RepositoryTree"), (n & 2) == 2);
        this.panel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RepositoryPathNode.class, (String)"CTL_Browser_Prompt"));
        this.panel.addTreeExpansionListener(this);
        this.getExplorerManager().addVetoableChangeListener((VetoableChangeListener)this);
        if (browserActionArray != null) {
            this.nodeActions = browserActionArray;
            this.panel.setActions(browserActionArray);
            for (int i = 0; i < browserActionArray.length; ++i) {
                browserActionArray[i].setBrowser(this);
            }
        } else {
            this.nodeActions = EMPTY_ACTIONS;
        }
        this.repositoryRoot = repositoryFile;
        RepositoryPathNode repositoryPathNode = RepositoryPathNode.createRepositoryRootNode(this, repositoryFile);
        repositoryPathNode.expand();
        Node[] nodeArray = this.getSelectedNodes(repositoryPathNode, repositoryFile, repositoryFileArray);
        this.getExplorerManager().setRootContext((Node)repositoryPathNode);
        if (nodeArray == null) {
            nodeArray = new Node[]{};
        }
        try {
            this.getExplorerManager().setSelectedNodes(nodeArray);
            for (int i = 0; i < nodeArray.length; ++i) {
                this.getExplorerManager().setExploredContext(nodeArray[i]);
            }
            if (nodeArray.length > 0) {
                ((RepositoryPathNode)nodeArray[nodeArray.length - 1]).expand();
            } else {
                repositoryPathNode.expand();
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            Subversion.LOG.log(Level.INFO, null, propertyVetoException);
        }
    }

    public RepositoryFile[] getRepositoryFiles() {
        if (!this.show()) {
            this.cancel();
            return EMPTY_ROOT;
        }
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        this.cancel();
        if (nodeArray.length == 0) {
            return EMPTY_ROOT;
        }
        RepositoryFile[] repositoryFileArray = new RepositoryFile[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            repositoryFileArray[i] = ((RepositoryPathNode)nodeArray[i]).getEntry().getRepositoryFile();
        }
        return repositoryFileArray;
    }

    private boolean show() {
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.getBrowserPanel(), NbBundle.getMessage(Browser.class, (String)"CTL_Browser_BrowseFolders_Title"));
        dialogDescriptor.setModal(true);
        dialogDescriptor.setHelpCtx(new HelpCtx(this.helpID));
        dialogDescriptor.setValid(false);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                    dialogDescriptor.setValid(Browser.this.getSelectedNodes().length > 0);
                }
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Browser.class, (String)"CTL_Browser_BrowseFolders_Title"));
        dialog.setVisible(true);
        return DialogDescriptor.OK_OPTION.equals(dialogDescriptor.getValue());
    }

    private Node[] getSelectedNodes(RepositoryPathNode repositoryPathNode, RepositoryFile repositoryFile, RepositoryFile[] repositoryFileArray) {
        if (repositoryFileArray == null || repositoryFileArray.length <= 0) {
            return null;
        }
        RepositoryPathNode repositoryPathNode2 = null;
        ArrayList<RepositoryPathNode> arrayList = new ArrayList<RepositoryPathNode>(repositoryFileArray.length);
        for (int i = 0; i < repositoryFileArray.length; ++i) {
            String[] stringArray = repositoryFileArray[i].getPathSegments();
            repositoryPathNode2 = repositoryPathNode;
            RepositoryFile repositoryFile2 = repositoryFile;
            for (int j = 0; j < stringArray.length; ++j) {
                repositoryFile2 = repositoryFile2.appendPath(stringArray[j]);
                RepositoryPathNode repositoryPathNode3 = j == stringArray.length - 1 ? RepositoryPathNode.createRepositoryPathNode((BrowserClient)this, repositoryFile2) : RepositoryPathNode.createPreselectedPathNode(this, repositoryFile2);
                repositoryPathNode2.getChildren().add(new Node[]{repositoryPathNode3});
                repositoryPathNode2 = repositoryPathNode3;
            }
            arrayList.add(repositoryPathNode2);
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel() {
        SvnProgressSupport[] svnProgressSupportArray = null;
        Node node = this.supportList;
        synchronized (node) {
            this.cancelled = true;
            svnProgressSupportArray = this.supportList.toArray(new SvnProgressSupport[this.supportList.size()]);
            this.supportList.clear();
        }
        node = this.getExplorerManager().getRootContext();
        if (node != null) {
            this.getExplorerManager().setRootContext(Node.EMPTY);
            try {
                node.destroy();
                if (svnProgressSupportArray != null && svnProgressSupportArray.length > 0) {
                    for (SvnProgressSupport svnProgressSupport : svnProgressSupportArray) {
                        svnProgressSupport.cancel();
                    }
                }
            }
            catch (IOException iOException) {
                Subversion.LOG.log(Level.INFO, null, iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RepositoryPathNode.RepositoryPathEntry> listRepositoryPath(RepositoryPathNode.RepositoryPathEntry repositoryPathEntry, SvnProgressSupport svnProgressSupport) throws SVNClientException {
        ISVNDirEntry[] iSVNDirEntryArray;
        ArrayList<RepositoryPathNode.RepositoryPathEntry> arrayList = new ArrayList<RepositoryPathNode.RepositoryPathEntry>();
        List<SvnProgressSupport> list = this.supportList;
        synchronized (list) {
            if (this.cancelled) {
                svnProgressSupport.cancel();
                return arrayList;
            }
            this.supportList.add(svnProgressSupport);
        }
        try {
            if (repositoryPathEntry.getSvnNodeKind().equals((Object)SVNNodeKind.FILE)) {
                list = arrayList;
                return list;
            }
            list = Subversion.getInstance().getClient(this.repositoryRoot.getRepositoryUrl(), svnProgressSupport);
            if (svnProgressSupport.isCanceled()) {
                List<RepositoryPathNode.RepositoryPathEntry> list2 = null;
                return list2;
            }
            iSVNDirEntryArray = list.getList(repositoryPathEntry.getRepositoryFile().getFileUrl(), repositoryPathEntry.getRepositoryFile().getRevision(), false);
            if (iSVNDirEntryArray == null || iSVNDirEntryArray.length == 0) {
                ArrayList<RepositoryPathNode.RepositoryPathEntry> arrayList2 = arrayList;
                return arrayList2;
            }
            for (int i = 0; i < iSVNDirEntryArray.length; ++i) {
                ISVNDirEntry iSVNDirEntry;
                if (svnProgressSupport.isCanceled()) {
                    iSVNDirEntry = null;
                    return iSVNDirEntry;
                }
                iSVNDirEntry = iSVNDirEntryArray[i];
                if (iSVNDirEntry.getNodeKind() != SVNNodeKind.DIR && (iSVNDirEntry.getNodeKind() != SVNNodeKind.FILE || (this.mode & 1) != 1)) continue;
                RepositoryFile repositoryFile = new RepositoryFile(repositoryPathEntry.getRepositoryFile().getRepositoryUrl(), repositoryPathEntry.getRepositoryFile().getFileUrl().appendPath(iSVNDirEntry.getPath()), (SVNRevision)iSVNDirEntry.getLastChangedRevision());
                RepositoryPathNode.RepositoryPathEntry repositoryPathEntry2 = new RepositoryPathNode.RepositoryPathEntry(repositoryFile, iSVNDirEntry.getNodeKind(), (SVNRevision)iSVNDirEntry.getLastChangedRevision(), iSVNDirEntry.getLastChangedDate(), iSVNDirEntry.getLastCommitAuthor());
                arrayList.add(repositoryPathEntry2);
            }
        }
        catch (SVNClientException sVNClientException) {
            if (SvnClientExceptionHandler.isWrongURLInRevision(sVNClientException.getMessage())) {
                iSVNDirEntryArray = null;
                return iSVNDirEntryArray;
            }
            svnProgressSupport.annotate(sVNClientException);
            throw sVNClientException;
        }
        finally {
            List<SvnProgressSupport> list3 = this.supportList;
            synchronized (list3) {
                this.supportList.remove(svnProgressSupport);
            }
        }
        return arrayList;
    }

    private JPanel getBrowserPanel() {
        return this.panel;
    }

    public Node[] getSelectedNodes() {
        return this.getExplorerManager().getSelectedNodes();
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            boolean bl = !this.initialSelection;
            this.initialSelection = false;
            if (!this.keepWarning) {
                this.panel.warning(null);
            }
            this.keepWarning = false;
            Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
            Node[] nodeArray2 = (Node[])propertyChangeEvent.getOldValue();
            if (nodeArray == null || nodeArray.length == 0) {
                return;
            }
            if ((this.mode & 4) == 4 && this.checkForNodeType(nodeArray, SVNNodeKind.DIR)) {
                this.panel.warning(NbBundle.getMessage(Browser.class, (String)"LBL_Warning_FileSelectionOnly"));
                if (bl) {
                    this.keepWarning = true;
                }
                throw new PropertyVetoException("", propertyChangeEvent);
            }
            if ((this.mode & 8) == 8 && this.checkForNodeType(nodeArray, SVNNodeKind.FILE)) {
                this.panel.warning(NbBundle.getMessage(Browser.class, (String)"LBL_Warning_FolderSelectionOnly"));
                if (bl) {
                    this.keepWarning = true;
                }
                throw new PropertyVetoException("", propertyChangeEvent);
            }
            if (nodeArray2.length == 0 && nodeArray.length == 1) {
                return;
            }
            if (nodeArray2.length != 0 && this.areDisjunct(nodeArray2, nodeArray)) {
                return;
            }
            Node node = null;
            node = nodeArray2.length > 0 ? nodeArray2[0] : nodeArray[0];
            if (!this.selectionIsAtLevel(nodeArray, this.getNodeLevel(node))) {
                this.panel.warning(NbBundle.getMessage(Browser.class, (String)"LBL_Warning_NoMultiSelection"));
                if (bl) {
                    this.keepWarning = true;
                }
                throw new PropertyVetoException("", propertyChangeEvent);
            }
        }
    }

    private boolean checkForNodeType(Node[] nodeArray, SVNNodeKind sVNNodeKind) {
        for (int i = 0; i < nodeArray.length; ++i) {
            RepositoryPathNode repositoryPathNode;
            if (!(nodeArray[i] instanceof RepositoryPathNode) || (repositoryPathNode = (RepositoryPathNode)nodeArray[i]).getEntry().getSvnNodeKind() != sVNNodeKind) continue;
            return true;
        }
        return false;
    }

    private boolean selectionIsAtLevel(Node[] nodeArray, int n) {
        for (int i = 0; i < nodeArray.length; ++i) {
            if (this.getNodeLevel(nodeArray[i]) == n) continue;
            return false;
        }
        return true;
    }

    private boolean areDisjunct(Node[] nodeArray, Node[] nodeArray2) {
        for (int i = 0; i < nodeArray.length; ++i) {
            if (!this.isInArray(nodeArray[i], nodeArray2)) continue;
            return false;
        }
        return true;
    }

    private int getNodeLevel(Node node) {
        int n = 0;
        while (node != null) {
            node = node.getParentNode();
            ++n;
        }
        return n;
    }

    private boolean isInArray(Node node, Node[] nodeArray) {
        for (int i = 0; i < nodeArray.length; ++i) {
            if (node != nodeArray[i]) continue;
            return true;
        }
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getExplorerManager().addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getExplorerManager().removePropertyChangeListener(propertyChangeListener);
    }

    ExplorerManager getExplorerManager() {
        return this.panel.getExplorerManager();
    }

    @Override
    public Action[] getActions() {
        return this.nodeActions;
    }

    void setSelectedNodes(Node[] nodeArray) throws PropertyVetoException {
        this.getExplorerManager().setSelectedNodes(nodeArray);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        Object object = treeExpansionEvent.getPath().getLastPathComponent();
        if (object == null) {
            return;
        }
        Node node = Visualizer.findNode((Object)object);
        if (node instanceof RepositoryPathNode) {
            RepositoryPathNode repositoryPathNode = (RepositoryPathNode)node;
            repositoryPathNode.expand();
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }
}

