/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidKeyException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.net.ssl.SSLKeyException;
import javax.swing.SwingUtilities;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientDescriptor;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.config.SvnConfigFiles;
import org.openide.util.Cancellable;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class SvnClientInvocationHandler
implements InvocationHandler {
    private static Set<String> remoteMethods = new HashSet<String>();
    private static Object semaphor;
    private final ISVNClientAdapter adapter;
    private final SvnClientDescriptor desc;
    private Cancellable cancellable;
    private SvnProgressSupport support;
    private final int handledExceptions;

    public SvnClientInvocationHandler(ISVNClientAdapter iSVNClientAdapter, SvnClientDescriptor svnClientDescriptor, int n) {
        assert (iSVNClientAdapter != null);
        assert (svnClientDescriptor != null);
        this.adapter = iSVNClientAdapter;
        this.desc = svnClientDescriptor;
        this.handledExceptions = n;
    }

    public SvnClientInvocationHandler(ISVNClientAdapter iSVNClientAdapter, SvnClientDescriptor svnClientDescriptor, SvnProgressSupport svnProgressSupport, int n) {
        assert (iSVNClientAdapter != null);
        assert (svnClientDescriptor != null);
        this.adapter = iSVNClientAdapter;
        this.desc = svnClientDescriptor;
        this.support = svnProgressSupport;
        this.handledExceptions = n;
        this.cancellable = new Cancellable(){

            public boolean cancel() {
                try {
                    SvnClientInvocationHandler.this.adapter.cancelOperation();
                }
                catch (SVNClientException sVNClientException) {
                    Subversion.LOG.log(Level.SEVERE, null, sVNClientException);
                    return false;
                }
                return true;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        String string = method.getName();
        assert (this.noRemoteCallinAWT(string, objectArray)) : "noRemoteCallinAWT(): " + string;
        try {
            Object object2 = null;
            if (this.parallelizable(method, objectArray)) {
                object2 = this.invokeMethod(method, objectArray);
            } else {
                Object object3 = semaphor;
                synchronized (object3) {
                    object2 = this.invokeMethod(method, objectArray);
                }
            }
            Subversion.getInstance().getStatusCache().refreshDirtyFileSystems();
            return object2;
        }
        catch (Exception exception) {
            try {
                if (this.handleException((SvnClient)object, exception)) {
                    return this.invoke(object, method, objectArray);
                }
                throw new SVNClientException(SvnClientExceptionHandler.ACTION_CANCELED_BY_USER);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof SVNClientException) {
                    throw throwable;
                }
                throw invocationTargetException;
            }
            catch (SSLKeyException sSLKeyException) {
                if (sSLKeyException.getCause() instanceof InvalidKeyException) {
                    InvalidKeyException invalidKeyException = (InvalidKeyException)sSLKeyException.getCause();
                    if (invalidKeyException.getMessage().toLowerCase().equals("illegal key size or default parameters")) {
                        SvnClientExceptionHandler.handleInvalidKeyException(invalidKeyException);
                    }
                    return null;
                }
                throw sSLKeyException;
            }
            catch (Throwable throwable) {
                if (throwable instanceof InterruptedException) {
                    throw new SVNClientException(SvnClientExceptionHandler.ACTION_CANCELED_BY_USER);
                }
                Throwable throwable2 = throwable.getCause();
                if (throwable2 instanceof InterruptedException) {
                    throw new SVNClientException(SvnClientExceptionHandler.ACTION_CANCELED_BY_USER);
                }
                throw throwable;
            }
        }
    }

    protected boolean parallelizable(Method method, Object[] objectArray) {
        return SwingUtilities.isEventDispatchThread();
    }

    protected Object invokeMethod(Method method, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return this.handle(method, objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object handle(Method method, Object[] objectArray) throws SecurityException, InvocationTargetException, IllegalAccessException, NoSuchMethodException, IllegalArgumentException {
        Class<?>[] classArray = method.getParameterTypes();
        Class<?> clazz = method.getDeclaringClass();
        if (ISVNClientAdapter.class.isAssignableFrom(clazz)) {
            if (this.support != null) {
                this.support.setCancellableDelegate(this.cancellable);
            }
            if (this.desc != null && this.desc.getSvnUrl() != null) {
                SvnConfigFiles.getInstance().setProxy(this.desc.getSvnUrl());
            }
        } else {
            if (Cancellable.class.isAssignableFrom(clazz)) {
                return this.cancellable.getClass().getMethod(method.getName(), classArray).invoke((Object)this.cancellable, objectArray);
            }
            if (!SvnClientDescriptor.class.isAssignableFrom(clazz)) return this.adapter.getClass().getMethod(method.getName(), classArray).invoke((Object)this.adapter, objectArray);
            if (this.desc == null) throw new NoSuchMethodException(method.getName());
            return this.desc.getClass().getMethod(method.getName(), classArray).invoke((Object)this.desc, objectArray);
        }
        Object object = this.adapter.getClass().getMethod(method.getName(), classArray).invoke((Object)this.adapter, objectArray);
        if (this.support == null) return object;
        this.support.setCancellableDelegate(null);
        return object;
    }

    private boolean handleException(SvnClient svnClient, Throwable throwable) throws Throwable {
        if (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getCause();
        }
        if (!(throwable instanceof SVNClientException)) {
            throw throwable;
        }
        SvnClientExceptionHandler svnClientExceptionHandler = new SvnClientExceptionHandler((SVNClientException)throwable, this.adapter, svnClient, this.handledExceptions);
        return svnClientExceptionHandler.handleException();
    }

    protected boolean noRemoteCallinAWT(String string, Object[] objectArray) {
        if (!SwingUtilities.isEventDispatchThread()) {
            return true;
        }
        return !remoteMethods.contains(string);
    }

    static {
        remoteMethods.add("checkout");
        remoteMethods.add("commit");
        remoteMethods.add("commitAcrossWC");
        remoteMethods.add("getList");
        remoteMethods.add("getDirEntry");
        remoteMethods.add("copy");
        remoteMethods.add("remove");
        remoteMethods.add("doExport");
        remoteMethods.add("doImport");
        remoteMethods.add("mkdir");
        remoteMethods.add("move");
        remoteMethods.add("update");
        remoteMethods.add("getLogMessages");
        remoteMethods.add("getContent");
        remoteMethods.add("setRevProperty");
        remoteMethods.add("diff");
        remoteMethods.add("annotate");
        remoteMethods.add("getInfo");
        remoteMethods.add("switchToUrl");
        remoteMethods.add("merge");
        remoteMethods.add("lock");
        remoteMethods.add("unlock");
        semaphor = new Object();
    }
}

