/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientCallback;
import org.netbeans.modules.subversion.client.SvnClientDescriptor;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnClientInvocationHandler;
import org.netbeans.modules.subversion.client.SvnCmdLineClientInvocationHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.config.SvnConfigFiles;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;
import org.tigris.subversion.svnclientadapter.SVNClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapter;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapterFactory;

public class SvnClientFactory {
    private static SvnClientFactory instance;
    private static ClientAdapterFactory factory;
    private static SVNClientException exception;
    private static final String[] CMDLINE_LOCATIONS;

    private SvnClientFactory() {
    }

    public static synchronized SvnClientFactory getInstance() {
        SvnClientFactory.init();
        return instance;
    }

    public static synchronized void init() {
        if (instance == null) {
            instance = new SvnClientFactory();
            instance.setup();
        }
    }

    public SvnClient createSvnClient() throws SVNClientException {
        if (exception != null) {
            throw exception;
        }
        return factory.createSvnClient();
    }

    public SvnClient createSvnClient(SVNUrl sVNUrl, SvnProgressSupport svnProgressSupport, String string, String string2, int n) throws SVNClientException {
        if (exception != null) {
            throw exception;
        }
        return factory.createSvnClient(sVNUrl, svnProgressSupport, string, string2, n);
    }

    private void setup() {
        block6: {
            try {
                String string = System.getProperty("svnClientAdapterFactory");
                if (string == null || string.trim().equals("") || string.equals("commandline")) {
                    this.setupCommandline();
                    break block6;
                }
                if (string.equals("javahl")) {
                    try {
                        this.setupJavaHl();
                    }
                    catch (Throwable throwable) {
                        String string2 = JhlClientAdapter.getLibraryLoadErrors();
                        Subversion.LOG.log(Level.WARNING, null, throwable);
                        Subversion.LOG.warning(string2);
                        Subversion.LOG.log(Level.WARNING, "Could not setup JavaHl. Falling back on the commandline client!");
                        this.setupCommandline();
                    }
                    break block6;
                }
                throw new SVNClientException("Unknown factory: " + string);
            }
            catch (SVNClientException sVNClientException) {
                exception = sVNClientException;
            }
        }
    }

    public static void checkClientAvailable() throws SVNClientException {
        if (exception != null) {
            throw exception;
        }
    }

    private void setupJavaHl() throws SVNClientException {
        JhlClientAdapterFactory.setup();
        factory = new ClientAdapterFactory(){

            protected ISVNClientAdapter createAdapter() {
                return SVNClientAdapterFactory.createSVNClient((String)"javahl");
            }

            protected SvnClientInvocationHandler getInvocationHandler(ISVNClientAdapter iSVNClientAdapter, SvnClientDescriptor svnClientDescriptor, SvnProgressSupport svnProgressSupport, int n) {
                return new SvnClientInvocationHandler(iSVNClientAdapter, svnClientDescriptor, svnProgressSupport, n);
            }

            protected ISVNPromptUserPassword createCallback(SVNUrl sVNUrl, int n) {
                return new SvnClientCallback(sVNUrl, n);
            }
        };
        Subversion.LOG.info("svnClientAdapter running on javahl");
    }

    public void setupCommandline() throws SVNClientException {
        exception = null;
        this.setupComandlineFatory();
        factory = new ClientAdapterFactory(){

            protected ISVNClientAdapter createAdapter() {
                return SVNClientAdapterFactory.createSVNClient((String)"commandline");
            }

            protected SvnClientInvocationHandler getInvocationHandler(ISVNClientAdapter iSVNClientAdapter, SvnClientDescriptor svnClientDescriptor, SvnProgressSupport svnProgressSupport, int n) {
                return new SvnCmdLineClientInvocationHandler(iSVNClientAdapter, svnClientDescriptor, svnProgressSupport, n);
            }

            protected ISVNPromptUserPassword createCallback(SVNUrl sVNUrl, int n) {
                return null;
            }
        };
        Subversion.LOG.fine("svnClientAdapter running on commandline client");
    }

    private void setupComandlineFatory() throws SVNClientException {
        String string = SvnModuleConfig.getDefault().getExecutableBinaryPath();
        String string2 = this.setupComandlineFatory(string);
        if (!string2.equals(instance)) {
            SvnModuleConfig.getDefault().setExecutableBinaryPath(string2);
        }
    }

    private String setupComandlineFatory(String string) throws SVNClientException {
        try {
            CmdLineClientAdapterFactory.setup13((String)string);
            return string;
        }
        catch (SVNClientException sVNClientException) {
            if (Utilities.isMac() || Utilities.isUnix()) {
                for (String string2 : CMDLINE_LOCATIONS) {
                    try {
                        CmdLineClientAdapterFactory.setup13((String)string2);
                        return string2;
                    }
                    catch (SVNClientException sVNClientException2) {
                    }
                }
            }
            throw sVNClientException;
        }
    }

    static {
        exception = null;
        CMDLINE_LOCATIONS = new String[]{"/usr/local/bin"};
    }

    private abstract class ClientAdapterFactory {
        private ClientAdapterFactory() {
        }

        protected abstract ISVNClientAdapter createAdapter();

        protected abstract SvnClientInvocationHandler getInvocationHandler(ISVNClientAdapter var1, SvnClientDescriptor var2, SvnProgressSupport var3, int var4);

        protected abstract ISVNPromptUserPassword createCallback(SVNUrl var1, int var2);

        SvnClient createSvnClient() {
            SvnClientInvocationHandler svnClientInvocationHandler = this.getInvocationHandler(this.createAdapter(), this.createDescriptor(null), null, -1);
            return this.createSvnClient(svnClientInvocationHandler);
        }

        public SvnClient createSvnClient(SVNUrl sVNUrl, SvnProgressSupport svnProgressSupport, String string, String string2, int n) {
            ISVNClientAdapter iSVNClientAdapter = this.createAdapter();
            SvnClientInvocationHandler svnClientInvocationHandler = this.getInvocationHandler(iSVNClientAdapter, this.createDescriptor(sVNUrl), svnProgressSupport, n);
            this.setupAdapter(iSVNClientAdapter, string, string2, this.createCallback(sVNUrl, n));
            return this.createSvnClient(svnClientInvocationHandler);
        }

        private SvnClientDescriptor createDescriptor(final SVNUrl sVNUrl) {
            return new SvnClientDescriptor(){

                public SVNUrl getSvnUrl() {
                    return sVNUrl;
                }
            };
        }

        private SvnClient createSvnClient(SvnClientInvocationHandler svnClientInvocationHandler) {
            Class<?> clazz = Proxy.getProxyClass(SvnClient.class.getClassLoader(), SvnClient.class);
            Subversion.getInstance().cleanupFilesystem();
            try {
                return (SvnClient)clazz.getConstructor(InvocationHandler.class).newInstance(svnClientInvocationHandler);
            }
            catch (Exception exception) {
                Subversion.LOG.log(Level.SEVERE, null, exception);
                return null;
            }
        }

        protected void setupAdapter(ISVNClientAdapter iSVNClientAdapter, String string, String string2, ISVNPromptUserPassword iSVNPromptUserPassword) {
            if (iSVNPromptUserPassword != null) {
                iSVNClientAdapter.addPasswordCallback(iSVNPromptUserPassword);
            }
            try {
                File file = FileUtil.normalizeFile((File)new File(SvnConfigFiles.getNBConfigPath()));
                iSVNClientAdapter.setConfigDirectory(file);
                iSVNClientAdapter.setUsername(string);
                iSVNClientAdapter.setPassword(string2);
            }
            catch (SVNClientException sVNClientException) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
            }
        }
    }
}

