/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SubversionVCS;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.netbeans.spi.queries.VisibilityQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class SubversionVisibilityQuery
implements VisibilityQueryImplementation2,
VersioningListener {
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private FileStatusCache cache = Subversion.getInstance().getStatusCache();

    public SubversionVisibilityQuery() {
        this.cache.addVersioningListener(this);
    }

    public boolean isVisible(FileObject fileObject) {
        if (fileObject.isData()) {
            return true;
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        return this.isVisible(file);
    }

    public boolean isVisible(File file) {
        if (file == null) {
            return true;
        }
        if (file.isFile()) {
            return true;
        }
        if (!(VersioningSupport.getOwner((File)file) instanceof SubversionVCS)) {
            return true;
        }
        try {
            return this.cache.getStatus(file).getStatus() != 256;
        }
        catch (Exception exception) {
            Subversion.LOG.log(Level.SEVERE, exception.getMessage(), exception);
            return true;
        }
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>(this.listeners);
        arrayList.add(changeListener);
        this.listeners = arrayList;
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>(this.listeners);
        arrayList.remove(changeListener);
        this.listeners = arrayList;
    }

    public void versioningEvent(VersioningEvent versioningEvent) {
        File file;
        if (versioningEvent.getId() == FileStatusCache.EVENT_FILE_STATUS_CHANGED && (file = (File)versioningEvent.getParams()[0]) != null && file.isDirectory()) {
            FileInformation fileInformation = (FileInformation)versioningEvent.getParams()[1];
            FileInformation fileInformation2 = (FileInformation)versioningEvent.getParams()[2];
            if (fileInformation != null && fileInformation.getStatus() == 256 || fileInformation2.getStatus() == 256) {
                this.fireVisibilityChanged();
            }
        }
    }

    static boolean isHiddenFolder(FileInformation fileInformation, File file) {
        return file.isDirectory() && fileInformation != null && fileInformation.getStatus() == 256;
    }

    private void fireVisibilityChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }
}

