/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.util.FileUtils;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.util.Utils;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FilesystemHandler
extends VCSInterceptor {
    private final Subversion svn;
    private final FileStatusCache cache;
    private final Set<File> invalidMetadata = new HashSet<File>(5);

    public FilesystemHandler(Subversion subversion) {
        this.svn = subversion;
        this.cache = subversion.getStatusCache();
    }

    public boolean beforeDelete(File file) {
        Subversion.LOG.fine("beforeDelete " + file);
        if (SvnUtils.isPartOfSubversionMetadata(file)) {
            return true;
        }
        return !file.isFile() && this.hasMetadata(file);
    }

    public void doDelete(File file) throws IOException {
        Subversion.LOG.fine("doDelete " + file);
        boolean bl = SvnUtils.isPartOfSubversionMetadata(file);
        if (!bl) {
            this.remove(file);
        }
    }

    public void afterDelete(final File file) {
        Subversion.LOG.fine("afterDelete " + file);
        Utils.post((Runnable)new Runnable(){

            public void run() {
                if (file == null) {
                    return;
                }
                int n = FilesystemHandler.this.cache.getStatus(file).getStatus();
                if (n != 2 && n != 4) {
                    try {
                        SvnClient svnClient = Subversion.getInstance().getClient(true);
                        svnClient.remove(new File[]{file}, true);
                    }
                    catch (SVNClientException sVNClientException) {
                        // empty catch block
                    }
                }
                FilesystemHandler.this.cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
            }
        });
    }

    public boolean beforeMove(File file, File file2) {
        Subversion.LOG.fine("beforeMove " + file + " -> " + file2);
        File file3 = file2.getParentFile();
        if (file != null && file3 != null && this.isVersioned(file)) {
            return Subversion.getInstance().isManaged(file2);
        }
        return false;
    }

    public void doMove(final File file, final File file2) throws IOException {
        Subversion.LOG.fine("doMove " + file + " -> " + file2);
        if (SwingUtilities.isEventDispatchThread()) {
            Subversion.LOG.log(Level.INFO, "Warning: launching external process in AWT", new Exception().fillInStackTrace());
            final Throwable[] throwableArray = new Throwable[1];
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        FilesystemHandler.this.svnMoveImplementation(file, file2);
                    }
                    catch (Throwable throwable) {
                        throwableArray[0] = throwable;
                    }
                }
            };
            Subversion.getInstance().getRequestProcessor().post(runnable).waitFinished();
            if (throwableArray[0] != null) {
                if (throwableArray[0] instanceof IOException) {
                    throw (IOException)throwableArray[0];
                }
                if (throwableArray[0] instanceof RuntimeException) {
                    throw (RuntimeException)throwableArray[0];
                }
                if (throwableArray[0] instanceof Error) {
                    throw (Error)throwableArray[0];
                }
                throw new IllegalStateException("Unexpected exception class: " + throwableArray[0]);
            }
        } else {
            this.svnMoveImplementation(file, file2);
        }
    }

    public void afterMove(final File file, final File file2) {
        Subversion.LOG.fine("afterMove " + file + " -> " + file2);
        Utils.post((Runnable)new Runnable(){

            public void run() {
                SvnUtils.refreshRecursively(file2);
                FilesystemHandler.this.cache.onNotify(file2, null);
                File file3 = file2.getParentFile();
                if (file3 != null) {
                    if (file.equals(file2)) {
                        Subversion.LOG.warning("Wrong (identity) rename event for " + file.getAbsolutePath());
                    }
                    FilesystemHandler.this.cache.onNotify(file, null);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beforeCreate(File file, boolean bl) {
        Subversion.LOG.fine("beforeCreate " + file);
        if (SvnUtils.isPartOfSubversionMetadata(file)) {
            Set<File> set = this.invalidMetadata;
            synchronized (set) {
                File file2 = file;
                while (!file2.getName().equals(".svn") && !file2.getName().equals("_svn")) {
                    file2 = file2.getParentFile();
                    assert (file2 != null) : "file " + file + " doesn't have a .svn parent";
                }
                this.invalidMetadata.add(file2);
            }
            return false;
        }
        if (!file.exists()) {
            try {
                SvnClient svnClient = Subversion.getInstance().getClient(true);
                this.revertDeleted(svnClient, file, true);
            }
            catch (SVNClientException sVNClientException) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
            }
        }
        return false;
    }

    private static List<File> getDeletedParents(File file, SvnClient svnClient) throws SVNClientException {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 = file.getParentFile(); file2 != null; file2 = file2.getParentFile()) {
            ISVNStatus iSVNStatus = FilesystemHandler.getStatus(svnClient, file2);
            if (iSVNStatus == null || !iSVNStatus.getTextStatus().equals((Object)SVNStatusKind.DELETED)) {
                return arrayList;
            }
            arrayList.add(file2);
        }
        return arrayList;
    }

    public void doCreate(File file, boolean bl) throws IOException {
    }

    public void afterCreate(final File file) {
        Subversion.LOG.fine("afterCreate " + file);
        Utils.post((Runnable)new Runnable(){

            public void run() {
                if (file == null) {
                    return;
                }
                int n = FilesystemHandler.this.cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN).getStatus();
                if ((n & 0xFFFFFFFE) == 0) {
                    return;
                }
                if (file.isDirectory()) {
                    FilesystemHandler.this.cache.directoryContentChanged(file);
                }
            }
        });
    }

    public void afterChange(final File file) {
        Subversion.LOG.fine("afterChange " + file);
        Utils.post((Runnable)new Runnable(){

            public void run() {
                if ((FilesystemHandler.this.cache.getStatus(file).getStatus() & 0xFFFFFFFE) != 0) {
                    FilesystemHandler.this.cache.refreshCached(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInvalidMetadata() {
        Set<File> set = this.invalidMetadata;
        synchronized (set) {
            for (File file : this.invalidMetadata) {
                Utils.deleteRecursively((File)file);
            }
            this.invalidMetadata.clear();
        }
    }

    private boolean hasMetadata(File file) {
        return new File(file, ".svn/entries").canRead() || new File(file, "_svn/entries").canRead();
    }

    private boolean isVersioned(File file) {
        if (SvnUtils.isPartOfSubversionMetadata(file)) {
            return false;
        }
        return !file.isFile() && this.hasMetadata(file) || file.isFile() && this.hasMetadata(file.getParentFile());
    }

    private boolean remove(File file) {
        try {
            SvnClient svnClient = Subversion.getInstance().getClient(true);
            svnClient.remove(new File[]{file}, true);
            return true;
        }
        catch (SVNClientException sVNClientException) {
            return false;
        }
    }

    private void revertDeleted(SvnClient svnClient, File file, boolean bl) {
        try {
            ISVNStatus iSVNStatus = FilesystemHandler.getStatus(svnClient, file);
            if (iSVNStatus != null && iSVNStatus.getTextStatus().equals((Object)SVNStatusKind.DELETED)) {
                if (bl) {
                    List<File> list = FilesystemHandler.getDeletedParents(file, svnClient);
                    svnClient.revert(list.toArray(new File[list.size()]), false);
                }
                svnClient.revert(file, false);
                file.delete();
            }
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void svnMoveImplementation(File file, File file2) throws IOException {
        try {
            boolean bl = true;
            SvnClient svnClient = Subversion.getInstance().getClient(true);
            File file3 = null;
            try {
                this.removeInvalidMetadata();
                File file4 = file2.isDirectory() ? file2 : file2.getParentFile();
                if (file4 != null) {
                    assert (Subversion.getInstance().isManaged(file4));
                    if (!this.hasMetadata(file4)) {
                        this.addDirectories(file4);
                    }
                }
                int n = 6;
                while (true) {
                    try {
                        this.revertDeleted(svnClient, file2, false);
                        ISVNStatus iSVNStatus = FilesystemHandler.getStatus(svnClient, file);
                        if (iSVNStatus != null && iSVNStatus.getTextStatus().equals((Object)SVNStatusKind.ADDED)) {
                            svnClient.revert(file, true);
                            this.renameFile(file, file2);
                        } else if (iSVNStatus != null && iSVNStatus.getTextStatus().equals((Object)SVNStatusKind.UNVERSIONED)) {
                            this.renameFile(file, file2);
                        } else {
                            List<File> list = this.listAllChildren(file);
                            svnClient.move(file, file2, bl);
                            for (File file5 : list) {
                                this.cache.onNotify(file5, null);
                            }
                        }
                    }
                    catch (SVNClientException sVNClientException) {
                        if (sVNClientException.getMessage().endsWith("' locked") && n > 0) {
                            try {
                                Thread.sleep(107L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            --n;
                            continue;
                        }
                        IOException iOException = new IOException("Subversion failed to rename " + file.getAbsolutePath() + " to: " + file2.getAbsolutePath());
                        iOException.initCause(sVNClientException);
                        throw iOException;
                    }
                    break;
                }
            }
            finally {
                if (file3 != null) {
                    FileUtils.deleteRecursively(file3);
                }
            }
        }
        catch (SVNClientException sVNClientException) {
            IOException iOException = new IOException("Subversion failed to rename " + file.getAbsolutePath() + " to: " + file2.getAbsolutePath());
            iOException.initCause(sVNClientException);
            throw iOException;
        }
    }

    private void renameFile(File file, File file2) {
        List<File> list = this.listAllChildren(file);
        file.renameTo(file2);
        this.cache.onNotify(file, null);
        for (File file3 : list) {
            this.cache.onNotify(file3, null);
        }
        this.cache.onNotify(file2, null);
    }

    private List<File> listAllChildren(File file) {
        if (file.isFile()) {
            return new ArrayList<File>(0);
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                arrayList.add(file2);
                arrayList.addAll(this.listAllChildren(file2));
            }
        }
        return arrayList;
    }

    private void addDirectories(final File file) throws SVNClientException {
        File file2 = file.getParentFile();
        if (file2 != null) {
            if (Subversion.getInstance().isManaged(file2) && !this.hasMetadata(file2)) {
                this.addDirectories(file2);
            }
        } else {
            throw new SVNClientException("Reached FS root, but it's still not Subversion versioned!");
        }
        SvnClient svnClient = Subversion.getInstance().getClient(true);
        svnClient.addDirectory(file, false);
        Utils.post((Runnable)new Runnable(){

            public void run() {
                FilesystemHandler.this.cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
            }
        });
    }

    private static ISVNStatus getStatus(SvnClient svnClient, File file) throws SVNClientException {
        return svnClient.getSingleStatus(file);
    }
}

