/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.api.client;

import java.io.IOException;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.websvc.api.client.ClientStubDescriptor;
import org.netbeans.modules.websvc.client.WebServicesClientSupportAccessor;
import org.netbeans.modules.websvc.spi.client.WebServicesClientSupportImpl;
import org.netbeans.modules.websvc.spi.client.WebServicesClientSupportProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class WebServicesClientSupport {
    public static final String WSCLIENTUPTODATE_CLASSPATH = "wsclientuptodate.classpath";
    private WebServicesClientSupportImpl impl;
    private static final Lookup.Result implementations = Lookup.getDefault().lookup(new Lookup.Template(WebServicesClientSupportProvider.class));

    private WebServicesClientSupport(WebServicesClientSupportImpl webServicesClientSupportImpl) {
        if (webServicesClientSupportImpl == null) {
            throw new IllegalArgumentException();
        }
        this.impl = webServicesClientSupportImpl;
    }

    public static WebServicesClientSupport getWebServicesClientSupport(FileObject fileObject) {
        if (fileObject == null) {
            throw new NullPointerException("Passed null to WebServicesClientSupport.getWebServicesClientSupport(FileObject)");
        }
        for (WebServicesClientSupportProvider webServicesClientSupportProvider : implementations.allInstances()) {
            WebServicesClientSupport webServicesClientSupport = webServicesClientSupportProvider.findWebServicesClientSupport(fileObject);
            if (webServicesClientSupport == null) continue;
            return webServicesClientSupport;
        }
        return null;
    }

    public void addServiceClient(String string, String string2, String string3, FileObject fileObject, ClientStubDescriptor clientStubDescriptor) {
        this.impl.addServiceClient(string, string2, string3, fileObject, clientStubDescriptor);
    }

    public void addServiceClient(String string, String string2, String string3, FileObject fileObject, ClientStubDescriptor clientStubDescriptor, String[] stringArray) {
        this.impl.addServiceClient(string, string2, string3, fileObject, clientStubDescriptor, stringArray);
    }

    public void addServiceClientReference(String string, String string2, String string3, String string4, String[] stringArray) {
        this.impl.addServiceClientReference(string, string2, string3, string4, stringArray);
    }

    public void removeServiceClient(String string) {
        this.impl.removeServiceClient(string);
    }

    public FileObject getWsdlFolder(boolean bl) throws IOException {
        return this.impl.getWsdlFolder(bl);
    }

    public FileObject getWsdlFolder() {
        FileObject fileObject = null;
        try {
            fileObject = this.impl.getWsdlFolder(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fileObject;
    }

    public FileObject getDeploymentDescriptor() {
        return this.impl.getDeploymentDescriptor();
    }

    public List getStubDescriptors() {
        return this.impl.getStubDescriptors();
    }

    public List getServiceClients() {
        return this.impl.getServiceClients();
    }

    public String getWsdlSource(String string) {
        return this.impl.getWsdlSource(string);
    }

    public void setWsdlSource(String string, String string2) {
        this.impl.setWsdlSource(string, string2);
    }

    public void setProxyJVMOptions(String string, String string2) {
        this.impl.setProxyJVMOptions(string, string2);
    }

    public String getServiceRefName(String string) {
        return this.impl.getServiceRefName(string);
    }

    public boolean isBroken(Project project) {
        return WebServicesClientSupport.getWebServicesClientSupport(project.getProjectDirectory()) == null && !this.getServiceClients().isEmpty();
    }

    public void showBrokenAlert(Project project) {
        ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
        String string = null;
        if (projectInformation != null) {
            string = projectInformation.getDisplayName();
        }
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebServicesClientSupport.class, (String)"ERR_NoJaxrpcPluginFound", (Object)string), 2);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
    }

    static {
        WebServicesClientSupportAccessor.DEFAULT = new WebServicesClientSupportAccessor(){

            public WebServicesClientSupport createWebServicesClientSupport(WebServicesClientSupportImpl webServicesClientSupportImpl) {
                return new WebServicesClientSupport(webServicesClientSupportImpl);
            }

            public WebServicesClientSupportImpl getWebServicesClientSupportImpl(WebServicesClientSupport webServicesClientSupport) {
                return webServicesClientSupport == null ? null : webServicesClientSupport.impl;
            }
        };
    }
}

