/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.project.jsf.api;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class AddResourceOverwriteDialog
extends JPanel {
    private File target = null;
    private File newTarget = null;
    private File fileReturn = null;
    public static final int CONFLICT_ASK = 0;
    public static final int CONFLICT_ASK_MANY = 1;
    public static final int CONFLICT_OVERWRITE = 2;
    public static final int CONFLICT_USE_EXISTING = 3;
    public static final int CONFLICT_CREATE_NEW = 4;
    private static int mode = 0;
    private ButtonGroup buttonGroup1;
    private JPanel jPanel1;
    private JLabel label;
    private JRadioButton overwriteButton;
    private JRadioButton renameButton;
    private JRadioButton useExistingButton;

    public AddResourceOverwriteDialog(File file) {
        this.target = file;
        this.initComponents();
        this.initComponents2();
    }

    public static int getMode() {
        return mode;
    }

    public static void setMode(int n) {
        mode = n;
    }

    public void showDialog() {
        if (mode == 2 || mode == 3) {
            this.fileReturn = this.target;
            return;
        }
        if (mode == 4) {
            this.fileReturn = this.newTarget;
            return;
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(AddResourceOverwriteDialog.class, (String)"LBL_ResourceNameConflict"));
        dialogDescriptor.setMessageType(2);
        dialogDescriptor.setOptionType(2);
        JButton jButton = null;
        if (mode == 1) {
            jButton = new JButton(NbBundle.getMessage(AddResourceOverwriteDialog.class, (String)"LBL_Always"));
            dialogDescriptor.setAdditionalOptions(new Object[]{jButton});
        }
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.show();
        Object object = dialogDescriptor.getValue();
        if (object != NotifyDescriptor.OK_OPTION && object != jButton) {
            this.fileReturn = null;
            return;
        }
        if (this.renameButton.isSelected()) {
            this.fileReturn = this.newTarget;
            if (object == jButton) {
                mode = 4;
            }
        } else if (this.overwriteButton.isSelected()) {
            boolean bl = this.target.delete();
            this.fileReturn = this.target;
            if (object == jButton) {
                mode = 2;
            }
        } else if (this.useExistingButton.isSelected()) {
            this.fileReturn = this.target;
            if (object == jButton) {
                mode = 3;
            }
        }
    }

    public File getFile() {
        return this.fileReturn;
    }

    private void initComponents2() {
        this.newTarget = this.findUniqueFile(this.target);
        this.label.setText(NbBundle.getMessage(AddResourceOverwriteDialog.class, (String)"LBL_AddResourceMsg", (Object)this.target.getName()));
        this.renameButton.setText(NbBundle.getMessage(AddResourceOverwriteDialog.class, (String)"LBL_AddResourceRename", (Object)this.newTarget.getName()));
        this.overwriteButton.setText(NbBundle.getMessage(AddResourceOverwriteDialog.class, (String)"LBL_AddResourceOverwrite"));
        this.useExistingButton.setText(NbBundle.getMessage(AddResourceOverwriteDialog.class, (String)"LBL_AddResourceUseExisting"));
        this.renameButton.setSelected(false);
        this.overwriteButton.setSelected(false);
        this.useExistingButton.setSelected(true);
    }

    private File findUniqueFile(File file) {
        int n = 1;
        String string = file.getName();
        String string2 = FileUtil.getExtension((String)string);
        String string3 = string.substring(0, string.lastIndexOf(string2) - 1);
        String string4 = string;
        File file2 = file.getParentFile();
        File file3 = null;
        while (file3 == null) {
            file3 = new File(file2, string4);
            if (!file3.exists()) {
                return file3;
            }
            file3 = null;
            string4 = string3 + "_" + n++ + "." + string2;
        }
        return file3;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.useExistingButton = new JRadioButton();
        this.renameButton = new JRadioButton();
        this.overwriteButton = new JRadioButton();
        this.label = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridLayout(0, 1));
        this.buttonGroup1.add(this.useExistingButton);
        this.useExistingButton.setSelected(true);
        this.useExistingButton.setText("Use existing file instead of the selected file");
        this.jPanel1.add(this.useExistingButton);
        this.buttonGroup1.add(this.renameButton);
        this.renameButton.setText("Rename existing file to <>");
        this.jPanel1.add(this.renameButton);
        this.buttonGroup1.add(this.overwriteButton);
        this.overwriteButton.setText("Overwrite existing file with the selected file");
        this.jPanel1.add(this.overwriteButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.label.setText("The file <filename> already exists in the Resources folder. ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.label, gridBagConstraints);
    }
}

