/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.j2me.cdc.platform.CDCPlatform;
import org.netbeans.modules.j2me.cdc.project.CDCProjectUtil;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainClassChooser
extends JPanel {
    protected ChangeListener changeListener;
    private String dialogSubtitle = null;
    protected List<String> possibleMainClasses;
    private FileObject sourcesRoot;
    private final String bcp;
    protected boolean onlyMain;
    protected String mainClass;
    protected Map<String, String> executionModes;
    protected String specialExecFqnXlet;
    protected String specialExecFqnApplet;
    public static Boolean unitTestingSupport_hasMainMethodResult = null;
    private JRadioButton appletExecution;
    private ButtonGroup buttonGroup1;
    private JLabel jLabel1;
    private JList jMainClassList;
    private JScrollPane jScrollPane1;
    private JRadioButton mainExecution;
    private JCheckBox multipleXlets;
    private JLabel onlymainLabel;
    private JRadioButton xletExecution;

    public MainClassChooser(FileObject fileObject, Map<String, String> map, String string) {
        this(fileObject, null, false, map, string);
    }

    public MainClassChooser(FileObject fileObject, String string, boolean bl, Map<String, String> map, String string2) {
        this.dialogSubtitle = string;
        this.sourcesRoot = fileObject;
        this.onlyMain = bl;
        this.executionModes = map;
        this.initComponents();
        this.initClassesView(fileObject);
        if (bl) {
            this.onlymainLabel.setText(NbBundle.getMessage(MainClassChooser.class, (String)"MSG_OnlyMainAllowed"));
        }
        this.bcp = string2;
        this.specialExecFqnXlet = map != null ? map.get(CDCPlatform.PROP_EXEC_XLET) : null;
        this.specialExecFqnApplet = map != null ? map.get(CDCPlatform.PROP_EXEC_APPLET) : null;
    }

    private void initClassesView(final FileObject fileObject) {
        this.possibleMainClasses = null;
        this.jMainClassList.setSelectionMode(0);
        this.jMainClassList.setListData(this.getWarmupList());
        this.jMainClassList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                MainClassChooser.this.checkSelectionOptions();
                if (MainClassChooser.this.changeListener != null) {
                    MainClassChooser.this.changeListener.stateChanged(new ChangeEvent(listSelectionEvent));
                }
            }
        });
        this.jMainClassList.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (MouseUtils.isDoubleClick((MouseEvent)mouseEvent) && MainClassChooser.this.getSelectedMainClass() != null && MainClassChooser.this.changeListener != null) {
                    MainClassChooser.this.changeListener.stateChanged(new ChangeEvent(mouseEvent));
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                MainClassChooser.this.possibleMainClasses = CDCProjectUtil.getMainClasses(new FileObject[]{fileObject}, MainClassChooser.this.executionModes, MainClassChooser.this.bcp);
                if (MainClassChooser.this.possibleMainClasses.isEmpty()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MainClassChooser.this.jMainClassList.setListData(new String[]{NbBundle.getMessage(MainClassChooser.class, (String)"LBL_ChooseMainClass_NO_CLASSES_NODE")});
                        }
                    });
                } else {
                    Object[] objectArray = MainClassChooser.this.possibleMainClasses.toArray(new String[0]);
                    Arrays.sort(objectArray);
                    if (MainClassChooser.this.onlyMain) {
                        final ArrayList<String> arrayList = new ArrayList<String>(MainClassChooser.this.possibleMainClasses);
                        Iterator iterator = arrayList.iterator();
                        while (iterator.hasNext()) {
                            String string = (String)iterator.next();
                            if (CDCProjectUtil.isMainClass(string, fileObject) && (MainClassChooser.this.executionModes == null || !MainClassChooser.this.executionModes.containsKey(CDCPlatform.PROP_EXEC_MAIN))) continue;
                            iterator.remove();
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                Object[] objectArray = arrayList.toArray(new String[0]);
                                if (objectArray.length == 0) {
                                    MainClassChooser.this.jMainClassList.setListData(new String[]{NbBundle.getMessage(MainClassChooser.class, (String)"LBL_ChooseMainClass_NO_CLASSES_NODE")});
                                    return;
                                }
                                Arrays.sort(objectArray);
                                MainClassChooser.this.jMainClassList.setListData(objectArray);
                                MainClassChooser.this.jMainClassList.setSelectedIndex(0);
                            }
                        });
                        return;
                    }
                    boolean bl = false;
                    if (!MainClassChooser.this.possibleMainClasses.isEmpty()) {
                        for (String object2 : MainClassChooser.this.possibleMainClasses) {
                            if (!CDCProjectUtil.isXletClass(object2, fileObject, MainClassChooser.this.specialExecFqnXlet)) continue;
                            bl = true;
                            break;
                        }
                        if (bl && MainClassChooser.this.mainClass != null && MainClassChooser.this.mainClass.indexOf(59) != -1) {
                            int n;
                            Object object;
                            String[] stringArray = MainClassChooser.this.updateListView(true);
                            StringTokenizer stringTokenizer = new StringTokenizer(MainClassChooser.this.mainClass, ";");
                            ArrayList<Integer> arrayList = new ArrayList<Integer>();
                            while (stringTokenizer.hasMoreTokens()) {
                                object = stringTokenizer.nextToken();
                                for (n = 0; n < stringArray.length; ++n) {
                                    if (!((String)object).equals(stringArray[n])) continue;
                                    arrayList.add(new Integer(n));
                                }
                            }
                            object = new int[arrayList.size()];
                            for (n = 0; n < ((Object)object).length; ++n) {
                                object[n] = (Integer)arrayList.get(n);
                            }
                            SwingUtilities.invokeLater(new Runnable((int[])object, stringArray){
                                final /* synthetic */ int[] val$sel;
                                final /* synthetic */ String[] val$xlets;
                                {
                                    this.val$sel = nArray;
                                    this.val$xlets = stringArray;
                                }

                                public void run() {
                                    int[] nArray;
                                    MainClassChooser.this.multipleXlets.setSelected(this.val$sel.length > 1);
                                    MainClassChooser.this.jMainClassList.setListData(this.val$xlets);
                                    JList jList = MainClassChooser.this.jMainClassList;
                                    if (this.val$sel.length != 0) {
                                        nArray = this.val$sel;
                                    } else {
                                        int[] nArray2 = new int[1];
                                        nArray = nArray2;
                                        nArray2[0] = 0;
                                    }
                                    jList.setSelectedIndices(nArray);
                                }
                            });
                        } else {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    MainClassChooser.this.jMainClassList.setListData(MainClassChooser.this.updateListView(false));
                                    if (MainClassChooser.this.mainClass != null && MainClassChooser.this.isValidMainClassName(MainClassChooser.this.mainClass)) {
                                        MainClassChooser.this.jMainClassList.setSelectedValue(MainClassChooser.this.mainClass, true);
                                    } else {
                                        MainClassChooser.this.jMainClassList.setSelectedIndex(0);
                                    }
                                }
                            });
                        }
                        MainClassChooser.this.checkSelectionOptions();
                    }
                }
            }
        });
        if (this.dialogSubtitle != null) {
            Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)this.dialogSubtitle);
        }
    }

    protected void checkSelectionOptions() {
        if (!this.multipleXlets.isSelected()) {
            String string = this.getSelectedMainClass();
            if (string == null) {
                string = this.mainClass;
            }
            final String string2 = string;
            final boolean[] blArray = new boolean[]{false};
            final boolean[] blArray2 = new boolean[]{false};
            final boolean[] blArray3 = new boolean[]{false};
            RequestProcessor.Task task = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    blArray[0] = CDCProjectUtil.isMainClass(string2, MainClassChooser.this.sourcesRoot);
                    blArray2[0] = CDCProjectUtil.isXletClass(string2, MainClassChooser.this.sourcesRoot, MainClassChooser.this.specialExecFqnXlet);
                    blArray3[0] = CDCProjectUtil.isAppletClass(string2, MainClassChooser.this.sourcesRoot, MainClassChooser.this.specialExecFqnApplet);
                }
            });
            task.waitFinished();
            this.mainExecution.setEnabled(blArray[0] && (this.executionModes == null || this.executionModes.containsKey(CDCPlatform.PROP_EXEC_MAIN)));
            this.xletExecution.setEnabled(blArray2[0] && !this.onlyMain && (this.executionModes == null || this.executionModes.containsKey(CDCPlatform.PROP_EXEC_XLET)));
            this.appletExecution.setEnabled(blArray3[0] && !this.onlyMain && (this.executionModes == null || this.executionModes.containsKey(CDCPlatform.PROP_EXEC_APPLET)));
            this.multipleXlets.setEnabled(blArray2[0] && (this.executionModes == null || this.executionModes.containsKey(CDCPlatform.PROP_EXEC_XLET)));
            if (blArray3[0] && this.appletExecution.isSelected()) {
                return;
            }
            if (blArray2[0] && this.xletExecution.isSelected()) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (blArray[0] || MainClassChooser.this.onlyMain) {
                        MainClassChooser.this.mainExecution.setSelected(blArray[0]);
                    } else if (blArray2[0]) {
                        MainClassChooser.this.xletExecution.setSelected(blArray2[0]);
                    } else if (blArray3[0]) {
                        MainClassChooser.this.appletExecution.setSelected(blArray3[0]);
                    }
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainClassChooser.this.mainExecution.setEnabled(false);
                    MainClassChooser.this.xletExecution.setEnabled(true);
                    MainClassChooser.this.appletExecution.setEnabled(false);
                    MainClassChooser.this.xletExecution.setSelected(true);
                }
            });
        }
    }

    private Object[] getWarmupList() {
        return new Object[]{NbBundle.getMessage(MainClassChooser.class, (String)"LBL_ChooseMainClass_WARMUP_MESSAGE")};
    }

    protected boolean isValidMainClassName(Object object) {
        return this.possibleMainClasses != null && this.possibleMainClasses.contains(object);
    }

    public String getSelectedMainClass() {
        if (this.isValidMainClassName(this.jMainClassList.getSelectedValue()) && !this.multipleXlets.isSelected()) {
            return (String)this.jMainClassList.getSelectedValue();
        }
        if (this.multipleXlets.isSelected()) {
            Object[] objectArray = this.jMainClassList.getSelectedValues();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!this.isValidMainClassName(objectArray[i])) continue;
                stringBuffer.append(objectArray[i]);
                stringBuffer.append(';');
            }
            return stringBuffer.length() != 0 ? stringBuffer.toString().substring(0, stringBuffer.length() - 1) : null;
        }
        return null;
    }

    public void setSelectedMainClass(String string) {
        this.mainClass = string;
    }

    public boolean isXletExecution() {
        return this.xletExecution.isSelected();
    }

    public void setXletExecution(boolean bl) {
        this.xletExecution.setSelected(bl);
    }

    boolean isAppletExecution() {
        return this.appletExecution.isSelected();
    }

    public void setAppletExecution(boolean bl) {
        this.appletExecution.setSelected(bl);
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.changeListener = null;
    }

    public static boolean hasMainMethod(FileObject fileObject) {
        return CDCProjectUtil.hasMainMethod(fileObject);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jMainClassList = new JList();
        this.mainExecution = new JRadioButton();
        this.xletExecution = new JRadioButton();
        this.appletExecution = new JRadioButton();
        this.multipleXlets = new JCheckBox();
        this.onlymainLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(380, 300));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(MainClassChooser.class).getString("AD_MainClassChooser"));
        this.jLabel1.setLabelFor(this.jMainClassList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getBundle(MainClassChooser.class).getString("CTL_AvaialableMainClasses"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 2, 12);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(100, 200));
        this.jScrollPane1.setViewportView(this.jMainClassList);
        this.jMainClassList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MainClassChooser.class, (String)"ACSN_jMainClassList"));
        this.jMainClassList.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(MainClassChooser.class).getString("ACSD_jMainClassList"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.buttonGroup1.add(this.mainExecution);
        this.mainExecution.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.mainExecution, (String)NbBundle.getBundle(MainClassChooser.class).getString("LBL_RunAsMain"));
        this.mainExecution.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.mainExecution.setEnabled(false);
        this.mainExecution.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.mainExecution, gridBagConstraints);
        this.mainExecution.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MainClassChooser.class, (String)"ACSN_CustomizerRun_Main"));
        this.mainExecution.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MainClassChooser.class, (String)"ACSD_CustomizerRun_Main"));
        this.buttonGroup1.add(this.xletExecution);
        Mnemonics.setLocalizedText((AbstractButton)this.xletExecution, (String)NbBundle.getBundle(MainClassChooser.class).getString("LBL_RunAsXlet"));
        this.xletExecution.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.xletExecution.setEnabled(false);
        this.xletExecution.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.xletExecution, gridBagConstraints);
        this.xletExecution.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MainClassChooser.class, (String)"ACSN_CustomizerRun_Xlet"));
        this.xletExecution.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MainClassChooser.class, (String)"ACSD_CustomizerRun_Xlet"));
        this.buttonGroup1.add(this.appletExecution);
        Mnemonics.setLocalizedText((AbstractButton)this.appletExecution, (String)NbBundle.getBundle(MainClassChooser.class).getString("LBL_RunAsApplet"));
        this.appletExecution.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.appletExecution.setEnabled(false);
        this.appletExecution.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.appletExecution, gridBagConstraints);
        this.appletExecution.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MainClassChooser.class, (String)"ACSN_CustomizerRun_Applet"));
        this.appletExecution.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MainClassChooser.class, (String)"ACSD_CustomizerRun_Applet"));
        Mnemonics.setLocalizedText((AbstractButton)this.multipleXlets, (String)NbBundle.getBundle(MainClassChooser.class).getString("LBL_AllowMultipleXlets"));
        this.multipleXlets.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.multipleXlets.setEnabled(false);
        this.multipleXlets.setMargin(new Insets(0, 0, 0, 0));
        this.multipleXlets.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainClassChooser.this.multipleXletsActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.multipleXlets, gridBagConstraints);
        this.multipleXlets.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MainClassChooser.class, (String)"ACSN_CustomizerRun_AllowMultiple"));
        this.multipleXlets.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MainClassChooser.class, (String)"ACSD_CustomizerRun_AllowMultiple"));
        this.onlymainLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.onlymainLabel, gridBagConstraints);
    }

    private void multipleXletsActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.multipleXlets.isSelected();
        String[] stringArray = this.updateListView(bl);
        this.jMainClassList.setListData(stringArray);
        this.jMainClassList.setSelectedIndex(0);
        this.checkSelectionOptions();
    }

    protected String[] updateListView(boolean bl) {
        if (bl) {
            this.jMainClassList.setSelectionMode(2);
            ArrayList<String> arrayList = new ArrayList<String>(this.possibleMainClasses);
            Object[] objectArray = arrayList.iterator();
            while (objectArray.hasNext()) {
                String string = (String)objectArray.next();
                if (CDCProjectUtil.isXletClass(string, this.sourcesRoot, this.specialExecFqnXlet)) continue;
                objectArray.remove();
            }
            objectArray = arrayList.toArray(new String[0]);
            Arrays.sort(objectArray);
            return objectArray;
        }
        this.jMainClassList.setSelectionMode(0);
        Object[] objectArray = this.possibleMainClasses.toArray(new String[0]);
        Arrays.sort(objectArray);
        return objectArray;
    }
}

