/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xsd;

import java.awt.Component;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.modules.xml.api.model.GrammarEnvironment;
import org.netbeans.modules.xml.api.model.GrammarQuery;
import org.netbeans.modules.xml.api.model.GrammarResult;
import org.netbeans.modules.xml.api.model.HintContext;
import org.netbeans.modules.xml.xsd.Namespace;
import org.netbeans.modules.xml.xsd.XSDGrammar;
import org.netbeans.modules.xml.xsd.XSDParser;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class XSDGrammarResolver
implements GrammarQuery {
    private final Map prefix2Namespace;
    private final Map uri2Namespace = new HashMap();
    private Namespace defaultNamespace = null;
    private Node target = null;
    private FileObject document = null;

    private XSDGrammarResolver() {
        this.prefix2Namespace = new HashMap();
    }

    public static XSDGrammarResolver createResolver(GrammarEnvironment grammarEnvironment) {
        XSDGrammarResolver xSDGrammarResolver = null;
        Enumeration enumeration = grammarEnvironment.getDocumentChildren();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            NamedNodeMap namedNodeMap = element.getAttributes();
            String string = Namespace.getPrefix(element.getNodeName());
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                String string2 = node2.getNodeName();
                if (!string2.startsWith("xmlns")) continue;
                String string3 = node2.getNodeValue();
                String string4 = Namespace.getSufix(string2);
                Namespace namespace = new Namespace(string3, string4);
                if (xSDGrammarResolver == null) {
                    xSDGrammarResolver = new XSDGrammarResolver();
                }
                xSDGrammarResolver.addNamespace(namespace);
                if (string4 != null && !string4.equals(string)) continue;
                xSDGrammarResolver.defaultNamespace = namespace;
            }
            if (xSDGrammarResolver == null) continue;
            assert (xSDGrammarResolver.defaultNamespace != null);
            super.resolveSchemaLocation(element);
            if (xSDGrammarResolver.defaultNamespace.getSchemaLocation() == null) {
                ErrorManager.getDefault().log(16, "SCHEMA is null: " + element.getLocalName());
            }
            xSDGrammarResolver.setTarget(node);
            xSDGrammarResolver.setDocument(grammarEnvironment.getFileObject());
            System.err.println("create resolver - success");
            return xSDGrammarResolver;
        }
        return null;
    }

    private void resolveSchemaLocation(Element element) {
        Namespace namespace = this.findNamespaceByURI("http://www.w3.org/2001/XMLSchema-instance");
        String string = namespace.getPrefix().concat(":");
        String string2 = element.getAttribute(string.concat("schemaLocation"));
        if (string2 == null) {
            string2 = element.getAttribute(string.concat("noNamespaceSchemaLocation"));
        }
        System.err.println("SCHEMA LOC: " + string2);
        this.defaultNamespace.setSchemaLocation(string2);
    }

    private void setDocument(FileObject fileObject) {
        this.document = fileObject;
    }

    private XSDGrammar findGrammar(HintContext hintContext) throws IOException {
        Namespace namespace = this.findNamespace((Node)hintContext);
        XSDGrammar xSDGrammar = namespace.getGrammar();
        if (xSDGrammar == null) {
            xSDGrammar = this.createGrammar(namespace);
            namespace.setGrammar(xSDGrammar);
            xSDGrammar.setNamespace(namespace);
        }
        return xSDGrammar;
    }

    private XSDGrammar createGrammar(Namespace namespace) throws IOException {
        Object object;
        String string = namespace.getSchemaLocation();
        if (string == null) {
            string = namespace.getURI();
        }
        System.err.println("findSchema: " + string);
        int n = string.indexOf(32);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        try {
            InputSource inputSource;
            EntityResolver entityResolver;
            object = UserCatalog.getDefault();
            if (object != null && (entityResolver = object.getEntityResolver()) != null && (inputSource = entityResolver.resolveEntity(string, null)) != null) {
                return new XSDParser().parse(inputSource);
            }
        }
        catch (SAXException sAXException) {
            ErrorManager.getDefault().notify(4096, (Throwable)sAXException);
        }
        try {
            object = new URL(string);
            return new XSDParser().parse(new InputSource(((URL)object).openStream()));
        }
        catch (MalformedURLException malformedURLException) {
            if (this.document == null) {
                return null;
            }
            FileObject fileObject = this.document.getParent().getFileObject(string);
            if (fileObject == null) {
                return null;
            }
            return new XSDParser().parse(new InputSource(fileObject.getInputStream()));
        }
    }

    private void addNamespace(Namespace namespace) {
        if (namespace.getPrefix() != null) {
            this.prefix2Namespace.put(namespace.getPrefix(), namespace);
        }
        this.uri2Namespace.put(namespace.getURI(), namespace);
    }

    private Namespace findNamespaceByURI(String string) {
        return (Namespace)this.uri2Namespace.get(string);
    }

    private Namespace findNamespace(Node node) {
        System.err.println("find namespace");
        System.err.println("PARENT: " + node.getParentNode().getNodeName());
        return this.defaultNamespace;
    }

    public boolean isAllowed(Enumeration enumeration) {
        return true;
    }

    public Enumeration queryAttributes(HintContext hintContext) {
        Thread.dumpStack();
        return Collections.enumeration(new ArrayList());
    }

    public GrammarResult queryDefault(HintContext hintContext) {
        Thread.dumpStack();
        return null;
    }

    public Enumeration queryElements(HintContext hintContext) {
        try {
            XSDGrammar xSDGrammar = this.findGrammar(hintContext);
            return xSDGrammar.queryElements(hintContext);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(4096, (Throwable)iOException);
            return Collections.enumeration(new ArrayList(0));
        }
    }

    public Enumeration queryEntities(String string) {
        Thread.dumpStack();
        return Collections.enumeration(new ArrayList());
    }

    public Enumeration queryNotations(String string) {
        Thread.dumpStack();
        return Collections.enumeration(new ArrayList());
    }

    public Enumeration queryValues(HintContext hintContext) {
        Thread.dumpStack();
        return Collections.enumeration(new ArrayList());
    }

    public Component getCustomizer(HintContext hintContext) {
        return null;
    }

    public Node.Property[] getProperties(HintContext hintContext) {
        return null;
    }

    public boolean hasCustomizer(HintContext hintContext) {
        return false;
    }

    public Node getTarget() {
        return this.target;
    }

    public void setTarget(Node node) {
        this.target = node;
    }
}

