/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.multiview;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.xml.schema.SchemaDataObject;
import org.netbeans.modules.xml.schema.SchemaEditorSupport;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.multiview.SchemaMultiViewSupport;
import org.netbeans.modules.xml.schema.multiview.SourceCookieProxyLookup;
import org.netbeans.modules.xml.schema.ui.basic.UIUtilities;
import org.netbeans.modules.xml.schema.ui.nodes.StructuralSchemaNodeFactory;
import org.netbeans.modules.xml.validation.ShowCookie;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.awt.UndoRedo;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class SchemaSourceMultiViewElement
extends CloneableEditor
implements MultiViewElement {
    private static final long serialVersionUID = 4403502726950453345L;
    private transient JComponent toolbar;
    private transient MultiViewElementCallback multiViewCallback;
    private SchemaDataObject schemaDataObject;
    private Node rootNode;
    private Node selectedNode;
    private NodeAdapter nl;
    private Timer timerSelNodes;
    private CaretListener caretListener;
    private transient RequestProcessor.Task selectionTask = null;

    public SchemaSourceMultiViewElement() {
    }

    public SchemaSourceMultiViewElement(SchemaDataObject schemaDataObject) {
        super((CloneableEditorSupport)schemaDataObject.getSchemaEditorSupport());
        this.schemaDataObject = schemaDataObject;
        schemaDataObject.getSchemaEditorSupport().initializeCloneableEditor(this);
        this.initialize();
    }

    private void initialize() {
        ShowCookie showCookie = new ShowCookie(){

            public void show(Validator.ResultItem resultItem) {
                if (SchemaSourceMultiViewElement.this.isActiveTC()) {
                    try {
                        int n = 0;
                        Component component = resultItem.getComponents();
                        if (component instanceof SchemaComponent) {
                            n = ((SchemaComponent)component).findPosition();
                            SchemaSourceMultiViewElement.this.getEditorPane().setCaretPosition(n);
                            return;
                        }
                        int n2 = resultItem.getLineNumber();
                        n = NbDocument.findLineOffset((StyledDocument)((StyledDocument)SchemaSourceMultiViewElement.this.getEditorPane().getDocument()), (int)n2);
                        SchemaSourceMultiViewElement.this.getEditorPane().setCaretPosition(n);
                    }
                    catch (Exception exception) {
                        SchemaSourceMultiViewElement.this.getEditorPane().setCaretPosition(0);
                    }
                }
            }
        };
        Node node = this.schemaDataObject.getNodeDelegate();
        SourceCookieProxyLookup sourceCookieProxyLookup = new SourceCookieProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{this.getActionMap(), this.schemaDataObject, showCookie})}, node);
        this.associateLookup((Lookup)sourceCookieProxyLookup);
        this.addPropertyChangeListener("activatedNodes", sourceCookieProxyLookup);
        this.caretListener = new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                SchemaSourceMultiViewElement.this.timerSelNodes.restart();
            }
        };
        this.timerSelNodes = new Timer(1, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!SchemaSourceMultiViewElement.this.isActiveTC() || SchemaSourceMultiViewElement.this.getEditorPane() == null) {
                    return;
                }
                SchemaSourceMultiViewElement.this.selectElementsAtOffset();
            }
        });
        this.timerSelNodes.setRepeats(false);
    }

    public JComponent getToolbarRepresentation() {
        Document document = this.getEditorPane().getDocument();
        if (document instanceof NbDocument.CustomToolbar) {
            if (this.toolbar == null) {
                this.toolbar = ((NbDocument.CustomToolbar)document).createToolbar(this.getEditorPane());
            }
            return this.toolbar;
        }
        return null;
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
        this.multiViewCallback = multiViewElementCallback;
    }

    public void requestVisible() {
        if (this.multiViewCallback != null) {
            this.multiViewCallback.requestVisible();
        } else {
            super.requestVisible();
        }
    }

    public void requestActive() {
        if (this.multiViewCallback != null) {
            this.multiViewCallback.requestActive();
        } else {
            super.requestActive();
        }
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public UndoRedo getUndoRedo() {
        return this.schemaDataObject.getSchemaEditorSupport().getUndoManager();
    }

    protected boolean closeLast() {
        SchemaEditorSupport schemaEditorSupport = this.schemaDataObject.getSchemaEditorSupport();
        JEditorPane[] jEditorPaneArray = schemaEditorSupport.getOpenedPanes();
        if (jEditorPaneArray == null || jEditorPaneArray.length == 0) {
            return schemaEditorSupport.silentClose();
        }
        return false;
    }

    public CloseOperationState canCloseElement() {
        if (!SchemaMultiViewSupport.isLastView(this.multiViewCallback.getTopComponent())) {
            return CloseOperationState.STATE_OK;
        }
        return MultiViewFactory.createUnsafeCloseState((String)"ID_TEXT_CLOSING", (Action)MultiViewFactory.NOOP_CLOSE_ACTION, (Action)MultiViewFactory.NOOP_CLOSE_ACTION);
    }

    public void componentActivated() {
        JEditorPane jEditorPane = this.getEditorPane();
        if (jEditorPane != null) {
            jEditorPane.addCaretListener(this.caretListener);
        }
        if (this.timerSelNodes != null) {
            this.timerSelNodes.restart();
        }
        super.componentActivated();
        SchemaEditorSupport schemaEditorSupport = this.schemaDataObject.getSchemaEditorSupport();
        schemaEditorSupport.addUndoManagerToDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void componentDeactivated() {
        JEditorPane jEditorPane = this.getEditorPane();
        if (jEditorPane != null) {
            jEditorPane.removeCaretListener(this.caretListener);
        }
        Object object = this;
        synchronized (object) {
            if (this.selectionTask != null) {
                this.selectionTask.cancel();
                this.selectionTask = null;
            }
        }
        if (this.timerSelNodes != null) {
            this.timerSelNodes.stop();
        }
        super.componentDeactivated();
        object = this.schemaDataObject.getSchemaEditorSupport();
        ((SchemaEditorSupport)((Object)object)).syncModel();
        ((SchemaEditorSupport)((Object)object)).removeUndoManagerFromDocument();
    }

    public void componentOpened() {
        super.componentOpened();
    }

    public void componentClosed() {
        super.componentClosed();
    }

    public void componentShowing() {
        super.componentShowing();
        SchemaEditorSupport schemaEditorSupport = this.schemaDataObject.getSchemaEditorSupport();
        schemaEditorSupport.addUndoManagerToDocument();
    }

    public void componentHidden() {
        super.componentHidden();
        SchemaEditorSupport schemaEditorSupport = this.schemaDataObject.getSchemaEditorSupport();
        schemaEditorSupport.syncModel();
        schemaEditorSupport.removeUndoManagerFromDocument();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject((Object)this.schemaDataObject);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        Object object = objectInput.readObject();
        if (object instanceof SchemaDataObject) {
            this.schemaDataObject = (SchemaDataObject)((Object)object);
        }
        this.initialize();
    }

    void selectElementsAtOffset() {
        if (this.selectionTask != null) {
            this.selectionTask.cancel();
            this.selectionTask = null;
        }
        RequestProcessor requestProcessor = new RequestProcessor("schema source view processor " + ((Object)((Object)this)).hashCode());
        this.selectionTask = requestProcessor.create(new Runnable(){

            public void run() {
                if (!SchemaSourceMultiViewElement.this.isActiveTC() || SchemaSourceMultiViewElement.this.schemaDataObject == null || !SchemaSourceMultiViewElement.this.schemaDataObject.isValid() || SchemaSourceMultiViewElement.this.schemaDataObject.isTemplate()) {
                    return;
                }
                Node node = SchemaSourceMultiViewElement.this.findNode(SchemaSourceMultiViewElement.this.getEditorPane().getCaret().getDot());
                if (node == null) {
                    SchemaSourceMultiViewElement.this.setActivatedNodes(new Node[]{SchemaSourceMultiViewElement.this.schemaDataObject.getNodeDelegate()});
                } else if (SchemaSourceMultiViewElement.this.selectedNode != node) {
                    if (SchemaSourceMultiViewElement.this.nl == null) {
                        SchemaSourceMultiViewElement.this.nl = new NodeAdapter(){

                            public void nodeDestroyed(NodeEvent nodeEvent) {
                                if (nodeEvent.getNode() == SchemaSourceMultiViewElement.this.selectedNode) {
                                    SchemaSourceMultiViewElement.this.selectElementsAtOffset();
                                }
                            }
                        };
                    } else if (SchemaSourceMultiViewElement.this.selectedNode != null) {
                        SchemaSourceMultiViewElement.this.selectedNode.removeNodeListener((NodeListener)SchemaSourceMultiViewElement.this.nl);
                    }
                    SchemaSourceMultiViewElement.this.selectedNode = node;
                    SchemaSourceMultiViewElement.this.selectedNode.addNodeListener((NodeListener)SchemaSourceMultiViewElement.this.nl);
                    SchemaSourceMultiViewElement.this.setActivatedNodes(new Node[]{SchemaSourceMultiViewElement.this.selectedNode});
                }
            }
        });
        if (EventQueue.isDispatchThread()) {
            this.selectionTask.run();
        } else {
            EventQueue.invokeLater((Runnable)this.selectionTask);
        }
    }

    private Node findNode(int n) {
        try {
            SchemaEditorSupport schemaEditorSupport = this.schemaDataObject.getSchemaEditorSupport();
            if (schemaEditorSupport == null) {
                return null;
            }
            SchemaModel schemaModel = schemaEditorSupport.getModel();
            if (schemaModel == null || schemaModel.getState() != Model.State.VALID) {
                return null;
            }
            if (this.rootNode == null) {
                this.rootNode = new StructuralSchemaNodeFactory(schemaEditorSupport.getModel(), this.schemaDataObject.getNodeDelegate().getLookup()).createRootNode();
            }
            if (this.rootNode == null) {
                return null;
            }
            SchemaComponent schemaComponent = (SchemaComponent)schemaEditorSupport.getModel().findComponent(n);
            if (schemaComponent == null) {
                return null;
            }
            List list = UIUtilities.findPathFromRoot((Node)this.rootNode, (SchemaComponent)schemaComponent);
            if (!list.isEmpty()) {
                return (Node)list.get(list.size() - 1);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    protected boolean isActiveTC() {
        return SchemaSourceMultiViewElement.getRegistry().getActivated() == this.multiViewCallback.getTopComponent();
    }
}

