/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.multiview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AXIModelFactory;
import org.netbeans.modules.xml.schema.SchemaDataObject;
import org.netbeans.modules.xml.schema.SchemaEditorSupport;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.multiview.SchemaColumnViewMultiViewDesc;
import org.netbeans.modules.xml.schema.multiview.SchemaMultiViewSupport;
import org.netbeans.modules.xml.schema.ui.basic.SchemaColumnsCategory;
import org.netbeans.modules.xml.schema.ui.basic.SchemaSettings;
import org.netbeans.modules.xml.schema.ui.basic.SchemaTreeCategory;
import org.netbeans.modules.xml.validation.ShowCookie;
import org.netbeans.modules.xml.validation.ValidateAction;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.netbeans.modules.xml.xam.ui.category.Category;
import org.netbeans.modules.xml.xam.ui.category.CategoryPane;
import org.netbeans.modules.xml.xam.ui.category.DefaultCategoryPane;
import org.netbeans.modules.xml.xam.ui.multiview.ActivatedNodesMediator;
import org.netbeans.modules.xml.xam.ui.multiview.CookieProxyLookup;
import org.netbeans.modules.xml.xam.ui.search.SearchManager;
import org.netbeans.modules.xml.xam.ui.undo.QuietUndoManager;
import org.openide.ErrorManager;
import org.openide.actions.FindAction;
import org.openide.awt.UndoRedo;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;

public class SchemaColumnViewMultiViewElement
extends TopComponent
implements MultiViewElement,
PropertyChangeListener,
ExplorerManager.Provider {
    private static final long serialVersionUID = 1L;
    private static final String EMPTY_DOC = "<schema xmlns=\"http://www.w3.org/2001/XMLSchema\"/>";
    private SchemaDataObject schemaDataObject;
    private SchemaModel schemaModel;
    private String errorMessage;
    private transient MultiViewElementCallback multiViewCallback;
    private CategoryPane categoryPane;
    private transient JToolBar toolbar;
    private transient JLabel errorLabel = new JLabel();
    private ExplorerManager manager;
    private ValidateAction validateAction;

    public SchemaColumnViewMultiViewElement() {
    }

    public SchemaColumnViewMultiViewElement(SchemaDataObject schemaDataObject) {
        this.schemaDataObject = schemaDataObject;
        try {
            this.initialize();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().log(65536, NbBundle.getMessage(SchemaColumnViewMultiViewElement.class, (String)"LBL_ColView_not_created"));
        }
    }

    private void initialize() throws IOException {
        SchemaEditorSupport schemaEditorSupport = this.schemaDataObject.getSchemaEditorSupport();
        this.manager = new ExplorerManager();
        CallbackSystemAction callbackSystemAction = (CallbackSystemAction)SystemAction.get(FindAction.class);
        Object object = callbackSystemAction.getActionMapKey();
        ActionMap actionMap = this.getActionMap();
        actionMap.put(object, new ColumnViewFindAction());
        actionMap.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        actionMap.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.manager));
        actionMap.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.manager));
        actionMap.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.manager, (boolean)false));
        InputMap inputMap = this.getInputMap(1);
        KeyStroke keyStroke = (KeyStroke)callbackSystemAction.getValue("AcceleratorKey");
        if (keyStroke == null) {
            keyStroke = KeyStroke.getKeyStroke("control F");
        }
        inputMap.put(keyStroke, object);
        ShowCookie showCookie = new ShowCookie(){

            public void show(Validator.ResultItem resultItem) {
                final Component component = resultItem.getComponents();
                if (SchemaColumnViewMultiViewElement.this.categoryPane != null && component instanceof SchemaComponent) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            SchemaColumnViewMultiViewElement.this.categoryPane.getCategory().showComponent((Component)((SchemaComponent)component));
                        }
                    });
                }
            }
        };
        Node node = this.schemaDataObject.getNodeDelegate();
        ActivatedNodesMediator activatedNodesMediator = new ActivatedNodesMediator(node);
        activatedNodesMediator.setExplorerManager((ExplorerManager.Provider)this);
        CookieProxyLookup cookieProxyLookup = new CookieProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{actionMap, this.schemaDataObject, showCookie}), activatedNodesMediator.getLookup(), node.getLookup()}, node);
        this.associateLookup((Lookup)cookieProxyLookup);
        this.addPropertyChangeListener("activatedNodes", (PropertyChangeListener)activatedNodesMediator);
        this.addPropertyChangeListener("activatedNodes", (PropertyChangeListener)cookieProxyLookup);
        this.setLayout(new BorderLayout());
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SchemaColumnViewMultiViewElement.class, (String)"LBL_SchemaColumnView"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SchemaColumnViewMultiViewElement.class, (String)"DSC_SchemaColumnView"));
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (!"state".equals(string)) {
            return;
        }
        Model.State state = (Model.State)propertyChangeEvent.getNewValue();
        if (state == Model.State.VALID) {
            this.errorMessage = null;
            this.recreateUI();
            return;
        }
        if (this.errorMessage == null) {
            this.errorMessage = NbBundle.getMessage(SchemaColumnViewMultiViewElement.class, (String)"MSG_NotWellformedSchema");
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SchemaColumnViewMultiViewElement.this.setActivatedNodes(new Node[]{SchemaColumnViewMultiViewElement.this.schemaDataObject.getNodeDelegate()});
            }
        });
        this.emptyUI(this.errorMessage);
    }

    public SchemaDataObject getSchemaDataObject() {
        return this.schemaDataObject;
    }

    private SchemaModel getSchemaModel() {
        try {
            if (this.schemaModel != null) {
                return this.schemaModel;
            }
            SchemaEditorSupport schemaEditorSupport = this.getSchemaDataObject().getSchemaEditorSupport();
            this.schemaModel = schemaEditorSupport.getModel();
            if (this.schemaModel != null) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class, (EventListener)this, (Object)this.schemaModel);
                this.schemaModel.addPropertyChangeListener(propertyChangeListener);
            }
        }
        catch (IOException iOException) {
            this.errorMessage = iOException.getMessage();
        }
        return this.schemaModel;
    }

    public int getPersistenceType() {
        return 2;
    }

    public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
        this.multiViewCallback = multiViewElementCallback;
    }

    public CloseOperationState canCloseElement() {
        if (!SchemaMultiViewSupport.isLastView(this.multiViewCallback.getTopComponent())) {
            return CloseOperationState.STATE_OK;
        }
        return MultiViewFactory.createUnsafeCloseState((String)"ID_SCHEMA_COLUMNVIEW_CLOSING", (Action)MultiViewFactory.NOOP_CLOSE_ACTION, (Action)MultiViewFactory.NOOP_CLOSE_ACTION);
    }

    private boolean isSchemaValid() {
        SchemaEditorSupport schemaEditorSupport = this.schemaDataObject.getSchemaEditorSupport();
        try {
            SchemaModel schemaModel = schemaEditorSupport.getModel();
            if (schemaModel != null && schemaModel.getState() == Model.State.VALID) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private void initUI() {
        if (this.isSchemaValid()) {
            this.recreateUI();
            return;
        }
        if (this.errorMessage == null) {
            this.errorMessage = NbBundle.getMessage(SchemaColumnViewMultiViewElement.class, (String)"MSG_NotWellformedSchema");
        }
        this.emptyUI(this.errorMessage);
    }

    private void recreateUI() {
        this.removeAll();
        if (this.categoryPane == null) {
            this.categoryPane = new DefaultCategoryPane();
            SchemaModel schemaModel = this.getSchemaModel();
            Lookup lookup = this.getLookup();
            SchemaColumnsCategory schemaColumnsCategory = new SchemaColumnsCategory(schemaModel, lookup);
            this.categoryPane.addCategory((Category)schemaColumnsCategory);
            SchemaTreeCategory schemaTreeCategory = new SchemaTreeCategory(schemaModel, lookup);
            this.categoryPane.addCategory((Category)schemaTreeCategory);
            SchemaSettings.ViewMode viewMode = SchemaSettings.getDefault().getViewMode();
            switch (viewMode) {
                case COLUMN: {
                    this.categoryPane.setCategory((Category)schemaColumnsCategory);
                    break;
                }
                case TREE: {
                    this.categoryPane.setCategory((Category)schemaTreeCategory);
                }
            }
        }
        this.add(this.categoryPane.getComponent(), "Center");
        this.revalidate();
        this.repaint();
    }

    private void emptyUI(String string) {
        this.removeAll();
        this.errorLabel.setText("<" + string + ">");
        this.errorLabel.setHorizontalAlignment(0);
        this.errorLabel.setHorizontalTextPosition(0);
        Color color = UIManager.getColor("window");
        this.errorLabel.setBackground(color != null ? color : Color.white);
        this.errorLabel.setOpaque(true);
        this.add(this.errorLabel, "Center");
        this.revalidate();
        this.repaint();
    }

    private void addUndoManager() {
        SchemaModel schemaModel = this.getSchemaModel();
        if (schemaModel != null) {
            SchemaEditorSupport schemaEditorSupport = this.schemaDataObject.getSchemaEditorSupport();
            QuietUndoManager quietUndoManager = schemaEditorSupport.getUndoManager();
            schemaModel.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
            schemaModel.addUndoableEditListener((UndoableEditListener)quietUndoManager);
            quietUndoManager.setModel((Model)schemaModel);
            AXIModel aXIModel = AXIModelFactory.getDefault().getModel(schemaModel);
            quietUndoManager.removeWrapperModel((Model)aXIModel);
        }
    }

    public void componentActivated() {
        super.componentActivated();
        this.addUndoManager();
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)true);
    }

    public void componentDeactivated() {
        super.componentDeactivated();
        if (this.manager != null) {
            ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
        }
    }

    public void componentOpened() {
        super.componentOpened();
    }

    public void componentClosed() {
        super.componentClosed();
        if (this.categoryPane != null) {
            this.categoryPane.close();
        }
        if (this.toolbar != null) {
            this.toolbar.removeAll();
        }
        if (this.manager != null) {
            ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
            this.manager = null;
        }
        this.toolbar = null;
        this.validateAction = null;
        this.schemaModel = null;
        this.categoryPane = null;
    }

    public void componentShowing() {
        Category category;
        super.componentShowing();
        this.initUI();
        this.addUndoManager();
        if (this.categoryPane != null && (category = this.categoryPane.getCategory()) != null) {
            category.componentShown();
        }
    }

    public void componentHidden() {
        Category category;
        super.componentHidden();
        if (this.categoryPane != null && (category = this.categoryPane.getCategory()) != null) {
            category.componentHidden();
        }
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.categoryPane != null) {
            this.categoryPane.getComponent().requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        boolean bl = super.requestFocusInWindow();
        if (this.categoryPane != null) {
            return this.categoryPane.getComponent().requestFocusInWindow();
        }
        return bl;
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolbar != null) {
            return this.toolbar;
        }
        try {
            SchemaModel schemaModel = this.schemaDataObject.getSchemaEditorSupport().getModel();
            if (schemaModel != null && schemaModel.getState() == Model.State.VALID) {
                SearchManager searchManager;
                this.toolbar = new JToolBar();
                this.toolbar.setFloatable(false);
                if (this.categoryPane != null) {
                    this.toolbar.addSeparator();
                    this.categoryPane.populateToolbar(this.toolbar);
                }
                if ((searchManager = SearchManager.getDefault()) != null) {
                    this.toolbar.addSeparator();
                    this.toolbar.add(searchManager.getSearchAction());
                }
                this.toolbar.addSeparator();
                this.validateAction = new ValidateAction((Model)schemaModel);
                JButton jButton = this.toolbar.add((Action)this.validateAction);
                jButton.getAccessibleContext().setAccessibleName("" + jButton.getAction().getValue("Name"));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.toolbar;
    }

    public UndoRedo getUndoRedo() {
        return this.schemaDataObject.getSchemaEditorSupport().getUndoManager();
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(SchemaColumnViewMultiViewDesc.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceResetDocument(SchemaModel schemaModel) {
        SchemaDataObject schemaDataObject = this.getSchemaDataObject();
        SchemaEditorSupport schemaEditorSupport = schemaDataObject.getSchemaEditorSupport();
        StyledDocument styledDocument = schemaEditorSupport.getDocument();
        QuietUndoManager quietUndoManager = schemaEditorSupport.getUndoManager();
        schemaModel.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
        schemaEditorSupport.ignoreUpdateTitles(true);
        try {
            String string = styledDocument.getText(0, styledDocument.getLength());
            styledDocument.remove(0, styledDocument.getLength());
            styledDocument.insertString(0, EMPTY_DOC, null);
            schemaModel.sync();
            styledDocument.remove(0, styledDocument.getLength());
            styledDocument.insertString(0, string, null);
            schemaModel.sync();
            schemaDataObject.setModified(false);
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(SchemaColumnViewMultiViewElement.class.getName()).log(Level.FINE, "forceResetDocument", badLocationException);
        }
        catch (IOException iOException) {
            Logger.getLogger(SchemaColumnViewMultiViewElement.class.getName()).log(Level.FINE, "forceResetDocument", iOException);
        }
        finally {
            schemaEditorSupport.ignoreUpdateTitles(false);
            schemaModel.addUndoableEditListener((UndoableEditListener)quietUndoManager);
        }
    }

    private class ColumnViewFindAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public void actionPerformed(ActionEvent actionEvent) {
            SchemaColumnViewMultiViewElement schemaColumnViewMultiViewElement = SchemaColumnViewMultiViewElement.this;
            if (schemaColumnViewMultiViewElement.categoryPane != null) {
                CategoryPane categoryPane = schemaColumnViewMultiViewElement.categoryPane;
                categoryPane.getSearchComponent().showComponent();
            }
        }
    }
}

