/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.multiview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.EventListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditListener;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AXIModelFactory;
import org.netbeans.modules.xml.schema.SchemaDataObject;
import org.netbeans.modules.xml.schema.SchemaEditorSupport;
import org.netbeans.modules.xml.schema.abe.InstanceDesignerPanel;
import org.netbeans.modules.xml.schema.abe.UIUtilities;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.multiview.SchemaABEViewMultiViewDesc;
import org.netbeans.modules.xml.schema.multiview.SchemaColumnViewMultiViewElement;
import org.netbeans.modules.xml.schema.multiview.SchemaMultiViewSupport;
import org.netbeans.modules.xml.validation.ShowCookie;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.netbeans.modules.xml.xam.ui.multiview.ActivatedNodesMediator;
import org.netbeans.modules.xml.xam.ui.multiview.CookieProxyLookup;
import org.netbeans.modules.xml.xam.ui.undo.QuietUndoManager;
import org.openide.awt.UndoRedo;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;

public class SchemaABEViewMultiViewElement
extends TopComponent
implements MultiViewElement,
PropertyChangeListener,
ExplorerManager.Provider {
    private static final long serialVersionUID = -483941387931729295L;
    private AXIModel axiModel;
    private String errorMessage;
    private SchemaDataObject schemaDataObject;
    private InstanceDesignerPanel abeDesigner;
    private transient JPanel toolBarPanel;
    private JLabel errorLabel = new JLabel();
    private transient MultiViewElementCallback multiViewCallback;
    private ExplorerManager manager;
    boolean firsTime = true;
    boolean propChangeListenerAdded = false;

    public SchemaABEViewMultiViewElement() {
    }

    public SchemaABEViewMultiViewElement(SchemaDataObject schemaDataObject) {
        this.schemaDataObject = schemaDataObject;
        this.initialize();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (!"state".equals(string)) {
            return;
        }
        Model.State state = (Model.State)propertyChangeEvent.getNewValue();
        if (state == Model.State.VALID) {
            this.errorMessage = null;
            this.recreateUI();
            return;
        }
        if (this.errorMessage == null) {
            this.errorMessage = NbBundle.getMessage(SchemaColumnViewMultiViewElement.class, (String)"MSG_InvalidSchema");
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SchemaABEViewMultiViewElement.this.setActivatedNodes(new Node[]{SchemaABEViewMultiViewElement.this.schemaDataObject.getNodeDelegate()});
            }
        });
        this.emptyUI(this.errorMessage);
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private void initialize() {
        Node node = this.schemaDataObject.getNodeDelegate();
        ShowCookie showCookie = new ShowCookie(){

            public void show(Validator.ResultItem resultItem) {
                Component component = resultItem.getComponents();
                if (component != null) {
                    SchemaABEViewMultiViewElement.this.abeDesigner.selectUIComponent(component);
                }
            }
        };
        ActivatedNodesMediator activatedNodesMediator = new ActivatedNodesMediator(node);
        this.manager = new ExplorerManager();
        activatedNodesMediator.setExplorerManager((ExplorerManager.Provider)this);
        ActionMap actionMap = this.getActionMap();
        actionMap.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        actionMap.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.manager));
        actionMap.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.manager));
        actionMap.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.manager, (boolean)false));
        CookieProxyLookup cookieProxyLookup = new CookieProxyLookup(new Lookup[]{activatedNodesMediator.getLookup(), Lookups.proxy((Lookup.Provider)new Lookup.Provider(){

            public Lookup getLookup() {
                Lookup lookup = Lookup.EMPTY;
                if (SchemaABEViewMultiViewElement.this.abeDesigner != null) {
                    lookup = Lookups.singleton((Object)SchemaABEViewMultiViewElement.this.abeDesigner.getPaletteController());
                }
                return lookup;
            }
        }), Lookups.fixed((Object[])new Object[]{this.getActionMap(), this.schemaDataObject, showCookie}), node.getLookup()}, node);
        this.associateLookup((Lookup)cookieProxyLookup);
        this.addPropertyChangeListener("activatedNodes", (PropertyChangeListener)activatedNodesMediator);
        this.addPropertyChangeListener("activatedNodes", (PropertyChangeListener)cookieProxyLookup);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SchemaColumnViewMultiViewElement.class, (String)"LBL_ABE_View_name"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SchemaColumnViewMultiViewElement.class, (String)"LBL_ABE_View_name"));
    }

    private void initUI() {
        Object object;
        if (this.firsTime) {
            this.setLayout(new BorderLayout());
            this.errorLabel.setHorizontalAlignment(0);
            this.errorLabel.setHorizontalTextPosition(0);
            object = UIManager.getColor("window");
            this.errorLabel.setBackground((Color)(object != null ? object : Color.white));
            this.errorLabel.setOpaque(true);
            this.firsTime = false;
        }
        if ((object = this.getAXIModel()) != null && object.getState() == Model.State.VALID) {
            this.recreateUI();
            return;
        }
        if (this.errorMessage == null) {
            this.errorMessage = NbBundle.getMessage(SchemaColumnViewMultiViewElement.class, (String)"MSG_InvalidSchema");
        }
        this.emptyUI(this.errorMessage);
    }

    private void recreateUI() {
        if (this.abeDesigner == null) {
            this.abeDesigner = new InstanceDesignerPanel(this.getAXIModel(), (DataObject)this.schemaDataObject, (TopComponent)this);
        }
        if (!this.isChild((java.awt.Component)this.abeDesigner)) {
            this.add((java.awt.Component)this.abeDesigner, "Center");
        }
        if (!this.propChangeListenerAdded) {
            this.abeDesigner.addPropertyChangeListener((PropertyChangeListener)this);
            this.propChangeListenerAdded = true;
        }
        if (this.errorLabel != null) {
            this.errorLabel.setVisible(false);
        }
        this.abeDesigner.setVisible(true);
        this.revalidate();
        this.repaint();
    }

    private void emptyUI(String string) {
        if (this.abeDesigner != null) {
            this.abeDesigner.setVisible(false);
        }
        this.errorLabel.setText("<" + string + ">");
        if (!this.isChild(this.errorLabel)) {
            this.add(this.errorLabel, "North");
        }
        if (this.propChangeListenerAdded) {
            this.abeDesigner.addPropertyChangeListener((PropertyChangeListener)this);
            this.propChangeListenerAdded = false;
        }
        this.errorLabel.setVisible(true);
        this.revalidate();
        this.repaint();
    }

    private boolean isChild(java.awt.Component component) {
        java.awt.Component[] componentArray = this.getComponents();
        if (componentArray == null || componentArray.length <= 0) {
            return false;
        }
        return Arrays.asList(componentArray).contains(component);
    }

    public int getPersistenceType() {
        return 2;
    }

    public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
        this.multiViewCallback = multiViewElementCallback;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(SchemaABEViewMultiViewDesc.class);
    }

    public CloseOperationState canCloseElement() {
        if (!SchemaMultiViewSupport.isLastView(this.multiViewCallback.getTopComponent())) {
            return CloseOperationState.STATE_OK;
        }
        return MultiViewFactory.createUnsafeCloseState((String)"ID_SCHEMA_ABEVIEW_CLOSING", (Action)MultiViewFactory.NOOP_CLOSE_ACTION, (Action)MultiViewFactory.NOOP_CLOSE_ACTION);
    }

    public void componentActivated() {
        super.componentActivated();
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)true);
        this.addUndoManager();
        UIUtilities.hideGlassMessage((boolean)true);
    }

    public void componentClosed() {
        super.componentClosed();
        UIUtilities.hideGlassMessage((boolean)true);
        if (this.abeDesigner != null) {
            this.abeDesigner.shutdown();
            this.abeDesigner = null;
        }
        this.removeUndoManager();
        this.removeAll();
        this.setLayout(null);
    }

    public void componentDeactivated() {
        super.componentDeactivated();
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
        UIUtilities.hideGlassMessage((boolean)true);
    }

    public void componentHidden() {
        super.componentHidden();
        UIUtilities.hideGlassMessage((boolean)true);
    }

    public void componentOpened() {
        super.componentOpened();
        UIUtilities.hideGlassMessage((boolean)true);
    }

    public void componentShowing() {
        super.componentShowing();
        this.initUI();
        this.addUndoManager();
        UIUtilities.hideGlassMessage((boolean)true);
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.abeDesigner != null) {
            this.abeDesigner.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        boolean bl = super.requestFocusInWindow();
        if (this.abeDesigner != null) {
            return this.abeDesigner.requestFocusInWindow();
        }
        return bl;
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolBarPanel == null) {
            this.toolBarPanel = new JPanel(new FlowLayout(0));
            JSeparator jSeparator = new JSeparator(1);
            this.toolBarPanel.add(jSeparator);
        }
        return this.toolBarPanel;
    }

    private void addUndoManager() {
        SchemaModel schemaModel = this.getAXIModel().getSchemaModel();
        if (schemaModel != null) {
            SchemaEditorSupport schemaEditorSupport = this.schemaDataObject.getSchemaEditorSupport();
            QuietUndoManager quietUndoManager = schemaEditorSupport.getUndoManager();
            schemaModel.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
            schemaModel.addUndoableEditListener((UndoableEditListener)quietUndoManager);
            quietUndoManager.setModel((Model)schemaModel);
            quietUndoManager.addWrapperModel((Model)this.getAXIModel());
        }
    }

    private void removeUndoManager() {
        SchemaModel schemaModel = this.getAXIModel().getSchemaModel();
        if (schemaModel != null) {
            SchemaEditorSupport schemaEditorSupport = this.schemaDataObject.getSchemaEditorSupport();
            QuietUndoManager quietUndoManager = schemaEditorSupport.getUndoManager();
            schemaModel.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
            quietUndoManager.removeWrapperModel((Model)schemaModel);
        }
    }

    public UndoRedo getUndoRedo() {
        return this.schemaDataObject.getSchemaEditorSupport().getUndoManager();
    }

    private AXIModel getAXIModel() {
        if (this.axiModel != null) {
            return this.axiModel;
        }
        try {
            SchemaModel schemaModel = this.schemaDataObject.getSchemaEditorSupport().getModel();
            this.axiModel = AXIModelFactory.getDefault().getModel(schemaModel);
            if (this.axiModel != null) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class, (EventListener)this, (Object)this.axiModel);
                this.axiModel.addPropertyChangeListener(propertyChangeListener);
            }
        }
        catch (IOException iOException) {
            this.errorMessage = iOException.getMessage();
        }
        return this.axiModel;
    }

    public JComponent getVisualRepresentation() {
        return this;
    }
}

