/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema;

import java.awt.EventQueue;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AXIModelFactory;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.SchemaDataObject;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.schema.multiview.SchemaMultiViewSupport;
import org.netbeans.modules.xml.schema.ui.basic.SchemaModelCookie;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.ui.undo.QuietUndoManager;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.UndoRedo;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.UserCancelException;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class SchemaEditorSupport
extends DataEditorSupport
implements SchemaModelCookie,
OpenCookie,
EditCookie,
EditorCookie.Observable,
LineCookie,
CloseCookie,
PrintCookie {
    private static final Logger logger = Logger.getLogger(SchemaEditorSupport.class.getName());
    private transient Task prepareTask2;
    private transient boolean ignoreUpdateTitles;
    private transient SchemaModel model;

    public SchemaEditorSupport(SchemaDataObject schemaDataObject) {
        super((DataObject)schemaDataObject, (CloneableEditorSupport.Env)new SchemaEditorEnv(schemaDataObject));
        this.setMIMEType("application/x-schema+xml");
    }

    public SchemaEditorEnv getEnv() {
        return (SchemaEditorEnv)this.env;
    }

    protected CloneableEditorSupport.Pane createPane() {
        CloneableTopComponent cloneableTopComponent = SchemaMultiViewSupport.createMultiView((SchemaDataObject)this.getDataObject());
        Mode mode = WindowManager.getDefault().findMode("editor");
        if (mode != null) {
            mode.dockInto((TopComponent)cloneableTopComponent);
        }
        return (CloneableEditorSupport.Pane)cloneableTopComponent;
    }

    public void initializeCloneableEditor(CloneableEditor cloneableEditor) {
        super.initializeCloneableEditor(cloneableEditor);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SchemaEditorSupport.this.updateTitles();
            }
        });
    }

    public void ignoreUpdateTitles(boolean bl) {
        this.ignoreUpdateTitles = bl;
    }

    protected void updateTitles() {
        if (this.ignoreUpdateTitles) {
            return;
        }
        super.updateTitles();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TopComponent topComponent;
                ArrayList<TopComponent> arrayList = new ArrayList<TopComponent>();
                DataObject dataObject = SchemaEditorSupport.this.getDataObject();
                TopComponent topComponent2 = TopComponent.getRegistry().getActivated();
                if (topComponent2 != null && dataObject == topComponent2.getLookup().lookup(DataObject.class)) {
                    arrayList.add(topComponent2);
                }
                Set set = TopComponent.getRegistry().getOpened();
                for (Object object : set) {
                    topComponent = (TopComponent)object;
                    if (dataObject != topComponent.getLookup().lookup(DataObject.class)) continue;
                    arrayList.add(topComponent);
                }
                for (TopComponent topComponent3 : arrayList) {
                    topComponent = MultiViews.findMultiViewHandler((TopComponent)topComponent3);
                    if (topComponent == null) continue;
                    topComponent3.setHtmlDisplayName(SchemaEditorSupport.this.messageHtmlName());
                    String string = SchemaEditorSupport.this.messageName();
                    topComponent3.setDisplayName(string);
                    topComponent3.setName(string);
                    topComponent3.setToolTipText(SchemaEditorSupport.this.messageToolTip());
                }
            }
        });
    }

    protected UndoRedo.Manager createUndoRedoManager() {
        return new QuietUndoManager(super.createUndoRedoManager());
    }

    public QuietUndoManager getUndoManager() {
        return (QuietUndoManager)this.getUndoRedo();
    }

    public SchemaModel getModel() throws IOException {
        boolean bl;
        if (this.model != null) {
            return this.model;
        }
        SchemaDataObject schemaDataObject = this.getEnv().getSchemaDataObject();
        FileObject fileObject = schemaDataObject.getPrimaryFile();
        ModelSource modelSource = Utilities.getModelSource((FileObject)fileObject, (boolean)true);
        boolean bl2 = bl = modelSource != null && modelSource.getLookup().lookup(Document.class) != null;
        if (!bl) {
            throw new IOException(NbBundle.getMessage(SchemaEditorSupport.class, (String)"MSG_UnableToCreateModel"));
        }
        this.model = SchemaModelFactory.getDefault().getModel(modelSource);
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUndoManagerToDocument() {
        QuietUndoManager quietUndoManager = this.getUndoManager();
        StyledDocument styledDocument = this.getDocument();
        SchemaModel schemaModel = null;
        AXIModel aXIModel = null;
        try {
            schemaModel = this.getModel();
            aXIModel = AXIModelFactory.getDefault().getModel(schemaModel);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        QuietUndoManager quietUndoManager2 = quietUndoManager;
        synchronized (quietUndoManager2) {
            if (schemaModel != null) {
                schemaModel.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
            }
            quietUndoManager.setModel(null);
            quietUndoManager.removeWrapperModel((Model)aXIModel);
            if (styledDocument != null) {
                styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                styledDocument.addUndoableEditListener((UndoableEditListener)quietUndoManager);
                quietUndoManager.beginCompound();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUndoManagerFromDocument() {
        QuietUndoManager quietUndoManager = this.getUndoManager();
        StyledDocument styledDocument = this.getDocument();
        QuietUndoManager quietUndoManager2 = quietUndoManager;
        synchronized (quietUndoManager2) {
            if (styledDocument != null) {
                styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                quietUndoManager.endCompound();
            }
            this.addUndoManagerToModel(quietUndoManager);
        }
    }

    private void addUndoManagerToModel(QuietUndoManager quietUndoManager) {
        try {
            SchemaModel schemaModel = this.getModel();
            if (schemaModel != null) {
                schemaModel.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                schemaModel.addUndoableEditListener((UndoableEditListener)quietUndoManager);
                quietUndoManager.setModel((Model)schemaModel);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void removeUndoManagerFromModel(QuietUndoManager quietUndoManager) {
        try {
            SchemaModel schemaModel = this.getModel();
            if (schemaModel != null) {
                schemaModel.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                quietUndoManager.setModel(null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean suspendUndoRedo() {
        boolean bl;
        QuietUndoManager quietUndoManager;
        QuietUndoManager quietUndoManager2 = quietUndoManager = this.getUndoManager();
        synchronized (quietUndoManager2) {
            bl = quietUndoManager.isCompound();
            if (bl) {
                this.removeUndoManagerFromDocument();
            }
            this.removeUndoManagerFromModel(quietUndoManager);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeUndoRedo(boolean bl) {
        if (bl) {
            this.addUndoManagerToDocument();
        } else {
            QuietUndoManager quietUndoManager;
            QuietUndoManager quietUndoManager2 = quietUndoManager = this.getUndoManager();
            synchronized (quietUndoManager2) {
                this.addUndoManagerToModel(quietUndoManager);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromStreamToKit(StyledDocument styledDocument, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
        String string = EncodingUtil.detectEncoding((InputStream)inputStream);
        if (string == null) {
            string = "UTF8";
        }
        Reader reader = null;
        try {
            reader = EncodingUtil.getUnicodeReader((InputStream)inputStream, (String)string);
            editorKit.read(reader, (Document)styledDocument, 0);
        }
        catch (CharConversionException charConversionException) {
            logger.log(Level.WARNING, charConversionException.getMessage());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.log(Level.WARNING, unsupportedEncodingException.getMessage());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    protected void saveFromKitToStream(StyledDocument styledDocument, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
        String string = EncodingUtil.detectEncoding((Document)styledDocument);
        if (string == null) {
            string = "UTF8";
        }
        try {
            new OutputStreamWriter((OutputStream)new ByteArrayOutputStream(1), string);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
            editorKit.write(outputStreamWriter, (Document)styledDocument, 0, styledDocument.getLength());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            IOException iOException = new IOException("Unsupported encoding " + string);
            ErrorManager.getDefault().annotate((Throwable)iOException, NbBundle.getMessage(SchemaEditorSupport.class, (String)"MSG_SchemaEditorSupport_Unsupported_Encoding", (Object)string));
            throw iOException;
        }
    }

    public boolean silentClose() {
        return super.close(false);
    }

    public void saveDocument() throws IOException {
        StyledDocument styledDocument = this.getDocument();
        String string = EncodingUtil.detectEncoding((Document)styledDocument);
        if (string == null) {
            string = "UTF8";
        }
        try {
            new OutputStreamWriter((OutputStream)new ByteArrayOutputStream(1), string);
            if (!this.checkCharsetConversion(EncodingUtil.getJava2IANAMapping((String)string))) {
                return;
            }
            super.saveDocument();
            this.getDataObject().setModified(false);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)MessageFormat.format(NbBundle.getMessage(SchemaEditorSupport.class, (String)"MSG_SchemaEditorSupport_Use_UTF8"), string));
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (object.equals(NotifyDescriptor.YES_OPTION)) {
                this.updateDocumentWithNewEncoding(styledDocument);
            }
            throw new UserCancelException();
        }
    }

    private void updateDocumentWithNewEncoding(final StyledDocument styledDocument) throws IOException {
        try {
            int n;
            int n2 = Math.min(1000, styledDocument.getLength());
            final char[] cArray = styledDocument.getText(0, n2).toCharArray();
            int n3 = 0;
            if (cArray[0] == '<' && cArray[1] == '?' && cArray[2] == 'x') {
                for (n = 3; n < n2; ++n) {
                    if (cArray[n] != '?' || cArray[n + 1] != '>') continue;
                    n3 = n + 1;
                    break;
                }
            }
            n = n3;
            Runnable runnable = new Runnable(){

                public void run() {
                    block2: {
                        try {
                            styledDocument.remove(0, n + 1);
                            styledDocument.insertString(0, "<?xml version='1.0' encoding='UTF-8' ?>\n<!-- was: " + new String(cArray, 0, n + 1) + " -->", null);
                        }
                        catch (BadLocationException badLocationException) {
                            if (System.getProperty("netbeans.debug.exceptions") == null) break block2;
                            badLocationException.printStackTrace();
                        }
                    }
                }
            };
            NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)runnable);
            super.saveDocument();
            this.getDataObject().setModified(false);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
    }

    private boolean checkCharsetConversion(String string) {
        boolean bl = true;
        try {
            CharsetEncoder charsetEncoder = Charset.forName(string).newEncoder();
            if (!charsetEncoder.canEncode(this.getDocument().getText(0, this.getDocument().getLength()))) {
                Object[] objectArray = new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), string};
                String string2 = NbBundle.getMessage(SchemaEditorSupport.class, (String)"MSG_SchemaEditorSupport_BadCharConversion", (Object[])objectArray);
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string2, 0, 2);
                confirmation.setValue(NotifyDescriptor.NO_OPTION);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (confirmation.getValue() != NotifyDescriptor.YES_OPTION) {
                    bl = false;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
        }
        return bl;
    }

    public void syncModel() {
        try {
            SchemaModel schemaModel = this.getModel();
            if (schemaModel != null) {
                schemaModel.sync();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Task prepareDocument() {
        Task task = super.prepareDocument();
        if (task != this.prepareTask2) {
            this.prepareTask2 = task;
            task.addTaskListener(new TaskListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void taskFinished(Task task) {
                    QuietUndoManager quietUndoManager = SchemaEditorSupport.this.getUndoManager();
                    StyledDocument styledDocument = SchemaEditorSupport.this.getDocument();
                    if (styledDocument == null) {
                        return;
                    }
                    QuietUndoManager quietUndoManager2 = quietUndoManager;
                    synchronized (quietUndoManager2) {
                        quietUndoManager.setDocument((AbstractDocument)((Object)styledDocument));
                        if (!quietUndoManager.isCompound()) {
                            styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                            SchemaEditorSupport.this.addUndoManagerToModel(quietUndoManager);
                        }
                    }
                    SchemaEditorSupport.this.prepareTask2 = null;
                }
            });
        }
        return task;
    }

    public Task reloadDocument() {
        Task task = super.reloadDocument();
        task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                EventQueue.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        QuietUndoManager quietUndoManager = SchemaEditorSupport.this.getUndoManager();
                        StyledDocument styledDocument = SchemaEditorSupport.this.getDocument();
                        QuietUndoManager quietUndoManager2 = quietUndoManager;
                        synchronized (quietUndoManager2) {
                            if (!quietUndoManager.isCompound()) {
                                styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                            }
                        }
                    }
                });
            }
        });
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyClosed() {
        QuietUndoManager quietUndoManager = this.getUndoManager();
        StyledDocument styledDocument = this.getDocument();
        QuietUndoManager quietUndoManager2 = quietUndoManager;
        synchronized (quietUndoManager2) {
            if (styledDocument != null) {
                styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                quietUndoManager.endCompound();
                quietUndoManager.setDocument(null);
            }
            try {
                SchemaModel schemaModel = this.getModel();
                if (schemaModel != null) {
                    schemaModel.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                    AXIModel aXIModel = AXIModelFactory.getDefault().getModel(schemaModel);
                    quietUndoManager.removeWrapperModel((Model)aXIModel);
                }
                quietUndoManager.setModel(null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.model = null;
        super.notifyClosed();
    }

    protected boolean notifyModified() {
        boolean bl = super.notifyModified();
        if (!bl) {
            return false;
        }
        SchemaDataObject schemaDataObject = (SchemaDataObject)this.getDataObject();
        if (schemaDataObject.getCookie(SaveCookie.class) == null) {
            schemaDataObject.addSaveCookie(new SaveCookie(){

                public void save() throws IOException {
                    try {
                        SchemaEditorSupport.this.saveDocument();
                    }
                    catch (UserCancelException userCancelException) {
                        // empty catch block
                    }
                }
            });
        }
        return true;
    }

    public static class CloseHandler
    implements CloseOperationHandler,
    Serializable {
        private static final long serialVersionUID = -3838395157610633251L;
        private DataObject dataObject;

        private CloseHandler() {
        }

        public CloseHandler(DataObject dataObject) {
            this.dataObject = dataObject;
        }

        private SchemaEditorSupport getSchemaEditorSupport() {
            return this.dataObject == null ? null : (SchemaEditorSupport)this.dataObject.getCookie(SchemaEditorSupport.class);
        }

        public boolean resolveCloseOperation(CloseOperationState[] closeOperationStateArray) {
            boolean bl;
            SchemaEditorSupport schemaEditorSupport = this.getSchemaEditorSupport();
            boolean bl2 = bl = schemaEditorSupport != null ? schemaEditorSupport.canClose() : true;
            if (bl) {
                this.dataObject.setModified(false);
            }
            return bl;
        }
    }

    protected static class SchemaEditorEnv
    extends DataEditorSupport.Env {
        static final long serialVersionUID = 1099957785497677206L;

        public SchemaEditorEnv(SchemaDataObject schemaDataObject) {
            super((DataObject)schemaDataObject);
        }

        public CloneableEditorSupport findTextEditorSupport() {
            return this.getSchemaDataObject().getSchemaEditorSupport();
        }

        public SchemaDataObject getSchemaDataObject() {
            return (SchemaDataObject)this.getDataObject();
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return this.getDataObject().getPrimaryFile().lock();
        }
    }
}

