/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.reformat;

import java.util.LinkedList;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.reformat.BracesStack;
import org.netbeans.modules.cnd.editor.reformat.ContextDetector;
import org.netbeans.modules.cnd.editor.reformat.DiffLinkedList;
import org.netbeans.modules.cnd.editor.reformat.PreprocessorFormatter;
import org.netbeans.modules.cnd.editor.reformat.Reformatter;
import org.netbeans.modules.cnd.editor.reformat.StackEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReformatterImpl {
    final ContextDetector ts;
    final CodeStyle codeStyle;
    final DiffLinkedList diffs = new DiffLinkedList();
    final BracesStack braces;
    private final int startOffset;
    private final int endOffset;
    private PreprocessorFormatter preprocessorFormatter;
    private int tabSize;

    ReformatterImpl(TokenSequence<CppTokenId> tokenSequence, int n, int n2, CodeStyle codeStyle) {
        this.braces = new BracesStack(codeStyle);
        this.ts = new ContextDetector(tokenSequence, this.diffs, this.braces);
        this.startOffset = n;
        this.endOffset = n2;
        this.codeStyle = codeStyle;
        this.preprocessorFormatter = new PreprocessorFormatter(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    LinkedList<Reformatter.Diff> reformat() {
        this.tabSize = this.codeStyle.getGlobalTabSize();
        if (this.tabSize <= 1) {
            this.tabSize = 4;
        }
        this.ts.moveStart();
        Token<CppTokenId> token = this.ts.lookPrevious();
        while (this.ts.moveNext()) {
            if (this.ts.offset() > this.endOffset) {
                return this.diffs.getStorage();
            }
            Token<CppTokenId> token2 = this.ts.token();
            CppTokenId cppTokenId = (CppTokenId)token2.id();
            if (token != null && token.id() == CppTokenId.PREPROCESSOR_DIRECTIVE && cppTokenId != CppTokenId.PREPROCESSOR_DIRECTIVE) {
                if (this.braces.getStatementContinuation() == BracesStack.StatementContinuation.START && this.ts.isStatementContinuation()) {
                    this.braces.setStatementContinuation(BracesStack.StatementContinuation.CONTINUE);
                }
                if (this.doFormat()) {
                    this.indentNewLine(token2);
                }
            }
            switch (cppTokenId) {
                case PREPROCESSOR_DIRECTIVE: 
                case NEW_LINE: 
                case ESCAPED_WHITESPACE: 
                case WHITESPACE: 
                case BLOCK_COMMENT: 
                case DOXYGEN_COMMENT: 
                case LINE_COMMENT: 
                case PRIVATE: 
                case PROTECTED: 
                case PUBLIC: 
                case COLON: 
                case SEMICOLON: 
                case LBRACE: 
                case RBRACE: 
                case LPAREN: 
                case RPAREN: {
                    break;
                }
                default: {
                    this.braces.setLastStatementStart(this.ts);
                }
            }
            block3 : switch (cppTokenId) {
                case PREPROCESSOR_DIRECTIVE: {
                    this.preprocessorFormatter.indentPreprocessor(token);
                    break;
                }
                case NEW_LINE: {
                    if (this.braces.getStatementContinuation() == BracesStack.StatementContinuation.START && this.ts.isStatementContinuation()) {
                        this.braces.setStatementContinuation(BracesStack.StatementContinuation.CONTINUE);
                    }
                    if (!this.doFormat()) break;
                    this.newLineFormat(token, token2, this.braces.parenDepth);
                    break;
                }
                case WHITESPACE: {
                    if (!this.doFormat()) break;
                    this.whiteSpaceFormat(token, token2);
                    break;
                }
                case BLOCK_COMMENT: 
                case DOXYGEN_COMMENT: {
                    if (!this.doFormat()) break;
                    this.reformatBlockComment(token, token2);
                    break;
                }
                case LBRACE: {
                    Token<CppTokenId> token3;
                    Object object;
                    int n = this.braces.lastStatementStart;
                    this.braces.push(this.ts);
                    if (this.doFormat()) {
                        this.braceFormat(token, token2);
                        object = this.braces.peek();
                        if (((StackEntry)object).getImportantKind() == CppTokenId.CLASS || ((StackEntry)object).getImportantKind() == CppTokenId.STRUCT || ((StackEntry)object).getImportantKind() == CppTokenId.UNION || ((StackEntry)object).getImportantKind() == CppTokenId.ENUM) {
                            this.newLinesBeforeDeclaration(this.codeStyle.blankLinesBeforeClass(), n);
                        } else if (((StackEntry)object).getImportantKind() != CppTokenId.NAMESPACE) {
                            if (((StackEntry)object).isLikeToFunction()) {
                                this.newLinesBeforeDeclaration(this.codeStyle.blankLinesBeforeMethods(), n);
                            } else if (!((StackEntry)object).isLikeToArrayInitialization() && (token3 = this.ts.lookPreviousImportant()) != null && token3.id() == CppTokenId.SEMICOLON && this.braces.getLength() == 1) {
                                ((StackEntry)object).setLikeToFunction(true);
                                this.newLinesBeforeDeclaration(this.codeStyle.blankLinesBeforeMethods(), this.braces.lastKRstart);
                            }
                        }
                    }
                    this.braces.lastKRstart = -1;
                    break;
                }
                case LPAREN: {
                    if (this.braces.parenDepth == 0) {
                        if (this.braces.getStatementContinuation() == BracesStack.StatementContinuation.STOP) {
                            this.braces.setStatementContinuation(BracesStack.StatementContinuation.START);
                        }
                        if (this.braces.getLength() == 0) {
                            this.braces.lastKRstart = this.braces.lastStatementStart;
                        }
                        if (this.braces.lastStatementParen >= 0) {
                            this.braces.lastStatementParen = this.ts.index();
                        }
                    }
                    ++this.braces.parenDepth;
                    if (!this.doFormat()) break;
                    this.formatLeftParen(token, token2);
                    break;
                }
                case RPAREN: {
                    --this.braces.parenDepth;
                    if (this.braces.parenDepth < 0) {
                        this.braces.parenDepth = 0;
                    }
                    if (this.braces.parenDepth == 0) {
                        StackEntry stackEntry = this.braces.peek();
                        if (stackEntry == null || stackEntry.getKind() != CppTokenId.LBRACE || stackEntry.getImportantKind() == CppTokenId.CLASS || stackEntry.getImportantKind() == CppTokenId.NAMESPACE) {
                            this.braces.setStatementContinuation(BracesStack.StatementContinuation.STOP);
                        }
                        if (this.braces.lastStatementParen >= 0) {
                            this.braces.lastStatementParen = -1;
                        }
                    }
                    if (!this.doFormat()) break;
                    this.formatRightParen(token, token2);
                    break;
                }
                case IDENTIFIER: {
                    Object object;
                    boolean bl = false;
                    if (this.braces.getStatementContinuation() == BracesStack.StatementContinuation.STOP) {
                        this.braces.setStatementContinuation(BracesStack.StatementContinuation.START);
                        boolean bl2 = bl = this.ts.index() == this.braces.lastStatementStart;
                    }
                    if (!bl || (object = this.ts.lookNextImportant()) == null || object.id() != CppTokenId.COLON) break;
                    this.indentLabel(token);
                    break;
                }
                case SEMICOLON: {
                    Object object;
                    StackEntry stackEntry = this.braces.peek();
                    if (this.braces.parenDepth == 0) {
                        this.braces.pop(this.ts);
                    }
                    if (stackEntry != null && (stackEntry.getKind() == CppTokenId.DO || stackEntry.getImportantKind() == CppTokenId.DO) && (object = this.ts.lookNextImportant()) != null && object.id() == CppTokenId.WHILE) {
                        this.braces.isDoWhile = true;
                    }
                    if (this.doFormat()) {
                        this.spaceBefore(token, this.codeStyle.spaceBeforeSemi());
                        if (this.braces.parenDepth == 0 && this.addNewLineAfterSemocolon(token2)) break;
                        this.spaceAfter(token2, this.codeStyle.spaceAfterSemi());
                    }
                    if (this.braces.parenDepth != 0) break;
                    this.braces.setStatementContinuation(BracesStack.StatementContinuation.STOP);
                    break;
                }
                case COMMA: {
                    if (!this.doFormat()) break;
                    this.spaceBefore(token, this.codeStyle.spaceBeforeComma());
                    this.spaceAfter(token2, this.codeStyle.spaceAfterComma());
                    break;
                }
                case PRIVATE: 
                case PROTECTED: 
                case PUBLIC: {
                    Object object;
                    StackEntry stackEntry = this.braces.peek();
                    if (!this.doFormat() || stackEntry == null || stackEntry.getImportantKind() == null) break;
                    switch (stackEntry.getImportantKind()) {
                        case CLASS: 
                        case STRUCT: {
                            object = this.ts.lookNextImportant();
                            if (object != null && object.id() == CppTokenId.COLON) {
                                this.newLineBefore(true);
                                break;
                            }
                            break block3;
                        }
                    }
                    break;
                }
                case COLON: {
                    boolean bl = this.braces.isLabel;
                    this.braces.isLabel = false;
                    if (!this.doFormat()) break;
                    if (bl) {
                        this.spaceBefore(token, false);
                        if (!this.ts.isLastLineToken()) {
                            this.ts.addAfterCurrent(token2, 1, this.getIndent());
                        }
                        this.braces.setStatementContinuation(BracesStack.StatementContinuation.STOP);
                        break;
                    }
                    Object object = this.ts.lookPreviousImportant();
                    if (object != null && (object.id() == CppTokenId.PRIVATE || object.id() == CppTokenId.PROTECTED || object.id() == CppTokenId.PUBLIC)) {
                        this.spaceBefore(token, false);
                        if (this.ts.isLastLineToken()) break;
                        this.ts.addAfterCurrent(token2, 1, this.getIndent());
                        break;
                    }
                    if (object != null && object.id() == CppTokenId.DEFAULT) {
                        this.spaceBefore(token, false);
                        this.braces.setStatementContinuation(BracesStack.StatementContinuation.STOP);
                        break;
                    }
                    Token<CppTokenId> token3 = this.ts.lookPreviousImportant(2);
                    if (token3 != null && token3.id() == CppTokenId.CASE) {
                        this.spaceBefore(token, false);
                        this.braces.setStatementContinuation(BracesStack.StatementContinuation.STOP);
                        break;
                    }
                    if (this.ts.isQuestionColumn()) {
                        this.spaceBefore(token, this.codeStyle.spaceAroundTernaryOps());
                        this.spaceAfter(token2, this.codeStyle.spaceAroundTernaryOps());
                        break;
                    }
                    this.spaceBefore(token, this.codeStyle.spaceBeforeColon());
                    this.spaceAfter(token2, this.codeStyle.spaceAfterColon());
                    break;
                }
                case RBRACE: {
                    Token<CppTokenId> token3;
                    StackEntry stackEntry = this.braces.peek();
                    Object object = null;
                    if (stackEntry != null) {
                        if (stackEntry.getKind() == CppTokenId.DO || stackEntry.getImportantKind() == CppTokenId.DO) {
                            token3 = this.ts.lookNextImportant();
                            if (token3 != null && token3.id() == CppTokenId.WHILE) {
                                this.braces.isDoWhile = true;
                            }
                        } else if (stackEntry.getImportantKind() == CppTokenId.TRY || stackEntry.getImportantKind() == CppTokenId.CATCH) {
                            object = this.braces.lookPerevious();
                        }
                    }
                    this.braces.pop(this.ts);
                    if (!this.doFormat()) break;
                    this.indentRbrace(stackEntry, token, token2, (StackEntry)object);
                    break;
                }
                case QUESTION: {
                    if (!this.doFormat()) break;
                    this.spaceBefore(token, this.codeStyle.spaceAroundTernaryOps());
                    this.spaceAfter(token2, this.codeStyle.spaceAroundTernaryOps());
                    break;
                }
                case NOT: 
                case TILDE: 
                case PLUSPLUS: 
                case MINUSMINUS: {
                    if (!this.doFormat()) break;
                    if (this.isOperator()) {
                        this.spaceBefore(token, false);
                        this.spaceAfter(token2, this.codeStyle.spaceBeforeMethodDeclParen());
                        break;
                    }
                    Token<CppTokenId> token4 = this.ts.lookPreviousImportant();
                    if (token4 == null || token4.id() != CppTokenId.SEMICOLON && token4.id() != CppTokenId.COMMA) {
                        this.spaceBefore(token, this.codeStyle.spaceAroundUnaryOps());
                    }
                    this.spaceAfter(token2, this.codeStyle.spaceAroundUnaryOps());
                    break;
                }
                case PLUS: 
                case MINUS: {
                    if (!this.doFormat()) break;
                    if (this.isOperator()) {
                        this.spaceBefore(token, false);
                        this.spaceAfter(token2, this.codeStyle.spaceBeforeMethodDeclParen());
                        break;
                    }
                    ContextDetector.OperatorKind operatorKind = this.ts.getOperatorKind(token2);
                    if (operatorKind == ContextDetector.OperatorKind.BINARY) {
                        this.spaceBefore(token, this.codeStyle.spaceAroundBinaryOps());
                        this.spaceAfter(token2, this.codeStyle.spaceAroundBinaryOps());
                        break;
                    }
                    if (operatorKind != ContextDetector.OperatorKind.UNARY) break;
                    Object object = this.ts.lookPreviousImportant();
                    if (object == null || object.id() != CppTokenId.SEMICOLON && object.id() != CppTokenId.COMMA) {
                        this.spaceBefore(token, this.codeStyle.spaceAroundUnaryOps());
                    }
                    this.spaceAfter(token2, this.codeStyle.spaceAroundUnaryOps());
                    break;
                }
                case STAR: 
                case AMP: {
                    if (!this.doFormat()) break;
                    if (this.isOperator()) {
                        this.spaceBefore(token, false);
                        this.spaceAfter(token2, this.codeStyle.spaceBeforeMethodDeclParen());
                        break;
                    }
                    ContextDetector.OperatorKind operatorKind = this.ts.getOperatorKind(token2);
                    if (operatorKind == ContextDetector.OperatorKind.BINARY) {
                        this.spaceBefore(token, this.codeStyle.spaceAroundBinaryOps());
                        this.spaceAfter(token2, this.codeStyle.spaceAroundBinaryOps());
                        break;
                    }
                    if (operatorKind == ContextDetector.OperatorKind.TYPE_MODIFIER) break;
                    break;
                }
                case GT: 
                case LT: {
                    if (!this.doFormat()) break;
                    if (this.isOperator()) {
                        this.spaceBefore(token, false);
                        this.spaceAfter(token2, this.codeStyle.spaceBeforeMethodDeclParen());
                        break;
                    }
                    if (this.isNewStyleCast(token2)) {
                        if (token2.id() == CppTokenId.LT) {
                            this.spaceAfter(token2, this.codeStyle.spaceWithinTypeCastParens());
                            break;
                        }
                        this.spaceBefore(token, this.codeStyle.spaceWithinTypeCastParens());
                        this.spaceAfter(token2, this.codeStyle.spaceAfterTypeCast());
                        break;
                    }
                    ContextDetector.OperatorKind operatorKind = this.ts.getOperatorKind(token2);
                    if (operatorKind == ContextDetector.OperatorKind.BINARY) {
                        this.spaceBefore(token, this.codeStyle.spaceAroundBinaryOps());
                        this.spaceAfter(token2, this.codeStyle.spaceAroundBinaryOps());
                        break;
                    }
                    if (operatorKind == ContextDetector.OperatorKind.SEPARATOR) break;
                    break;
                }
                case EQEQ: 
                case LTEQ: 
                case GTEQ: 
                case NOTEQ: 
                case AMPAMP: 
                case BARBAR: 
                case SLASH: 
                case BAR: 
                case PERCENT: 
                case LTLT: 
                case GTGT: {
                    if (!this.doFormat()) break;
                    if (this.isOperator()) {
                        this.spaceBefore(token, false);
                        this.spaceAfter(token2, this.codeStyle.spaceBeforeMethodDeclParen());
                        break;
                    }
                    this.spaceBefore(token, this.codeStyle.spaceAroundBinaryOps());
                    this.spaceAfter(token2, this.codeStyle.spaceAroundBinaryOps());
                    break;
                }
                case EQ: 
                case PLUSEQ: 
                case MINUSEQ: 
                case STAREQ: 
                case SLASHEQ: 
                case AMPEQ: 
                case BAREQ: 
                case CARETEQ: 
                case PERCENTEQ: 
                case LTLTEQ: 
                case GTGTEQ: {
                    if (this.braces.getStatementContinuation() == BracesStack.StatementContinuation.STOP) {
                        this.braces.setStatementContinuation(BracesStack.StatementContinuation.START);
                    }
                    if (this.doFormat()) {
                        if (!this.isOperator()) {
                            this.spaceBefore(token, this.codeStyle.spaceAroundAssignOps());
                            this.spaceAfter(token2, this.codeStyle.spaceAroundAssignOps());
                        } else {
                            this.spaceBefore(token, false);
                            this.spaceAfter(token2, this.codeStyle.spaceBeforeMethodDeclParen());
                        }
                    }
                    if (this.braces.getStatementContinuation() != BracesStack.StatementContinuation.START) break;
                    this.braces.setStatementContinuation(BracesStack.StatementContinuation.CONTINUE);
                    break;
                }
                case CLASS: 
                case STRUCT: 
                case NAMESPACE: 
                case ENUM: 
                case UNION: {
                    break;
                }
                case IF: {
                    this.braces.push(this.ts);
                    this.braces.lastStatementParen = this.ts.index();
                    if (!this.doFormat()) break;
                    this.spaceAfterBefore(token2, this.codeStyle.spaceBeforeIfParen(), CppTokenId.LPAREN);
                    break;
                }
                case ELSE: {
                    this.braces.push(this.ts);
                    if (!this.doFormat()) break;
                    this.formatElse(token);
                    break;
                }
                case WHILE: {
                    this.braces.push(this.ts);
                    this.braces.lastStatementParen = this.ts.index();
                    if (this.doFormat()) {
                        boolean bl = true;
                        if (this.braces.isDoWhile) {
                            if (this.ts.isFirstLineToken()) {
                                if (!this.codeStyle.newLineWhile()) {
                                    this.newLine(token, token2, CodeStyle.BracePlacement.SAME_LINE, this.codeStyle.spaceBeforeWhile(), 0);
                                    bl = false;
                                }
                            } else if (this.codeStyle.newLineWhile()) {
                                this.newLine(token, token2, CodeStyle.BracePlacement.NEW_LINE, this.codeStyle.spaceBeforeWhile(), 0);
                                bl = false;
                            }
                        }
                        if (bl) {
                            this.spaceBefore(token, this.codeStyle.spaceBeforeWhile());
                        }
                        this.spaceAfterBefore(token2, this.codeStyle.spaceBeforeWhileParen(), CppTokenId.LPAREN);
                    }
                    this.braces.isDoWhile = false;
                    break;
                }
                case FOR: {
                    this.braces.push(this.ts);
                    this.braces.lastStatementParen = this.ts.index();
                    if (!this.doFormat()) break;
                    this.spaceAfterBefore(token2, this.codeStyle.spaceBeforeForParen(), CppTokenId.LPAREN);
                    break;
                }
                case TRY: {
                    this.braces.push(this.ts);
                    if (!this.doFormat()) break;
                    this.spaceBefore(token, true);
                    break;
                }
                case CATCH: {
                    this.braces.push(this.ts);
                    this.braces.lastStatementParen = this.ts.index();
                    if (!this.doFormat()) break;
                    boolean bl = true;
                    if (this.ts.isFirstLineToken()) {
                        if (!this.codeStyle.newLineCatch()) {
                            this.newLine(token, token2, CodeStyle.BracePlacement.SAME_LINE, this.codeStyle.spaceBeforeCatch(), 0);
                            bl = false;
                        }
                    } else if (this.codeStyle.newLineCatch()) {
                        this.newLine(token, token2, CodeStyle.BracePlacement.NEW_LINE, this.codeStyle.spaceBeforeCatch(), 0);
                        bl = false;
                    }
                    if (bl) {
                        this.spaceBefore(token, this.codeStyle.spaceBeforeCatch());
                    }
                    this.spaceAfterBefore(token2, this.codeStyle.spaceBeforeCatchParen(), CppTokenId.LPAREN);
                    break;
                }
                case ASM: {
                    this.braces.push(this.ts);
                    break;
                }
                case DO: {
                    this.braces.push(this.ts);
                    break;
                }
                case SWITCH: {
                    this.braces.push(this.ts);
                    this.braces.lastStatementParen = this.ts.index();
                    if (!this.doFormat()) break;
                    this.spaceAfterBefore(token2, this.codeStyle.spaceBeforeSwitchParen(), CppTokenId.LPAREN);
                    break;
                }
                case DEFAULT: 
                case CASE: {
                    this.braces.setStatementContinuation(BracesStack.StatementContinuation.STOP);
                    break;
                }
                case BREAK: {
                    break;
                }
                case CONTINUE: {
                    break;
                }
                case SCOPE: {
                    if (!this.doFormat()) break;
                    Token<CppTokenId> token5 = this.ts.lookPreviousImportant(1);
                    if (token5 != null && token5.id() == CppTokenId.IDENTIFIER) {
                        this.spaceBefore(token, false);
                    }
                    this.spaceAfter(token2, false);
                    break;
                }
                case REINTERPRET_CAST: 
                case STATIC_CAST: 
                case CONST_CAST: 
                case DYNAMIC_CAST: {
                    if (!this.doFormat()) break;
                    this.spaceAfter(token2, this.codeStyle.spaceWithinTypeCastParens());
                    break;
                }
            }
            token = token2;
        }
        return this.diffs.getStorage();
    }

    int getParentIndent() {
        return this.continuationIndent(this.braces.getSelfIndent());
    }

    int getCaseIndent() {
        if (this.codeStyle.getFormatNewLineBeforeBraceSwitch() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED) {
            if (this.codeStyle.indentCasesFromSwitch()) {
                return this.getParentIndent() + this.codeStyle.indentSize() / 2;
            }
            return this.getParentIndent();
        }
        if (this.codeStyle.indentCasesFromSwitch()) {
            return this.getParentIndent() + this.codeStyle.indentSize();
        }
        return this.getParentIndent();
    }

    int getIndent() {
        return this.continuationIndent(this.braces.getIndent());
    }

    int continuationIndent(int n) {
        BracesStack.StatementKind statementKind;
        StackEntry stackEntry = this.braces.peek();
        if (stackEntry != null) {
            if (this.braces.getStatementContinuation() == BracesStack.StatementContinuation.CONTINUE) {
                switch (stackEntry.getKind()) {
                    case CLASS: 
                    case STRUCT: 
                    case NAMESPACE: 
                    case ENUM: 
                    case UNION: {
                        break;
                    }
                    case SWITCH: {
                        if (this.codeStyle.getFormatNewLineBeforeBraceSwitch() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED) {
                            n += this.codeStyle.getFormatStatementContinuationIndent() - this.codeStyle.indentSize() / 2;
                            break;
                        }
                        n += this.codeStyle.getFormatStatementContinuationIndent() - this.codeStyle.indentSize();
                        break;
                    }
                    case IF: 
                    case ELSE: 
                    case WHILE: 
                    case FOR: 
                    case CATCH: 
                    case DO: {
                        if (this.codeStyle.getFormatNewlineBeforeBrace() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED) {
                            n += this.codeStyle.getFormatStatementContinuationIndent() - this.codeStyle.indentSize() / 2;
                            break;
                        }
                        n += this.codeStyle.getFormatStatementContinuationIndent() - this.codeStyle.indentSize();
                        break;
                    }
                    default: {
                        if (stackEntry.getKind() == CppTokenId.LBRACE && stackEntry.getImportantKind() != null && stackEntry.getImportantKind() == CppTokenId.ENUM || stackEntry.isLikeToArrayInitialization()) break;
                        BracesStack.StatementKind statementKind2 = this.braces.getLastStatementKind(this.ts);
                        if (statementKind2 == null || statementKind2 != BracesStack.StatementKind.CLASS && (statementKind2 != BracesStack.StatementKind.FUNCTION || this.braces.parenDepth != 0)) {
                            n += this.codeStyle.getFormatStatementContinuationIndent();
                            break;
                        } else {
                            break;
                        }
                    }
                }
            }
        } else if (this.braces.getStatementContinuation() == BracesStack.StatementContinuation.CONTINUE && ((statementKind = this.braces.getLastStatementKind(this.ts)) == null || statementKind != BracesStack.StatementKind.CLASS && (statementKind != BracesStack.StatementKind.FUNCTION || this.braces.parenDepth != 0))) {
            n += this.codeStyle.getFormatStatementContinuationIndent();
        }
        if (n > 0) {
            return n;
        }
        return 0;
    }

    private boolean addNewLineAfterSemocolon(Token<CppTokenId> token) {
        if (!this.ts.isLastLineToken()) {
            this.ts.addAfterCurrent(token, 1, this.getIndent());
            return true;
        }
        return false;
    }

    private void braceFormat(Token<CppTokenId> token, Token<CppTokenId> token2) {
        StackEntry stackEntry = this.braces.peek();
        if (stackEntry != null && stackEntry.getImportantKind() != null) {
            switch (stackEntry.getImportantKind()) {
                case NAMESPACE: {
                    this.newLine(token, token2, this.codeStyle.getFormatNewlineBeforeBraceNamespace(), this.codeStyle.spaceBeforeClassDeclLeftBrace(), 1);
                    return;
                }
                case CLASS: 
                case STRUCT: 
                case ENUM: 
                case UNION: {
                    Token<CppTokenId> token3 = this.ts.lookNextImportant();
                    if (token3 != null) {
                        this.newLinesAfter(token, token2);
                    }
                    return;
                }
                case IF: {
                    this.newLine(token, token2, this.codeStyle.getFormatNewlineBeforeBrace(), this.codeStyle.spaceBeforeIfLeftBrace(), 1);
                    return;
                }
                case ELSE: {
                    this.newLine(token, token2, this.codeStyle.getFormatNewlineBeforeBrace(), this.codeStyle.spaceBeforeElseLeftBrace(), 1);
                    return;
                }
                case SWITCH: {
                    this.newLine(token, token2, this.codeStyle.getFormatNewLineBeforeBraceSwitch(), this.codeStyle.spaceBeforeSwitchLeftBrace(), 1);
                    return;
                }
                case WHILE: {
                    this.newLine(token, token2, this.codeStyle.getFormatNewlineBeforeBrace(), this.codeStyle.spaceBeforeWhileLeftBrace(), 1);
                    return;
                }
                case DO: {
                    this.newLine(token, token2, this.codeStyle.getFormatNewlineBeforeBrace(), this.codeStyle.spaceBeforeDoLeftBrace(), 1);
                    return;
                }
                case FOR: {
                    this.newLine(token, token2, this.codeStyle.getFormatNewlineBeforeBrace(), this.codeStyle.spaceBeforeForLeftBrace(), 1);
                    return;
                }
                case TRY: {
                    this.newLine(token, token2, this.codeStyle.getFormatNewlineBeforeBrace(), this.codeStyle.spaceBeforeTryLeftBrace(), 1);
                    return;
                }
                case CATCH: {
                    this.newLine(token, token2, this.codeStyle.getFormatNewlineBeforeBrace(), this.codeStyle.spaceBeforeCatchLeftBrace(), 1);
                    return;
                }
            }
        }
        if (stackEntry != null && stackEntry.isLikeToFunction()) {
            Token<CppTokenId> token4 = this.ts.lookNextImportant();
            if (token4 != null && token4.id() == CppTokenId.RBRACE && this.codeStyle.ignoreEmptyFunctionBody()) {
                this.newLine(token, token2, CodeStyle.BracePlacement.SAME_LINE, this.codeStyle.spaceBeforeMethodDeclLeftBrace(), 0);
            } else {
                this.newLine(token, token2, this.codeStyle.getFormatNewlineBeforeBraceDeclaration(), this.codeStyle.spaceBeforeMethodDeclLeftBrace(), 1);
            }
        } else if (stackEntry != null && stackEntry.isLikeToArrayInitialization()) {
            StackEntry stackEntry2 = this.braces.lookPerevious();
            if (stackEntry2 != null && stackEntry2.isLikeToArrayInitialization()) {
                this.newLine(token, token2, CodeStyle.BracePlacement.NEW_LINE, this.codeStyle.spaceBeforeArrayInitLeftBrace(), 0);
            } else {
                Token<CppTokenId> token5 = this.ts.lookPreviousLineImportant();
                boolean bl = false;
                if (token5 != null && token5.id() == CppTokenId.EQ) {
                    bl |= this.codeStyle.spaceAroundAssignOps();
                }
                this.newLine(token, token2, CodeStyle.BracePlacement.SAME_LINE, bl || this.codeStyle.spaceBeforeArrayInitLeftBrace(), 0);
                this.spaceAfter(token2, this.codeStyle.spaceWithinBraces());
            }
        } else {
            Token<CppTokenId> token6 = this.ts.lookPreviousImportant();
            if (token6 != null && token6.id() == CppTokenId.LBRACE) {
                this.newLine(token, token2, CodeStyle.BracePlacement.NEW_LINE, true, 1);
                return;
            }
            StackEntry stackEntry3 = this.braces.lookPerevious();
            if (stackEntry3 != null && stackEntry3.getImportantKind() != null && stackEntry3.getImportantKind() == CppTokenId.SWITCH) {
                this.newLine(token, token2, CodeStyle.BracePlacement.NEW_LINE, true, 1);
                return;
            }
            if (stackEntry3 == null || stackEntry3 != null && stackEntry3.getImportantKind() != null && stackEntry3.getImportantKind() == CppTokenId.NAMESPACE) {
                this.newLine(token, token2, CodeStyle.BracePlacement.NEW_LINE, true, 1);
                if (stackEntry != null) {
                    // empty if block
                }
                return;
            }
            this.newLine(token, token2, CodeStyle.BracePlacement.NEW_LINE, true, 1);
        }
    }

    private void newLinesAfter(Token<CppTokenId> token, Token<CppTokenId> token2) {
        int n = this.ts.index();
        int n2 = -1;
        int n3 = 0;
        block4: while (this.ts.moveNext()) {
            switch ((CppTokenId)this.ts.token().id()) {
                case WHITESPACE: {
                    continue block4;
                }
                case NEW_LINE: {
                    n2 = this.ts.index();
                    ++n3;
                    continue block4;
                }
            }
        }
        this.ts.moveIndex(n);
        this.ts.moveNext();
        this.newLine(token, token2, this.codeStyle.getFormatNewlineBeforeBraceClass(), this.codeStyle.spaceBeforeClassDeclLeftBrace(), this.codeStyle.blankLinesAfterClassHeader() + 1);
        if (n3 > 1) {
            this.ts.moveNext();
            while (this.ts.moveNext() && this.ts.index() <= n2) {
                this.ts.replaceCurrent(this.ts.token(), 0, 0);
            }
        }
    }

    private void formatElse(Token<CppTokenId> token) {
        if (this.ts.isFirstLineToken()) {
            DiffLinkedList.DiffResult diffResult = this.diffs.getDiffs(this.ts, -1);
            if (diffResult != null) {
                boolean bl = false;
                if (diffResult.after != null) {
                    diffResult.after.replaceSpaces(this.getParentIndent());
                    bl = true;
                }
                if (diffResult.replace != null && token.id() == CppTokenId.WHITESPACE) {
                    if (!bl) {
                        diffResult.replace.replaceSpaces(this.getParentIndent());
                        bl = true;
                    } else {
                        diffResult.replace.replaceSpaces(0);
                    }
                }
                if (diffResult.before != null && token.id() == CppTokenId.WHITESPACE) {
                    if (!bl) {
                        diffResult.before.replaceSpaces(this.getParentIndent());
                        bl = true;
                    } else {
                        diffResult.before.replaceSpaces(0);
                    }
                }
                if (bl) {
                    return;
                }
            }
            if (token.id() == CppTokenId.WHITESPACE) {
                Token<CppTokenId> token2 = this.ts.lookPrevious(2);
                if (token2 != null && token2.id() == CppTokenId.NEW_LINE) {
                    this.ts.replacePrevious(token, 0, this.getParentIndent());
                } else {
                    this.ts.replacePrevious(token, 0, 0);
                }
            } else if (token.id() == CppTokenId.NEW_LINE || token.id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
                this.ts.addBeforeCurrent(0, this.getParentIndent());
            }
        } else if (token != null) {
            this.makeSpaceBefore(this.codeStyle.spaceBeforeElse());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDefinition() {
        int n = this.ts.index();
        try {
            int n2 = 1;
            int n3 = 0;
            int n4 = -1;
            Token<CppTokenId> token = this.ts.lookNextImportant();
            if (token != null && token.id() != CppTokenId.RPAREN) {
                n3 = 1;
            }
            block14: while (this.ts.moveNext()) {
                switch ((CppTokenId)this.ts.token().id()) {
                    case COLON: {
                        if (n2 == 0) {
                            n4 = this.ts.index();
                        }
                    }
                    case SEMICOLON: {
                        if (n3 == 0) {
                            return;
                        }
                        --n3;
                    }
                    case COMMA: {
                        if (n2 != 1) continue block14;
                        ++n3;
                        continue block14;
                    }
                    case RPAREN: {
                        --n2;
                        continue block14;
                    }
                    case LPAREN: {
                        ++n2;
                        continue block14;
                    }
                    case LBRACE: {
                        if (n2 == 0) {
                            if (n4 > 0) {
                                this.ts.moveIndex(n4);
                                this.ts.movePrevious();
                            }
                            this.functionDefinitionNewLine();
                        }
                        return;
                    }
                    case RBRACE: 
                    case IF: 
                    case WHILE: 
                    case FOR: {
                        return;
                    }
                }
            }
            return;
        }
        finally {
            this.ts.moveIndex(n);
            this.ts.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void functionDefinitionNewLine() {
        int n = this.ts.index();
        try {
            int n2 = 0;
            boolean bl = false;
            while (this.ts.movePrevious()) {
                if (this.braces.lastStatementStart >= this.ts.index()) {
                    return;
                }
                switch ((CppTokenId)this.ts.token().id()) {
                    case RPAREN: {
                        ++n2;
                        bl = true;
                        break;
                    }
                    case LPAREN: {
                        Token<CppTokenId> token;
                        if (--n2 != 0 || !bl || (token = this.ts.lookPreviousImportant()) == null || token.id() != CppTokenId.IDENTIFIER) break;
                        int n3 = -1;
                        block16: while (this.ts.movePrevious()) {
                            switch ((CppTokenId)this.ts.token().id()) {
                                case COLON: 
                                case COMMA: {
                                    return;
                                }
                                case WHITESPACE: {
                                    continue block16;
                                }
                                case IDENTIFIER: 
                                case TILDE: 
                                case SCOPE: {
                                    n3 = this.ts.index();
                                    continue block16;
                                }
                            }
                            this.ts.moveIndex(n3);
                            this.ts.moveNext();
                            this.newLineBefore(false);
                            return;
                        }
                        return;
                    }
                }
            }
        }
        finally {
            this.ts.moveIndex(n);
            this.ts.moveNext();
        }
    }

    private void indentLabel(Token<CppTokenId> token) {
        this.braces.isLabel = true;
        int n = 0;
        if (!this.codeStyle.absoluteLabelIndent()) {
            n = this.braces.getSelfIndent();
        }
        if (this.doFormat()) {
            if (!this.ts.isFirstLineToken()) {
                this.ts.addBeforeCurrent(1, 0);
            } else {
                DiffLinkedList.DiffResult diffResult = this.diffs.getDiffs(this.ts, -1);
                if (diffResult == null) {
                    if (token != null && token.id() == CppTokenId.WHITESPACE) {
                        this.ts.replacePrevious(token, 0, n);
                    }
                } else {
                    if (diffResult.after != null) {
                        diffResult.after.replaceSpaces(n);
                    }
                    if (diffResult.replace != null) {
                        diffResult.replace.replaceSpaces(n);
                    }
                }
            }
        }
    }

    private void indentRbrace(StackEntry stackEntry, Token<CppTokenId> token, Token<CppTokenId> token2, StackEntry stackEntry2) {
        int n = this.continuationIndent(stackEntry.getSelfIndent());
        Token<CppTokenId> token3 = this.ts.lookPreviousImportant();
        boolean bl = false;
        boolean bl2 = false;
        if (token3 != null && token3.id() == CppTokenId.LBRACE && stackEntry != null && stackEntry.isLikeToFunction() && this.codeStyle.ignoreEmptyFunctionBody()) {
            bl = true;
            if (this.ts.isFirstLineToken() && !(bl2 = this.removeLineBefore(true))) {
                bl = false;
            }
        }
        if (token != null && !bl2) {
            DiffLinkedList.DiffResult diffResult = this.diffs.getDiffs(this.ts, -1);
            if (diffResult != null) {
                if (diffResult.before != null && token.id() == CppTokenId.WHITESPACE) {
                    diffResult.before.replaceSpaces(n);
                    bl2 = true;
                }
                if (diffResult.replace != null) {
                    if (!bl2) {
                        if (stackEntry.isLikeToArrayInitialization() && !this.ts.isFirstLineToken() && !diffResult.replace.hasNewLine()) {
                            if (this.codeStyle.spaceWithinBraces()) {
                                diffResult.replace.replaceSpaces(1);
                            } else {
                                diffResult.replace.replaceSpaces(0);
                            }
                        } else if (bl) {
                            diffResult.replace.setText(0, 1);
                        } else {
                            diffResult.replace.replaceSpaces(n);
                        }
                    } else {
                        diffResult.replace.replaceSpaces(0);
                    }
                    bl2 = true;
                }
                if (diffResult.after != null) {
                    if (!bl2) {
                        if (bl) {
                            diffResult.after.setText(0, 1);
                        } else if (diffResult.after.hasNewLine() || this.ts.isFirstLineToken()) {
                            diffResult.after.replaceSpaces(n);
                        } else if (!stackEntry.isLikeToArrayInitialization()) {
                            this.ts.addBeforeCurrent(1, n);
                        } else {
                            this.spaceBefore(token, this.codeStyle.spaceWithinBraces());
                        }
                    }
                    bl2 = true;
                }
            }
            if (!bl2) {
                if (token.id() == CppTokenId.WHITESPACE) {
                    if (bl) {
                        this.ts.replacePrevious(token, 0, 1);
                    } else if (this.ts.isFirstLineToken()) {
                        this.ts.replacePrevious(token, 0, n);
                    } else if (this.braces.parenDepth <= 0) {
                        this.ts.replacePrevious(token, 1, n);
                    } else if (stackEntry.isLikeToArrayInitialization()) {
                        this.spaceBefore(token, this.codeStyle.spaceWithinBraces());
                    }
                } else if (token.id() == CppTokenId.NEW_LINE || token.id() == CppTokenId.PREPROCESSOR_DIRECTIVE || token.id() == CppTokenId.ESCAPED_WHITESPACE) {
                    this.ts.addBeforeCurrent(0, n);
                } else if (bl) {
                    this.ts.addBeforeCurrent(0, 1);
                } else if (!stackEntry.isLikeToArrayInitialization()) {
                    this.ts.addBeforeCurrent(1, n);
                } else {
                    this.spaceBefore(token, this.codeStyle.spaceWithinBraces());
                }
            }
        }
        boolean bl3 = stackEntry.getImportantKind() != null && (stackEntry.getImportantKind() == CppTokenId.CLASS || stackEntry.getImportantKind() == CppTokenId.STRUCT || stackEntry.getImportantKind() == CppTokenId.UNION || stackEntry.getImportantKind() == CppTokenId.ENUM);
        Token<CppTokenId> token4 = this.ts.lookNext();
        if (bl3) {
            if (token4 != null && token4.id() != CppTokenId.WHITESPACE && token4.id() != CppTokenId.NEW_LINE) {
                this.ts.addAfterCurrent(token2, 0, 1);
            }
            return;
        }
        Token<CppTokenId> token5 = this.ts.lookNextImportant();
        if (token5 != null) {
            switch ((CppTokenId)token5.id()) {
                case WHILE: {
                    StackEntry stackEntry3 = this.braces.peek();
                    if (stackEntry3 == null || stackEntry3.getKind() != CppTokenId.DO) break;
                    if (!this.codeStyle.newLineWhile()) {
                        Token<CppTokenId> token6;
                        if (this.ts.isLastLineToken() && ((token6 = this.ts.lookNext(2)) == null || token6.id() != CppTokenId.PREPROCESSOR_DIRECTIVE)) {
                            this.ts.replaceNext(token2, token4, 0, 0);
                        }
                    } else if (!this.ts.isLastLineToken()) {
                        this.ts.addAfterCurrent(token2, 1, stackEntry3.getSelfIndent());
                    }
                    return;
                }
                case CATCH: {
                    if (stackEntry2 == null || stackEntry2.getKind() != CppTokenId.TRY && stackEntry2.getKind() != CppTokenId.CATCH) break;
                    if (!this.codeStyle.newLineCatch()) {
                        Token<CppTokenId> token7;
                        if (this.ts.isLastLineToken() && ((token7 = this.ts.lookNext(2)) == null || token7.id() != CppTokenId.PREPROCESSOR_DIRECTIVE)) {
                            this.ts.replaceNext(token2, token4, 0, 0);
                        }
                    } else if (!this.ts.isLastLineToken()) {
                        this.ts.addAfterCurrent(token2, 1, stackEntry2.getSelfIndent());
                    }
                    return;
                }
                case ELSE: {
                    if (!this.codeStyle.newLineElse()) {
                        Token<CppTokenId> token8;
                        if (this.ts.isLastLineToken() && ((token8 = this.ts.lookNext(2)) == null || token8.id() != CppTokenId.PREPROCESSOR_DIRECTIVE)) {
                            this.ts.replaceNext(token2, token4, 0, 0);
                        }
                    } else if (!this.ts.isLastLineToken()) {
                        this.ts.addAfterCurrent(token2, 1, n);
                    }
                    return;
                }
            }
        }
        if ((token4 = this.ts.lookNextLineImportant()) != null && token4.id() != CppTokenId.RPAREN && token4.id() != CppTokenId.COMMA && token4.id() != CppTokenId.SEMICOLON && token4.id() != CppTokenId.NEW_LINE) {
            this.ts.addAfterCurrent(token2, 1, n);
        }
    }

    private void newLineFormat(Token<CppTokenId> token, Token<CppTokenId> token2, int n) {
        Token<CppTokenId> token3;
        if (token != null) {
            boolean bl = false;
            DiffLinkedList.DiffResult diffResult = this.diffs.getDiffs(this.ts, -1);
            if (diffResult != null) {
                if (diffResult.after != null) {
                    diffResult.after.replaceSpaces(0);
                    if (diffResult.replace != null) {
                        diffResult.replace.replaceSpaces(0);
                    }
                    bl = true;
                } else if (diffResult.replace != null) {
                    diffResult.replace.replaceSpaces(0);
                    bl = true;
                }
            }
            if (!bl && token.id() == CppTokenId.WHITESPACE) {
                this.ts.replacePrevious(token, 0, 0);
            }
        }
        if ((token3 = this.ts.lookNext()) != null) {
            if (token3.id() == CppTokenId.NEW_LINE) {
                return;
            }
            int n2 = -1;
            if (n > 0) {
                for (int i = 1; i <= n && (n2 = this.getParenthesisIndent(i)) < 0; ++i) {
                }
            } else {
                StackEntry stackEntry = this.braces.peek();
                if (stackEntry != null && stackEntry.isLikeToArrayInitialization() && this.codeStyle.alignMultilineArrayInit()) {
                    n2 = this.ts.openBraceIndent(1);
                }
            }
            if (n2 == -1) {
                Token<CppTokenId> token4 = this.ts.lookNextLineImportant();
                if (token4 != null && this.braces.getStatementContinuation() != BracesStack.StatementContinuation.STOP) {
                    switch ((CppTokenId)token4.id()) {
                        case IF: 
                        case ELSE: 
                        case WHILE: 
                        case FOR: 
                        case TRY: 
                        case CATCH: 
                        case DO: 
                        case SWITCH: 
                        case DEFAULT: 
                        case CASE: 
                        case BREAK: 
                        case CONTINUE: 
                        case RETURN: {
                            this.braces.setStatementContinuation(BracesStack.StatementContinuation.STOP);
                            this.braces.lastStatementStart = -1;
                        }
                    }
                }
                if (token4 != null && (token4.id() == CppTokenId.CASE || token4.id() == CppTokenId.DEFAULT)) {
                    n2 = this.getCaseIndent();
                }
                if (this.braces.isDoWhile && token4 != null && token4.id() == CppTokenId.WHILE) {
                    n2 = this.getParentIndent();
                }
            }
            if (n2 == -1) {
                n2 = this.getIndent();
            }
            if (token3.id() == CppTokenId.WHITESPACE) {
                this.ts.replaceNext(token2, token3, 0, n2);
            } else if (n2 > 0) {
                this.ts.addAfterCurrent(token2, 0, n2);
            }
        }
    }

    private int getParenthesisIndent(int n) {
        Token<CppTokenId> token = this.ts.findOpenParenToken(n);
        if (token != null) {
            switch ((CppTokenId)token.id()) {
                case FOR: {
                    return this.countParenthesisIndent(this.codeStyle.alignMultilineFor(), n);
                }
                case IF: {
                    return this.countParenthesisIndent(this.codeStyle.alignMultilineIfCondition(), n);
                }
                case WHILE: {
                    return this.countParenthesisIndent(this.codeStyle.alignMultilineWhileCondition(), n);
                }
                case IDENTIFIER: {
                    if (this.braces.isDeclarationLevel()) {
                        return this.countParenthesisIndent(this.codeStyle.alignMultilineMethodParams(), n);
                    }
                    return this.countParenthesisIndent(this.codeStyle.alignMultilineCallArgs(), n);
                }
            }
            return this.countParenthesisIndent(this.codeStyle.alignMultilineParen(), n);
        }
        return -1;
    }

    private int countParenthesisIndent(boolean bl, int n) {
        int n2;
        if (bl && (n2 = this.ts.openParenIndent(n)) >= 0) {
            return n2;
        }
        return -1;
    }

    private void indentNewLine(Token<CppTokenId> token) {
        if (token.id() == CppTokenId.NEW_LINE) {
            return;
        }
        Token<CppTokenId> token2 = this.ts.lookNextLineImportant();
        int n = token2 != null && (token2.id() == CppTokenId.CASE || token2.id() == CppTokenId.DEFAULT) ? this.getCaseIndent() : this.getIndent();
        if (token.id() == CppTokenId.WHITESPACE) {
            this.ts.replaceCurrent(token, 0, n);
        } else {
            this.ts.addBeforeCurrent(0, n);
        }
    }

    private void reformatBlockComment(Token<CppTokenId> token, Token<CppTokenId> token2) {
        int n;
        if (!this.ts.isFirstLineToken()) {
            return;
        }
        int n2 = 0;
        if (token == null || token.id() == CppTokenId.NEW_LINE || token.id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
            n2 = 0;
        } else if (token.id() == CppTokenId.WHITESPACE) {
            CharSequence charSequence = token.text();
            for (n = 0; n < token.length(); ++n) {
                if (charSequence.charAt(n) == ' ') {
                    ++n2;
                    continue;
                }
                if (charSequence.charAt(n) != '\t') continue;
                n2 = (n2 / this.tabSize + 1) * this.tabSize;
            }
        }
        int n3 = this.getIndent();
        n = -1;
        int n4 = -1;
        int n5 = 0;
        CharSequence charSequence = token2.text();
        for (int i = 0; i < charSequence.length(); ++i) {
            if (charSequence.charAt(i) == '\n') {
                n = i;
                n4 = i;
                n5 = 0;
                continue;
            }
            if (charSequence.charAt(i) == ' ' || charSequence.charAt(i) == '\t') {
                n4 = i;
                if (charSequence.charAt(i) == ' ') {
                    ++n5;
                    continue;
                }
                if (charSequence.charAt(i) != '\t') continue;
                n5 = (n5 / this.tabSize + 1) * this.tabSize;
                continue;
            }
            if (n >= 0) {
                this.addCommentIndent(n, n4, charSequence.charAt(i), n3, n2, n5);
            }
            n = -1;
        }
        this.addCommentIndent(n, n4, '*', n3, n2, n5);
    }

    private void addCommentIndent(int n, int n2, char c, int n3, int n4, int n5) {
        if (n >= 0 && n2 >= n) {
            if (c == '*') {
                this.diffs.addFirst(this.ts.offset() + n + 1, this.ts.offset() + n2 + 1, 0, 1 + n3);
            } else {
                int n6 = n3 + n5 - n4;
                if (n6 < 0) {
                    n6 = n3;
                }
                this.diffs.addFirst(this.ts.offset() + n + 1, this.ts.offset() + n2 + 1, 0, n6);
            }
        }
    }

    private void whiteSpaceFormat(Token<CppTokenId> token, Token<CppTokenId> token2) {
        Object object;
        if (token != null) {
            object = this.diffs.getDiffs(this.ts, 0);
            if (object != null) {
                if (object.replace != null) {
                    return;
                }
                if (object.before != null) {
                    this.ts.replaceCurrent(token2, 0, 0);
                    return;
                }
            }
            if (token.id() == CppTokenId.NEW_LINE || token.id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
                return;
            }
        }
        if ((object = this.ts.lookNext()) != null && object.id() == CppTokenId.NEW_LINE) {
            return;
        }
        if (token == null) {
            this.ts.replaceCurrent(token2, 0, 0);
        } else {
            this.ts.replaceCurrent(token2, 0, 1);
        }
    }

    private void newLine(Token<CppTokenId> token, Token<CppTokenId> token2, CodeStyle.BracePlacement bracePlacement, boolean bl, int n) {
        if (bracePlacement == CodeStyle.BracePlacement.NEW_LINE) {
            this.newLineBefore(true);
        } else if (bracePlacement == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED) {
            this.newLineBefore(true);
        } else if (bracePlacement == CodeStyle.BracePlacement.SAME_LINE) {
            if (this.ts.isFirstLineToken()) {
                if (!this.removeLineBefore(bl)) {
                    this.newLineBefore(true);
                }
            } else {
                this.spaceBefore(token, bl);
            }
        }
        if (n > 0) {
            if (this.ts.isLastLineToken()) {
                if (n > 1) {
                    this.ts.addAfterCurrent(token2, n - 1, 0);
                }
            } else {
                this.ts.addAfterCurrent(token2, n, this.getIndent());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newLinesBeforeDeclaration(int n, int n2) {
        int n3 = this.ts.index();
        int[] nArray = this.ts.getNewLinesBeforeDeclaration(n2);
        try {
            if (nArray[0] == -1) {
                if (n2 <= 0) {
                    return;
                }
                this.ts.moveIndex(n2);
                this.ts.moveNext();
                this.ts.addBeforeCurrent(n, 0);
            } else {
                if (nArray[0] == 0) {
                    return;
                }
                this.ts.moveIndex(n2);
                this.ts.moveNext();
                int n4 = this.ts.getTokenPosition();
                this.ts.moveIndex(nArray[0]);
                Reformatter.Diff diff = null;
                while (this.ts.moveNext() && this.ts.index() <= nArray[1]) {
                    DiffLinkedList.DiffResult diffResult = this.diffs.getDiffs(this.ts, 0);
                    if (diffResult != null) {
                        if (diffResult.replace != null) {
                            diffResult.replace.setText(0, 0);
                            if (diff == null) {
                                diff = diffResult.replace;
                            }
                        } else if (diff == null) {
                            diff = this.ts.replaceCurrent(this.ts.token(), 0, 0);
                        } else {
                            this.ts.replaceCurrent(this.ts.token(), 0, 0);
                        }
                        if (diffResult.before == null) continue;
                        diffResult.before.setText(0, 0);
                        if (diff != null) continue;
                        diff = diffResult.replace;
                        continue;
                    }
                    if (diff == null) {
                        diff = this.ts.replaceCurrent(this.ts.token(), 0, 0);
                        continue;
                    }
                    this.ts.replaceCurrent(this.ts.token(), 0, 0);
                }
                if (diff != null) {
                    diff.setText(n + nArray[2], n4);
                } else {
                    this.ts.moveIndex(nArray[0]);
                    this.ts.moveNext();
                    if (this.ts.token().id() == CppTokenId.WHITESPACE || this.ts.token().id() == CppTokenId.NEW_LINE) {
                        this.ts.replaceCurrent(this.ts.token(), n + nArray[2], n4);
                    } else {
                        this.ts.addBeforeCurrent(n + nArray[2], n4);
                    }
                }
            }
        }
        finally {
            this.ts.moveIndex(n3);
            this.ts.moveNext();
        }
    }

    private void newLineBefore(boolean bl) {
        int n = bl ? this.getParentIndent() : this.getIndent();
        if (!this.ts.isFirstLineToken()) {
            Token<CppTokenId> token = this.ts.lookPrevious();
            if (token != null) {
                DiffLinkedList.DiffResult diffResult = this.diffs.getDiffs(this.ts, -1);
                if (token.id() == CppTokenId.WHITESPACE) {
                    if (diffResult != null) {
                        if (diffResult.after != null) {
                            diffResult.after.setText(1, n);
                            if (diffResult.replace != null) {
                                diffResult.replace.setText(0, 0);
                            }
                            return;
                        }
                        if (diffResult.replace != null) {
                            diffResult.replace.setText(1, n);
                            return;
                        }
                    }
                    this.ts.replacePrevious(token, 1, n);
                    return;
                }
                if (diffResult != null && diffResult.after != null) {
                    diffResult.after.setText(1, n);
                    return;
                }
            }
            this.ts.addBeforeCurrent(1, n);
        } else {
            Token<CppTokenId> token;
            DiffLinkedList.DiffResult diffResult = this.diffs.getDiffs(this.ts, -1);
            if (diffResult != null) {
                if (diffResult.after != null) {
                    diffResult.after.replaceSpaces(n);
                    if (diffResult.replace != null) {
                        diffResult.replace.replaceSpaces(0);
                    }
                    return;
                }
                if (diffResult.replace != null) {
                    diffResult.replace.replaceSpaces(n);
                    if (diffResult.before != null) {
                        diffResult.before.replaceSpaces(0);
                    }
                    return;
                }
            }
            if ((token = this.ts.lookPrevious()) != null) {
                if (token.id() == CppTokenId.WHITESPACE) {
                    this.ts.replacePrevious(token, 0, n);
                } else if (token.id() == CppTokenId.NEW_LINE) {
                    this.ts.addBeforeCurrent(0, n);
                }
            }
        }
    }

    private void spaceBefore(Token<CppTokenId> token, boolean bl) {
        if (token != null && !this.ts.isFirstLineToken()) {
            if (bl) {
                DiffLinkedList.DiffResult diffResult = this.diffs.getDiffs(this.ts, -1);
                if (diffResult != null) {
                    if (diffResult.after != null && !diffResult.after.hasNewLine()) {
                        diffResult.after.replaceSpaces(1);
                        if (diffResult.replace != null && !diffResult.replace.hasNewLine()) {
                            diffResult.replace.replaceSpaces(0);
                        }
                        return;
                    }
                    if (diffResult.replace != null && !diffResult.replace.hasNewLine()) {
                        diffResult.replace.replaceSpaces(1);
                        return;
                    }
                }
                if (token.id() != CppTokenId.WHITESPACE && token.id() != CppTokenId.NEW_LINE && token.id() != CppTokenId.PREPROCESSOR_DIRECTIVE) {
                    this.ts.addBeforeCurrent(0, 1);
                }
            } else if (this.canRemoveSpaceBefore(token)) {
                DiffLinkedList.DiffResult diffResult = this.diffs.getDiffs(this.ts, -1);
                if (diffResult != null) {
                    if (diffResult.after != null && !diffResult.after.hasNewLine()) {
                        diffResult.after.replaceSpaces(0);
                        if (diffResult.replace != null && !diffResult.replace.hasNewLine()) {
                            diffResult.replace.replaceSpaces(0);
                        }
                        return;
                    }
                    if (diffResult.replace != null && !diffResult.replace.hasNewLine()) {
                        diffResult.replace.replaceSpaces(0);
                        return;
                    }
                }
                if (token.id() == CppTokenId.WHITESPACE) {
                    this.ts.replacePrevious(token, 0, 0);
                }
            }
        }
    }

    private boolean canRemoveSpaceBefore(Token<CppTokenId> token) {
        Token<CppTokenId> token2;
        if (token == null) {
            return false;
        }
        if (token.id() == CppTokenId.WHITESPACE) {
            token2 = this.ts.lookPrevious(2);
            if (token2 == null) {
                return true;
            }
            token = token2;
        }
        token2 = (Token<CppTokenId>)token.id();
        CppTokenId cppTokenId = (CppTokenId)this.ts.token().id();
        return this.canRemoveSpace((CppTokenId)token2, cppTokenId);
    }

    private boolean canRemoveSpace(CppTokenId cppTokenId, CppTokenId cppTokenId2) {
        if (cppTokenId == CppTokenId.IDENTIFIER && cppTokenId2 == CppTokenId.IDENTIFIER) {
            return false;
        }
        String string = cppTokenId2.primaryCategory();
        String string2 = cppTokenId.primaryCategory();
        if ("keyword".equals(string2) || "keyword-directive".equals(string2)) {
            if ("separator".equals(string)) {
                return true;
            }
            if (cppTokenId2 == CppTokenId.COLON) {
                return true;
            }
            if (cppTokenId2 == CppTokenId.LT) {
                return true;
            }
            return cppTokenId2 == CppTokenId.GT;
        }
        if ("operator".equals(string2)) {
            if ("operator".equals(string)) {
                return cppTokenId2 == CppTokenId.GT && (cppTokenId == CppTokenId.STAR || cppTokenId == CppTokenId.AMP);
            }
            return true;
        }
        return cppTokenId != CppTokenId.IDENTIFIER || !"number".equals(string) && !"literal".equals(string) && !"character".equals(string) && !"string".equals(string);
    }

    private boolean canRemoveSpaceAfter(Token<CppTokenId> token) {
        Token<CppTokenId> token2;
        Token<CppTokenId> token3 = this.ts.lookPrevious();
        if (token3 == null) {
            return false;
        }
        if (token3.id() == CppTokenId.WHITESPACE) {
            token2 = this.ts.lookNext(2);
            if (token2 == null) {
                return true;
            }
            token3 = token2;
        }
        token2 = (Token<CppTokenId>)token3.id();
        CppTokenId cppTokenId = (CppTokenId)token.id();
        return this.canRemoveSpace(cppTokenId, (CppTokenId)token2);
    }

    private void spaceAfter(Token<CppTokenId> token, boolean bl) {
        Token<CppTokenId> token2 = this.ts.lookNext();
        if (token2 != null) {
            Token<CppTokenId> token3;
            if (bl) {
                if (token2.id() != CppTokenId.WHITESPACE && token2.id() != CppTokenId.NEW_LINE) {
                    this.ts.addAfterCurrent(token, 0, 1);
                }
            } else if (this.canRemoveSpaceAfter(token) && token2.id() == CppTokenId.WHITESPACE && ((token3 = this.ts.lookNext(2)) == null || "separator".equals(((CppTokenId)token.id()).primaryCategory()) || !"operator".equals(((CppTokenId)token3.id()).primaryCategory()) || "keyword".equals(((CppTokenId)token.id()).primaryCategory()) && token3.id() == CppTokenId.LT)) {
                this.ts.replaceNext(token, token2, 0, 0);
            }
        }
    }

    private void spaceAfterBefore(Token<CppTokenId> token, boolean bl, CppTokenId cppTokenId) {
        Token<CppTokenId> token2 = this.ts.lookNext();
        if (token2 != null) {
            if (token2.id() == CppTokenId.WHITESPACE) {
                Token<CppTokenId> token3 = this.ts.lookNext(2);
                if (token3 != null && token3.id() == cppTokenId && !bl) {
                    this.ts.replaceNext(token, token2, 0, 0);
                }
            } else if (token2.id() == cppTokenId && bl) {
                this.ts.addAfterCurrent(token, 0, 1);
            }
        }
    }

    private void formatLeftParen(Token<CppTokenId> token, Token<CppTokenId> token2) {
        if (token != null) {
            Token<CppTokenId> token3 = this.ts.lookPreviousStatement();
            if (token3 != null) {
                switch ((CppTokenId)token3.id()) {
                    case IF: {
                        this.spaceAfter(token2, this.codeStyle.spaceWithinIfParens());
                        return;
                    }
                    case FOR: {
                        this.spaceAfter(token2, this.codeStyle.spaceWithinForParens());
                        return;
                    }
                    case WHILE: {
                        this.spaceAfter(token2, this.codeStyle.spaceWithinWhileParens());
                        return;
                    }
                    case SWITCH: {
                        this.spaceAfter(token2, this.codeStyle.spaceWithinSwitchParens());
                        return;
                    }
                    case CATCH: {
                        this.spaceAfter(token2, this.codeStyle.spaceWithinCatchParens());
                        return;
                    }
                }
            }
            if ((token3 = this.ts.lookPreviousImportant()) != null && token3.id() == CppTokenId.IDENTIFIER) {
                StackEntry stackEntry = this.braces.peek();
                if (stackEntry == null) {
                    this.spaceBefore(token, this.codeStyle.spaceBeforeMethodDeclParen());
                    this.spaceAfter(token2, this.codeStyle.spaceWithinMethodDeclParens());
                    if (this.codeStyle.newLineFunctionDefinitionName()) {
                        this.checkDefinition();
                    }
                    return;
                }
                if (stackEntry.getImportantKind() != null) {
                    switch (stackEntry.getImportantKind()) {
                        case CLASS: 
                        case NAMESPACE: {
                            this.spaceBefore(token, this.codeStyle.spaceBeforeMethodDeclParen());
                            this.spaceAfter(token2, this.codeStyle.spaceWithinMethodDeclParens());
                            if (this.codeStyle.newLineFunctionDefinitionName()) {
                                this.checkDefinition();
                            }
                            return;
                        }
                    }
                }
                this.spaceBefore(token, this.codeStyle.spaceBeforeMethodCallParen());
                this.spaceAfter(token2, this.codeStyle.spaceWithinMethodCallParens());
                return;
            }
            if (token3 != null && ("keyword".equals(((CppTokenId)token3.id()).primaryCategory()) || "keyword-directive".equals(((CppTokenId)token3.id()).primaryCategory()))) {
                switch ((CppTokenId)token3.id()) {
                    case RETURN: 
                    case SIZEOF: 
                    case TYPEID: 
                    case TYPEOF: 
                    case __TYPEOF: 
                    case __TYPEOF__: 
                    case ALIGNOF: 
                    case __ALIGNOF__: 
                    case THROW: 
                    case __ATTRIBUTE__: 
                    case _DECLSPEC: 
                    case __DECLSPEC: 
                    case _FAR: 
                    case __FAR: 
                    case _NEAR: 
                    case __NEAR: 
                    case _STDCALL: 
                    case __STDCALL: {
                        this.spaceBefore(token, this.codeStyle.spaceBeforeKeywordParen());
                    }
                }
                return;
            }
            if (this.ts.isTypeCast()) {
                this.spaceAfter(token2, this.codeStyle.spaceWithinTypeCastParens());
                return;
            }
            this.spaceAfter(token2, this.codeStyle.spaceWithinParens());
        }
    }

    private void formatRightParen(Token<CppTokenId> token, Token<CppTokenId> token2) {
        if (token != null) {
            Token<CppTokenId> token3 = this.ts.lookPreviousStatement();
            if (token3 != null) {
                switch ((CppTokenId)token3.id()) {
                    case IF: {
                        this.spaceBefore(token, this.codeStyle.spaceWithinIfParens());
                        return;
                    }
                    case FOR: {
                        this.spaceBefore(token, this.codeStyle.spaceWithinForParens());
                        return;
                    }
                    case WHILE: {
                        this.spaceBefore(token, this.codeStyle.spaceWithinWhileParens());
                        return;
                    }
                    case SWITCH: {
                        this.spaceBefore(token, this.codeStyle.spaceWithinSwitchParens());
                        return;
                    }
                    case CATCH: {
                        this.spaceBefore(token, this.codeStyle.spaceWithinCatchParens());
                        return;
                    }
                }
            }
            if ((token3 = this.getImportantBeforeBrace()) != null && token3.id() == CppTokenId.IDENTIFIER) {
                StackEntry stackEntry = this.braces.peek();
                if (stackEntry == null) {
                    this.spaceBefore(token, this.codeStyle.spaceWithinMethodDeclParens());
                    return;
                }
                if (stackEntry.getImportantKind() != null) {
                    switch (stackEntry.getImportantKind()) {
                        case CLASS: 
                        case NAMESPACE: {
                            this.spaceBefore(token, this.codeStyle.spaceWithinMethodDeclParens());
                            return;
                        }
                    }
                }
                this.spaceBefore(token, this.codeStyle.spaceWithinMethodCallParens());
                return;
            }
            if (this.ts.isTypeCast()) {
                this.spaceBefore(token, this.codeStyle.spaceWithinTypeCastParens());
                this.spaceAfter(token2, this.codeStyle.spaceAfterTypeCast());
                return;
            }
            this.spaceBefore(token, this.codeStyle.spaceWithinParens());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token<CppTokenId> getImportantBeforeBrace() {
        int n = this.ts.index();
        try {
            if (this.ts.token().id() == CppTokenId.RPAREN) {
                int n2 = 1;
                while (this.ts.movePrevious()) {
                    switch ((CppTokenId)this.ts.token().id()) {
                        case RPAREN: {
                            ++n2;
                            break;
                        }
                        case LPAREN: {
                            if (--n2 > 0) break;
                            Token<CppTokenId> token = this.ts.lookPreviousImportant();
                            return token;
                        }
                    }
                }
            }
            Token<CppTokenId> token = null;
            return token;
        }
        finally {
            this.ts.moveIndex(n);
            this.ts.moveNext();
        }
    }

    private boolean isOperator() {
        Token<CppTokenId> token = this.ts.lookPreviousImportant(1);
        return token != null && token.id() == CppTokenId.OPERATOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNewStyleCast(Token<CppTokenId> token) {
        if (token.id() == CppTokenId.LT) {
            Token<CppTokenId> token2 = this.ts.lookPreviousImportant(1);
            if (token2 != null) {
                return token2.id() == CppTokenId.REINTERPRET_CAST || token2.id() == CppTokenId.STATIC_CAST || token2.id() == CppTokenId.CONST_CAST || token2.id() == CppTokenId.DYNAMIC_CAST;
            }
            return false;
        }
        if (token.id() == CppTokenId.GT) {
            int n = this.ts.index();
            try {
                int n2 = 1;
                while (this.ts.movePrevious()) {
                    switch ((CppTokenId)this.ts.token().id()) {
                        case GT: {
                            ++n2;
                            break;
                        }
                        case LT: {
                            if (--n2 > 0) break;
                            Token<CppTokenId> token3 = this.ts.lookPreviousImportant(1);
                            if (token3 != null) {
                                boolean bl = token3.id() == CppTokenId.REINTERPRET_CAST || token3.id() == CppTokenId.STATIC_CAST || token3.id() == CppTokenId.CONST_CAST || token3.id() == CppTokenId.DYNAMIC_CAST;
                                return bl;
                            }
                            boolean bl = false;
                            return bl;
                        }
                        case SEMICOLON: 
                        case LBRACE: 
                        case RBRACE: {
                            boolean bl = false;
                            return bl;
                        }
                    }
                }
            }
            finally {
                this.ts.moveIndex(n);
                this.ts.moveNext();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean makeSpaceBefore(boolean bl) {
        int n = this.ts.index();
        try {
            while (true) {
                if (!this.ts.movePrevious()) {
                    boolean bl2 = false;
                    return bl2;
                }
                if (this.ts.token().id() == CppTokenId.NEW_LINE) {
                    DiffLinkedList.DiffResult diffResult = this.diffs.getDiffs(this.ts, 0);
                    if (diffResult.replace != null && !diffResult.replace.hasNewLine()) continue;
                    boolean bl3 = false;
                    return bl3;
                }
                if (this.ts.token().id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
                    boolean bl4 = false;
                    return bl4;
                }
                if (this.ts.token().id() != CppTokenId.WHITESPACE) break;
            }
            this.replaceSegment(bl, n);
            boolean bl5 = true;
            return bl5;
        }
        finally {
            this.ts.moveIndex(n);
            this.ts.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeLineBefore(boolean bl) {
        int n = this.ts.index();
        try {
            do {
                if (!this.ts.movePrevious()) {
                    boolean bl2 = false;
                    return bl2;
                }
                if (this.ts.token().id() == CppTokenId.NEW_LINE) {
                    if (this.ts.movePrevious()) {
                        if (this.ts.token().id() == CppTokenId.WHITESPACE) {
                            this.ts.movePrevious();
                            this.replaceSegment(bl, n);
                            boolean bl3 = true;
                            return bl3;
                        }
                        if (this.ts.token().id() != CppTokenId.LINE_COMMENT) {
                            this.replaceSegment(bl, n);
                            boolean bl4 = true;
                            return bl4;
                        }
                    }
                    boolean bl5 = false;
                    return bl5;
                }
                if (this.ts.token().id() != CppTokenId.PREPROCESSOR_DIRECTIVE) continue;
                boolean bl6 = false;
                return bl6;
            } while (this.ts.token().id() == CppTokenId.WHITESPACE);
            this.replaceSegment(bl, n);
            boolean bl7 = true;
            return bl7;
        }
        finally {
            this.ts.moveIndex(n);
            this.ts.moveNext();
        }
    }

    private void replaceSegment(boolean bl, int n) {
        boolean bl2 = true;
        Reformatter.Diff diff = null;
        while (this.ts.index() < n) {
            Reformatter.Diff diff2;
            DiffLinkedList.DiffResult diffResult = this.diffs.getDiffs(this.ts, 0);
            if (diffResult != null) {
                if (!bl2) {
                    if (diffResult.replace != null) {
                        if (diff == null) {
                            diff = diffResult.replace;
                        }
                        diffResult.replace.setText(0, 0);
                    } else {
                        diff2 = this.diffs.addFirst(this.ts.offset(), this.ts.offset() + this.ts.token().length(), 0, 0);
                        if (diff == null) {
                            diff = diff2;
                        }
                    }
                }
                if (diffResult.after != null) {
                    if (diff == null) {
                        diff = diffResult.after;
                    }
                    diffResult.after.setText(0, 0);
                }
            }
            if (!bl2 && diffResult == null) {
                diff2 = this.diffs.addFirst(this.ts.offset(), this.ts.offset() + this.ts.token().length(), 0, 0);
                if (diff == null) {
                    diff = diff2;
                }
            }
            bl2 = false;
            this.ts.moveNext();
        }
        if (diff != null && bl) {
            diff.setText(0, 1);
        }
    }

    boolean doFormat() {
        return this.ts.offset() >= this.startOffset;
    }
}

