/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.options;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.options.BooleanNodeProp;
import org.netbeans.modules.cnd.editor.options.BracePlacementProperty;
import org.netbeans.modules.cnd.editor.options.EditorOptions;
import org.netbeans.modules.cnd.editor.options.EditorOptionsPanelController;
import org.netbeans.modules.cnd.editor.options.IntNodeProp;
import org.netbeans.modules.cnd.editor.options.ManageStylesPanel;
import org.netbeans.modules.cnd.editor.options.PreprocessorIndentProperty;
import org.netbeans.modules.cnd.editor.options.PreviewPreferences;
import org.netbeans.modules.cnd.editor.reformat.Reformatter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorPropertySheet
extends JPanel
implements ActionListener,
PropertyChangeListener,
PreferenceChangeListener {
    private static final boolean USE_NEW_FORMATTER = true;
    private static final boolean TRACE = false;
    private EditorOptionsPanelController topControler;
    private boolean loaded = false;
    private CodeStyle.Language currentLanguage;
    private String lastChangedproperty;
    private Map<CodeStyle.Language, String> defaultStyles = new HashMap<CodeStyle.Language, String>();
    private Map<CodeStyle.Language, Map<String, PreviewPreferences>> allPreferences = new HashMap<CodeStyle.Language, Map<String, PreviewPreferences>>();
    private PropertySheet holder;
    private PreviewPreferences lastSheetPreferences = null;
    private JPanel categoryPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSplitPane jSplitPane1;
    private JComboBox languagesComboBox;
    private JButton manageStyles;
    private JPanel oprionsPanel;
    private JEditorPane previewPane;
    private JPanel previewPanel;
    private JComboBox styleComboBox;

    EditorPropertySheet(EditorOptionsPanelController editorOptionsPanelController) {
        this.topControler = editorOptionsPanelController;
        this.initComponents();
        this.holder = new PropertySheet();
        this.holder.setOpaque(false);
        this.holder.setDescriptionAreaVisible(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.categoryPanel.add((Component)this.holder, gridBagConstraints);
        this.manageStyles.setMinimumSize(new Dimension(126, 26));
        this.setName("Tab_Name");
        if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
            this.setOpaque(false);
        }
        this.previewPane.setContentType("text/x-c++");
        this.previewPane.putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
        this.previewPane.setText("1234567890123456789012345678901234567890");
        this.previewPane.setDoubleBuffered(true);
        this.initLanguageComboBox();
    }

    private void initLanguageComboBox() {
        DefaultComboBoxModel<CodeStyle.Language> defaultComboBoxModel = new DefaultComboBoxModel<CodeStyle.Language>();
        defaultComboBoxModel.addElement(CodeStyle.Language.C);
        defaultComboBoxModel.addElement(CodeStyle.Language.CPP);
        this.languagesComboBox.setModel(defaultComboBoxModel);
        this.currentLanguage = CodeStyle.Language.C;
        this.languagesComboBox.setSelectedIndex(0);
        this.languagesComboBox.addActionListener(this);
    }

    private void initLanguageMap() {
        for (String string : EditorOptions.getAllStyles(CodeStyle.Language.C)) {
            this.initLanguageStylePreferences(CodeStyle.Language.C, string);
        }
        this.defaultStyles.put(CodeStyle.Language.C, EditorOptions.getCurrentProfileId(CodeStyle.Language.C));
        for (String string : EditorOptions.getAllStyles(CodeStyle.Language.CPP)) {
            this.initLanguageStylePreferences(CodeStyle.Language.CPP, string);
        }
        this.defaultStyles.put(CodeStyle.Language.CPP, EditorOptions.getCurrentProfileId(CodeStyle.Language.CPP));
    }

    private void initLanguageStylePreferences(CodeStyle.Language language, String string) {
        Map<String, PreviewPreferences> map = this.allPreferences.get((Object)language);
        if (map == null) {
            map = new HashMap<String, PreviewPreferences>();
            this.allPreferences.put(language, map);
        }
        PreviewPreferences previewPreferences = new PreviewPreferences(EditorOptions.getPreferences(language, string), language, string);
        map.put(string, previewPreferences);
    }

    private void initLanguageCategory() {
        this.styleComboBox.removeActionListener(this);
        DefaultComboBoxModel<EntryWrapper> defaultComboBoxModel = new DefaultComboBoxModel<EntryWrapper>();
        Map<String, PreviewPreferences> map = this.allPreferences.get((Object)this.currentLanguage);
        String string = this.defaultStyles.get((Object)this.currentLanguage);
        ArrayList<EntryWrapper> arrayList = new ArrayList<EntryWrapper>();
        for (Map.Entry<String, PreviewPreferences> entry : map.entrySet()) {
            arrayList.add(new EntryWrapper(entry));
        }
        Collections.sort(arrayList);
        int n = 0;
        int n2 = 0;
        for (EntryWrapper entryWrapper : arrayList) {
            if (entryWrapper.name.equals(string)) {
                n = n2;
            }
            defaultComboBoxModel.addElement(entryWrapper);
            ++n2;
        }
        this.styleComboBox.setModel(defaultComboBoxModel);
        this.styleComboBox.setSelectedIndex(n);
        EntryWrapper entryWrapper = (EntryWrapper)this.styleComboBox.getSelectedItem();
        this.initSheets(entryWrapper.preferences);
        string = entryWrapper.name;
        this.defaultStyles.put(this.currentLanguage, string);
        this.styleComboBox.addActionListener(this);
        this.repaintPreview();
    }

    private void initSheets(PreviewPreferences previewPreferences) {
        if (this.lastSheetPreferences != null) {
            this.lastSheetPreferences.removePreferenceChangeListener(this);
        }
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("Indents");
        set.setDisplayName(EditorPropertySheet.getString("LBL_TabsAndIndents"));
        set.setShortDescription(EditorPropertySheet.getString("HINT_TabsAndIndents"));
        set.put((Node.Property)new IntNodeProp(this.currentLanguage, previewPreferences, "indentSize"));
        set.put((Node.Property)new IntNodeProp(this.currentLanguage, previewPreferences, "statementContinuationIndent"));
        set.put((Node.Property)new PreprocessorIndentProperty(this.currentLanguage, previewPreferences, "indentPreprocessorDirectives"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "sharpAtStartLine"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "indentNamespace"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "indentCasesFromSwitch"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "absoluteLabelIndent"));
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("BracesPlacement");
        set.setDisplayName(EditorPropertySheet.getString("LBL_BracesPlacement"));
        set.setShortDescription(EditorPropertySheet.getString("HINT_BracesPlacement"));
        set.put((Node.Property)new BracePlacementProperty(this.currentLanguage, previewPreferences, "newLineBeforeBraceNamespace"));
        set.put((Node.Property)new BracePlacementProperty(this.currentLanguage, previewPreferences, "newLineBeforeBraceClass"));
        set.put((Node.Property)new BracePlacementProperty(this.currentLanguage, previewPreferences, "newLineBeforeBraceDeclaration"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "ignoreEmptyFunctionBody"));
        set.put((Node.Property)new BracePlacementProperty(this.currentLanguage, previewPreferences, "newLineBeforeBraceSwitch"));
        set.put((Node.Property)new BracePlacementProperty(this.currentLanguage, previewPreferences, "newLineBeforeBrace"));
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("MultilineAlignment");
        set.setDisplayName(EditorPropertySheet.getString("LBL_MultilineAlignment"));
        set.setShortDescription(EditorPropertySheet.getString("HINT_MultilineAlignment"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "alignMultilineMethodParams"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "alignMultilineCallArgs"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "alignMultilineArrayInit"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "alignMultilineFor"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "alignMultilineIfCondition"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "alignMultilineWhileCondition"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "alignMultilineParen"));
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("NewLine");
        set.setDisplayName(EditorPropertySheet.getString("LBL_NewLine"));
        set.setShortDescription(EditorPropertySheet.getString("HINT_NewLine"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "newLineFunctionDefinitionName"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "newLineCatch"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "newLineElse"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "newLineWhile"));
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("SpacesBeforeKeywords");
        set.setDisplayName(EditorPropertySheet.getString("LBL_BeforeKeywords"));
        set.setShortDescription(EditorPropertySheet.getString("HINT_BeforeKeywords"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceBeforeCatch"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceBeforeElse"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceBeforeWhile"));
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("SpacesBeforeParentheses");
        set.setDisplayName(EditorPropertySheet.getString("LBL_BeforeParentheses"));
        set.setShortDescription(EditorPropertySheet.getString("HINT_BeforeParentheses"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceBeforeMethodDeclParen"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceBeforeMethodCallParen"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceBeforeCatchParen"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceBeforeForParen"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceBeforeIfParen"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceBeforeSwitchParen"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceBeforeWhileParen"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceBeforeKeywordParen"));
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("SpacesAroundOperators");
        set.setDisplayName(EditorPropertySheet.getString("LBL_AroundOperators"));
        set.setShortDescription(EditorPropertySheet.getString("HINT_AroundOperators"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceAroundAssignOps"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceAroundBinaryOps"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceAroundTernaryOps"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceAroundUnaryOps"));
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("SpacesBeforeLeftBracess");
        set.setDisplayName(EditorPropertySheet.getString("LBL_BeforeLeftBraces"));
        set.setShortDescription(EditorPropertySheet.getString("HINT_BeforeLeftBraces"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceBeforeClassDeclLeftBrace"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceBeforeMethodDeclLeftBrace"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceBeforeArrayInitLeftBrace"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceBeforeCatchLeftBrace"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceBeforeDoLeftBrace"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceBeforeElseLeftBrace"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceBeforeForLeftBrace"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceBeforeIfLeftBrace"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceBeforeSwitchLeftBrace"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceBeforeTryLeftBrace"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceBeforeWhileLeftBrace"));
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("SpacesWithinParentheses");
        set.setDisplayName(EditorPropertySheet.getString("LBL_WithinParentheses"));
        set.setShortDescription(EditorPropertySheet.getString("HINT_WithinParentheses"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceWithinMethodDeclParens"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceWithinMethodCallParens"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceWithinBraces"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceWithinParens"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceWithinCatchParens"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceWithinForParens"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceWithinIfParens"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceWithinSwitchParens"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceWithinTypeCastParens"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceWithinWhileParens"));
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("SpacesOther");
        set.setDisplayName(EditorPropertySheet.getString("LBL_Other_Spaces"));
        set.setShortDescription(EditorPropertySheet.getString("HINT_Other_Spaces"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceBeforeComma"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceAfterComma"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceBeforeSemi"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceAfterSemi"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceBeforeColon"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceAfterColon"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "spaceAfterTypeCast"));
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("BlankLines");
        set.setDisplayName(EditorPropertySheet.getString("LBL_BlankLines"));
        set.setShortDescription(EditorPropertySheet.getString("HINT_BlankLines"));
        set.put((Node.Property)new IntNodeProp(this.currentLanguage, previewPreferences, "blankLinesBeforeClass"));
        set.put((Node.Property)new IntNodeProp(this.currentLanguage, previewPreferences, "blankLinesAfterClassHeader"));
        set.put((Node.Property)new IntNodeProp(this.currentLanguage, previewPreferences, "blankLinesBeforeMethods"));
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("Other");
        set.setDisplayName(EditorPropertySheet.getString("LBL_Other"));
        set.setShortDescription(EditorPropertySheet.getString("HINT_Other"));
        set.put((Node.Property)new BooleanNodeProp(this.currentLanguage, previewPreferences, "addLeadingStarInComment"));
        sheet.put(set);
        DummyNode[] dummyNodeArray = new DummyNode[]{new DummyNode(sheet, "Sheet")};
        this.holder.setNodes((Node[])dummyNodeArray);
        previewPreferences.addPreferenceChangeListener(this);
        this.lastSheetPreferences = previewPreferences;
    }

    void load() {
        this.loaded = false;
        this.initLanguageMap();
        this.initLanguageCategory();
        this.loaded = true;
        this.repaintPreview();
    }

    void store() {
        for (Map.Entry<CodeStyle.Language, Map<String, PreviewPreferences>> entry : this.allPreferences.entrySet()) {
            CodeStyle.Language language = entry.getKey();
            Map<String, PreviewPreferences> map = entry.getValue();
            EditorOptions.setCurrentProfileId(language, this.defaultStyles.get((Object)language));
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, PreviewPreferences> entry2 : map.entrySet()) {
                String string = entry2.getKey();
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(string);
                PreviewPreferences previewPreferences = entry2.getValue();
                Preferences preferences = EditorOptions.getPreferences(language, string);
                if (string.equals(this.defaultStyles.get((Object)language))) {
                    EditorOptions.setPreferences(CodeStyle.getDefault(language), preferences);
                }
                for (String string2 : EditorOptions.keys()) {
                    Object object;
                    Object object2 = EditorOptions.getDefault(language, string, string2);
                    if (object2 instanceof Boolean) {
                        object = previewPreferences.getBoolean(string2, (Boolean)object2);
                        if (!object2.equals(object)) {
                            preferences.putBoolean(string2, (Boolean)object);
                            continue;
                        }
                        preferences.remove(string2);
                        continue;
                    }
                    if (object2 instanceof Integer) {
                        object = previewPreferences.getInt(string2, (Integer)object2);
                        if (!object2.equals(object)) {
                            preferences.putInt(string2, (Integer)object);
                            continue;
                        }
                        preferences.remove(string2);
                        continue;
                    }
                    object = previewPreferences.get(string2, object2.toString());
                    if (!object2.equals(object)) {
                        preferences.put(string2, (String)object);
                        continue;
                    }
                    preferences.remove(string2);
                }
            }
            EditorOptions.setAllStyles(language, stringBuilder.toString());
        }
        this.defaultStyles.clear();
        this.allPreferences.clear();
        this.holder.setNodes(null);
    }

    void cancel() {
        this.defaultStyles.clear();
        this.allPreferences.clear();
        this.holder.setNodes(null);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.lastChangedproperty = null;
        if (this.styleComboBox.equals(actionEvent.getSource())) {
            EntryWrapper entryWrapper = (EntryWrapper)this.styleComboBox.getSelectedItem();
            if (entryWrapper != null) {
                this.defaultStyles.put(this.currentLanguage, entryWrapper.name);
                this.initSheets(entryWrapper.preferences);
                this.repaintPreview();
            }
        } else if (this.languagesComboBox.equals(actionEvent.getSource())) {
            this.currentLanguage = (CodeStyle.Language)((Object)this.languagesComboBox.getSelectedItem());
            this.initLanguageCategory();
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        this.lastChangedproperty = preferenceChangeEvent.getKey();
        this.change();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.change();
    }

    private void change() {
        if (!this.loaded) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                EditorPropertySheet.this.topControler.changed();
                EditorPropertySheet.this.repaintPreview();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void repaintPreview() {
        EntryWrapper entryWrapper = (EntryWrapper)this.styleComboBox.getSelectedItem();
        if (entryWrapper != null) {
            if (CodeStyle.Language.C.equals((Object)this.currentLanguage)) {
                this.previewPane.setContentType("text/x-c");
            } else {
                this.previewPane.setContentType("text/x-c++");
            }
            if (this.loaded) {
                PreviewPreferences previewPreferences = new PreviewPreferences(entryWrapper.preferences, entryWrapper.preferences.getLanguage(), entryWrapper.preferences.getStyleId());
                previewPreferences.makeAllKeys(entryWrapper.preferences);
                this.jScrollPane1.setIgnoreRepaint(true);
                this.refreshPreview(this.previewPane, previewPreferences);
                this.previewPane.setIgnoreRepaint(false);
                this.previewPane.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
                this.previewPane.repaint(100L);
            }
        }
    }

    private String getPreviwText() {
        String string = CodeStyle.Language.C.equals((Object)this.currentLanguage) ? ".c" : ".cpp";
        if (this.lastChangedproperty != null) {
            if (this.lastChangedproperty.startsWith("space")) {
                return this.loadPreviewExample("SAMPLE_Spaces" + string);
            }
            if (this.lastChangedproperty.startsWith("blank")) {
                return this.loadPreviewExample("SAMPLE_BlankLines" + string);
            }
            if (this.lastChangedproperty.startsWith("align") || this.lastChangedproperty.startsWith("new")) {
                return this.loadPreviewExample("SAMPLE_AlignBraces" + string);
            }
        }
        return this.loadPreviewExample("SAMPLE_TabsIndents" + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadPreviewExample(String string) {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("OptionsDialog/CPlusPlus/FormatterPreviewExamples/" + string);
        if (fileObject != null && fileObject.getSize() > 0L) {
            StringBuilder stringBuilder = new StringBuilder((int)fileObject.getSize());
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(fileObject.getInputStream());
                char[] cArray = new char[1024];
                try {
                    int n;
                    while (0 < (n = inputStreamReader.read(cArray, 0, cArray.length))) {
                        stringBuilder.append(cArray, 0, n);
                    }
                }
                finally {
                    inputStreamReader.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public void refreshPreview(JEditorPane jEditorPane, Preferences preferences) {
        jEditorPane.setText(this.getPreviwText());
        BaseDocument baseDocument = (BaseDocument)jEditorPane.getDocument();
        CodeStyle codeStyle = EditorOptions.createCodeStyle(this.currentLanguage, preferences);
        try {
            new Reformatter((Document)baseDocument, codeStyle).reformat();
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    private static String getString(String string) {
        return NbBundle.getMessage(EditorPropertySheet.class, (String)string);
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.languagesComboBox = new JComboBox();
        this.jSplitPane1 = new JSplitPane();
        this.oprionsPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.styleComboBox = new JComboBox();
        this.categoryPanel = new JPanel();
        this.manageStyles = new JButton();
        this.previewPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.previewPane = new JEditorPane();
        this.jSeparator1 = new JSeparator();
        this.setLayout(new GridBagLayout());
        this.jLabel2.setLabelFor(this.languagesComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(EditorPropertySheet.class, (String)"EditorPropertySheet.jLabel2.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.languagesComboBox.setMinimumSize(new Dimension(100, 18));
        this.languagesComboBox.setPreferredSize(new Dimension(100, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.languagesComboBox, gridBagConstraints);
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerLocation(300);
        this.jSplitPane1.setOpaque(false);
        this.oprionsPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.oprionsPanel.setOpaque(false);
        this.oprionsPanel.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.styleComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(EditorPropertySheet.class, (String)"LBL_Style_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 6);
        this.oprionsPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.styleComboBox.setMaximumSize(new Dimension(100, 25));
        this.styleComboBox.setPreferredSize(new Dimension(100, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.oprionsPanel.add((Component)this.styleComboBox, gridBagConstraints);
        this.categoryPanel.setBorder(BorderFactory.createEtchedBorder());
        this.categoryPanel.setOpaque(false);
        this.categoryPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.oprionsPanel.add((Component)this.categoryPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.manageStyles, (String)NbBundle.getMessage(EditorPropertySheet.class, (String)"EditorPropertySheet.manageStyles.text"));
        this.manageStyles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditorPropertySheet.this.manageStylesActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 6, 12, 6);
        this.oprionsPanel.add((Component)this.manageStyles, gridBagConstraints);
        this.jSplitPane1.setLeftComponent(this.oprionsPanel);
        this.previewPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.previewPanel.setOpaque(false);
        this.previewPanel.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.previewPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.previewPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.previewPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jSplitPane1, gridBagConstraints);
        this.jSeparator1.setForeground(SystemColor.activeCaptionBorder);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.jSeparator1, gridBagConstraints);
    }

    private void manageStylesActionPerformed(ActionEvent actionEvent) {
        Map<CodeStyle.Language, Map<String, PreviewPreferences>> map = this.clonePreferences();
        ManageStylesPanel manageStylesPanel = new ManageStylesPanel(this.currentLanguage, map);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)manageStylesPanel, EditorPropertySheet.getString("MANAGE_STYLES_DIALOG_TITLE"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            this.allPreferences = map;
            this.initLanguageCategory();
        }
    }

    private Map<CodeStyle.Language, Map<String, PreviewPreferences>> clonePreferences() {
        HashMap<CodeStyle.Language, Map<String, PreviewPreferences>> hashMap = new HashMap<CodeStyle.Language, Map<String, PreviewPreferences>>();
        for (Map.Entry<CodeStyle.Language, Map<String, PreviewPreferences>> entry : this.allPreferences.entrySet()) {
            CodeStyle.Language language = entry.getKey();
            Map<String, PreviewPreferences> map = entry.getValue();
            HashMap<String, PreviewPreferences> hashMap2 = new HashMap<String, PreviewPreferences>();
            hashMap.put(language, hashMap2);
            for (Map.Entry<String, PreviewPreferences> entry2 : map.entrySet()) {
                PreviewPreferences previewPreferences = entry2.getValue();
                PreviewPreferences previewPreferences2 = new PreviewPreferences(previewPreferences, language, entry2.getKey());
                hashMap2.put(entry2.getKey(), previewPreferences2);
            }
        }
        return hashMap;
    }

    private class DummyNode
    extends AbstractNode {
        public DummyNode(Sheet sheet, String string) {
            super(Children.LEAF);
            if (sheet != null) {
                this.setSheet(sheet);
            }
            this.setName(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntryWrapper
    implements Comparable<EntryWrapper> {
        private final String name;
        private String displayName;
        private final PreviewPreferences preferences;

        private EntryWrapper(Map.Entry<String, PreviewPreferences> entry) {
            this.name = entry.getKey();
            this.preferences = entry.getValue();
            this.displayName = EditorOptions.getStyleDisplayName(this.preferences.getLanguage(), this.name);
        }

        public String toString() {
            return this.displayName;
        }

        @Override
        public int compareTo(EntryWrapper entryWrapper) {
            return this.displayName.compareTo(entryWrapper.displayName);
        }
    }
}

