/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.options;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.text.EditorKit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Settings;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorOptions {
    public static CodeStyleFactory codeStyleFactory;
    public static final String statementContinuationIndent = "statementContinuationIndent";
    public static final int statementContinuationIndentDefault = 8;
    public static final String indentSize = "indentSize";
    public static final int indentSizeDefault = 4;
    public static final String indentPreprocessorDirectives = "indentPreprocessorDirectives";
    public static final String indentPreprocessorDirectivesDefault;
    public static final String sharpAtStartLine = "sharpAtStartLine";
    public static final boolean sharpAtStartLineDefault = true;
    public static final String indentCasesFromSwitch = "indentCasesFromSwitch";
    public static final boolean indentCasesFromSwitchDefault = true;
    public static final String absoluteLabelIndent = "absoluteLabelIndent";
    public static final boolean absoluteLabelIndentDefault = true;
    public static final String indentNamespace = "indentNamespace";
    public static final boolean indentNamespaceDefault = true;
    public static final String newLineBeforeBraceNamespace = "newLineBeforeBraceNamespace";
    public static final String newLineBeforeBraceNamespaceDefault;
    public static final String newLineBeforeBraceClass = "newLineBeforeBraceClass";
    public static final String newLineBeforeBraceClassDefault;
    public static final String newLineBeforeBraceDeclaration = "newLineBeforeBraceDeclaration";
    public static final String newLineBeforeBraceDeclarationDefault;
    public static final String ignoreEmptyFunctionBody = "ignoreEmptyFunctionBody";
    public static final boolean ignoreEmptyFunctionBodyDefault = false;
    public static final String newLineBeforeBrace = "newLineBeforeBrace";
    public static final String newLineBeforeBraceDefault;
    public static final String newLineBeforeBraceSwitch = "newLineBeforeBraceSwitch";
    public static final String newLineBeforeBraceSwitchDefault;
    public static final String alignMultilineArrayInit = "alignMultilineArrayInit";
    public static final boolean alignMultilineArrayInitDefault = false;
    public static final String alignMultilineCallArgs = "alignMultilineCallArgs";
    public static final boolean alignMultilineCallArgsDefault = false;
    public static final String alignMultilineMethodParams = "alignMultilineMethodParams";
    public static final boolean alignMultilineMethodParamsDefault = false;
    public static final String alignMultilineFor = "alignMultilineFor";
    public static final boolean alignMultilineForDefault = false;
    public static final String alignMultilineIfCondition = "alignMultilineIfCondition";
    public static final boolean alignMultilineIfConditionDefault = false;
    public static final String alignMultilineWhileCondition = "alignMultilineWhileCondition";
    public static final boolean alignMultilineWhileConditionDefault = false;
    public static final String alignMultilineParen = "alignMultilineParen";
    public static final boolean alignMultilineParenDefault = false;
    public static final String newLineFunctionDefinitionName = "newLineFunctionDefinitionName";
    public static final boolean newLineFunctionDefinitionNameDefault = false;
    public static final String newLineCatch = "newLineCatch";
    public static final boolean newLineCatchDefault = false;
    public static final String newLineElse = "newLineElse";
    public static final boolean newLineElseDefault = false;
    public static final String newLineWhile = "newLineWhile";
    public static final boolean newLineWhileDefault = false;
    public static final String spaceBeforeWhile = "spaceBeforeWhile";
    public static final boolean spaceBeforeWhileDefault = true;
    public static final String spaceBeforeElse = "spaceBeforeElse";
    public static final boolean spaceBeforeElseDefault = true;
    public static final String spaceBeforeCatch = "spaceBeforeCatch";
    public static final boolean spaceBeforeCatchDefault = true;
    public static final String spaceBeforeMethodDeclParen = "spaceBeforeMethodDeclParen";
    public static final boolean spaceBeforeMethodDeclParenDefault = false;
    public static final String spaceBeforeMethodCallParen = "spaceBeforeMethodCallParen";
    public static final boolean spaceBeforeMethodCallParenDefault = false;
    public static final String spaceBeforeIfParen = "spaceBeforeIfParen";
    public static final boolean spaceBeforeIfParenDefault = true;
    public static final String spaceBeforeForParen = "spaceBeforeForParen";
    public static final boolean spaceBeforeForParenDefault = true;
    public static final String spaceBeforeWhileParen = "spaceBeforeWhileParen";
    public static final boolean spaceBeforeWhileParenDefault = true;
    public static final String spaceBeforeCatchParen = "spaceBeforeCatchParen";
    public static final boolean spaceBeforeCatchParenDefault = true;
    public static final String spaceBeforeSwitchParen = "spaceBeforeSwitchParen";
    public static final boolean spaceBeforeSwitchParenDefault = true;
    public static final String spaceAroundUnaryOps = "spaceAroundUnaryOps";
    public static final boolean spaceAroundUnaryOpsDefault = false;
    public static final String spaceAroundBinaryOps = "spaceAroundBinaryOps";
    public static final boolean spaceAroundBinaryOpsDefault = true;
    public static final String spaceAroundTernaryOps = "spaceAroundTernaryOps";
    public static final boolean spaceAroundTernaryOpsDefault = true;
    public static final String spaceAroundAssignOps = "spaceAroundAssignOps";
    public static final boolean spaceAroundAssignOpsDefault = true;
    public static final String spaceBeforeClassDeclLeftBrace = "spaceBeforeClassDeclLeftBrace";
    public static final boolean spaceBeforeClassDeclLeftBraceDefault = true;
    public static final String spaceBeforeMethodDeclLeftBrace = "spaceBeforeMethodDeclLeftBrace";
    public static final boolean spaceBeforeMethodDeclLeftBraceDefault = true;
    public static final String spaceBeforeIfLeftBrace = "spaceBeforeIfLeftBrace";
    public static final boolean spaceBeforeIfLeftBraceDefault = true;
    public static final String spaceBeforeElseLeftBrace = "spaceBeforeElseLeftBrace";
    public static final boolean spaceBeforeElseLeftBraceDefault = true;
    public static final String spaceBeforeWhileLeftBrace = "spaceBeforeWhileLeftBrace";
    public static final boolean spaceBeforeWhileLeftBraceDefault = true;
    public static final String spaceBeforeForLeftBrace = "spaceBeforeForLeftBrace";
    public static final boolean spaceBeforeForLeftBraceDefault = true;
    public static final String spaceBeforeDoLeftBrace = "spaceBeforeDoLeftBrace";
    public static final boolean spaceBeforeDoLeftBraceDefault = true;
    public static final String spaceBeforeSwitchLeftBrace = "spaceBeforeSwitchLeftBrace";
    public static final boolean spaceBeforeSwitchLeftBraceDefault = true;
    public static final String spaceBeforeTryLeftBrace = "spaceBeforeTryLeftBrace";
    public static final boolean spaceBeforeTryLeftBraceDefault = true;
    public static final String spaceBeforeCatchLeftBrace = "spaceBeforeCatchLeftBrace";
    public static final boolean spaceBeforeCatchLeftBraceDefault = true;
    public static final String spaceBeforeArrayInitLeftBrace = "spaceBeforeArrayInitLeftBrace";
    public static final boolean spaceBeforeArrayInitLeftBraceDefault = false;
    public static final String spaceWithinParens = "spaceWithinParens";
    public static final boolean spaceWithinParensDefault = false;
    public static final String spaceWithinMethodDeclParens = "spaceWithinMethodDeclParens";
    public static final boolean spaceWithinMethodDeclParensDefault = false;
    public static final String spaceWithinMethodCallParens = "spaceWithinMethodCallParens";
    public static final boolean spaceWithinMethodCallParensDefault = false;
    public static final String spaceWithinIfParens = "spaceWithinIfParens";
    public static final boolean spaceWithinIfParensDefault = false;
    public static final String spaceWithinForParens = "spaceWithinForParens";
    public static final boolean spaceWithinForParensDefault = false;
    public static final String spaceWithinWhileParens = "spaceWithinWhileParens";
    public static final boolean spaceWithinWhileParensDefault = false;
    public static final String spaceWithinSwitchParens = "spaceWithinSwitchParens";
    public static final boolean spaceWithinSwitchParensDefault = false;
    public static final String spaceWithinCatchParens = "spaceWithinCatchParens";
    public static final boolean spaceWithinCatchParensDefault = false;
    public static final String spaceWithinTypeCastParens = "spaceWithinTypeCastParens";
    public static final boolean spaceWithinTypeCastParensDefault = false;
    public static final String spaceWithinBraces = "spaceWithinBraces";
    public static final boolean spaceWithinBracesDefault = false;
    public static final String spaceBeforeKeywordParen = "spaceBeforeKeywordParen";
    public static final boolean spaceBeforeKeywordParenDefault = true;
    public static final String spaceBeforeComma = "spaceBeforeComma";
    public static final boolean spaceBeforeCommaDefault = false;
    public static final String spaceAfterComma = "spaceAfterComma";
    public static final boolean spaceAfterCommaDefault = true;
    public static final String spaceBeforeSemi = "spaceBeforeSemi";
    public static final boolean spaceBeforeSemiDefault = false;
    public static final String spaceAfterSemi = "spaceAfterSemi";
    public static final boolean spaceAfterSemiDefault = true;
    public static final String spaceBeforeColon = "spaceBeforeColon";
    public static final boolean spaceBeforeColonDefault = true;
    public static final String spaceAfterColon = "spaceAfterColon";
    public static final boolean spaceAfterColonDefault = true;
    public static final String spaceAfterTypeCast = "spaceAfterTypeCast";
    public static final boolean spaceAfterTypeCastDefault = true;
    public static final String blankLinesBeforeClass = "blankLinesBeforeClass";
    public static final int blankLinesBeforeClassDefault = 1;
    public static final String blankLinesAfterClassHeader = "blankLinesAfterClassHeader";
    public static final int blankLinesAfterClassHeaderDefault = 0;
    public static final String blankLinesBeforeMethods = "blankLinesBeforeMethods";
    public static final int blankLinesBeforeMethodsDefault = 1;
    public static final String addLeadingStarInComment = "addLeadingStarInComment";
    public static final Boolean addLeadingStarInCommentDefault;
    private static final String APACHE_PROFILE = "Apache";
    private static final String DEFAULT_PROFILE = "Default";
    private static final String GNU_PROFILE = "GNU";
    private static final String LUNIX_PROFILE = "Linux";
    private static final String ANSI_PROFILE = "ANSI";
    private static final String OPEN_SOLARIS_PROFILE = "OpenSolaris";
    private static final String K_AND_R_PROFILE = "KandR";
    private static final String MYSQL_PROFILE = "MySQL";
    public static final String[] PREDEFINED_STYLES;
    private static Map<String, Object> defaults;
    private static Map<String, Map<String, Object>> namedDefaults;
    private static Class<? extends EditorKit> cKitClass;
    private static Class<? extends EditorKit> cppKitClass;

    private static void createDefaults() {
        defaults = new HashMap<String, Object>();
        defaults.put(indentSize, 4);
        defaults.put(statementContinuationIndent, 8);
        defaults.put(indentPreprocessorDirectives, indentPreprocessorDirectivesDefault);
        defaults.put(sharpAtStartLine, true);
        defaults.put(indentNamespace, true);
        defaults.put(indentCasesFromSwitch, true);
        defaults.put(absoluteLabelIndent, true);
        defaults.put(newLineBeforeBraceNamespace, newLineBeforeBraceNamespaceDefault);
        defaults.put(newLineBeforeBraceClass, newLineBeforeBraceClassDefault);
        defaults.put(newLineBeforeBraceDeclaration, newLineBeforeBraceDeclarationDefault);
        defaults.put(ignoreEmptyFunctionBody, false);
        defaults.put(newLineBeforeBraceSwitch, newLineBeforeBraceSwitchDefault);
        defaults.put(newLineBeforeBrace, newLineBeforeBraceDefault);
        defaults.put(alignMultilineArrayInit, false);
        defaults.put(alignMultilineCallArgs, false);
        defaults.put(alignMultilineMethodParams, false);
        defaults.put(alignMultilineFor, false);
        defaults.put(alignMultilineIfCondition, false);
        defaults.put(alignMultilineWhileCondition, false);
        defaults.put(alignMultilineParen, false);
        defaults.put(newLineFunctionDefinitionName, false);
        defaults.put(newLineCatch, false);
        defaults.put(newLineElse, false);
        defaults.put(newLineWhile, false);
        defaults.put(spaceBeforeWhile, true);
        defaults.put(spaceBeforeElse, true);
        defaults.put(spaceBeforeCatch, true);
        defaults.put(spaceBeforeMethodDeclParen, false);
        defaults.put(spaceBeforeMethodCallParen, false);
        defaults.put(spaceBeforeIfParen, true);
        defaults.put(spaceBeforeForParen, true);
        defaults.put(spaceBeforeWhileParen, true);
        defaults.put(spaceBeforeCatchParen, true);
        defaults.put(spaceBeforeSwitchParen, true);
        defaults.put(spaceAroundUnaryOps, false);
        defaults.put(spaceAroundBinaryOps, true);
        defaults.put(spaceAroundTernaryOps, true);
        defaults.put(spaceAroundAssignOps, true);
        defaults.put(spaceBeforeClassDeclLeftBrace, true);
        defaults.put(spaceBeforeMethodDeclLeftBrace, true);
        defaults.put(spaceBeforeIfLeftBrace, true);
        defaults.put(spaceBeforeElseLeftBrace, true);
        defaults.put(spaceBeforeWhileLeftBrace, true);
        defaults.put(spaceBeforeForLeftBrace, true);
        defaults.put(spaceBeforeDoLeftBrace, true);
        defaults.put(spaceBeforeSwitchLeftBrace, true);
        defaults.put(spaceBeforeTryLeftBrace, true);
        defaults.put(spaceBeforeCatchLeftBrace, true);
        defaults.put(spaceBeforeArrayInitLeftBrace, false);
        defaults.put(spaceWithinParens, false);
        defaults.put(spaceWithinMethodDeclParens, false);
        defaults.put(spaceWithinMethodCallParens, false);
        defaults.put(spaceWithinIfParens, false);
        defaults.put(spaceWithinForParens, false);
        defaults.put(spaceWithinWhileParens, false);
        defaults.put(spaceWithinSwitchParens, false);
        defaults.put(spaceWithinCatchParens, false);
        defaults.put(spaceWithinTypeCastParens, false);
        defaults.put(spaceWithinBraces, false);
        defaults.put(spaceBeforeKeywordParen, true);
        defaults.put(spaceBeforeComma, false);
        defaults.put(spaceAfterComma, true);
        defaults.put(spaceBeforeSemi, false);
        defaults.put(spaceAfterSemi, true);
        defaults.put(spaceBeforeColon, true);
        defaults.put(spaceAfterColon, true);
        defaults.put(spaceAfterTypeCast, true);
        defaults.put(blankLinesBeforeClass, 1);
        defaults.put(blankLinesAfterClassHeader, 0);
        defaults.put(blankLinesBeforeMethods, 1);
        defaults.put(addLeadingStarInComment, addLeadingStarInCommentDefault);
        namedDefaults = new HashMap<String, Map<String, Object>>();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        namedDefaults.put(APACHE_PROFILE, hashMap);
        hashMap.put(indentCasesFromSwitch, false);
        hashMap.put(alignMultilineCallArgs, true);
        hashMap.put(alignMultilineMethodParams, true);
        hashMap.put(alignMultilineIfCondition, true);
        hashMap.put(alignMultilineWhileCondition, true);
        hashMap.put(newLineCatch, true);
        hashMap.put(newLineElse, true);
        hashMap.put(newLineWhile, true);
        hashMap.put(newLineBeforeBraceNamespace, CodeStyle.BracePlacement.NEW_LINE.name());
        hashMap.put(newLineBeforeBraceClass, CodeStyle.BracePlacement.NEW_LINE.name());
        hashMap.put(newLineBeforeBraceDeclaration, CodeStyle.BracePlacement.NEW_LINE.name());
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        namedDefaults.put(GNU_PROFILE, hashMap2);
        hashMap2.put(indentCasesFromSwitch, false);
        hashMap2.put(alignMultilineCallArgs, true);
        hashMap2.put(alignMultilineMethodParams, true);
        hashMap2.put(alignMultilineIfCondition, true);
        hashMap2.put(alignMultilineWhileCondition, true);
        hashMap2.put(alignMultilineParen, true);
        hashMap2.put(spaceBeforeMethodCallParen, true);
        hashMap2.put(spaceBeforeMethodDeclParen, true);
        hashMap2.put(newLineFunctionDefinitionName, true);
        hashMap2.put(newLineCatch, true);
        hashMap2.put(newLineElse, true);
        hashMap2.put(newLineWhile, true);
        hashMap2.put(newLineBeforeBraceNamespace, CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED.name());
        hashMap2.put(newLineBeforeBraceClass, CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED.name());
        hashMap2.put(newLineBeforeBraceDeclaration, CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED.name());
        hashMap2.put(newLineBeforeBraceSwitch, CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED.name());
        hashMap2.put(newLineBeforeBrace, CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED.name());
        hashMap2.put(ignoreEmptyFunctionBody, true);
        HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
        namedDefaults.put(LUNIX_PROFILE, hashMap3);
        hashMap3.put(indentCasesFromSwitch, false);
        hashMap3.put(indentSize, 8);
        hashMap3.put(newLineBeforeBraceDeclaration, CodeStyle.BracePlacement.NEW_LINE.name());
        hashMap3.put(spaceBeforeKeywordParen, false);
        HashMap<String, Object> hashMap4 = new HashMap<String, Object>();
        namedDefaults.put(ANSI_PROFILE, hashMap4);
        hashMap4.put(newLineBeforeBraceNamespace, CodeStyle.BracePlacement.NEW_LINE.name());
        hashMap4.put(newLineBeforeBraceClass, CodeStyle.BracePlacement.NEW_LINE.name());
        hashMap4.put(newLineBeforeBraceDeclaration, CodeStyle.BracePlacement.NEW_LINE.name());
        hashMap4.put(newLineBeforeBraceSwitch, CodeStyle.BracePlacement.NEW_LINE.name());
        hashMap4.put(newLineBeforeBrace, CodeStyle.BracePlacement.NEW_LINE.name());
        hashMap4.put(alignMultilineMethodParams, true);
        hashMap4.put(alignMultilineCallArgs, true);
        hashMap4.put(newLineCatch, true);
        hashMap4.put(newLineElse, true);
        hashMap4.put(newLineWhile, true);
        hashMap4.put(indentCasesFromSwitch, false);
        hashMap4.put(indentNamespace, false);
        HashMap<String, Object> hashMap5 = new HashMap<String, Object>();
        namedDefaults.put(OPEN_SOLARIS_PROFILE, hashMap5);
        hashMap5.put(newLineBeforeBraceNamespace, CodeStyle.BracePlacement.NEW_LINE.name());
        hashMap5.put(newLineBeforeBraceClass, CodeStyle.BracePlacement.NEW_LINE.name());
        hashMap5.put(newLineBeforeBraceDeclaration, CodeStyle.BracePlacement.NEW_LINE.name());
        hashMap5.put(newLineFunctionDefinitionName, true);
        hashMap5.put(indentSize, 8);
        hashMap5.put(alignMultilineCallArgs, true);
        hashMap5.put(alignMultilineMethodParams, true);
        hashMap5.put(alignMultilineIfCondition, true);
        hashMap5.put(alignMultilineWhileCondition, true);
        hashMap5.put(alignMultilineFor, true);
        hashMap5.put(indentCasesFromSwitch, false);
        HashMap<String, Object> hashMap6 = new HashMap<String, Object>();
        namedDefaults.put(K_AND_R_PROFILE, hashMap6);
        hashMap6.put(absoluteLabelIndent, false);
        hashMap6.put(indentCasesFromSwitch, false);
        hashMap6.put(indentNamespace, false);
        hashMap6.put(newLineBeforeBraceDeclaration, CodeStyle.BracePlacement.NEW_LINE.name());
        HashMap<String, Object> hashMap7 = new HashMap<String, Object>();
        namedDefaults.put(MYSQL_PROFILE, hashMap7);
        hashMap7.put(indentCasesFromSwitch, false);
        hashMap7.put(indentSize, 2);
        hashMap7.put(newLineBeforeBraceNamespace, CodeStyle.BracePlacement.NEW_LINE.name());
        hashMap7.put(newLineBeforeBraceClass, CodeStyle.BracePlacement.NEW_LINE.name());
        hashMap7.put(newLineBeforeBraceDeclaration, CodeStyle.BracePlacement.NEW_LINE.name());
        hashMap7.put(newLineBeforeBrace, CodeStyle.BracePlacement.NEW_LINE.name());
        hashMap7.put(alignMultilineCallArgs, true);
        hashMap7.put(alignMultilineWhileCondition, true);
        hashMap7.put(alignMultilineFor, true);
        hashMap7.put(alignMultilineMethodParams, true);
        hashMap7.put(alignMultilineIfCondition, true);
        hashMap7.put(spaceAroundAssignOps, false);
        hashMap7.put(addLeadingStarInComment, false);
    }

    public static Object getDefault(CodeStyle.Language language, String string, String string2) {
        Object object;
        Map<String, Object> map = namedDefaults.get(string);
        if (map != null && (object = map.get(string2)) != null) {
            return object;
        }
        return defaults.get(string2);
    }

    public static String getCurrentProfileId(CodeStyle.Language language) {
        switch (language) {
            case C: {
                return NbPreferences.forModule(CodeStyle.class).node("CodeStyle").get("C_Style", DEFAULT_PROFILE);
            }
        }
        return NbPreferences.forModule(CodeStyle.class).node("CodeStyle").get("CPP_Style", DEFAULT_PROFILE);
    }

    public static void setCurrentProfileId(CodeStyle.Language language, String string) {
        switch (language) {
            case C: {
                NbPreferences.forModule(CodeStyle.class).node("CodeStyle").put("C_Style", string);
                break;
            }
            default: {
                NbPreferences.forModule(CodeStyle.class).node("CodeStyle").put("CPP_Style", string);
            }
        }
    }

    private static String getString(String string) {
        return NbBundle.getMessage(EditorOptions.class, (String)string);
    }

    public static String getStyleDisplayName(CodeStyle.Language language, String string) {
        for (String string2 : PREDEFINED_STYLES) {
            if (!string.equals(string2)) continue;
            return EditorOptions.getString(string + "_Name");
        }
        switch (language) {
            case C: {
                return NbPreferences.forModule(CodeStyle.class).node("CodeStyle").get(string + "_Style_Name", string);
            }
        }
        return NbPreferences.forModule(CodeStyle.class).node("CodeStyle").get(string + "_Style_Name", string);
    }

    public static Preferences getPreferences(CodeStyle.Language language, String string) {
        switch (language) {
            case C: {
                return NbPreferences.forModule(CodeStyle.class).node("C_CodeStyles").node(string);
            }
        }
        return NbPreferences.forModule(CodeStyle.class).node("CPP_CodeStyles").node(string);
    }

    public static List<String> getAllStyles(CodeStyle.Language language) {
        String string = null;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : PREDEFINED_STYLES) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string2);
        }
        switch (language) {
            case C: {
                string = NbPreferences.forModule(CodeStyle.class).node("C_CodeStyles").get("List_Of_Styles", stringBuilder.toString());
                break;
            }
            default: {
                string = NbPreferences.forModule(CodeStyle.class).node("CPP_CodeStyles").get("List_Of_Styles", stringBuilder.toString());
            }
        }
        ArrayList arrayList = new ArrayList();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public static void setAllStyles(CodeStyle.Language language, String string) {
        switch (language) {
            case C: {
                NbPreferences.forModule(CodeStyle.class).node("C_CodeStyles").put("List_Of_Styles", string);
                break;
            }
            default: {
                NbPreferences.forModule(CodeStyle.class).node("CPP_CodeStyles").put("List_Of_Styles", string);
            }
        }
    }

    public static int getGlobalTabSize(CodeStyle.Language language) {
        Formatter formatter = (Formatter)Settings.getValue(EditorOptions.getKitClass(language), (String)"formatter");
        if (formatter != null) {
            return formatter.getTabSize();
        }
        return 4;
    }

    private static Class<? extends EditorKit> getKitClass(CodeStyle.Language language) {
        if (language == CodeStyle.Language.C) {
            if (cKitClass == null) {
                EditorKit editorKit = (EditorKit)MimeLookup.getLookup((MimePath)MimePath.get((String)"text/x-c")).lookup(EditorKit.class);
                cKitClass = editorKit != null ? editorKit.getClass() : EditorKit.class;
            }
            return cKitClass;
        }
        if (cppKitClass == null) {
            EditorKit editorKit = (EditorKit)MimeLookup.getLookup((MimePath)MimePath.get((String)"text/x-c++")).lookup(EditorKit.class);
            cppKitClass = editorKit != null ? editorKit.getClass() : EditorKit.class;
        }
        return cppKitClass;
    }

    public static CodeStyle createCodeStyle(CodeStyle.Language language, Preferences preferences) {
        CodeStyle.getDefault(language);
        return codeStyleFactory.create(language, preferences);
    }

    public static Preferences getPreferences(CodeStyle codeStyle) {
        return codeStyleFactory.getPreferences(codeStyle);
    }

    public static void resetToDefault(CodeStyle codeStyle) {
        Preferences preferences = EditorOptions.getPreferences(codeStyle);
        for (Map.Entry<String, Object> entry : defaults.entrySet()) {
            if (entry.getValue() instanceof Boolean) {
                preferences.putBoolean(entry.getKey(), (Boolean)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Integer) {
                preferences.putInt(entry.getKey(), (Integer)entry.getValue());
                continue;
            }
            preferences.put(entry.getKey(), entry.getValue().toString());
        }
    }

    public static void resetToDefault(CodeStyle codeStyle, String string) {
        Preferences preferences = EditorOptions.getPreferences(codeStyle);
        for (Map.Entry<String, Object> entry : namedDefaults.get(string).entrySet()) {
            if (entry.getValue() instanceof Boolean) {
                preferences.putBoolean(entry.getKey(), (Boolean)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Integer) {
                preferences.putInt(entry.getKey(), (Integer)entry.getValue());
                continue;
            }
            preferences.put(entry.getKey(), entry.getValue().toString());
        }
    }

    public static Set<String> keys() {
        return defaults.keySet();
    }

    public static void setPreferences(CodeStyle codeStyle, Preferences preferences) {
        codeStyleFactory.setPreferences(codeStyle, preferences);
    }

    static {
        Class<CodeStyle> clazz = CodeStyle.class;
        try {
            Class.forName(clazz.getName(), true, clazz.getClassLoader());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        indentPreprocessorDirectivesDefault = CodeStyle.PreprocessorIndent.START_LINE.name();
        newLineBeforeBraceNamespaceDefault = CodeStyle.BracePlacement.SAME_LINE.name();
        newLineBeforeBraceClassDefault = CodeStyle.BracePlacement.SAME_LINE.name();
        newLineBeforeBraceDeclarationDefault = CodeStyle.BracePlacement.SAME_LINE.name();
        newLineBeforeBraceDefault = CodeStyle.BracePlacement.SAME_LINE.name();
        newLineBeforeBraceSwitchDefault = CodeStyle.BracePlacement.SAME_LINE.name();
        addLeadingStarInCommentDefault = true;
        PREDEFINED_STYLES = new String[]{DEFAULT_PROFILE, APACHE_PROFILE, GNU_PROFILE, LUNIX_PROFILE, ANSI_PROFILE, OPEN_SOLARIS_PROFILE, K_AND_R_PROFILE, MYSQL_PROFILE};
        EditorOptions.createDefaults();
    }

    public static interface CodeStyleFactory {
        public CodeStyle create(CodeStyle.Language var1, Preferences var2);

        public Preferences getPreferences(CodeStyle var1);

        public void setPreferences(CodeStyle var1, Preferences var2);
    }
}

