/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.cplusplus;

import org.netbeans.editor.ImageTokenID;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtFormatSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.cplusplus.CCTokenContext;
import org.openide.util.NbBundle;

public class CCFormatSupport
extends ExtFormatSupport {
    private TokenContextPath tokenContextPath;
    private CodeStyle codeStyle;

    public CCFormatSupport(FormatWriter formatWriter) {
        this(formatWriter, CCTokenContext.contextPath);
    }

    private CCFormatSupport(FormatWriter formatWriter, TokenContextPath tokenContextPath) {
        super(formatWriter);
        this.tokenContextPath = tokenContextPath;
        this.codeStyle = CodeStyle.getDefault(formatWriter.getDocument());
    }

    public TokenContextPath getTokenContextPath() {
        return this.tokenContextPath;
    }

    public boolean isComment(TokenItem tokenItem, int n) {
        TokenID tokenID = tokenItem.getTokenID();
        return tokenItem.getTokenContextPath() == this.tokenContextPath && (tokenID == CCTokenContext.LINE_COMMENT || tokenID == CCTokenContext.BLOCK_COMMENT);
    }

    public boolean isPreprocessorAtLineStart(TokenItem tokenItem) {
        FormatTokenPosition formatTokenPosition;
        if (this.getFormatSpaceBeforeMethodCallParenthesis()) {
            return false;
        }
        if (tokenItem != null && (formatTokenPosition = this.findLineFirstNonWhitespace(this.getPosition(tokenItem, 0))) != null) {
            tokenItem = formatTokenPosition.getToken();
        }
        return tokenItem != null && tokenItem.getImage().startsWith("#");
    }

    public boolean isPreprocessorLine(TokenItem tokenItem) {
        FormatTokenPosition formatTokenPosition;
        if (tokenItem != null && (formatTokenPosition = this.findLineFirstNonWhitespace(this.getPosition(tokenItem, 0))) != null) {
            if (this.isEndBackSlashedLine(formatTokenPosition)) {
                FormatTokenPosition formatTokenPosition2;
                formatTokenPosition = formatTokenPosition2 = this.findPreviousEOL(formatTokenPosition);
                while (formatTokenPosition2 != null && this.isBackSlashEndLine(formatTokenPosition2)) {
                    formatTokenPosition = formatTokenPosition2;
                    formatTokenPosition2 = this.findPreviousEOL(formatTokenPosition2);
                }
                formatTokenPosition = this.findLineFirstNonWhitespace(formatTokenPosition);
            } else if (this.isBackSlashEndLine(formatTokenPosition)) {
                FormatTokenPosition formatTokenPosition3 = formatTokenPosition;
                formatTokenPosition3 = this.findPreviousEOL(formatTokenPosition3);
                while (formatTokenPosition3 != null && this.isBackSlashEndLine(formatTokenPosition3)) {
                    formatTokenPosition = formatTokenPosition3;
                    formatTokenPosition3 = this.findPreviousEOL(formatTokenPosition3);
                }
                formatTokenPosition = this.findLineFirstNonWhitespace(formatTokenPosition);
            }
            if (formatTokenPosition != null) {
                tokenItem = formatTokenPosition.getToken();
            }
        }
        return tokenItem != null && tokenItem.getImage().startsWith("#");
    }

    public boolean isEndBackSlashedLine(FormatTokenPosition formatTokenPosition) {
        TokenItem tokenItem;
        FormatTokenPosition formatTokenPosition2 = this.findPreviousEOL(formatTokenPosition);
        if (formatTokenPosition2 != null && (tokenItem = formatTokenPosition2.getToken()) != null && (formatTokenPosition2 = this.findLineFirstNonWhitespace(this.getPosition(tokenItem, 0))) != null) {
            return this.isBackSlashEndLine(formatTokenPosition2);
        }
        return false;
    }

    public boolean isBackSlashEndLine(FormatTokenPosition formatTokenPosition) {
        TokenItem tokenItem;
        FormatTokenPosition formatTokenPosition2 = this.findLineEndNonImportant(formatTokenPosition);
        if (formatTokenPosition2 != null && (tokenItem = formatTokenPosition2.getToken()) != null) {
            if (tokenItem.getTokenID() == CCTokenContext.BACKSLASH || tokenItem.getTokenID() == CCTokenContext.INVALID_BACKSLASH) {
                return true;
            }
            return (tokenItem = tokenItem.getPrevious()) != null && (tokenItem.getTokenID() == CCTokenContext.BACKSLASH || tokenItem.getTokenID() == CCTokenContext.INVALID_BACKSLASH);
        }
        return false;
    }

    public boolean isMultiLineComment(TokenItem tokenItem) {
        return tokenItem.getTokenID() == CCTokenContext.BLOCK_COMMENT;
    }

    public boolean isMultiLineComment(FormatTokenPosition formatTokenPosition) {
        TokenItem tokenItem = formatTokenPosition.getToken();
        return tokenItem == null ? false : this.isMultiLineComment(tokenItem);
    }

    public boolean isCCDocComment(TokenItem tokenItem) {
        return this.isMultiLineComment(tokenItem) && tokenItem.getImage().startsWith("/*");
    }

    public TokenID getWhitespaceTokenID() {
        return CCTokenContext.WHITESPACE;
    }

    public TokenContextPath getWhitespaceTokenContextPath() {
        return this.tokenContextPath;
    }

    public boolean canModifyWhitespace(TokenItem tokenItem) {
        if (tokenItem.getTokenContextPath() == CCTokenContext.contextPath) {
            switch (tokenItem.getTokenID().getNumericID()) {
                case 6: 
                case 9: {
                    return true;
                }
            }
        }
        return false;
    }

    public TokenItem findStatement(TokenItem tokenItem) {
        TokenItem tokenItem2 = null;
        boolean bl = true;
        for (TokenItem tokenItem3 = this.getPreviousToken(tokenItem); tokenItem3 != null; tokenItem3 = tokenItem3.getPrevious()) {
            if (tokenItem3.getTokenContextPath() != this.tokenContextPath) continue;
            switch (tokenItem3.getTokenID().getNumericID()) {
                case 58: {
                    if (this.isForLoopSemicolon(tokenItem3)) break;
                    return tokenItem2 != null ? tokenItem2 : tokenItem3;
                }
                case 64: 
                case 103: {
                    return tokenItem2 != null ? tokenItem2 : tokenItem3;
                }
                case 65: {
                    if (!this.isArrayInitializationBraceBlock(tokenItem3, null)) {
                        return tokenItem2 != null ? tokenItem2 : tokenItem3;
                    }
                    tokenItem3 = this.findMatchingToken(tokenItem3, null, (ImageTokenID)CCTokenContext.LBRACE, true);
                    break;
                }
                case 56: {
                    TokenItem tokenItem4;
                    TokenItem tokenItem5 = this.findAnyToken(tokenItem3, null, new TokenID[]{CCTokenContext.CASE, CCTokenContext.DEFAULT, CCTokenContext.QUESTION}, tokenItem3.getTokenContextPath(), true);
                    if (tokenItem5 != null) {
                        switch (tokenItem5.getTokenID().getNumericID()) {
                            case 95: 
                            case 100: {
                                return tokenItem2 != null ? tokenItem2 : tokenItem3;
                            }
                        }
                    }
                    if ((tokenItem4 = this.findImportantToken(tokenItem3, null, true, true)) != null && tokenItem4.getTokenID().getNumericID() == 61) {
                        tokenItem3 = tokenItem4;
                        break;
                    }
                    if (tokenItem2 != null && bl && tokenItem5 == null) {
                        return tokenItem2;
                    }
                    bl = false;
                    break;
                }
                case 95: 
                case 100: 
                case 102: 
                case 121: {
                    return tokenItem3;
                }
                case 107: 
                case 110: 
                case 130: {
                    TokenItem tokenItem6;
                    if (tokenItem2 != null && tokenItem2.getTokenID() == CCTokenContext.LPAREN && (tokenItem6 = this.findMatchingToken(tokenItem2, tokenItem, (ImageTokenID)CCTokenContext.RPAREN, false)) != null && tokenItem6.getNext() != null && (tokenItem6 = this.findImportantToken(tokenItem6.getNext(), tokenItem, false, true)) != null) {
                        return tokenItem6;
                    }
                    return tokenItem3;
                }
            }
            if (this.isPreprocessorLine(tokenItem3) || !this.isImportant(tokenItem3, 0)) continue;
            tokenItem2 = tokenItem3;
        }
        return tokenItem2;
    }

    public TokenItem findIf(TokenItem tokenItem) {
        if (tokenItem == null || !this.tokenEquals(tokenItem, (TokenID)CCTokenContext.ELSE, this.tokenContextPath)) {
            throw new IllegalArgumentException(NbBundle.getBundle(CCFormatSupport.class).getString("MSG_AcceptOnlyElse"));
        }
        int n = 0;
        int n2 = 0;
        block7: while ((tokenItem = this.findStatement(tokenItem)) != null) {
            switch (tokenItem.getTokenID().getNumericID()) {
                case 64: {
                    if (--n >= 0) break;
                    return null;
                }
                case 65: {
                    ++n;
                    break;
                }
                case 103: {
                    if (n != 0) break;
                    ++n2;
                    break;
                }
                case 56: 
                case 58: 
                case 95: 
                case 100: 
                case 102: 
                case 107: 
                case 130: {
                    break;
                }
                case 110: {
                    if (n != 0 || n2-- != 0) continue block7;
                    return tokenItem;
                }
            }
        }
        return null;
    }

    public TokenItem findSwitch(TokenItem tokenItem) {
        if (tokenItem == null || !this.tokenEquals(tokenItem, (TokenID)CCTokenContext.CASE, this.tokenContextPath) && !this.tokenEquals(tokenItem, (TokenID)CCTokenContext.DEFAULT, this.tokenContextPath)) {
            throw new IllegalArgumentException(NbBundle.getBundle(CCFormatSupport.class).getString("MSG_AcceptOlyCaseDefault"));
        }
        int n = 1;
        while ((tokenItem = this.findStatement(tokenItem)) != null) {
            switch (tokenItem.getTokenID().getNumericID()) {
                case 64: {
                    if (--n >= 0) break;
                    return null;
                }
                case 65: {
                    ++n;
                    break;
                }
                case 100: 
                case 121: {
                    if (n != 0) break;
                    return tokenItem;
                }
            }
        }
        return null;
    }

    private TokenItem findClassifier(TokenItem tokenItem) {
        int n = 1;
        TokenItem tokenItem2 = tokenItem;
        while ((tokenItem2 = this.findStatement(tokenItem2)) != null) {
            switch (tokenItem2.getTokenID().getNumericID()) {
                case 64: {
                    if (--n < 0) {
                        return null;
                    }
                    if (n != 0) break;
                    while ((tokenItem2 = tokenItem2.getPrevious()) != null) {
                        switch (tokenItem2.getTokenID().getNumericID()) {
                            case 75: 
                            case 85: 
                            case 93: 
                            case 97: {
                                return tokenItem2;
                            }
                        }
                    }
                    return null;
                }
                case 65: {
                    ++n;
                }
            }
        }
        return null;
    }

    public TokenItem findTry(TokenItem tokenItem) {
        if (tokenItem == null || !this.tokenEquals(tokenItem, (TokenID)CCTokenContext.CATCH, this.tokenContextPath)) {
            throw new IllegalArgumentException(NbBundle.getBundle(CCFormatSupport.class).getString("MSG_AcceptOnlyCatch"));
        }
        int n = 0;
        while ((tokenItem = this.findStatement(tokenItem)) != null) {
            switch (tokenItem.getTokenID().getNumericID()) {
                case 64: {
                    if (--n >= 0) break;
                    return null;
                }
                case 65: {
                    ++n;
                    break;
                }
                case 126: {
                    if (n != 0) break;
                    return tokenItem;
                }
            }
        }
        return null;
    }

    public TokenItem findStatementStart(TokenItem tokenItem) {
        TokenItem tokenItem2 = this.findStatementStart(tokenItem, true);
        while (tokenItem2 != null && this.isPreprocessorLine(tokenItem2)) {
            TokenItem tokenItem3 = tokenItem2.getPrevious();
            if (tokenItem3 == null) {
                return null;
            }
            tokenItem2 = this.findStatementStart(tokenItem3, true);
        }
        return tokenItem2;
    }

    public TokenItem findStatementStart(TokenItem tokenItem, boolean bl) {
        TokenItem tokenItem2 = this.findStatement(tokenItem);
        if (tokenItem2 != null) {
            switch (tokenItem2.getTokenID().getNumericID()) {
                case 58: {
                    TokenItem tokenItem3 = this.findStatement(tokenItem2);
                    if (tokenItem3 == null) {
                        return tokenItem;
                    }
                    switch (tokenItem3.getTokenID().getNumericID()) {
                        case 56: 
                        case 58: 
                        case 64: 
                        case 65: 
                        case 95: 
                        case 100: {
                            return tokenItem2;
                        }
                        case 102: 
                        case 107: 
                        case 110: 
                        case 115: 
                        case 116: 
                        case 117: 
                        case 130: {
                            return this.findStatementStart(tokenItem2, bl);
                        }
                        case 103: {
                            TokenItem tokenItem4 = this.findIf(tokenItem3);
                            if (tokenItem4 != null) {
                                return this.findStatementStart(tokenItem4, bl);
                            }
                            return tokenItem3;
                        }
                    }
                    TokenItem tokenItem5 = this.findStatement(tokenItem3);
                    if (tokenItem5 != null) {
                        switch (tokenItem5.getTokenID().getNumericID()) {
                            case 56: 
                            case 58: 
                            case 64: 
                            case 65: {
                                return tokenItem3;
                            }
                            case 102: 
                            case 107: 
                            case 110: 
                            case 130: {
                                return this.findStatementStart(tokenItem5, bl);
                            }
                            case 103: {
                                TokenItem tokenItem6 = this.findIf(tokenItem5);
                                if (tokenItem6 != null) {
                                    return this.findStatementStart(tokenItem6, bl);
                                }
                                return tokenItem5;
                            }
                        }
                    }
                    return tokenItem3;
                }
                case 64: {
                    return tokenItem;
                }
                case 65: {
                    TokenItem tokenItem7;
                    TokenItem tokenItem8 = this.findMatchingToken(tokenItem2, null, (ImageTokenID)CCTokenContext.LBRACE, true);
                    if (tokenItem8 != null && (tokenItem7 = this.findStatement(tokenItem8)) != null) {
                        switch (tokenItem7.getTokenID().getNumericID()) {
                            case 103: {
                                TokenItem tokenItem9 = this.findIf(tokenItem7);
                                if (tokenItem9 != null) {
                                    return this.findStatementStart(tokenItem9, bl);
                                }
                                return tokenItem7;
                            }
                            case 96: {
                                TokenItem tokenItem10 = this.findTry(tokenItem7);
                                if (tokenItem10 != null) {
                                    return this.findStatementStart(tokenItem10, bl);
                                }
                                return tokenItem7;
                            }
                            case 102: 
                            case 107: 
                            case 110: 
                            case 130: {
                                return this.findStatementStart(tokenItem7, bl);
                            }
                        }
                        if (tokenItem7.getTokenID().getNumericID() == 64) {
                            return tokenItem2;
                        }
                        return tokenItem7;
                    }
                    return tokenItem2;
                }
                case 56: 
                case 95: 
                case 100: {
                    return tokenItem;
                }
                case 103: {
                    TokenItem tokenItem11 = this.findIf(tokenItem2);
                    return tokenItem11 != null ? this.findStatementStart(tokenItem11, bl) : tokenItem2;
                }
                case 102: 
                case 107: 
                case 110: 
                case 130: {
                    if (!bl) {
                        return tokenItem2;
                    }
                    return this.findStatementStart(tokenItem2, bl);
                }
                case 7: {
                    return tokenItem2;
                }
            }
            return tokenItem2;
        }
        return tokenItem;
    }

    public int getTokenIndent(TokenItem tokenItem, boolean bl) {
        FormatTokenPosition formatTokenPosition = this.getPosition(tokenItem, 0);
        FormatTokenPosition formatTokenPosition2 = bl ? this.findLineFirstNonWhitespace(formatTokenPosition) : this.findLineFirstNonWhitespaceAndNonLeftBrace(formatTokenPosition);
        if (formatTokenPosition2 != null) {
            formatTokenPosition = formatTokenPosition2;
        }
        return this.getVisualColumnOffset(formatTokenPosition);
    }

    public int getTokenIndent(TokenItem tokenItem) {
        return this.getTokenIndent(tokenItem, false);
    }

    private int getRightIndent() {
        int n = this.getShiftWidth();
        if (this.isHalfIndentNewlineBeforeBrace()) {
            return n / 2;
        }
        return n;
    }

    private int getRightIndentSwitch() {
        int n = this.getShiftWidth();
        if (this.isHalfIndentNewlineBeforeBrace()) {
            return n / 2;
        }
        return n;
    }

    private int getRightIndentDeclaration() {
        int n = this.getShiftWidth();
        if (this.isHalfIndentNewlineBeforeBraceDeclaration()) {
            return n / 2;
        }
        return n;
    }

    public int findIndent(TokenItem tokenItem) {
        TokenItem tokenItem2;
        TokenItem tokenItem3;
        TokenItem tokenItem4;
        TokenItem tokenItem5;
        TokenItem tokenItem6;
        int n = -1;
        if (tokenItem != null) {
            block0 : switch (tokenItem.getTokenID().getNumericID()) {
                case 103: {
                    tokenItem6 = this.findIf(tokenItem);
                    if (tokenItem6 == null) break;
                    n = this.getTokenIndent(tokenItem6);
                    break;
                }
                case 64: {
                    tokenItem5 = this.findStatement(tokenItem);
                    if (tokenItem5 == null) {
                        n = 0;
                        break;
                    }
                    switch (tokenItem5.getTokenID().getNumericID()) {
                        case 70: 
                        case 96: 
                        case 102: 
                        case 103: 
                        case 107: 
                        case 110: 
                        case 126: 
                        case 130: {
                            n = this.getTokenIndent(tokenItem5);
                            if (!this.isHalfIndentNewlineBeforeBrace()) break block0;
                            n += this.getShiftWidth() / 2;
                            break block0;
                        }
                        case 121: {
                            n = this.getTokenIndent(tokenItem5);
                            if (!this.isHalfIndentNewlineBeforeBraceSwitch()) break block0;
                            n += this.getShiftWidth() / 2;
                            break block0;
                        }
                        case 64: {
                            n = this.getTokenIndent(tokenItem5) + this.getShiftWidth();
                            break block0;
                        }
                    }
                    tokenItem5 = this.findStatementStart(tokenItem);
                    if (tokenItem5 == null) {
                        n = 0;
                        break;
                    }
                    if (tokenItem5 == tokenItem) {
                        tokenItem5 = this.findStatement(tokenItem);
                        n = tokenItem5 != null ? (n = this.getTokenIndent(tokenItem5)) : 0;
                        break;
                    }
                    n = this.getTokenIndent(tokenItem5);
                    switch (tokenItem5.getTokenID().getNumericID()) {
                        case 64: {
                            n += this.getShiftWidth();
                        }
                    }
                    break;
                }
                case 65: {
                    tokenItem4 = this.findMatchingToken(tokenItem, null, (ImageTokenID)CCTokenContext.LBRACE, true);
                    if (tokenItem4 != null) {
                        tokenItem3 = this.findStatement(tokenItem4);
                        boolean bl = false;
                        if (tokenItem3 == null) {
                            tokenItem3 = tokenItem4;
                        } else {
                            switch (tokenItem3.getTokenID().getNumericID()) {
                                case 58: 
                                case 64: 
                                case 65: {
                                    tokenItem3 = tokenItem4;
                                    bl = true;
                                }
                            }
                        }
                        n = this.getTokenIndent(tokenItem3, bl);
                        switch (tokenItem3.getTokenID().getNumericID()) {
                            case 70: 
                            case 96: 
                            case 102: 
                            case 103: 
                            case 107: 
                            case 110: 
                            case 126: 
                            case 130: {
                                if (!this.isHalfIndentNewlineBeforeBrace()) break;
                                n += this.getShiftWidth() / 2;
                                break;
                            }
                            case 121: {
                                if (!this.isHalfIndentNewlineBeforeBraceSwitch()) break;
                                n += this.getShiftWidth() / 2;
                            }
                        }
                        break;
                    }
                    n = this.getTokenIndent(tokenItem);
                    break;
                }
                case 95: 
                case 100: {
                    tokenItem3 = this.findSwitch(tokenItem);
                    if (tokenItem3 == null) break;
                    n = this.getTokenIndent(tokenItem3);
                    if (this.indentCasesFromSwitch()) {
                        n += this.getShiftWidth();
                        break;
                    }
                    if (!this.isHalfIndentNewlineBeforeBraceSwitch()) break;
                    n += this.getShiftWidth() / 2;
                    break;
                }
                case 115: 
                case 116: 
                case 117: {
                    TokenItem tokenItem7 = this.findClassifier(tokenItem);
                    if (tokenItem7 == null) break;
                    n = this.getTokenIndent(tokenItem7);
                    break;
                }
                case 85: 
                case 97: {
                    tokenItem2 = this.findClassifierStart(tokenItem);
                    if (tokenItem2 == null) break;
                    n = this.getTokenIndent(tokenItem2);
                }
            }
        }
        if (n < 0 && (tokenItem6 = this.findImportantToken(tokenItem, null, true, true)) != null) {
            block23 : switch (tokenItem6.getTokenID().getNumericID()) {
                case 58: {
                    tokenItem5 = this.findStatementStart(tokenItem);
                    while (tokenItem5 != null && (this.isPreprocessorLine(tokenItem5) || tokenItem5.getImage().startsWith("\n"))) {
                        tokenItem5 = this.findStatementStart(tokenItem5.getPrevious());
                    }
                    if (tokenItem5 != null) {
                        switch (tokenItem5.getTokenID().getNumericID()) {
                            case 115: 
                            case 116: 
                            case 117: {
                                n = this.getTokenIndent(tokenItem5) + this.getShiftWidth();
                                break block23;
                            }
                        }
                        n = this.getTokenIndent(tokenItem5);
                        break;
                    }
                    n = this.getTokenIndent(tokenItem5);
                    break;
                }
                case 64: {
                    tokenItem4 = this.findStatementStart(tokenItem6, false);
                    if (tokenItem4 == null) {
                        tokenItem4 = tokenItem6;
                    }
                    switch (tokenItem4.getTokenID().getNumericID()) {
                        case 70: 
                        case 96: 
                        case 102: 
                        case 103: 
                        case 107: 
                        case 110: 
                        case 121: 
                        case 126: 
                        case 130: {
                            n = this.getTokenIndent(tokenItem4) + this.getShiftWidth();
                            break block23;
                        }
                    }
                    n = this.getTokenIndent(tokenItem4) + this.getRightIndentDeclaration();
                    break;
                }
                case 65: {
                    tokenItem3 = this.findStatementStart(tokenItem);
                    n = this.getTokenIndent(tokenItem3);
                    break;
                }
                case 56: {
                    TokenItem tokenItem8 = this.getVisibility(tokenItem6);
                    if (tokenItem8 != null) {
                        n = this.getTokenIndent(tokenItem8) + this.getRightIndentDeclaration();
                        break;
                    }
                    tokenItem8 = this.findAnyToken(tokenItem6, null, new TokenID[]{CCTokenContext.CASE, CCTokenContext.DEFAULT, CCTokenContext.QUESTION, CCTokenContext.PRIVATE, CCTokenContext.PROTECTED, CCTokenContext.PUBLIC}, tokenItem6.getTokenContextPath(), true);
                    if (tokenItem8 != null) {
                        int n2 = tokenItem8.getTokenID().getNumericID();
                        if (n2 == 59) {
                            n = this.getTokenIndent(tokenItem8) + this.getShiftWidth();
                            break;
                        }
                        if (n2 == 95 || n2 == 100) {
                            n = this.getTokenIndent(tokenItem8) + this.getRightIndentSwitch();
                            break;
                        }
                        n = this.getTokenIndent(tokenItem6);
                        break;
                    }
                    n = this.getTokenIndent(tokenItem6);
                    break;
                }
                case 59: {
                    n = this.getTokenIndent(tokenItem6) + this.getShiftWidth();
                    break;
                }
                case 102: 
                case 103: {
                    n = this.getTokenIndent(tokenItem6) + this.getRightIndent();
                    break;
                }
                case 61: {
                    tokenItem2 = this.findMatchingToken(tokenItem6, null, (ImageTokenID)CCTokenContext.LPAREN, true);
                    if (tokenItem2 != null && (tokenItem2 = this.findImportantToken(tokenItem2, null, true, true)) != null && tokenItem2.getTokenContextPath() == this.tokenContextPath) {
                        switch (tokenItem2.getTokenID().getNumericID()) {
                            case 107: 
                            case 110: 
                            case 130: {
                                n = this.getTokenIndent(tokenItem2) + this.getRightIndent();
                                break;
                            }
                            case 7: {
                                if (tokenItem == null || tokenItem.getTokenID().getNumericID() != 7) break;
                                n = this.getTokenIndent(tokenItem6);
                            }
                        }
                    }
                    if (n >= 0) break;
                    n = this.computeStatementIndent(tokenItem);
                    break;
                }
                case 7: {
                    if (tokenItem != null && tokenItem.getTokenID().getNumericID() == 7) {
                        n = this.getTokenIndent(tokenItem6);
                        break;
                    }
                    n = this.computeStatementIndent(tokenItem);
                    break;
                }
                case 55: {
                    if (this.isEnumComma(tokenItem6)) {
                        n = this.getTokenIndent(tokenItem6);
                        break;
                    }
                    n = this.computeStatementIndent(tokenItem6);
                    break;
                }
                default: {
                    n = this.computeStatementIndent(tokenItem);
                }
            }
            if (n < 0) {
                n = this.getTokenIndent(tokenItem6);
            }
        }
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    private int computeStatementIndent(TokenItem tokenItem) {
        TokenItem tokenItem2 = this.findStatementStart(tokenItem);
        int n = this.getTokenIndent(tokenItem2);
        if (tokenItem2 != null) {
            if (tokenItem != null && this.tokenEquals(tokenItem, (TokenID)CCTokenContext.COMMA, this.tokenContextPath)) {
                TokenItem tokenItem3;
                if (this.isArrayInitializationBraceBlock(tokenItem, null) && this.getLeftParen(tokenItem, tokenItem2) == null) {
                    return n;
                }
                TokenItem tokenItem4 = this.getLeftParen(tokenItem, tokenItem2);
                if (tokenItem4 != null && (tokenItem3 = this.findImportantToken(tokenItem4, null, true, true)) != null && tokenItem3.getTokenID().getNumericID() == 7 && (this.isStatement(tokenItem2) ? this.alignMultilineCallArgs() : this.alignMultilineMethodParams())) {
                    return this.getVisualColumnOffset(this.getPosition(tokenItem4, 0)) + 1;
                }
            } else if (!this.isStatement(tokenItem2)) {
                return n;
            }
            n += this.getFormatStatementContinuationIndent();
        }
        return n;
    }

    private boolean isStatement(TokenItem tokenItem) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        while (tokenItem != null) {
            if (tokenItem.getTokenContextPath() == this.tokenContextPath) {
                switch (tokenItem.getTokenID().getNumericID()) {
                    case 22: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 107: 
                    case 109: 
                    case 110: 
                    case 118: 
                    case 119: 
                    case 121: 
                    case 123: 
                    case 124: 
                    case 126: 
                    case 127: 
                    case 130: {
                        return true;
                    }
                    case 58: {
                        return !bl;
                    }
                    case 64: 
                    case 75: 
                    case 78: 
                    case 93: 
                    case 97: 
                    case 104: 
                    case 105: 
                    case 108: 
                    case 111: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 120: 
                    case 122: 
                    case 128: {
                        return false;
                    }
                    case 56: {
                        if (bl3) break;
                        return false;
                    }
                    case 59: {
                        bl3 = true;
                        break;
                    }
                    case 57: {
                        if (bl2 || n != 1) break;
                        bl = true;
                        break;
                    }
                    case 61: {
                        break;
                    }
                    case 60: {
                        if (!bl2 && n > 1) {
                            bl = true;
                        }
                        bl2 = true;
                        break;
                    }
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 76: 
                    case 77: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 88: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 98: 
                    case 129: {
                        if (bl2) break;
                        return false;
                    }
                    case 7: {
                        ++n;
                    }
                }
            }
            tokenItem = tokenItem.getNext();
        }
        return true;
    }

    public FormatTokenPosition indentLine(FormatTokenPosition formatTokenPosition, boolean bl) {
        int n = 0;
        FormatTokenPosition formatTokenPosition2 = this.findLineFirstNonWhitespace(formatTokenPosition);
        if (formatTokenPosition2 != null) {
            if (this.isPreprocessorLine(formatTokenPosition2.getToken())) {
                if (!this.isPreprocessorAtLineStart(formatTokenPosition2.getToken())) {
                    return formatTokenPosition;
                }
            } else if (this.isComment(formatTokenPosition2)) {
                if (bl) {
                    return formatTokenPosition;
                }
                if (this.isMultiLineComment(formatTokenPosition2) && formatTokenPosition2.getOffset() != 0) {
                    n = this.getLineIndent(this.getPosition(formatTokenPosition2.getToken(), 0), true) + 1;
                    if (this.isIndentOnly()) {
                        if (this.getChar(formatTokenPosition2) != '*' && this.isCCDocComment(formatTokenPosition2.getToken()) && this.getFormatLeadingStarInComment()) {
                            this.insertString(formatTokenPosition2, "* ");
                            this.setIndentShift(2);
                        }
                    } else if (this.getChar(formatTokenPosition2) != '*') {
                        if (this.isCCDocComment(formatTokenPosition2.getToken())) {
                            if (this.getFormatLeadingStarInComment()) {
                                this.insertString(formatTokenPosition2, "* ");
                            }
                        } else {
                            n = this.getLineIndent(formatTokenPosition, true);
                        }
                    }
                } else if (!this.isMultiLineComment(formatTokenPosition2)) {
                    n = formatTokenPosition2.equals(this.findLineStart(formatTokenPosition2)) ? this.getLineIndent(formatTokenPosition2, true) : this.findIndent(formatTokenPosition2.getToken());
                } else {
                    if (this.isIndentOnly() && formatTokenPosition2.getOffset() != 0) {
                        return formatTokenPosition;
                    }
                    n = this.isCCDocComment(formatTokenPosition2.getToken()) ? this.findIndent(formatTokenPosition2.getToken()) : (formatTokenPosition2.getToken().getImage().indexOf(10) == -1 ? this.findIndent(formatTokenPosition2.getToken()) : this.getLineIndent(formatTokenPosition2, true));
                }
            } else {
                n = this.findIndent(formatTokenPosition2.getToken());
            }
        } else {
            TokenItem tokenItem = formatTokenPosition.getToken();
            if (tokenItem == null && (tokenItem = this.findLineStart(formatTokenPosition).getToken()) == null) {
                tokenItem = this.getLastToken();
            }
            if (tokenItem != null && this.isMultiLineComment(tokenItem)) {
                if (this.getFormatLeadingStarInComment() && (this.isIndentOnly() || this.isCCDocComment(tokenItem))) {
                    this.insertString(formatTokenPosition, "*");
                    this.setIndentShift(1);
                }
                n = this.getVisualColumnOffset(this.getPosition(tokenItem, 0)) + 1;
            } else {
                n = this.findIndent(formatTokenPosition.getToken());
            }
        }
        return this.changeLineIndent(formatTokenPosition, n);
    }

    public boolean isForLoopSemicolon(TokenItem tokenItem) {
        if (tokenItem == null || !this.tokenEquals(tokenItem, (TokenID)CCTokenContext.SEMICOLON, this.tokenContextPath)) {
            throw new IllegalArgumentException("Only accept ';'.");
        }
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        for (tokenItem = tokenItem.getPrevious(); tokenItem != null; tokenItem = tokenItem.getPrevious()) {
            if (this.tokenEquals(tokenItem, (TokenID)CCTokenContext.LPAREN, this.tokenContextPath)) {
                if (n == 0) {
                    FormatTokenPosition formatTokenPosition = this.getPosition(tokenItem, 0);
                    return (formatTokenPosition = this.findImportant(formatTokenPosition, null, false, true)) != null && this.tokenEquals(formatTokenPosition.getToken(), (TokenID)CCTokenContext.FOR, this.tokenContextPath);
                }
                --n;
                continue;
            }
            if (this.tokenEquals(tokenItem, (TokenID)CCTokenContext.RPAREN, this.tokenContextPath)) {
                ++n;
                continue;
            }
            if (this.tokenEquals(tokenItem, (TokenID)CCTokenContext.LBRACE, this.tokenContextPath)) {
                if (n2 == 0) {
                    return false;
                }
                --n2;
                continue;
            }
            if (this.tokenEquals(tokenItem, (TokenID)CCTokenContext.RBRACE, this.tokenContextPath)) {
                ++n2;
                continue;
            }
            if (!this.tokenEquals(tokenItem, (TokenID)CCTokenContext.SEMICOLON, this.tokenContextPath)) continue;
            if (bl) {
                return false;
            }
            bl = true;
        }
        return false;
    }

    private TokenItem findClassifierStart(TokenItem tokenItem) {
        while ((tokenItem = this.findStatement(tokenItem)) != null) {
            switch (tokenItem.getTokenID().getNumericID()) {
                case 58: 
                case 64: 
                case 65: {
                    return null;
                }
                case 122: {
                    return this.findStatementStart(tokenItem);
                }
            }
        }
        return null;
    }

    private TokenItem getVisibility(TokenItem tokenItem) {
        TokenItem tokenItem2 = tokenItem;
        if (tokenItem2 != null) {
            tokenItem2 = tokenItem.getPrevious();
        }
        while (tokenItem2 != null) {
            if (tokenItem2.getTokenContextPath() == this.tokenContextPath) {
                switch (tokenItem2.getTokenID().getNumericID()) {
                    case 58: 
                    case 64: 
                    case 65: {
                        return null;
                    }
                    case 115: 
                    case 116: 
                    case 117: {
                        return tokenItem2;
                    }
                }
            }
            tokenItem2 = tokenItem2.getPrevious();
        }
        return null;
    }

    private TokenItem getLeftParen(TokenItem tokenItem, TokenItem tokenItem2) {
        int n = 0;
        for (tokenItem = tokenItem.getPrevious(); tokenItem != null && tokenItem != tokenItem2; tokenItem = tokenItem.getPrevious()) {
            if (this.tokenEquals(tokenItem, (TokenID)CCTokenContext.LPAREN, this.tokenContextPath)) {
                if (--n >= 0) continue;
                return tokenItem;
            }
            if (!this.tokenEquals(tokenItem, (TokenID)CCTokenContext.RPAREN, this.tokenContextPath)) continue;
            ++n;
        }
        return null;
    }

    private boolean isArrayInitializationBraceBlock(TokenItem tokenItem, TokenItem tokenItem2) {
        int n = 0;
        block5: for (tokenItem = tokenItem.getPrevious(); tokenItem != null && tokenItem != tokenItem2 && tokenItem.getTokenContextPath() == this.tokenContextPath; tokenItem = tokenItem.getPrevious()) {
            switch (tokenItem.getTokenID().getNumericID()) {
                case 65: {
                    ++n;
                    continue block5;
                }
                case 64: {
                    if (--n >= 0) continue block5;
                    TokenItem tokenItem3 = this.findImportantToken(tokenItem, tokenItem2, true, true);
                    return tokenItem3 != null && tokenItem3.getTokenContextPath() == this.tokenContextPath && (CCTokenContext.RBRACKET.equals(tokenItem3.getTokenID()) || CCTokenContext.EQ.equals(tokenItem3.getTokenID()));
                }
                case 58: 
                case 102: 
                case 107: 
                case 110: 
                case 130: {
                    if (n != 0) continue block5;
                    return false;
                }
            }
        }
        return false;
    }

    public boolean isEnumComma(TokenItem tokenItem) {
        TokenItem tokenItem2;
        while (tokenItem != null && this.tokenEquals(tokenItem, (TokenID)CCTokenContext.COMMA, this.tokenContextPath) && (tokenItem2 = this.findStatementStart(tokenItem)) != tokenItem) {
            tokenItem = tokenItem2;
        }
        if (tokenItem != null && (this.tokenEquals(tokenItem, (TokenID)CCTokenContext.IDENTIFIER, this.tokenContextPath) || this.tokenEquals(tokenItem, (TokenID)CCTokenContext.DOT, this.tokenContextPath)) && (tokenItem2 = this.findImportantToken(tokenItem, null, true, true)) != null && this.tokenEquals(tokenItem2, (TokenID)CCTokenContext.LBRACE, this.tokenContextPath)) {
            TokenItem tokenItem3 = this.findStatementStart(tokenItem2);
            if (tokenItem3 != null && this.findToken(tokenItem3, tokenItem2, (TokenID)CCTokenContext.ENUM, this.tokenContextPath, null, false) != null) {
                return true;
            }
            if (tokenItem3 != null && this.findToken(tokenItem3, tokenItem2, (TokenID)CCTokenContext.EQ, this.tokenContextPath, null, false) != null) {
                return true;
            }
        }
        return false;
    }

    private CodeStyle getCodeStyle() {
        return this.codeStyle;
    }

    public boolean getFormatSpaceBeforeMethodCallParenthesis() {
        return this.getCodeStyle().spaceBeforeMethodCallParen();
    }

    public boolean getFormatSpaceAfterComma() {
        return this.getCodeStyle().spaceAfterComma();
    }

    public boolean indentCasesFromSwitch() {
        return this.getCodeStyle().indentCasesFromSwitch();
    }

    public boolean getFormatNewlineBeforeBrace() {
        return this.getCodeStyle().getFormatNewlineBeforeBrace() != CodeStyle.BracePlacement.SAME_LINE;
    }

    public boolean isHalfIndentNewlineBeforeBrace() {
        return this.getCodeStyle().getFormatNewlineBeforeBrace() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED;
    }

    public boolean getFormatNewlineBeforeBraceSwitch() {
        return this.getCodeStyle().getFormatNewLineBeforeBraceSwitch() != CodeStyle.BracePlacement.SAME_LINE;
    }

    public boolean isHalfIndentNewlineBeforeBraceSwitch() {
        return this.getCodeStyle().getFormatNewLineBeforeBraceSwitch() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED;
    }

    public boolean getFormatNewlineBeforeBraceDeclaration() {
        return this.getCodeStyle().getFormatNewlineBeforeBraceDeclaration() != CodeStyle.BracePlacement.SAME_LINE;
    }

    public boolean isHalfIndentNewlineBeforeBraceDeclaration() {
        return this.getCodeStyle().getFormatNewlineBeforeBraceDeclaration() == CodeStyle.BracePlacement.NEW_LINE_HALF_INDENTED;
    }

    public boolean getFormatLeadingStarInComment() {
        return this.getCodeStyle().getFormatLeadingStarInComment();
    }

    private int getFormatStatementContinuationIndent() {
        return this.getCodeStyle().getFormatStatementContinuationIndent();
    }

    public int getShiftWidth() {
        return this.getCodeStyle().indentSize();
    }

    private boolean alignMultilineCallArgs() {
        return this.getCodeStyle().alignMultilineCallArgs();
    }

    private boolean alignMultilineMethodParams() {
        return this.getCodeStyle().alignMultilineMethodParams();
    }

    public FormatTokenPosition findLineFirstNonWhitespaceAndNonLeftBrace(FormatTokenPosition formatTokenPosition) {
        FormatTokenPosition formatTokenPosition2 = super.findLineFirstNonWhitespace(formatTokenPosition);
        if (formatTokenPosition2 == null) {
            return null;
        }
        if (!formatTokenPosition2.getToken().getImage().startsWith("{")) {
            return formatTokenPosition2;
        }
        FormatTokenPosition formatTokenPosition3 = this.findNextEOL(formatTokenPosition2);
        TokenItem tokenItem = this.findMatchingToken(formatTokenPosition2.getToken(), formatTokenPosition3 != null ? formatTokenPosition3.getToken() : null, (ImageTokenID)CCTokenContext.RBRACE, false);
        if (tokenItem != null) {
            return formatTokenPosition2;
        }
        FormatTokenPosition formatTokenPosition4 = this.getNextPosition(formatTokenPosition2);
        if (formatTokenPosition4 == null) {
            return formatTokenPosition2;
        }
        FormatTokenPosition formatTokenPosition5 = this.findImportant(formatTokenPosition4, null, true, false);
        if (formatTokenPosition5 != null) {
            return formatTokenPosition5;
        }
        return formatTokenPosition2;
    }

    public TokenItem findImportantToken(TokenItem tokenItem, TokenItem tokenItem2, boolean bl, boolean bl2) {
        TokenItem tokenItem3 = this.findImportantToken(tokenItem, tokenItem2, bl);
        if (bl2) {
            while (tokenItem3 != null && this.getPosition(tokenItem3, 0) != null) {
                FormatTokenPosition formatTokenPosition = this.findLineFirstNonWhitespace(this.getPosition(tokenItem3, 0));
                if (formatTokenPosition == null) {
                    return null;
                }
                if (!this.isPreprocessorLine(formatTokenPosition.getToken())) break;
                tokenItem3 = bl ? tokenItem3.getPrevious() : tokenItem3.getNext();
                if (tokenItem3 == null) continue;
                tokenItem3 = this.findImportantToken(tokenItem3, tokenItem2, bl);
            }
        }
        return tokenItem3;
    }
}

