/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing.lexer;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.annotations.NonNull;
import org.netbeans.modules.javascript.editing.JsUtils;
import org.netbeans.modules.javascript.editing.lexer.JsTokenId;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Call {
    public static final Call LOCAL = new Call(null, null, false, false);
    public static final Call NONE = new Call(null, null, false, false);
    public static final Call UNKNOWN = new Call(null, null, false, false);
    private final String type;
    private final String lhs;
    private final boolean isStatic;
    private final boolean methodExpected;
    private int prevCallParenPos = -1;

    public Call(String string, String string2, boolean bl, boolean bl2) {
        this.type = string;
        this.lhs = string2;
        this.methodExpected = bl2;
        if (string2 == null) {
            string2 = string;
        }
        this.isStatic = bl;
    }

    public String getType() {
        return this.type;
    }

    public String getLhs() {
        return this.lhs;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public int getPrevCallParenPos() {
        return this.prevCallParenPos;
    }

    public boolean isSimpleIdentifier() {
        if (this.lhs == null) {
            return false;
        }
        int n = this.lhs.length();
        for (int i = 0; i < n; ++i) {
            char c = this.lhs.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '@' || c == '$') continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this == LOCAL) {
            return "LOCAL";
        }
        if (this == NONE) {
            return "NONE";
        }
        if (this == UNKNOWN) {
            return "UNKNOWN";
        }
        return "Call(" + this.type + "," + this.lhs + "," + this.isStatic + "," + this.prevCallParenPos + ")";
    }

    public boolean isMethodExpected() {
        return this.methodExpected;
    }

    @NonNull
    public static Call getCallType(BaseDocument baseDocument, TokenHierarchy<Document> tokenHierarchy, int n) {
        Token token;
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence(tokenHierarchy, n);
        if (tokenSequence == null) {
            return NONE;
        }
        tokenSequence.move(n);
        boolean bl = false;
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return NONE;
        }
        if (tokenSequence.offset() == n) {
            tokenSequence.movePrevious();
        }
        if ((token = tokenSequence.token()) != null) {
            String string;
            int n2;
            String string2;
            JsTokenId jsTokenId = (JsTokenId)token.id();
            if (jsTokenId == JsTokenId.WHITESPACE) {
                return LOCAL;
            }
            if (jsTokenId == JsTokenId.IDENTIFIER || jsTokenId == JsTokenId.CONSTANT || jsTokenId.primaryCategory().equals("keyword")) {
                string2 = ((Object)token.text()).toString();
                if (".".equals(string2)) {
                    bl = true;
                } else if (!"::".equals(string2)) {
                    bl = true;
                    if (Character.isUpperCase(string2.charAt(0))) {
                        bl = false;
                    }
                    if (!tokenSequence.movePrevious()) {
                        return LOCAL;
                    }
                }
                token = tokenSequence.token();
                jsTokenId = (JsTokenId)token.id();
            }
            if (jsTokenId == JsTokenId.DOT) {
                bl = true;
            } else if (jsTokenId == JsTokenId.IDENTIFIER) {
                string2 = ((Object)token.text()).toString();
                if (string2.equals(".")) {
                    bl = true;
                } else if (!string2.equals("::")) {
                    return LOCAL;
                }
            } else {
                return LOCAL;
            }
            int n3 = n2 = tokenSequence.offset();
            int n4 = 0;
            try {
                if (n > baseDocument.getLength()) {
                    n = baseDocument.getLength();
                }
                n4 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            block15: while (tokenSequence.movePrevious() && tokenSequence.offset() >= n4) {
                token = tokenSequence.token();
                jsTokenId = (JsTokenId)token.id();
                string = null;
                if (jsTokenId == JsTokenId.ANY_KEYWORD) {
                    string = ((Object)token.text()).toString();
                }
                switch (jsTokenId) {
                    case WHITESPACE: {
                        break block15;
                    }
                    case STRING_LITERAL: 
                    case STRING_END: {
                        return new Call("String", null, false, bl);
                    }
                    case REGEXP_LITERAL: 
                    case REGEXP_END: {
                        return new Call("RegExp", null, false, bl);
                    }
                    case INT_LITERAL: 
                    case FLOAT_LITERAL: {
                        return new Call("Number", null, false, bl);
                    }
                    case LPAREN: 
                    case LBRACE: 
                    case LBRACKET: {
                        break block15;
                    }
                    case RPAREN: {
                        Call call = new Call(null, null, false, false);
                        call.prevCallParenPos = tokenSequence.offset();
                        OffsetRange offsetRange = LexUtilities.findBwd(baseDocument, tokenSequence, JsTokenId.LPAREN, JsTokenId.RPAREN);
                        if (offsetRange != OffsetRange.NONE) {
                            call.prevCallParenPos = offsetRange.getStart();
                        }
                        return call;
                    }
                    case RBRACKET: {
                        Call call = new Call(null, null, false, false);
                        call.prevCallParenPos = tokenSequence.offset();
                        OffsetRange offsetRange = LexUtilities.findBwd(baseDocument, tokenSequence, JsTokenId.LBRACKET, JsTokenId.LBRACKET);
                        if (offsetRange != OffsetRange.NONE) {
                            call.prevCallParenPos = offsetRange.getStart();
                        }
                        return call;
                    }
                    case GLOBAL_VAR: 
                    case IDENTIFIER: 
                    case DOT: 
                    case CONSTANT: 
                    case THIS: {
                        n3 = tokenSequence.offset();
                        continue block15;
                    }
                    case ANY_KEYWORD: {
                        if ("true".equals(string)) {
                            return new Call("Boolean", null, false, bl);
                        }
                        if ("false".equals(string)) {
                            return new Call("Boolean", null, false, bl);
                        }
                    }
                    default: {
                        if (jsTokenId.primaryCategory().equals("keyword")) {
                            n3 = tokenSequence.offset();
                            continue block15;
                        }
                        return UNKNOWN;
                    }
                }
            }
            if (n3 < n2) {
                try {
                    string = baseDocument.getText(n3, n2 - n3);
                    if (string.equals("super") || string.equals("this")) {
                        return new Call(string, string, false, true);
                    }
                    if (Character.isUpperCase(string.charAt(0))) {
                        String string3 = null;
                        boolean bl2 = true;
                        String[] stringArray = string.split("\\.");
                        for (int i = 0; i < stringArray.length; ++i) {
                            String string4 = stringArray[i];
                            if (JsUtils.isValidJsClassName(string4)) continue;
                            if (i == stringArray.length - 1 && "prototype".equals(string4)) {
                                string3 = string.substring(0, string.length() - ".prototype".length());
                                continue;
                            }
                            bl2 = false;
                        }
                        if (bl2 && string3 == null) {
                            string3 = string;
                        }
                        return new Call(string3, string, true, bl);
                    }
                    return new Call(null, string, false, bl);
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            } else {
                return UNKNOWN;
            }
        }
        return LOCAL;
    }
}

