/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.gsf.api.EditorAction;
import org.netbeans.modules.javascript.editing.NbUtilities;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class RunScriptAction
extends AbstractAction
implements EditorAction {
    Boolean enabled;

    public RunScriptAction() {
        super(NbBundle.getMessage(RunScriptAction.class, (String)"js-run-action"));
        this.putValue("PopupMenuText", NbBundle.getBundle(RunScriptAction.class).getString("popup-js-run-action"));
    }

    public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        this.actionPerformed(jTextComponent);
    }

    public String getActionName() {
        return "js-run-action";
    }

    public Class getShortDescriptionBundleClass() {
        return RunScriptAction.class;
    }

    public boolean isEnabled() {
        if (this.enabled == null) {
            try {
                ClassLoader classLoader = RunScriptAction.class.getClassLoader();
                Class<?> clazz = classLoader.loadClass("javax.script.ScriptEngineManager");
                this.enabled = clazz != null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.enabled = Boolean.FALSE;
            }
        }
        return this.enabled;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JTextComponent jTextComponent = NbUtilities.getOpenPane();
        if (jTextComponent != null) {
            this.actionPerformed(jTextComponent);
        }
    }

    void actionPerformed(final JTextComponent jTextComponent) {
        if (jTextComponent.getCaret() == null) {
            return;
        }
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                block13: {
                    ClassLoader classLoader = RunScriptAction.class.getClassLoader();
                    InputOutput inputOutput = null;
                    FileObject fileObject = null;
                    try {
                        Class<?> clazz = classLoader.loadClass("javax.script.ScriptEngineManager");
                        Object obj = clazz.newInstance();
                        Method method = clazz.getMethod("getEngineByMimeType", String.class);
                        Object object = method.invoke(obj, "text/javascript");
                        Document document = jTextComponent.getDocument();
                        DataObject dataObject = NbEditorUtilities.getDataObject((Document)document);
                        String string = dataObject.getPrimaryFile().getNameExt();
                        fileObject = dataObject.getPrimaryFile();
                        SaveCookie saveCookie = (SaveCookie)dataObject.getLookup().lookup(SaveCookie.class);
                        if (saveCookie != null) {
                            try {
                                saveCookie.save();
                            }
                            catch (IOException iOException) {
                                ErrorManager.getDefault().notify((Throwable)iOException);
                            }
                        }
                        Class<?> clazz2 = classLoader.loadClass("javax.script.ScriptEngine");
                        Method method2 = clazz2.getMethod("getContext", new Class[0]);
                        Object object2 = method2.invoke(object, new Object[0]);
                        Method method3 = clazz2.getMethod("put", String.class, Object.class);
                        method3.invoke(object, "javax.script.filename", fileObject.getPath());
                        inputOutput = IOProvider.getDefault().getIO("Run " + string, false);
                        Class<?> clazz3 = classLoader.loadClass("javax.script.ScriptContext");
                        Method method4 = clazz3.getMethod("setWriter", Writer.class);
                        Method method5 = clazz3.getMethod("setErrorWriter", Writer.class);
                        Method method6 = clazz3.getMethod("setReader", Reader.class);
                        method4.invoke(object2, inputOutput.getOut());
                        method5.invoke(object2, inputOutput.getErr());
                        method6.invoke(object2, inputOutput.getIn());
                        inputOutput.getOut().reset();
                        inputOutput.select();
                        Method method7 = clazz2.getMethod("eval", String.class);
                        Object object3 = method7.invoke(object, document.getText(0, document.getLength()));
                        if (object3 != null) {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)("Result: " + object3)));
                        }
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        try {
                            Class<?> clazz = classLoader.loadClass("javax.script.ScriptException");
                            if (invocationTargetException.getCause() == null || !clazz.isAssignableFrom(invocationTargetException.getCause().getClass())) break block13;
                            if (inputOutput != null) {
                                String string = invocationTargetException.getCause().getMessage();
                                int n = 0;
                                if (string.startsWith("sun.org.mozilla")) {
                                    string = string.substring(string.indexOf(58) + 1);
                                    string = string.substring(0, string.lastIndexOf(40)).trim() + " " + string.substring(string.lastIndexOf(41) + 1).trim();
                                    try {
                                        n = Integer.valueOf(string.substring(string.lastIndexOf("number") + 7));
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                                inputOutput.getOut().println(string, (OutputListener)new OutputProcessor(fileObject, n));
                            }
                            ErrorManager.getDefault().notify((Throwable)invocationTargetException);
                        }
                        catch (Exception exception) {
                            ErrorManager.getDefault().notify((Throwable)exception);
                        }
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify((Throwable)exception);
                    }
                }
            }
        });
    }

    public static class OutputProcessor
    implements OutputListener {
        public static final Logger LOGGER = Logger.getLogger(OutputListener.class.getName());
        private final FileObject file;
        private final int lineno;

        OutputProcessor(FileObject fileObject, int n) {
            if (n < 0) {
                n = 0;
            }
            this.file = fileObject;
            this.lineno = n;
        }

        public void outputLineSelected(OutputEvent outputEvent) {
        }

        public void outputLineAction(OutputEvent outputEvent) {
            OutputProcessor.open(this.file, this.lineno);
        }

        public void outputLineCleared(OutputEvent outputEvent) {
        }

        public static boolean open(final FileObject fileObject, final int n) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        OutputProcessor.open(fileObject, n);
                    }
                });
                return true;
            }
            try {
                StyledDocument styledDocument;
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
                if (editorCookie != null && lineCookie != null && (styledDocument = editorCookie.openDocument()) != null) {
                    Line line;
                    int n2 = n;
                    if (n2 < 1) {
                        n2 = 1;
                    }
                    if ((line = lineCookie.getLineSet().getCurrent(n2 - 1)) != null) {
                        line.show(2);
                        return true;
                    }
                }
                if ((styledDocument = (OpenCookie)dataObject.getCookie(OpenCookie.class)) != null) {
                    styledDocument.open();
                    return true;
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
            return false;
        }
    }
}

