/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.text.Document;
import org.mozilla.javascript.Node;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.DeclarationFinder;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.javascript.editing.AstElement;
import org.netbeans.modules.javascript.editing.AstPath;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.IndexedElement;
import org.netbeans.modules.javascript.editing.IndexedFunction;
import org.netbeans.modules.javascript.editing.JsCodeCompletion;
import org.netbeans.modules.javascript.editing.JsIndex;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.VariableVisitor;
import org.netbeans.modules.javascript.editing.lexer.Call;
import org.netbeans.modules.javascript.editing.lexer.JsTokenId;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsDeclarationFinder
implements DeclarationFinder {
    private static final boolean CHOOSE_ONE_DECLARATION = Boolean.getBoolean("javascript.choose_one_decl");

    public OffsetRange getReferenceSpan(Document document, int n) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence((TokenHierarchy<Document>)tokenHierarchy, n);
        if (tokenSequence == null) {
            return OffsetRange.NONE;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return OffsetRange.NONE;
        }
        boolean bl = n == tokenSequence.offset();
        OffsetRange offsetRange = this.getReferenceSpan(tokenSequence, (TokenHierarchy<Document>)tokenHierarchy, n);
        if (offsetRange == OffsetRange.NONE && bl && tokenSequence.movePrevious()) {
            offsetRange = this.getReferenceSpan(tokenSequence, (TokenHierarchy<Document>)tokenHierarchy, n);
        }
        return offsetRange;
    }

    IndexedFunction findMethodDeclaration(CompilationInfo compilationInfo, Node node, AstPath astPath, Set<IndexedFunction>[] setArray) {
        String string = AstUtilities.getCallName(node, false);
        JsParseResult jsParseResult = AstUtilities.getParseResult(compilationInfo);
        JsIndex jsIndex = JsIndex.get(compilationInfo.getIndex("text/javascript"));
        Set<IndexedElement> set = jsIndex.getAllNames(string, NameKind.EXACT_NAME, JsIndex.ALL_SCOPE, jsParseResult);
        IndexedElement indexedElement = this.findBestElementMatch(compilationInfo, set);
        if (indexedElement instanceof IndexedFunction) {
            return (IndexedFunction)indexedElement;
        }
        return null;
    }

    private OffsetRange getReferenceSpan(TokenSequence<?> tokenSequence, TokenHierarchy<Document> tokenHierarchy, int n) {
        Token token = tokenSequence.token();
        TokenId tokenId = token.id();
        if (tokenId == JsTokenId.IDENTIFIER && token.length() == 1 && tokenId == JsTokenId.IDENTIFIER && ((Object)token.text()).toString().equals(",")) {
            return OffsetRange.NONE;
        }
        if (tokenId == JsTokenId.IDENTIFIER || tokenId == JsTokenId.GLOBAL_VAR || tokenId == JsTokenId.CONSTANT) {
            return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length());
        }
        return OffsetRange.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeclarationFinder.DeclarationLocation findDeclaration(CompilationInfo compilationInfo, int n) {
        Document document;
        try {
            document = compilationInfo.getDocument();
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        BaseDocument baseDocument = (BaseDocument)document;
        JsParseResult jsParseResult = AstUtilities.getParseResult(compilationInfo);
        baseDocument.readLock();
        try {
            Object object;
            Object object2;
            Object object3;
            List<Node> list;
            Call call;
            Node node = jsParseResult.getRootNode();
            int n2 = AstUtilities.getAstOffset(compilationInfo, n);
            if (n2 == -1) {
                DeclarationFinder.DeclarationLocation declarationLocation = null;
                return declarationLocation;
            }
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
            AstPath astPath = null;
            Node node2 = null;
            if (node != null) {
                astPath = new AstPath(node, n2);
                node2 = astPath.leaf();
            }
            if ((call = Call.getCallType(baseDocument, (TokenHierarchy<Document>)tokenHierarchy, n)).getLhs() == null && node2 instanceof Node.StringNode && (list = (object3 = ((VariableVisitor)(object2 = jsParseResult.getVariableVisitor())).getLocalVars(node2)).get(object = node2.getString())) != null && list.size() > 0) {
                Node node32;
                HashMap<Integer, Node> hashMap = new HashMap<Integer, Node>();
                for (Node node32 : list) {
                    hashMap.put(node32.getSourceStart(), node32);
                }
                ArrayList arrayList = new ArrayList(hashMap.keySet());
                Collections.sort(arrayList);
                node32 = (Node)hashMap.get(arrayList.get(0));
                DeclarationFinder.DeclarationLocation declarationLocation = this.getLocation(compilationInfo, node32);
                return declarationLocation;
            }
            object2 = new JsCodeCompletion().getPrefix(compilationInfo, n, false);
            if (object2 != null) {
                object3 = JsIndex.get(compilationInfo.getIndex("text/javascript"));
                object = ((JsIndex)object3).getAllNames((String)object2, NameKind.EXACT_NAME, JsIndex.ALL_SCOPE, jsParseResult);
                list = null;
                DeclarationFinder.DeclarationLocation declarationLocation = this.getMethodDeclaration(compilationInfo, (String)((Object)list), (Set<IndexedElement>)object, node2, (JsIndex)object3, n2, n);
                return declarationLocation;
            }
        }
        finally {
            baseDocument.readUnlock();
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private DeclarationFinder.DeclarationLocation getLocation(CompilationInfo compilationInfo, Node node) {
        AstElement astElement = AstElement.getElement(compilationInfo, node);
        return new DeclarationFinder.DeclarationLocation(compilationInfo.getFileObject(), LexUtilities.getLexerOffset(compilationInfo, node.getSourceStart()), (ElementHandle)astElement);
    }

    DeclarationFinder.DeclarationLocation findLinkedMethod(CompilationInfo compilationInfo, String string) {
        JsParseResult jsParseResult;
        JsIndex jsIndex = JsIndex.get(compilationInfo.getIndex("text/javascript"));
        Set<IndexedElement> set = jsIndex.getAllNames(string, NameKind.EXACT_NAME, JsIndex.ALL_SCOPE, jsParseResult = AstUtilities.getParseResult(compilationInfo));
        IndexedElement indexedElement = this.findBestElementMatch(compilationInfo, set);
        if (indexedElement != null) {
            return new DeclarationFinder.DeclarationLocation(indexedElement.getFileObject(), 0, (ElementHandle)indexedElement);
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private IndexedElement findBestElementMatch(CompilationInfo compilationInfo, Set<IndexedElement> set) {
        if (set.size() > 0) {
            IndexedElement indexedElement = set.iterator().next();
            IndexedElement indexedElement2 = indexedElement.findRealFileElement();
            if (indexedElement2 != null) {
                return indexedElement2;
            }
            return indexedElement;
        }
        return null;
    }

    private DeclarationFinder.DeclarationLocation getMethodDeclaration(CompilationInfo compilationInfo, String string, Set<IndexedElement> set, Node node, JsIndex jsIndex, int n, int n2) {
        IndexedElement indexedElement = this.findBestElementMatch(compilationInfo, set);
        if (indexedElement != null) {
            DeclarationFinder.DeclarationLocation declarationLocation;
            IndexedElement indexedElement2;
            Node node2;
            boolean bl = false;
            if (indexedElement.getFilenameUrl() != null && indexedElement.getFilenameUrl().indexOf("jsstubs") != -1 && indexedElement.getFilenameUrl().indexOf("sdocs.zip") == -1) {
                bl = true;
            }
            if ((node2 = AstUtilities.getForeignNode(indexedElement2 = indexedElement, null)) == null) {
                int n3 = 0;
                declarationLocation = new DeclarationFinder.DeclarationLocation(indexedElement.getFileObject(), n3, (ElementHandle)indexedElement2);
            } else {
                declarationLocation = new DeclarationFinder.DeclarationLocation(indexedElement2.getFile().getFileObject(), node2.getSourceStart(), (ElementHandle)indexedElement2);
            }
            if (bl) {
                if (indexedElement.isDocOnly()) {
                    declarationLocation.setInvalidMessage(NbBundle.getMessage(JsDeclarationFinder.class, (String)"NoSourceDocOnly", (Object)indexedElement.getName()));
                } else {
                    declarationLocation.setInvalidMessage(NbBundle.getMessage(JsDeclarationFinder.class, (String)"InvalidJsMethod", (Object)indexedElement.getName()));
                }
            }
            if (!CHOOSE_ONE_DECLARATION && set.size() > 1) {
                for (IndexedElement indexedElement3 : set) {
                    declarationLocation.addAlternative((DeclarationFinder.AlternativeLocation)new JsAltLocation(indexedElement3, indexedElement3 == indexedElement));
                }
            }
            return declarationLocation;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private class JsAltLocation
    implements DeclarationFinder.AlternativeLocation {
        private IndexedElement element;
        private boolean isPreferred;
        private String cachedDisplayItem;

        JsAltLocation(IndexedElement indexedElement, boolean bl) {
            this.element = indexedElement;
            this.isPreferred = bl;
        }

        public String getDisplayHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.setMaxLength(120);
            if (this.cachedDisplayItem == null) {
                Object object;
                Object object2;
                Object object3;
                htmlFormatter.reset();
                boolean bl = false;
                boolean bl2 = false;
                if (this.isPreferred) {
                    htmlFormatter.emphasis(true);
                } else if (bl) {
                    htmlFormatter.deprecated(true);
                }
                if (this.element instanceof IndexedFunction) {
                    if (this.element.getIn() != null) {
                        htmlFormatter.appendText(this.element.getIn());
                        htmlFormatter.appendText(".");
                    }
                    htmlFormatter.appendText(this.element.getName());
                    object3 = (IndexedFunction)this.element;
                    object2 = ((IndexedFunction)object3).getParameters();
                    if (object2 != null && object2.size() > 0) {
                        htmlFormatter.appendText("(");
                        object = object2.iterator();
                        while (object.hasNext()) {
                            htmlFormatter.parameters(true);
                            htmlFormatter.appendText((String)object.next());
                            htmlFormatter.parameters(false);
                            if (!object.hasNext()) continue;
                            htmlFormatter.appendText(", ");
                        }
                        htmlFormatter.appendText(")");
                    }
                } else {
                    htmlFormatter.appendText(this.element.getName());
                }
                object3 = null;
                object2 = this.element.getFilenameUrl();
                if (object2 != null) {
                    if (((String)object2).indexOf("Jsstubs") != -1) {
                        int n;
                        object3 = NbBundle.getMessage(DeclarationFinder.class, (String)"JsLib");
                        if (((String)object2).indexOf("/stub_") == -1 && (n = ((String)object2).indexOf((String)(object = "Jsstubs/1.8.6-p110/"))) != -1) {
                            object3 = (String)object3 + ": " + ((String)object2).substring(n);
                        }
                    } else {
                        object = this.element.getFileObject();
                        if (object != null) {
                            object3 = object.getNameExt();
                        } else {
                            int n = ((String)object2).lastIndexOf(47);
                            if (n != -1) {
                                String string = ((String)object2).substring(0, n);
                                int n2 = string.lastIndexOf(47);
                                if (n2 != -1 && ((String)object2).length() - n2 < 40) {
                                    object3 = ((String)object2).substring(n2 + 1);
                                    if (((String)object3).indexOf(58) != -1) {
                                        object3 = ((String)object2).substring(n + 1);
                                    }
                                } else {
                                    object3 = ((String)object2).substring(n + 1);
                                }
                            }
                        }
                    }
                }
                if (object3 != null) {
                    htmlFormatter.appendText(" ");
                    htmlFormatter.appendText(NbBundle.getMessage(JsDeclarationFinder.class, (String)"In"));
                    htmlFormatter.appendText(" ");
                    htmlFormatter.appendText((String)object3);
                }
                if (bl2) {
                    htmlFormatter.appendText(" ");
                    htmlFormatter.appendText(NbBundle.getMessage(JsDeclarationFinder.class, (String)"Documented"));
                } else if (bl) {
                    htmlFormatter.appendText(" ");
                    htmlFormatter.appendText(NbBundle.getMessage(JsDeclarationFinder.class, (String)"NoDoced"));
                }
                if (this.isPreferred) {
                    htmlFormatter.emphasis(false);
                } else if (bl) {
                    htmlFormatter.deprecated(false);
                }
                this.cachedDisplayItem = htmlFormatter.getText();
            }
            return this.cachedDisplayItem;
        }

        public DeclarationFinder.DeclarationLocation getLocation() {
            Node node = AstUtilities.getForeignNode(this.element, null);
            if (node == null) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            int n = node.getSourceStart();
            DeclarationFinder.DeclarationLocation declarationLocation = new DeclarationFinder.DeclarationLocation(this.element.getFileObject(), n, (ElementHandle)this.element);
            return declarationLocation;
        }

        public ElementHandle getElement() {
            return this.element;
        }

        public int compareTo(DeclarationFinder.AlternativeLocation alternativeLocation) {
            String string;
            JsAltLocation jsAltLocation = (JsAltLocation)alternativeLocation;
            if (this.isPreferred) {
                return -1;
            }
            if (jsAltLocation.isPreferred) {
                return 1;
            }
            String string2 = this.element.getIn() != null ? this.element.getIn() : "";
            int n = string2.compareTo(string = jsAltLocation.element.getIn() != null ? jsAltLocation.element.getIn() : "");
            if (n != 0) {
                return n;
            }
            String string3 = this.element.getFileObject() != null ? this.element.getFileObject().getNameExt() : "";
            String string4 = jsAltLocation.element.getFileObject() != null ? jsAltLocation.element.getFileObject().getNameExt() : "";
            n = string3.compareTo(string4);
            return n;
        }
    }
}

