/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Node;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.StructureItem;
import org.netbeans.modules.gsf.api.StructureScanner;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.netbeans.modules.javascript.editing.AstElement;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.FunctionAstElement;
import org.netbeans.modules.javascript.editing.GlobalAstElement;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.JsUtils;
import org.netbeans.modules.javascript.editing.ParseTreeVisitor;
import org.netbeans.modules.javascript.editing.ParseTreeWalker;
import org.netbeans.modules.javascript.editing.VariableVisitor;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsAnalyzer
implements StructureScanner {
    public static final String NETBEANS_IMPORT_FILE = "__netbeans_import__";
    private static final String DOT_CALL = ".call";

    public List<? extends StructureItem> scan(CompilationInfo compilationInfo, HtmlFormatter htmlFormatter) {
        List<Object> list;
        Object object;
        JsParseResult jsParseResult = AstUtilities.getParseResult(compilationInfo);
        AnalysisResult analysisResult = jsParseResult.getStructure();
        List<? extends AstElement> list2 = analysisResult.getElements();
        ArrayList<Object> arrayList = new ArrayList<Object>(list2.size());
        HashMap hashMap = new HashMap();
        ArrayList<AstElement> arrayList2 = new ArrayList<AstElement>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        for (AstElement object2 : list2) {
            object = object2.getIn();
            if (object2.getKind() == ElementKind.CLASS) {
                object = object != null && ((String)object).length() > 0 ? (String)object + "." + object2.getName() : object2.getName();
            } else if (object2.getKind() == ElementKind.CONSTRUCTOR && Character.isUpperCase(object2.getName().charAt(0))) {
                object = object2.getIn() != null && object2.getIn().length() > 0 ? object2.getIn() + "." + object2.getName() : object2.getName();
            }
            if (object != null && ((String)object).length() > 0) {
                list = (List)hashMap.get(object);
                if (list == null) {
                    list = new ArrayList();
                    hashMap.put(object, list);
                    arrayList3.add(object);
                }
                list.add(object2);
                continue;
            }
            arrayList2.add(object2);
        }
        for (AstElement astElement : arrayList2) {
            if (astElement.getKind() == ElementKind.CONSTRUCTOR) {
                object = astElement.getName();
                list = (ArrayList<AstElement>)hashMap.get(object);
                if (list == null) {
                    list = new ArrayList<AstElement>();
                    hashMap.put(object, list);
                    arrayList3.add(object);
                }
                list.add(astElement);
                continue;
            }
            object = new JsStructureItem(astElement, compilationInfo, htmlFormatter);
            arrayList.add(object);
        }
        for (String string : arrayList3) {
            object = (List)hashMap.get(string);
            assert (object != null);
            list = (AstElement)object.get(0);
            JsFakeClassStructureItem jsFakeClassStructureItem = new JsFakeClassStructureItem(string, ElementKind.CLASS, (AstElement)((Object)list), compilationInfo, htmlFormatter);
            arrayList.add(jsFakeClassStructureItem);
            int n = ((AstElement)((Object)list)).getNode().getSourceStart();
            int n2 = ((AstElement)((Object)list)).getNode().getSourceEnd();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object object2;
                AstElement astElement = (AstElement)iterator.next();
                if (astElement.getKind() != ElementKind.CLASS) {
                    object2 = new JsStructureItem(astElement, compilationInfo, htmlFormatter);
                    jsFakeClassStructureItem.addChild((StructureItem)object2);
                } else {
                    jsFakeClassStructureItem.element = astElement;
                }
                object2 = astElement.getNode();
                if (object2.getSourceStart() < n) {
                    n = object2.getSourceStart();
                }
                if (object2.getSourceEnd() <= n2) continue;
                n2 = object2.getSourceEnd();
            }
            jsFakeClassStructureItem.begin = LexUtilities.getLexerOffset(compilationInfo, n);
            jsFakeClassStructureItem.end = LexUtilities.getLexerOffset(compilationInfo, n2);
        }
        return arrayList;
    }

    public Map<String, List<OffsetRange>> folds(CompilationInfo compilationInfo) {
        JsParseResult jsParseResult = AstUtilities.getParseResult(compilationInfo);
        TranslatedSource translatedSource = jsParseResult.getTranslatedSource();
        AnalysisResult analysisResult = jsParseResult.getStructure();
        List<? extends AstElement> list = analysisResult.getElements();
        HashMap<String, List<OffsetRange>> hashMap = new HashMap<String, List<OffsetRange>>();
        ArrayList<OffsetRange> arrayList = new ArrayList<OffsetRange>();
        hashMap.put("codeblocks", arrayList);
        try {
            BaseDocument baseDocument = (BaseDocument)compilationInfo.getDocument();
            for (AstElement astElement : list) {
                ElementKind elementKind = astElement.getKind();
                switch (elementKind) {
                    case METHOD: 
                    case CONSTRUCTOR: 
                    case CLASS: 
                    case MODULE: {
                        int n;
                        int n2;
                        Node node = astElement.getNode();
                        OffsetRange offsetRange = AstUtilities.getRange(node);
                        if (translatedSource != null && (n2 = translatedSource.getLexicalOffset(offsetRange.getStart())) < (n = translatedSource.getLexicalOffset(offsetRange.getEnd()))) {
                            offsetRange = new OffsetRange(n2, n);
                        }
                        if (elementKind != ElementKind.METHOD && elementKind != ElementKind.CONSTRUCTOR && offsetRange.getStart() <= Utilities.getRowStart((BaseDocument)baseDocument, (int)offsetRange.getStart())) break;
                        n2 = offsetRange.getStart();
                        n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n2);
                        n = offsetRange.getEnd();
                        if (n2 == -1 || n == -1 || n2 >= n || n > baseDocument.getLength()) break;
                        offsetRange = new OffsetRange(n2, n);
                        arrayList.add(offsetRange);
                    }
                }
                assert (astElement.getChildren().size() == 0);
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        return hashMap;
    }

    static AnalysisResult analyze(JsParseResult jsParseResult, CompilationInfo compilationInfo) {
        AnalysisResult analysisResult = new AnalysisResult(compilationInfo);
        ParseTreeWalker parseTreeWalker = new ParseTreeWalker(analysisResult);
        Node node = jsParseResult.getRootNode();
        if (node != null) {
            parseTreeWalker.walk(node);
        }
        analysisResult.postProcess(jsParseResult);
        return analysisResult;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JsStructureItem
    implements StructureItem {
        private AstElement element;
        private ElementKind kind;
        private CompilationInfo info;
        private HtmlFormatter formatter;
        private String name;

        private JsStructureItem(AstElement astElement, CompilationInfo compilationInfo, HtmlFormatter htmlFormatter) {
            this.element = astElement;
            this.info = compilationInfo;
            this.formatter = htmlFormatter;
            this.kind = astElement.getKind();
        }

        void setKind(ElementKind elementKind) {
            this.kind = elementKind;
        }

        void setName(String string) {
            this.name = string;
        }

        public String getName() {
            if (this.name == null) {
                this.name = this.element.getName();
            }
            return this.name;
        }

        public String getSortText() {
            return this.getName();
        }

        public String getHtml() {
            FunctionAstElement functionAstElement;
            List<String> list;
            this.formatter.reset();
            boolean bl = this.element.getModifiers().contains(Modifier.DEPRECATED);
            if (bl) {
                this.formatter.deprecated(true);
            }
            this.formatter.appendText(this.getName());
            if (bl) {
                this.formatter.deprecated(false);
            }
            if (this.element instanceof FunctionAstElement && (list = (functionAstElement = (FunctionAstElement)this.element).getParameters()) != null && list.size() > 0) {
                this.formatter.appendHtml("(");
                this.formatter.parameters(true);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.formatter.appendText(string);
                    if (!iterator.hasNext()) continue;
                    this.formatter.appendHtml(", ");
                }
                this.formatter.parameters(false);
                this.formatter.appendHtml(")");
            }
            if (this.element.getType() != null && this.element.getType() != Node.UNKNOWN_TYPE) {
                this.formatter.appendHtml(" : ");
                this.formatter.appendText(JsUtils.normalizeTypeString(this.element.getType()));
            }
            return this.formatter.getText();
        }

        public ElementHandle getElementHandle() {
            return this.element;
        }

        public ElementKind getKind() {
            return this.kind;
        }

        public Set<Modifier> getModifiers() {
            return this.element.getModifiers();
        }

        public boolean isLeaf() {
            switch (this.kind) {
                case METHOD: 
                case CONSTRUCTOR: 
                case ATTRIBUTE: 
                case CONSTANT: 
                case FIELD: 
                case KEYWORD: 
                case VARIABLE: 
                case OTHER: 
                case GLOBAL: 
                case PACKAGE: 
                case PROPERTY: {
                    return true;
                }
                case CLASS: 
                case MODULE: {
                    return false;
                }
            }
            throw new RuntimeException("Unhandled kind: " + this.kind);
        }

        public List<? extends StructureItem> getNestedItems() {
            List<AstElement> list = this.element.getChildren();
            if (list != null && list.size() > 0) {
                ArrayList<JsStructureItem> arrayList = new ArrayList<JsStructureItem>(list.size());
                for (AstElement astElement : list) {
                    arrayList.add(new JsStructureItem(astElement, this.info, this.formatter));
                }
                return arrayList;
            }
            return Collections.emptyList();
        }

        public long getPosition() {
            return LexUtilities.getLexerOffset(this.info, this.element.getNode().getSourceStart());
        }

        public long getEndPosition() {
            return LexUtilities.getLexerOffset(this.info, this.element.getNode().getSourceEnd());
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof JsStructureItem)) {
                return false;
            }
            JsStructureItem jsStructureItem = (JsStructureItem)object;
            if (this.kind != jsStructureItem.kind) {
                return false;
            }
            return this.getName().equals(jsStructureItem.getName());
        }

        public int hashCode() {
            int n = 7;
            n = 29 * n + (this.getName() != null ? this.getName().hashCode() : 0);
            n = 29 * n + (this.kind != null ? this.kind.hashCode() : 0);
            return n;
        }

        public String toString() {
            return this.getName();
        }

        public ImageIcon getCustomIcon() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JsFakeClassStructureItem
    implements StructureItem {
        private List<StructureItem> children = new ArrayList<StructureItem>();
        private String name;
        private AstElement element;
        private ElementKind kind;
        private CompilationInfo info;
        private HtmlFormatter formatter;
        private int begin;
        private int end;

        private JsFakeClassStructureItem(String string, ElementKind elementKind, AstElement astElement, CompilationInfo compilationInfo, HtmlFormatter htmlFormatter) {
            this.name = string;
            this.kind = elementKind;
            this.element = astElement;
            this.info = compilationInfo;
            this.formatter = htmlFormatter;
        }

        private void addChild(StructureItem structureItem) {
            this.children.add(structureItem);
        }

        public String getName() {
            return this.name;
        }

        public String getSortText() {
            return this.getName();
        }

        public String getHtml() {
            this.formatter.reset();
            this.formatter.appendText(this.name);
            return this.formatter.getText();
        }

        public ElementHandle getElementHandle() {
            return this.element;
        }

        public ElementKind getKind() {
            return this.kind;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isLeaf() {
            return this.children.size() == 0;
        }

        public List<? extends StructureItem> getNestedItems() {
            return this.children;
        }

        public long getPosition() {
            return this.begin;
        }

        public long getEndPosition() {
            return this.end;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof JsFakeClassStructureItem)) {
                return false;
            }
            JsFakeClassStructureItem jsFakeClassStructureItem = (JsFakeClassStructureItem)object;
            if (this.kind != jsFakeClassStructureItem.kind) {
                return false;
            }
            return this.getName().equals(jsFakeClassStructureItem.getName());
        }

        public int hashCode() {
            int n = 7;
            n = 29 * n + (this.getName() != null ? this.getName().hashCode() : 0);
            n = 29 * n + (this.kind != null ? this.kind.hashCode() : 0);
            return n;
        }

        public String toString() {
            return this.getName();
        }

        public ImageIcon getCustomIcon() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnalysisResult
    implements ParseTreeVisitor {
        private List<AstElement> elements = new ArrayList<AstElement>();
        private List<String> imports;
        private CompilationInfo info;
        private Map<String, String> classExtends;
        private Set<String> fields;
        private Node inConstructor;
        private Node currentFunction;
        private Map<String, String> classToFqn;

        private AnalysisResult(CompilationInfo compilationInfo) {
            this.info = compilationInfo;
        }

        void addNameSpace(String string, String string2) {
            if (this.classToFqn == null) {
                this.classToFqn = new HashMap<String, String>();
            }
            this.classToFqn.put(string, string2);
        }

        String getNameSpace(String string) {
            if (this.classToFqn != null) {
                return this.classToFqn.get(string);
            }
            return null;
        }

        String getExtends(String string) {
            if (this.classExtends != null) {
                return this.classExtends.get(string);
            }
            return null;
        }

        Map<String, String> getExtendsMap() {
            return this.classExtends;
        }

        void addSuperClass(String string, String string2) {
            if (this.classExtends == null) {
                this.classExtends = new HashMap<String, String>();
            }
            this.classExtends.put(string.toString(), string2.toString());
        }

        @Override
        public boolean visit(Node node) {
            block0 : switch (node.getType()) {
                case 37: {
                    Node node2;
                    Node node3;
                    Node node4;
                    if (!node.hasChildren()) break;
                    Node node5 = node.getFirstChild();
                    if (node5.getType() == 38) {
                        String string = node5.getString();
                        if (!string.equals(JsAnalyzer.NETBEANS_IMPORT_FILE)) break;
                        this.processImports(node5.getNext());
                        break;
                    }
                    if (node5.getType() != 33 || (node4 = node5.getFirstChild()) == null || node4.getType() != 38 || !"YAHOO".equals(node4.getString()) || (node3 = node4.getNext()) == null || node3.getType() != 40 || !"extend".equals(node3.getString()) || (node2 = node5.getNext()) == null) break;
                    Node node6 = node2.getNext();
                    StringBuilder stringBuilder = new StringBuilder();
                    StringBuilder stringBuilder2 = new StringBuilder();
                    if (!AstUtilities.addName(stringBuilder, node2) || !AstUtilities.addName(stringBuilder2, node6)) break;
                    this.addSuperClass(stringBuilder.toString(), stringBuilder2.toString());
                    break;
                }
                case 64: {
                    AstElement astElement;
                    Object object;
                    Object object2;
                    String[] stringArray = AstUtilities.getObjectLitFqn(node);
                    String string = stringArray[0];
                    String string2 = stringArray[1];
                    if (string == null) break;
                    if (string.endsWith(".prototype")) {
                        string = string.substring(0, string.length() - ".prototype".length());
                        object2 = string;
                        object = null;
                        int n = string.lastIndexOf(46);
                        if (n != -1) {
                            object = string.substring(0, n);
                            object2 = string.substring(n + 1);
                        }
                        if ((astElement = AstElement.createElement(this.info, node, (String)object2, (String)object, this)) != null) {
                            this.checkDocumentation(astElement);
                            astElement.setKind(ElementKind.CONSTRUCTOR);
                            this.elements.add(astElement);
                        }
                    }
                    if (string2 != null) {
                        this.addSuperClass(string, string2.toString());
                    }
                    for (object2 = node.getFirstChild(); object2 != null; object2 = object2.getNext()) {
                        String string3;
                        if (object2.getType() != 157 || (object = AstUtilities.getLabelledNode(object2)) == null) continue;
                        if (object.getType() == 105 && ((FunctionNode)object).getFunctionName().length() > 0) break block0;
                        String string4 = object2.getString();
                        astElement = AstElement.createElement(this.info, object, string4, string, this);
                        if (astElement == null) continue;
                        this.checkDocumentation(astElement);
                        if (object.getType() != 105) {
                            astElement.setKind(ElementKind.PROPERTY);
                            string3 = AstUtilities.getExpressionType(object);
                            if (string3 != null) {
                                astElement.setType(string3);
                            }
                        } else if (astElement.getKind() == ElementKind.CONSTRUCTOR) {
                            this.inConstructor = object;
                            string3 = astElement.getIn();
                            if (string3 != null && string3.length() > 0) {
                                astElement.setType(string3);
                            } else {
                                astElement.setType(astElement.getName());
                            }
                        }
                        this.elements.add(astElement);
                    }
                    break;
                }
                case 105: {
                    AstElement astElement;
                    FunctionNode functionNode = (FunctionNode)node;
                    this.currentFunction = functionNode;
                    boolean[] blArray = new boolean[1];
                    String string = AstUtilities.getFunctionFqn(node, blArray);
                    if (string == null || string.length() <= 0) break;
                    String string5 = "";
                    boolean bl = blArray[0];
                    String string6 = string;
                    int n = string.lastIndexOf(46);
                    if (n != -1) {
                        string5 = string.substring(0, n);
                        if (string5.equals("window") || string5.equals("document")) break;
                        if (!Character.isUpperCase(string5.charAt(0))) {
                            bl = true;
                        }
                        string = string.substring(n + 1);
                        if (string5.endsWith(".prototype")) {
                            string5 = string5.substring(0, string5.length() - ".prototype".length());
                        }
                    }
                    if ((astElement = AstElement.createElement(this.info, (Node)functionNode, string, string5, this)) != null) {
                        this.checkDocumentation(astElement);
                        if (!bl) {
                            astElement.markStatic();
                        }
                        this.elements.add(astElement);
                    }
                    if (!Character.isUpperCase(string.charAt(0))) break;
                    astElement.setType(string6);
                    this.inConstructor = functionNode;
                    break;
                }
                case 42: {
                    String string;
                    String string7;
                    StringBuilder stringBuilder;
                    Node node7;
                    Node node8 = node.getParentNode();
                    if (this.inConstructor != null && node8.getType() == 34) {
                        String string8;
                        int n;
                        String string9;
                        Node node9;
                        Node node10;
                        Node node11 = node8;
                        if (node11.getParentNode() == null || node11.getParentNode().getType() != 129) break;
                        for (node10 = node8; node10 != null && node10.getType() != 105; node10 = node10.getParentNode()) {
                        }
                        if (node10 != this.inConstructor || (node9 = node.getNext()) == null || node9.getType() != 40) break;
                        String string10 = node9.getString();
                        Node node12 = node9.getNext();
                        if (node12 != null && node12.getType() == 105 || !Character.isLowerCase(string10.charAt(0)) || (string9 = AstUtilities.getFqn(node, null, null)) == null) break;
                        String string11 = string9 + "." + string10;
                        if (this.fields != null && this.fields.contains(string11) || (n = string9.lastIndexOf(46) + 1) >= string9.length() || !Character.isUpperCase(string9.charAt(n))) break;
                        String string12 = string10;
                        String string13 = string9;
                        if (this.fields == null) {
                            this.fields = new HashSet<String>();
                        }
                        this.fields.add(string11);
                        AstElement astElement = AstElement.createElement(this.info, node9, string12, string13, this);
                        if (astElement == null) break;
                        this.checkDocumentation(astElement);
                        astElement.setKind(ElementKind.PROPERTY);
                        if (node12 != null && (string8 = AstUtilities.getExpressionType(node12)) != null) {
                            astElement.setType(string8);
                        }
                        this.elements.add(astElement);
                        break;
                    }
                    if (this.inConstructor == null || node8.getType() != 37 || (node7 = node8.getFirstChild()).getType() != 33 || !AstUtilities.addName(stringBuilder = new StringBuilder(), node7) || !(string7 = stringBuilder.toString()).endsWith(JsAnalyzer.DOT_CALL) || (string = AstUtilities.getFqn(node8, null, null)) == null) break;
                    String string14 = string7.substring(0, string7.length() - JsAnalyzer.DOT_CALL.length());
                    this.addSuperClass(string, string14.toString());
                    break;
                }
                case 4: {
                    if (this.currentFunction == null || this.currentFunction.nodeType == Node.UNKNOWN_TYPE) break;
                    Node node13 = node.getFirstChild();
                    String string = node13 == null ? "void" : AstUtilities.getExpressionType(node13);
                    if (string == Node.UNKNOWN_TYPE) {
                        this.currentFunction.nodeType = Node.UNKNOWN_TYPE;
                        break;
                    }
                    if (this.currentFunction.nodeType == null) {
                        this.currentFunction.nodeType = string;
                        break;
                    }
                    if (string == null || this.currentFunction.nodeType.indexOf(string) != -1) break;
                    this.currentFunction.nodeType = this.currentFunction.nodeType + "|" + string;
                }
            }
            return false;
        }

        @Override
        public boolean unvisit(Node node) {
            if (node.getType() == 105) {
                if (this.currentFunction != null && this.currentFunction.nodeType == null && this.info != null && !this.info.getFileObject().getNameExt().startsWith("stub_")) {
                    this.currentFunction.nodeType = "void";
                }
                this.currentFunction = null;
                for (Node node2 = node.getParentNode(); node2 != null; node2 = node2.getParentNode()) {
                    if (node2.getType() != 105) continue;
                    this.currentFunction = node2;
                    break;
                }
            }
            return false;
        }

        private void checkDocumentation(AstElement astElement) {
            Object object;
            if (astElement.in != null && astElement.in.length() > 0) {
                object = this.getNameSpace(astElement.in);
                if (object != null) {
                    astElement.in = (String)object + "." + astElement.in;
                }
            } else if (Character.isUpperCase(astElement.name.charAt(0)) && (object = this.getNameSpace(astElement.name)) != null) {
                astElement.in = object;
            }
            object = astElement.getDocProps();
            if (object != null) {
                String string;
                String string2 = (String)object.get("@extends");
                if (string2 != null) {
                    this.addSuperClass(astElement.name, string2);
                }
                if ((string = (String)object.get("@namespace")) != null) {
                    this.addNameSpace(astElement.name, string);
                    astElement.in = string;
                }
            }
        }

        private void postProcess(JsParseResult jsParseResult) {
            VariableVisitor variableVisitor;
            List<Node> list;
            if (jsParseResult.getRootNode() != null && (list = (variableVisitor = jsParseResult.getVariableVisitor()).getGlobalVars(true)).size() > 0) {
                HashSet<String> hashSet = new HashSet<String>();
                for (Node node : list) {
                    String string = node.getString();
                    if (hashSet.contains(string)) continue;
                    hashSet.add(string);
                    GlobalAstElement globalAstElement = new GlobalAstElement(this.info, node);
                    node.element = globalAstElement;
                    this.elements.add(globalAstElement);
                }
            }
        }

        private void processImports(Node node) {
            if (this.imports == null) {
                this.imports = new ArrayList<String>();
            }
            while (node != null) {
                assert (node.getType() == 40);
                String string = node.getString();
                if (string.indexOf(",") != -1) {
                    String[] stringArray;
                    for (String string2 : stringArray = string.split(",")) {
                        if (string2.startsWith("'") || string2.startsWith("\"")) {
                            this.imports.add(string2.substring(1, string2.length() - 1));
                            continue;
                        }
                        this.imports.add(string2);
                    }
                } else {
                    this.imports.add(string);
                }
                node = node.getNext();
            }
        }

        public List<String> getImports() {
            if (this.imports == null) {
                return Collections.emptyList();
            }
            return this.imports;
        }

        public List<? extends AstElement> getElements() {
            return this.elements;
        }
    }
}

