/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Node;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.FunctionAstElement;
import org.netbeans.modules.javascript.editing.JsAnalyzer;
import org.netbeans.modules.javascript.editing.JsElement;
import org.netbeans.modules.javascript.editing.lexer.JsCommentLexer;
import org.netbeans.modules.javascript.editing.lexer.JsCommentTokenId;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstElement
extends JsElement {
    public static final Set<Modifier> NONE = EnumSet.noneOf(Modifier.class);
    public static final Set<Modifier> STATIC = EnumSet.of(Modifier.STATIC);
    public static final Set<Modifier> PRIVATE = EnumSet.of(Modifier.PRIVATE);
    public static final Set<Modifier> STATIC_PRIVATE = EnumSet.of(Modifier.PRIVATE, Modifier.STATIC);
    protected List<AstElement> children;
    protected Node node;
    protected String name;
    protected String in;
    protected CompilationInfo info;
    protected String signature;
    protected ElementKind kind;
    protected String type;
    protected Map<String, String> docProps;
    protected String fqn;
    protected Set<Modifier> modifiers;

    AstElement(CompilationInfo compilationInfo, Node node) {
        this.info = compilationInfo;
        this.node = node;
    }

    public String getSignature() {
        if (this.signature == null) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.getIn();
            if (string != null && string.length() > 0) {
                stringBuilder.append(string);
                stringBuilder.append(".");
            }
            stringBuilder.append(this.getName());
            this.signature = stringBuilder.toString();
        }
        return this.signature;
    }

    public Node getNode() {
        return this.node;
    }

    public Map<String, String> getDocProps() {
        return this.docProps;
    }

    @Override
    public String getFqn() {
        if (this.fqn == null) {
            assert (this.name != null);
            this.fqn = this.in != null && this.in.length() > 0 ? this.in + "." + this.name : this.name;
        }
        return this.fqn;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            if (this.fqn != null) {
                int n = this.fqn.lastIndexOf(46);
                if (n != -1) {
                    this.name = this.fqn.substring(n + 1);
                    this.in = this.fqn.substring(0, n);
                }
            } else if (this.node.getType() == 118) {
                Node node;
                if (this.node.hasChildren() && (node = this.node.getFirstChild()).getType() == 38) {
                    this.name = node.getString();
                }
            } else if (this.node.isStringNode()) {
                this.name = this.node.getString();
            }
        }
        return this.name;
    }

    @Override
    public String getIn() {
        if (this.in == null) {
            this.in = "";
        }
        return this.in;
    }

    void setKind(ElementKind elementKind) {
        this.kind = elementKind;
    }

    @Override
    public ElementKind getKind() {
        if (this.kind == null) {
            switch (this.node.getType()) {
                case 38: 
                case 48: 
                case 155: {
                    return ElementKind.VARIABLE;
                }
            }
            return ElementKind.OTHER;
        }
        return this.kind;
    }

    public List<AstElement> getChildren() {
        return Collections.emptyList();
    }

    public String toString() {
        return "JsElement:" + this.getName() + "(" + this.getKind() + ")";
    }

    public CompilationInfo getInfo() {
        return this.info;
    }

    @Override
    public Set<Modifier> getModifiers() {
        if (this.modifiers == null) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            if (this.getName().startsWith("_")) {
                bl2 = true;
            }
            if (this.docProps != null) {
                if (this.docProps.containsKey("@deprecated")) {
                    bl = true;
                }
                if (this.docProps.containsKey("@private")) {
                    bl2 = true;
                }
                if (this.docProps.containsKey("@constructor")) {
                    bl3 = true;
                }
                if (this.docProps.containsKey("@return")) {
                    this.type = this.docProps.get("@return");
                }
                if (bl || bl2 || bl3) {
                    this.modifiers = EnumSet.noneOf(Modifier.class);
                    if (bl) {
                        this.modifiers.add(Modifier.DEPRECATED);
                    }
                    if (bl2) {
                        this.modifiers.add(Modifier.PRIVATE);
                    }
                    if (bl3) {
                        this.kind = ElementKind.CONSTRUCTOR;
                    }
                } else {
                    this.modifiers = NONE;
                }
            } else {
                this.modifiers = bl2 ? PRIVATE : NONE;
            }
        }
        return this.modifiers;
    }

    void markStatic() {
        this.getModifiers();
        if (this.modifiers == NONE) {
            this.modifiers = STATIC;
        } else {
            this.modifiers = EnumSet.copyOf(this.modifiers);
            this.modifiers.add(Modifier.STATIC);
        }
    }

    private void initDocProps(CompilationInfo compilationInfo) {
        Map<String, String> map;
        TokenSequence<? extends JsCommentTokenId> tokenSequence;
        if (this.node == null) {
            return;
        }
        BaseDocument baseDocument = LexUtilities.getDocument(compilationInfo, true);
        if (baseDocument != null && (tokenSequence = AstUtilities.getCommentFor(compilationInfo, baseDocument, this.node)) != null && (map = JsCommentLexer.findFunctionTypes(tokenSequence)) != null) {
            this.docProps = map;
        }
    }

    public static AstElement createElement(CompilationInfo compilationInfo, Node node, String string, String string2, JsAnalyzer.AnalysisResult analysisResult) {
        assert (node.element == null) : node + " in " + compilationInfo.getText();
        AstElement astElement = AstElement.getElement(compilationInfo, node);
        if ("Element.Methods".equals(string2)) {
            string2 = "Element";
        }
        astElement.name = string;
        astElement.in = string2;
        return astElement;
    }

    public static AstElement getElement(CompilationInfo compilationInfo, Node node) {
        if (node.element != null) {
            return (AstElement)node.element;
        }
        switch (node.getType()) {
            case 105: {
                if (!(node instanceof FunctionNode)) break;
                FunctionAstElement functionAstElement = new FunctionAstElement(compilationInfo, (FunctionNode)node);
                super.initDocProps(compilationInfo);
                node.element = functionAstElement;
                return functionAstElement;
            }
        }
        AstElement astElement = new AstElement(compilationInfo, node);
        astElement.initDocProps(compilationInfo);
        node.element = astElement;
        return astElement;
    }

    void setType(String string) {
        this.type = string;
    }

    public String getType() {
        if (this.type == null) {
            this.type = this.node.nodeType;
            if (this.node.nodeType == null) {
                this.getModifiers();
            }
        }
        return this.type;
    }
}

