/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.jsf.text;

import java.util.Arrays;
import org.netbeans.modules.visualweb.api.designer.DomProvider;
import org.netbeans.modules.visualweb.api.designer.markup.MarkupService;
import org.netbeans.modules.visualweb.designer.jsf.text.DomDocumentImpl;
import org.netbeans.modules.visualweb.insync.faces.Entities;
import org.openide.ErrorManager;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class DomPositionImpl
implements DomProvider.DomPosition {
    private final DomDocumentImpl domDocumentImpl;
    private final Node node;
    private final int offset;
    private final DomProvider.DomPosition.Bias bias;

    static DomProvider.DomPosition create(DomDocumentImpl domDocumentImpl, Node node, int n, DomProvider.DomPosition.Bias bias) {
        if (domDocumentImpl == null || node == null) {
            return NONE;
        }
        return new DomPositionImpl(domDocumentImpl, node, n, bias);
    }

    private DomPositionImpl(DomDocumentImpl domDocumentImpl, Node node, int n, DomProvider.DomPosition.Bias bias) {
        if (domDocumentImpl == null || node == null) {
            throw new NullPointerException("Parameters domDocumentImpl or node may not be null, domDocumentImpl=" + domDocumentImpl + ", node=" + node);
        }
        this.domDocumentImpl = domDocumentImpl;
        this.node = node;
        this.offset = n;
        this.bias = bias;
    }

    public DomProvider.DomPosition.Bias getBias() {
        return this.bias;
    }

    static DomProvider.DomPosition createNext(DomDocumentImpl domDocumentImpl, Node node, boolean bl) {
        if (node == null) {
            return NONE;
        }
        if (node.getNodeType() == 3) {
            return new DomPositionImpl(domDocumentImpl, node, bl ? node.getNodeValue().length() : 0, bl ? DomProvider.DomPosition.Bias.BACKWARD : DomProvider.DomPosition.Bias.FORWARD);
        }
        Node node2 = node.getParentNode();
        if (node2 == null) {
            return NONE;
        }
        int n = -1;
        while (node != null) {
            node = node.getPreviousSibling();
            ++n;
        }
        if (bl) {
            ++n;
        }
        return new DomPositionImpl(domDocumentImpl, node2, n, bl ? DomProvider.DomPosition.Bias.BACKWARD : DomProvider.DomPosition.Bias.FORWARD);
    }

    public int getOffset() {
        return this.offset;
    }

    public Node getNode() {
        return this.node;
    }

    public boolean isInside(Element element) {
        if (this == NONE) {
            return false;
        }
        Node node = element;
        Node node2 = element.getParentNode();
        if (node2 == null) {
            return false;
        }
        int n = -1;
        while (node != null) {
            node = node.getPreviousSibling();
            ++n;
        }
        return DomPositionImpl.compareBoundaryPoints(node2, n, this.node, this.offset) > 0 && DomPositionImpl.compareBoundaryPoints(node2, n + 1, this.node, this.offset) < 0;
    }

    public boolean isEarlierThan(DomProvider.DomPosition domPosition) {
        return DomPositionImpl.compareBoundaryPoints(domPosition, this) <= 0;
    }

    public boolean isLaterThan(DomProvider.DomPosition domPosition) {
        return DomPositionImpl.compareBoundaryPoints(domPosition, this) >= 0;
    }

    public boolean isStrictlyEarlierThan(DomProvider.DomPosition domPosition) {
        return DomPositionImpl.compareBoundaryPoints(domPosition, this) < 0;
    }

    public boolean isStrictlyLaterThan(DomProvider.DomPosition domPosition) {
        return DomPositionImpl.compareBoundaryPoints(domPosition, this) > 0;
    }

    public boolean equals(Object object) {
        if (object instanceof DomPositionImpl) {
            DomPositionImpl domPositionImpl = (DomPositionImpl)object;
            return this.getNode() == domPositionImpl.getNode() && this.getOffset() == domPositionImpl.getOffset();
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.getNode(), this.getOffset()});
    }

    public static short compareBoundaryPoints(DomProvider.DomPosition domPosition, DomProvider.DomPosition domPosition2) {
        assert (domPosition != NONE && domPosition2 != NONE);
        Node node = domPosition.getNode();
        int n = domPosition.getOffset();
        Node node2 = domPosition2.getNode();
        int n2 = domPosition2.getOffset();
        return DomPositionImpl.compareBoundaryPoints(node, n, node2, n2);
    }

    public static short compareBoundaryPoints(Node node, int n, Node node2, int n2) {
        Node node3;
        if (node == node2) {
            if (n < n2) {
                return 1;
            }
            if (n == n2) {
                return 0;
            }
            return -1;
        }
        Node node4 = node2;
        for (node3 = node4.getParentNode(); node3 != null; node3 = node3.getParentNode()) {
            if (node3 == node) {
                int n3 = DomPositionImpl.indexOf(node4, node);
                if (n <= n3) {
                    return 1;
                }
                return -1;
            }
            node4 = node3;
        }
        node4 = node;
        for (node3 = node4.getParentNode(); node3 != null; node3 = node3.getParentNode()) {
            if (node3 == node2) {
                int n4 = DomPositionImpl.indexOf(node4, node2);
                if (n4 < n2) {
                    return 1;
                }
                return -1;
            }
            node4 = node3;
        }
        int n5 = 0;
        for (node3 = node; node3 != null; node3 = node3.getParentNode()) {
            ++n5;
        }
        for (node3 = node2; node3 != null; node3 = node3.getParentNode()) {
            --n5;
        }
        while (n5 > 0) {
            node = node.getParentNode();
            --n5;
        }
        while (n5 < 0) {
            node2 = node2.getParentNode();
            ++n5;
        }
        node3 = node.getParentNode();
        for (Node node5 = node2.getParentNode(); node3 != node5; node3 = node3.getParentNode(), node5 = node5.getParentNode()) {
            node = node3;
            node2 = node5;
        }
        for (node3 = node.getNextSibling(); node3 != null; node3 = node3.getNextSibling()) {
            if (node3 != node2) continue;
            return 1;
        }
        return -1;
    }

    private static int indexOf(Node node, Node node2) {
        if (node.getParentNode() != node2) {
            return -1;
        }
        int n = 0;
        for (Node node3 = node2.getFirstChild(); node3 != node; node3 = node3.getNextSibling()) {
            ++n;
        }
        return n;
    }

    public static DomProvider.DomPosition first(DomProvider.DomPosition domPosition, DomProvider.DomPosition domPosition2) {
        if (domPosition == NONE) {
            return domPosition2;
        }
        if (domPosition2 == NONE) {
            return domPosition;
        }
        if (domPosition.isEarlierThan(domPosition2)) {
            return domPosition;
        }
        return domPosition2;
    }

    public static DomProvider.DomPosition last(DomProvider.DomPosition domPosition, DomProvider.DomPosition domPosition2) {
        if (domPosition == NONE) {
            return domPosition2;
        }
        if (domPosition2 == NONE) {
            return domPosition;
        }
        if (domPosition.isLaterThan(domPosition2)) {
            return domPosition;
        }
        return domPosition2;
    }

    public String toString() {
        if (this == NONE) {
            return "Position.NONE";
        }
        Node node = this.node;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        String string = node instanceof DocumentFragment ? "FRAG" : "DOC";
        if (this.node instanceof Text) {
            String string2 = this.node.getNodeValue();
            String string3 = string2.substring(0, this.offset);
            String string4 = string2.substring(this.offset);
            return "Position-" + string + "(rendered=" + this.domDocumentImpl.isRenderedNode(this.node) + ",[#text:" + this.offset + ": Bias=" + this.bias + "; " + string3 + "^" + string4 + "])";
        }
        NodeList nodeList = this.node.getChildNodes();
        String string5 = "";
        if (this.offset < nodeList.getLength()) {
            string5 = " (before " + nodeList.item(this.offset) + ")";
            if (this.offset > 0) {
                string5 = string5 + " (after " + nodeList.item(this.offset - 1) + ")";
            }
        } else if (this.offset == nodeList.getLength() && this.offset > 0) {
            string5 = " (after " + nodeList.item(this.offset - 1) + ")";
        }
        return "Position-" + string + "(rendered=" + this.domDocumentImpl.isRenderedNode(this.node) + "," + this.getNode() + "," + this.getOffset() + "):" + this.bias + "; " + string5;
    }

    public boolean isRenderedPosition() {
        if (this == NONE) {
            return false;
        }
        return this.domDocumentImpl.isRenderedNode(this.node);
    }

    public boolean isSourcePosition() {
        if (this == NONE) {
            return false;
        }
        return this.node == MarkupService.getSourceNodeForNode((Node)this.node);
    }

    public DomProvider.DomPosition getRenderedPosition() {
        if (this.domDocumentImpl.isRenderedNode(this.node)) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Node is expected not rendered, node=" + this.node));
        }
        Node node = this.node;
        NodeList nodeList = node.getChildNodes();
        int n = this.offset;
        if (node.getNodeType() == 1 || node.getNodeType() == 11) {
            if (nodeList.getLength() == 0) {
                Node node2 = MarkupService.getRenderedNodeForNode((Node)node);
                if (node2 != null) {
                    return this.domDocumentImpl.createDomPosition(node2, 0, DomProvider.DomPosition.Bias.FORWARD);
                }
                return DomProvider.DomPosition.NONE;
            }
            if (this.bias == DomProvider.DomPosition.Bias.BACKWARD && n > 0 && n - 1 < nodeList.getLength()) {
                node = node.getChildNodes().item(n - 1);
                return this.domDocumentImpl.createNextDomPosition(MarkupService.getRenderedNodeForNode((Node)node), true);
            }
            if (n < nodeList.getLength()) {
                node = node.getChildNodes().item(n);
                return this.domDocumentImpl.createNextDomPosition(MarkupService.getRenderedNodeForNode((Node)node), false);
            }
            node = node.getChildNodes().item(nodeList.getLength() - 1);
            return this.domDocumentImpl.createNextDomPosition(MarkupService.getRenderedNodeForNode((Node)node), true);
        }
        if (node instanceof Text) {
            String string;
            String string2;
            Text text;
            Text text2 = (Text)node;
            if (this.domDocumentImpl.isRenderedNode(text2)) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Node is expected to be not rendered, node=" + text2));
            }
            if ((text = MarkupService.getRenderedTextForText((Text)text2)) == null) {
                return NONE;
            }
            if (n > node.getNodeValue().length()) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Offset is greater than expected, offset=" + n + ", node.getNodeValue().lenght()=" + node.getNodeValue().length() + ", for node=" + node));
                return DomProvider.DomPosition.NONE;
            }
            int n2 = MarkupService.isJspxNode((Node)text2) ? ((string2 = text2.getNodeValue()) == (string = text.getNodeValue()) || string2.indexOf(38) == -1 ? n : Entities.getExpandedOffset((String)string2, (int)n)) : n;
            int n3 = text.getNodeValue().length();
            if (n2 > n3) {
                n2 = n3;
            }
            return new DomPositionImpl(this.domDocumentImpl, text, n2, this.bias);
        }
        ErrorManager.getDefault().log("Unexpected node type in getRendered: " + node);
        return NONE;
    }

    public DomProvider.DomPosition getSourcePosition() {
        if (!this.domDocumentImpl.isRenderedNode(this.node)) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Node is expected to be rendered, node=" + this.node));
        }
        Node node = this.node;
        NodeList nodeList = node.getChildNodes();
        int n = this.offset;
        if (node.getNodeType() == 1 || node.getNodeType() == 11) {
            if (nodeList.getLength() == 0) {
                Node node2 = MarkupService.getSourceNodeForNode((Node)node);
                if (node2 != null) {
                    return new DomPositionImpl(this.domDocumentImpl, node2, 0, DomProvider.DomPosition.Bias.FORWARD);
                }
                return DomProvider.DomPosition.NONE;
            }
            if (this.bias == DomProvider.DomPosition.Bias.BACKWARD && n > 0 && n - 1 < nodeList.getLength()) {
                for (Node node3 = node = node.getChildNodes().item(n - 1); node3 != null; node3 = node3.getParentNode()) {
                    Node node4 = MarkupService.getSourceNodeForNode((Node)node3);
                    if (node4 == null) continue;
                    return this.domDocumentImpl.createNextDomPosition(node4, true);
                }
                return DomProvider.DomPosition.NONE;
            }
            if (n < nodeList.getLength()) {
                for (Node node5 = node = node.getChildNodes().item(n); node5 != null; node5 = node5.getParentNode()) {
                    Node node6 = MarkupService.getSourceNodeForNode((Node)node5);
                    if (node6 == null) continue;
                    return this.domDocumentImpl.createNextDomPosition(node6, false);
                }
                return NONE;
            }
            for (Node node7 = node = node.getChildNodes().item(nodeList.getLength() - 1); node7 != null; node7 = node7.getParentNode()) {
                Node node8 = MarkupService.getSourceNodeForNode((Node)node7);
                if (node8 == null) continue;
                return this.domDocumentImpl.createNextDomPosition(node8, true);
            }
            return NONE;
        }
        if (node instanceof Text) {
            String string;
            String string2;
            Text text;
            Text text2 = (Text)node;
            if (!this.domDocumentImpl.isRenderedNode(text2)) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Node is expected to be rendered, node=" + node));
            }
            if ((text = MarkupService.getSourceTextForText((Text)text2)) == null) {
                return NONE;
            }
            assert (n <= text2.getNodeValue().length());
            int n2 = MarkupService.isJspxNode((Node)text) ? ((string2 = text.getNodeValue()) == (string = text2.getNodeValue()) || string2.indexOf(38) == -1 ? n : Entities.getUnexpandedOffset((String)string2, (int)n)) : n;
            int n3 = text.getNodeValue().length();
            if (n2 > n3) {
                n2 = n3;
            }
            return new DomPositionImpl(this.domDocumentImpl, text, n2, this.bias);
        }
        ErrorManager.getDefault().log("Unexpected node type in getSource: " + node);
        return NONE;
    }

    public Element getTargetElement() {
        if (this == NONE || this.node instanceof Text) {
            return null;
        }
        NodeList nodeList = this.node.getChildNodes();
        Node node = null;
        if (this.bias == DomProvider.DomPosition.Bias.FORWARD) {
            if (this.offset < nodeList.getLength()) {
                node = nodeList.item(this.offset);
            } else if (this.offset == nodeList.getLength() && this.offset > 0) {
                node = nodeList.item(this.offset - 1);
            }
        } else if (this.offset > 0) {
            node = nodeList.item(this.offset - 1);
        }
        if (node instanceof Element) {
            return (Element)node;
        }
        return null;
    }
}

