/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.jsf.action;

import com.sun.rave.designtime.DesignBean;
import org.netbeans.modules.visualweb.api.designer.Designer;
import org.netbeans.modules.visualweb.designer.jsf.JsfSupportUtilities;
import org.netbeans.modules.visualweb.insync.Util;
import org.netbeans.modules.visualweb.spi.designtime.idebridge.action.AbstractDesignBeanAction;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;

public class SelectParentAction
extends AbstractDesignBeanAction {
    protected String getDisplayName(DesignBean[] designBeanArray) {
        return NbBundle.getMessage(SelectParentAction.class, (String)"LBL_SelectParentAction");
    }

    protected String getIconBase(DesignBean[] designBeanArray) {
        return null;
    }

    protected boolean isEnabled(DesignBean[] designBeanArray) {
        if (designBeanArray.length == 0) {
            return false;
        }
        DesignBean designBean = designBeanArray[0];
        return SelectParentAction.canSelectParent(designBean);
    }

    protected void performAction(DesignBean[] designBeanArray) {
        if (designBeanArray.length == 0) {
            return;
        }
        DesignBean designBean = designBeanArray[0];
        SelectParentAction.selectParent(designBean);
    }

    private static boolean canSelectParent(DesignBean designBean) {
        if (designBean == null) {
            return false;
        }
        DesignBean designBean2 = SelectParentAction.findSelectableParent(designBean);
        if (designBean2 == null) {
            return false;
        }
        if (designBean2 == designBean2.getDesignContext().getRootContainer()) {
            return false;
        }
        return !Util.isSpecialBean((DesignBean)designBean2);
    }

    private static void selectParent(DesignBean designBean) {
        if (designBean == null) {
            return;
        }
        DesignBean designBean2 = SelectParentAction.findSelectableParent(designBean);
        if (designBean2 == null) {
            return;
        }
        Element element = JsfSupportUtilities.getComponentRootElementForDesignBean(designBean2);
        if (element == null) {
            return;
        }
        Designer designer = JsfSupportUtilities.findDesignerForDesignContext(designBean.getDesignContext());
        if (designer == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("Can't find designer for design context=" + designBean.getDesignContext()));
            return;
        }
        designer.selectComponent(element);
    }

    private static DesignBean findSelectableParent(DesignBean designBean) {
        if (designBean == null) {
            return null;
        }
        Designer designer = JsfSupportUtilities.findDesignerForDesignContext(designBean.getDesignContext());
        if (designer == null) {
            return null;
        }
        for (DesignBean designBean2 = designBean.getBeanParent(); designBean2 != null; designBean2 = designBean2.getBeanParent()) {
            Element element = JsfSupportUtilities.getComponentRootElementForDesignBean(designBean2);
            if (element == null || designer.findBoxForComponentRootElement(element) == null) continue;
            return designBean2;
        }
        return null;
    }
}

