/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.jsf;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignEvent;
import com.sun.rave.designtime.DesignProject;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.DisplayItem;
import com.sun.rave.designtime.Position;
import com.sun.rave.designtime.Result;
import com.sun.rave.designtime.event.DesignContextListener;
import com.sun.rave.designtime.event.DesignProjectListener;
import com.sun.rave.designtime.markup.MarkupDesignBean;
import com.sun.rave.designtime.markup.MarkupPosition;
import java.awt.EventQueue;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.modules.visualweb.api.designer.Designer;
import org.netbeans.modules.visualweb.api.designer.DesignerFactory;
import org.netbeans.modules.visualweb.api.designer.DomProvider;
import org.netbeans.modules.visualweb.api.designer.markup.MarkupService;
import org.netbeans.modules.visualweb.api.designtime.idebridge.DesigntimeIdeBridgeProvider;
import org.netbeans.modules.visualweb.designer.html.HtmlTag;
import org.netbeans.modules.visualweb.designer.jsf.DndSupport;
import org.netbeans.modules.visualweb.designer.jsf.DomProviderImpl;
import org.netbeans.modules.visualweb.designer.jsf.DomSynchronizer;
import org.netbeans.modules.visualweb.designer.jsf.ExternalDomProviderCache;
import org.netbeans.modules.visualweb.designer.jsf.FacesDndSupport;
import org.netbeans.modules.visualweb.designer.jsf.JsfSupportUtilities;
import org.netbeans.modules.visualweb.designer.jsf.RefreshServiceImpl;
import org.netbeans.modules.visualweb.designer.jsf.palette.PaletteControllerFactory;
import org.netbeans.modules.visualweb.designer.jsf.text.DomDocumentImpl;
import org.netbeans.modules.visualweb.designer.jsf.ui.ErrorPanelImpl;
import org.netbeans.modules.visualweb.designer.jsf.ui.JsfMultiViewElement;
import org.netbeans.modules.visualweb.designer.jsf.ui.NotAvailableMultiViewElement;
import org.netbeans.modules.visualweb.designer.jsf.ui.RenderErrorPanelImpl;
import org.netbeans.modules.visualweb.insync.ModelSet;
import org.netbeans.modules.visualweb.insync.ModelSetsListener;
import org.netbeans.modules.visualweb.insync.ResultHandler;
import org.netbeans.modules.visualweb.insync.UndoEvent;
import org.netbeans.modules.visualweb.insync.Unit;
import org.netbeans.modules.visualweb.insync.Util;
import org.netbeans.modules.visualweb.insync.beans.Bean;
import org.netbeans.modules.visualweb.insync.faces.FacesBean;
import org.netbeans.modules.visualweb.insync.faces.FacesPageUnit;
import org.netbeans.modules.visualweb.insync.faces.MarkupBean;
import org.netbeans.modules.visualweb.insync.java.JavaUnit;
import org.netbeans.modules.visualweb.insync.live.LiveUnit;
import org.netbeans.modules.visualweb.insync.markup.MarkupUnit;
import org.netbeans.modules.visualweb.insync.models.FacesModel;
import org.netbeans.modules.visualweb.insync.models.FacesModelSet;
import org.netbeans.spi.palette.PaletteController;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class JsfForm {
    private static final Set<JsfForm> jsfForms = new WeakSet();
    private final Set<Designer> designers = new WeakSet();
    private static final Set<JsfMultiViewElement> jsfMultiViewElements = new WeakSet();
    private static final Map<DesignProject, JsfDesignProjectListener> designProject2jsfDesignProjectListener = new WeakHashMap<DesignProject, JsfDesignProjectListener>();
    private static final ReadWriteLock jsfFormsLock = new ReentrantReadWriteLock();
    private static final ReadWriteLock jsfMultiViewElementsLock = new ReentrantReadWriteLock();
    private static final ReadWriteLock designersLock = new ReentrantReadWriteLock();
    private static final ReadWriteLock designProject2jsfDesignProjectListenersLock = new ReentrantReadWriteLock();
    private FacesModel facesModel;
    private DomSynchronizer domSynchronizer;
    private DesignContextListener designContextListener;
    private boolean isFragment;
    private boolean isPortlet;
    private PaletteController paletteController;
    private final DomProvider domProvider = new DomProviderImpl(this);
    private Exception renderFailureException;
    private MarkupDesignBean renderFailureComponent;
    private boolean renderFailureShown;
    private final DomDocumentImpl domDocumentImpl = new DomDocumentImpl(this);
    private final ExternalDomProviderCache externalDomProviderCache = new ExternalDomProviderCache();
    private JsfForm contextJsfForm;
    private boolean virtualFormsSupportEnabled;
    private boolean ajaxTransactionsSupportEnabled;
    private final DndSupport dndSupport = new DndSupport(this);
    private final ReadWriteLock facesModelLock = new ReentrantReadWriteLock();
    private static boolean LOAD_MODEL_SYNCHRONOUSLY = Boolean.getBoolean("vwp.designer.jsf.loadModelSync");
    private long generationSeen = 0L;
    private static final DataFlavor FLAVOR_DISPLAY_ITEM = new DataFlavor("application/x-java-jvm-local-objectref; class=" + DisplayItem.class.getName(), "RAVE_PALETTE_ITEM");

    private JsfForm(FacesModel facesModel, DataObject dataObject) {
        this.setFacesModel(facesModel);
        this.init(dataObject);
        if (this.isValid()) {
            this.init();
        }
    }

    private void init(DataObject dataObject) {
        this.initFragmentProperty(dataObject);
        this.initPaletteController(dataObject);
    }

    private void init() {
        this.initPortletProperty();
        this.initListening();
    }

    private void initFragmentProperty(DataObject dataObject) {
        FileObject fileObject = dataObject.getPrimaryFile();
        this.isFragment = "jspf".equals(fileObject.getExt());
    }

    private void initPortletProperty() {
        this.isPortlet = this.getFacesModel().getFacesModelSet() != null ? this.getFacesModel().getFacesModelSet().getFacesContainer().isPortletContainer() : false;
    }

    private void initPaletteController(DataObject dataObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile());
        if (project == null) {
            JsfForm.log(new NullPointerException("There is no project found for DataObject, jspDataObject=" + dataObject));
        }
        this.paletteController = PaletteControllerFactory.getDefault().createJsfPaletteController(project);
    }

    private void initListening() {
        this.initDesignProjectListening();
        this.updateDnDListening();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFacesModel(FacesModel facesModel) {
        this.facesModelLock.writeLock().lock();
        try {
            this.facesModel = facesModel;
        }
        finally {
            this.facesModelLock.writeLock().unlock();
        }
    }

    private static FacesModel getFacesModel(FileObject fileObject) {
        FacesModelSet facesModelSet = FacesModelSet.getInstance((FileObject)fileObject);
        if (facesModelSet != null) {
            return facesModelSet.getFacesModel(fileObject);
        }
        return null;
    }

    private static FacesModel getFacesModel(DataObject dataObject) {
        if (dataObject == null) {
            throw new NullPointerException("DataObject may not be null!");
        }
        return JsfForm.getFacesModel(dataObject.getPrimaryFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsfForm getJsfForm(DataObject dataObject) {
        JsfForm jsfForm;
        FacesModel facesModel;
        if (dataObject == null) {
            return null;
        }
        if (LOAD_MODEL_SYNCHRONOUSLY) {
            facesModel = JsfForm.getFacesModel(dataObject);
            if (facesModel == null) {
                if (!dataObject.isTemplate()) {
                    JsfForm.log(new IllegalArgumentException("There is no FacesModel available for non-template dataObject=" + dataObject));
                }
                return null;
            }
        } else {
            facesModel = FacesModelSet.getFacesModelIfAvailable((FileObject)dataObject.getPrimaryFile());
        }
        if ((jsfForm = JsfForm.findJsfFormForFacesModel(facesModel)) == null) {
            jsfFormsLock.writeLock().lock();
            try {
                jsfForm = new JsfForm(facesModel, dataObject);
                jsfForms.add(jsfForm);
            }
            finally {
                jsfFormsLock.writeLock().unlock();
            }
        }
        return jsfForm;
    }

    public static boolean tryFacesModelForJsfForm(JsfForm jsfForm, DataObject dataObject) {
        if (FacesModelSet.getFacesModelIfAvailable((FileObject)dataObject.getPrimaryFile()) == null) {
            return false;
        }
        FacesModel facesModel = jsfForm.loadFacesModel(dataObject);
        if (facesModel == null) {
            return false;
        }
        jsfForm.setFacesModel(facesModel);
        jsfForm.init();
        return true;
    }

    public static void loadFacesModelForJsfForm(final JsfForm jsfForm, final DataObject dataObject) {
        ModelSet.addModelSetsListener((ModelSetsListener)new ModelSetsListener(){

            public void modelSetAdded(ModelSet modelSet) {
                FileObject fileObject;
                Project project;
                Project project2 = modelSet.getProject();
                if (project2 == (project = FileOwnerQuery.getOwner((FileObject)(fileObject = dataObject.getPrimaryFile())))) {
                    FacesModel facesModel = jsfForm.loadFacesModel(dataObject);
                    if (facesModel != null) {
                        jsfForm.setFacesModel(facesModel);
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                jsfForm.init();
                                jsfForm.notifyViewsModelLoaded();
                            }
                        });
                    }
                    ModelSet.removeModelSetsListener((ModelSetsListener)this);
                }
            }

            public void modelSetRemoved(ModelSet modelSet) {
            }
        });
        FacesModelSet.startModeling((FileObject)dataObject.getPrimaryFile());
    }

    public static JsfForm findJsfFormForDomProvider(DomProvider domProvider) {
        if (!(domProvider instanceof DomProviderImpl)) {
            return null;
        }
        return ((DomProviderImpl)domProvider).getJsfForm();
    }

    public static Designer[] findDesigners(JsfForm jsfForm) {
        return jsfForm == null ? new Designer[]{} : jsfForm.getDesigners();
    }

    Designer createDesigner() {
        Designer designer = DesignerFactory.createDesigner((DomProvider)this.domProvider);
        this.addDesigner(designer);
        return designer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsfMultiViewElement[] getJsfMultiViewElements() {
        HashSet<JsfMultiViewElement> hashSet;
        jsfMultiViewElementsLock.readLock().lock();
        try {
            hashSet = new HashSet<JsfMultiViewElement>(jsfMultiViewElements);
        }
        finally {
            jsfMultiViewElementsLock.readLock().unlock();
        }
        if (hashSet.contains(null)) {
            hashSet.remove(null);
        }
        return hashSet.toArray(new JsfMultiViewElement[hashSet.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JsfMultiViewElement[] findJsfMultiViewElements(JsfForm jsfForm) {
        HashSet<JsfMultiViewElement> hashSet;
        if (jsfForm == null) {
            return new JsfMultiViewElement[0];
        }
        jsfMultiViewElementsLock.readLock().lock();
        try {
            hashSet = new HashSet<JsfMultiViewElement>(jsfMultiViewElements);
        }
        finally {
            jsfMultiViewElementsLock.readLock().unlock();
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            JsfMultiViewElement jsfMultiViewElement = (JsfMultiViewElement)iterator.next();
            if (jsfMultiViewElement.getJsfForm() == jsfForm) continue;
            iterator.remove();
        }
        return hashSet.toArray(new JsfMultiViewElement[hashSet.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MultiViewElement createMultiViewElement(JsfForm jsfForm, Designer designer, DataObject dataObject) {
        if (jsfForm == null || designer == null) {
            return new NotAvailableMultiViewElement();
        }
        JsfMultiViewElement jsfMultiViewElement = new JsfMultiViewElement(jsfForm, designer, dataObject);
        jsfMultiViewElementsLock.writeLock().lock();
        try {
            jsfMultiViewElements.add(jsfMultiViewElement);
        }
        finally {
            jsfMultiViewElementsLock.writeLock().unlock();
        }
        return jsfMultiViewElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsfMultiViewElement findJsfMultiViewElementForDesigner(Designer designer) {
        HashSet<JsfMultiViewElement> hashSet;
        if (designer == null) {
            return null;
        }
        jsfMultiViewElementsLock.readLock().lock();
        try {
            hashSet = new HashSet<JsfMultiViewElement>(jsfMultiViewElements);
        }
        finally {
            jsfMultiViewElementsLock.readLock().unlock();
        }
        for (JsfMultiViewElement jsfMultiViewElement : hashSet) {
            if (jsfMultiViewElement.getDesigner() != designer) continue;
            return jsfMultiViewElement;
        }
        return null;
    }

    static Designer[] getDesigners(JsfForm jsfForm) {
        if (jsfForm == null) {
            return new Designer[0];
        }
        Designer[] designerArray = JsfForm.findDesigners(jsfForm);
        if (designerArray.length == 0) {
            Designer designer = jsfForm.createDesigner();
            return new Designer[]{designer};
        }
        return designerArray;
    }

    static Designer[] getDesignersForDataObject(DataObject dataObject) {
        JsfForm jsfForm = JsfForm.getJsfForm(dataObject);
        if (jsfForm == null) {
            return new Designer[0];
        }
        return JsfForm.getDesigners(jsfForm);
    }

    static Designer[] findDesignersForDesignContext(DesignContext designContext) {
        JsfForm jsfForm = JsfForm.findJsfForm(designContext);
        if (jsfForm == null) {
            return new Designer[0];
        }
        return JsfForm.findDesigners(jsfForm);
    }

    static Designer[] findDesignersForElement(Element element) {
        JsfForm jsfForm = JsfForm.findJsfForm(element);
        if (jsfForm == null) {
            return new Designer[0];
        }
        return JsfForm.findDesigners(jsfForm);
    }

    static Designer[] findDesignersForDocument(Document document) {
        MarkupUnit markupUnit = MarkupUnit.getMarkupUnitForDocument((Document)document);
        if (markupUnit == null) {
            return new Designer[0];
        }
        return JsfForm.findDesignersForFileObject(markupUnit.getFileObject());
    }

    private static Designer[] findDesignersForFileObject(FileObject fileObject) {
        JsfForm jsfForm = JsfForm.findJsfForm(fileObject);
        if (jsfForm == null) {
            return new Designer[0];
        }
        return JsfForm.findDesigners(jsfForm);
    }

    static JsfForm findJsfForm(DataObject dataObject) {
        if (dataObject == null) {
            return null;
        }
        FacesModel facesModel = JsfForm.getFacesModel(dataObject);
        if (facesModel == null) {
            return null;
        }
        return JsfForm.findJsfFormForFacesModel(facesModel);
    }

    static JsfForm findJsfForm(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        FacesModel facesModel = JsfForm.getFacesModel(fileObject);
        if (facesModel == null) {
            return null;
        }
        return JsfForm.findJsfFormForFacesModel(facesModel);
    }

    public static JsfForm findJsfForm(DesignContext designContext) {
        if (designContext == null) {
            return null;
        }
        FacesModel facesModel = ((LiveUnit)designContext).getModel();
        if (facesModel == null) {
            return null;
        }
        return JsfForm.findJsfFormForFacesModel(facesModel);
    }

    public static JsfForm findJsfForm(Element element) {
        MarkupDesignBean markupDesignBean = MarkupUnit.getMarkupDesignBeanForElement((Element)element);
        if (markupDesignBean == null) {
            return null;
        }
        DesignContext designContext = markupDesignBean.getDesignContext();
        return JsfForm.findJsfForm(designContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JsfForm findJsfFormForFacesModel(FacesModel facesModel) {
        HashSet<JsfForm> hashSet;
        if (facesModel == null) {
            return null;
        }
        jsfFormsLock.readLock().lock();
        try {
            hashSet = new HashSet<JsfForm>(jsfForms);
        }
        finally {
            jsfFormsLock.readLock().unlock();
        }
        for (JsfForm jsfForm : hashSet) {
            if (jsfForm == null || jsfForm.getFacesModel() != facesModel) continue;
            return jsfForm;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDesignProjectListening() {
        JsfDesignProjectListener jsfDesignProjectListener;
        LiveUnit liveUnit = this.getFacesModel().getLiveUnit();
        if (liveUnit == null) {
            JsfForm.log(new NullPointerException("Invalid FacesModel, it has null LiveUnit, facesModel=" + this.getFacesModel()));
            return;
        }
        DesignProject designProject = liveUnit.getProject();
        if (designProject == null) {
            return;
        }
        designProject2jsfDesignProjectListenersLock.readLock().lock();
        try {
            jsfDesignProjectListener = designProject2jsfDesignProjectListener.get(designProject);
        }
        finally {
            designProject2jsfDesignProjectListenersLock.readLock().unlock();
        }
        if (jsfDesignProjectListener == null) {
            designProject2jsfDesignProjectListenersLock.writeLock().lock();
            try {
                jsfDesignProjectListener = new JsfDesignProjectListener();
                designProject.addDesignProjectListener((DesignProjectListener)WeakListeners.create(DesignProjectListener.class, (EventListener)((Object)jsfDesignProjectListener), (Object)designProject));
                designProject2jsfDesignProjectListener.put(designProject, jsfDesignProjectListener);
            }
            finally {
                designProject2jsfDesignProjectListenersLock.writeLock().lock();
            }
        }
    }

    private void updateDnDListening() {
        this.getDndSupport().updateDndListening();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FacesModel getFacesModel() {
        this.facesModelLock.readLock().lock();
        try {
            FacesModel facesModel = this.facesModel;
            return facesModel;
        }
        finally {
            this.facesModelLock.readLock().unlock();
        }
    }

    void setUpdatesSuspended(MarkupDesignBean markupDesignBean, boolean bl) {
        this.getDomSynchronizer().setUpdatesSuspended(markupDesignBean, bl);
    }

    private void updateDesignContextListening(DesignContext designContext) {
        this.designContextListener = new JsfDesignContextListener(this);
        designContext.addDesignContextListener((DesignContextListener)WeakListeners.create(DesignContextListener.class, (EventListener)this.designContextListener, (Object)designContext));
    }

    DocumentFragment createSourceFragment(MarkupDesignBean markupDesignBean) {
        return this.getDomSynchronizer().createSourceFragment(markupDesignBean);
    }

    void requestChange(MarkupDesignBean markupDesignBean) {
        this.getDomSynchronizer().requestChange(markupDesignBean);
    }

    void beanChanged(MarkupDesignBean markupDesignBean) {
        this.getDomSynchronizer().beanChanged((DesignBean)markupDesignBean);
    }

    void requestTextUpdate(MarkupDesignBean markupDesignBean) {
        this.getDomSynchronizer().requestTextUpdate(markupDesignBean);
    }

    void modelChanged() {
        this.notifyViewsModelChanged();
    }

    void nodeChanged(org.w3c.dom.Node node, org.w3c.dom.Node node2, Element[] elementArray) {
        this.notifyViewsNodeChanged(node, node2, elementArray);
    }

    void nodeRemoved(org.w3c.dom.Node node, org.w3c.dom.Node node2) {
        this.notifyViewsNodeRemoved(node, node2);
    }

    void nodeInserted(org.w3c.dom.Node node, org.w3c.dom.Node node2) {
        this.notifyViewsNodeInserted(node, node2);
    }

    public void updateErrorsInComponent() {
        this.updateRenderFailureValues();
        if (!this.hasRenderFailure()) {
            this.setRenderFailureShown(false);
        }
        this.updateComponentForErrors();
    }

    private void updateComponentForErrors() {
        if (EventQueue.isDispatchThread()) {
            this.doUpdateComponentForErrors();
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    JsfForm.this.doUpdateComponentForErrors();
                }
            });
        }
    }

    private void doUpdateComponentForErrors() {
        this.notifyViewsUpdateErrors();
    }

    void updateGridMode() {
        this.notifyViewsGridModeUpdated(this.isGridMode());
    }

    public boolean isGridMode() {
        return Util.isGridMode((FacesModel)this.getFacesModel());
    }

    void documentReplaced() {
        this.notifyViewsDocumentReplaced();
    }

    void showDropMatch(Element element, Element element2, int n) {
        this.notifyViewsShowDropMatch(element, element2, n);
    }

    void clearDropMatch() {
        this.notifyViewsClearDropMatch();
    }

    void selectComponent(Element element) {
        this.notifyViewsSelectComponent(element);
    }

    void inlineEditComponents(Element[] elementArray) {
        this.notifyViewsInlineEditComponents(elementArray);
    }

    private DomSynchronizer getDomSynchronizer() {
        if (this.domSynchronizer == null) {
            this.domSynchronizer = new DomSynchronizer(this);
        }
        return this.domSynchronizer;
    }

    FacesDndSupport.UpdateSuspender getUpdateSuspender() {
        return this.getDomSynchronizer();
    }

    void requestRefresh() {
        this.getDomSynchronizer().requestRefresh();
    }

    public void refreshModelWithExternals(boolean bl) {
        JsfForm[] jsfFormArray;
        for (JsfForm jsfForm : jsfFormArray = this.findExternals()) {
            jsfForm.refreshModel(bl);
        }
        this.refreshModel(bl);
    }

    private JsfForm[] findExternals() {
        Designer[] designerArray = JsfForm.findDesigners(this);
        if (designerArray.length == 0) {
            return new JsfForm[0];
        }
        Designer designer = designerArray[0];
        DomProvider[] domProviderArray = designer.getExternalDomProviders();
        ArrayList<JsfForm> arrayList = new ArrayList<JsfForm>();
        for (DomProvider domProvider : domProviderArray) {
            JsfForm jsfForm = JsfForm.findJsfFormForDomProvider(domProvider);
            if (jsfForm == null || jsfForm == this) continue;
            arrayList.add(jsfForm);
        }
        return arrayList.toArray(new JsfForm[arrayList.size()]);
    }

    public void refreshModel(boolean bl) {
        this.getFacesModel().refreshAndSyncNonPageBeans(bl);
        this.externalDomProviderCache.flush();
        this.notifyViewsModelRefreshed();
    }

    public void refreshProject() {
        Project project = this.getFacesModel().getProject();
        if (project != null) {
            RefreshServiceImpl.refreshProject(project, false);
        }
    }

    public String toString() {
        return super.toString() + "[facesModel=" + this.getFacesModel() + "]";
    }

    public boolean isFragment() {
        return this.isFragment;
    }

    public boolean isPortlet() {
        return this.isPortlet;
    }

    private void notifyViewsModelChanged() {
        JsfMultiViewElement[] jsfMultiViewElementArray;
        for (JsfMultiViewElement jsfMultiViewElement : jsfMultiViewElementArray = JsfForm.findJsfMultiViewElements(this)) {
            jsfMultiViewElement.modelChanged();
        }
    }

    private void notifyViewsModelRefreshed() {
        JsfMultiViewElement[] jsfMultiViewElementArray;
        for (JsfMultiViewElement jsfMultiViewElement : jsfMultiViewElementArray = JsfForm.findJsfMultiViewElements(this)) {
            jsfMultiViewElement.modelRefreshed();
        }
    }

    private void notifyViewsNodeChanged(org.w3c.dom.Node node, org.w3c.dom.Node node2, Element[] elementArray) {
        JsfMultiViewElement[] jsfMultiViewElementArray;
        for (JsfMultiViewElement jsfMultiViewElement : jsfMultiViewElementArray = JsfForm.findJsfMultiViewElements(this)) {
            jsfMultiViewElement.nodeChanged(node, node2, elementArray);
        }
    }

    private void notifyViewsNodeRemoved(org.w3c.dom.Node node, org.w3c.dom.Node node2) {
        JsfMultiViewElement[] jsfMultiViewElementArray;
        for (JsfMultiViewElement jsfMultiViewElement : jsfMultiViewElementArray = JsfForm.findJsfMultiViewElements(this)) {
            jsfMultiViewElement.nodeRemoved(node, node2);
        }
    }

    private void notifyViewsNodeInserted(org.w3c.dom.Node node, org.w3c.dom.Node node2) {
        JsfMultiViewElement[] jsfMultiViewElementArray;
        for (JsfMultiViewElement jsfMultiViewElement : jsfMultiViewElementArray = JsfForm.findJsfMultiViewElements(this)) {
            jsfMultiViewElement.nodeInserted(node, node2);
        }
    }

    private void notifyViewsGridModeUpdated(boolean bl) {
        JsfMultiViewElement[] jsfMultiViewElementArray;
        for (JsfMultiViewElement jsfMultiViewElement : jsfMultiViewElementArray = JsfForm.findJsfMultiViewElements(this)) {
            jsfMultiViewElement.gridModeUpdated(bl);
        }
    }

    private void notifyViewsDocumentReplaced() {
        JsfMultiViewElement[] jsfMultiViewElementArray;
        for (JsfMultiViewElement jsfMultiViewElement : jsfMultiViewElementArray = JsfForm.findJsfMultiViewElements(this)) {
            jsfMultiViewElement.documentReplaced();
        }
    }

    private void notifyViewsShowDropMatch(Element element, Element element2, int n) {
        JsfMultiViewElement[] jsfMultiViewElementArray;
        for (JsfMultiViewElement jsfMultiViewElement : jsfMultiViewElementArray = JsfForm.findJsfMultiViewElements(this)) {
            jsfMultiViewElement.showDropMatch(element, element2, n);
        }
    }

    private void notifyViewsClearDropMatch() {
        JsfMultiViewElement[] jsfMultiViewElementArray;
        for (JsfMultiViewElement jsfMultiViewElement : jsfMultiViewElementArray = JsfForm.findJsfMultiViewElements(this)) {
            jsfMultiViewElement.clearDropMatch();
        }
    }

    private void notifyViewsSelectComponent(Element element) {
        JsfMultiViewElement[] jsfMultiViewElementArray;
        for (JsfMultiViewElement jsfMultiViewElement : jsfMultiViewElementArray = JsfForm.findJsfMultiViewElements(this)) {
            jsfMultiViewElement.selectComponent(element);
        }
    }

    private void notifyViewsInlineEditComponents(Element[] elementArray) {
        JsfMultiViewElement[] jsfMultiViewElementArray;
        for (JsfMultiViewElement jsfMultiViewElement : jsfMultiViewElementArray = JsfForm.findJsfMultiViewElements(this)) {
            jsfMultiViewElement.inlineEditComponents(elementArray);
        }
    }

    private void notifyViewsUpdateErrors() {
        JsfMultiViewElement[] jsfMultiViewElementArray;
        for (JsfMultiViewElement jsfMultiViewElement : jsfMultiViewElementArray = JsfForm.findJsfMultiViewElements(this)) {
            jsfMultiViewElement.updateErrors();
        }
    }

    private void notifyViewsDesignContextGenerationChanged() {
        JsfMultiViewElement[] jsfMultiViewElementArray;
        for (JsfMultiViewElement jsfMultiViewElement : jsfMultiViewElementArray = JsfForm.findJsfMultiViewElements(this)) {
            jsfMultiViewElement.designContextGenerationChanged();
        }
    }

    private void designContextChanged(DesignContext designContext) {
        long l = designContext instanceof LiveUnit ? ((LiveUnit)designContext).getContextGeneration() : 0L;
        if (l == this.generationSeen) {
            return;
        }
        this.generationSeen = l;
        this.notifyViewsDesignContextGenerationChanged();
    }

    public PaletteController getPaletteController() {
        return this.paletteController;
    }

    static void refreshDesignersInProject(Project project) {
        JsfForm[] jsfFormArray;
        for (JsfForm jsfForm : jsfFormArray = JsfForm.findJsfFormsForProject(project)) {
            jsfForm.refreshProject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JsfForm[] findJsfFormsForProject(Project project) {
        HashSet<JsfForm> hashSet;
        if (project == null) {
            return new JsfForm[0];
        }
        ArrayList<JsfForm> arrayList = new ArrayList<JsfForm>();
        jsfFormsLock.readLock().lock();
        try {
            hashSet = new HashSet<JsfForm>(jsfForms);
        }
        finally {
            jsfFormsLock.readLock().unlock();
        }
        for (JsfForm jsfForm : hashSet) {
            if (project != jsfForm.getFacesModel().getProject() || arrayList.contains(jsfForm)) continue;
            arrayList.add(jsfForm);
        }
        return arrayList.toArray(new JsfForm[arrayList.size()]);
    }

    private void updateRenderFailureValues() {
        Exception exception = this.getRenderFailure();
        MarkupDesignBean markupDesignBean = this.getRenderFailureMarkupDesignBean();
        this.setRenderFailureValues(markupDesignBean, exception);
    }

    private Exception getRenderFailure() {
        FacesPageUnit facesPageUnit = this.getFacesModel().getFacesUnit();
        if (facesPageUnit == null) {
            return null;
        }
        return facesPageUnit.getRenderFailure();
    }

    private MarkupDesignBean getRenderFailureMarkupDesignBean() {
        FacesPageUnit facesPageUnit = this.getFacesModel().getFacesUnit();
        if (facesPageUnit == null) {
            return null;
        }
        DesignBean designBean = facesPageUnit.getRenderFailureComponent();
        if (designBean instanceof MarkupDesignBean) {
            return (MarkupDesignBean)designBean;
        }
        return null;
    }

    private void setRenderFailureValues(MarkupDesignBean markupDesignBean, Exception exception) {
        this.renderFailureComponent = markupDesignBean;
        this.renderFailureException = exception;
    }

    private boolean hasRenderFailure() {
        return this.getRenderFailureException() != null;
    }

    Exception getRenderFailureException() {
        return this.renderFailureException;
    }

    MarkupDesignBean getRenderFailureComponent() {
        return this.renderFailureComponent;
    }

    DndSupport getDndSupport() {
        return this.dndSupport;
    }

    FacesModel.JsfSupport getJsfSupport() {
        return this.getDndSupport();
    }

    public Element getHtmlBody() {
        return this.getHtmlBody(true);
    }

    public Element getHtmlBody(boolean bl) {
        if (!this.isModelValid()) {
            return null;
        }
        Element element = this.getFacesModel().getHtmlBody();
        if (bl) {
            this.updateErrorsInComponent();
        }
        return element;
    }

    public Document getJspDom() {
        return this.getFacesModel().getJspDom();
    }

    public Document getHtmlDom() {
        return this.getFacesModel().getHtmlDom();
    }

    public Element createComponent(String string, org.w3c.dom.Node node, org.w3c.dom.Node node2) {
        DesignBean designBean = this.createBean(string, node, node2);
        return designBean instanceof MarkupDesignBean ? ((MarkupDesignBean)designBean).getElement() : null;
    }

    private DesignBean createBean(String string, org.w3c.dom.Node node, org.w3c.dom.Node node2) {
        MarkupPosition markupPosition = new MarkupPosition(node, node2);
        DesignBean designBean = Util.findParentBean((org.w3c.dom.Node)node);
        LiveUnit liveUnit = this.getFacesModel().getLiveUnit();
        return liveUnit.createBean(string, designBean, (Position)markupPosition);
    }

    public boolean moveComponent(Element element, org.w3c.dom.Node node, org.w3c.dom.Node node2) {
        MarkupDesignBean markupDesignBean = MarkupUnit.getMarkupDesignBeanForElement((Element)element);
        if (markupDesignBean == null) {
            return false;
        }
        LiveUnit liveUnit = this.getLiveUnit();
        MarkupPosition markupPosition = new MarkupPosition(node, node2);
        MarkupDesignBean markupDesignBean2 = null;
        for (org.w3c.dom.Node node3 = node; !(node3 == null || node3 instanceof Element && (markupDesignBean2 = MarkupUnit.getMarkupDesignBeanForElement((Element)((Element)node3))) != null); node3 = node3.getParentNode()) {
        }
        if (markupDesignBean == markupDesignBean2) {
            return false;
        }
        return liveUnit.moveBean((DesignBean)markupDesignBean, (DesignBean)markupDesignBean2, (Position)markupPosition);
    }

    public boolean isInlineEditing() {
        Designer[] designerArray;
        for (Designer designer : designerArray = JsfForm.findDesigners(this)) {
            if (!designer.isInlineEditing()) continue;
            return true;
        }
        return false;
    }

    public UndoEvent writeLock(String string) {
        return this.getFacesModel().writeLock(string);
    }

    public void writeUnlock(UndoEvent undoEvent) {
        this.getFacesModel().writeUnlock(undoEvent);
    }

    public DomDocumentImpl getDomDocumentImpl() {
        return this.domDocumentImpl;
    }

    public boolean isModelInSync() {
        if (this.isValid()) {
            FacesModel facesModel = this.getFacesModel();
            if (facesModel == null) {
                return false;
            }
            MarkupUnit markupUnit = facesModel.getMarkupUnit();
            if (markupUnit == null) {
                return false;
            }
            if (markupUnit.getState() == Unit.State.SOURCEDIRTY) {
                return false;
            }
            JavaUnit javaUnit = facesModel.getJavaUnit();
            if (javaUnit == null) {
                return false;
            }
            return javaUnit.getState() != Unit.State.SOURCEDIRTY;
        }
        return false;
    }

    public void syncModel() {
        if (this.isValid()) {
            this.getFacesModel().sync();
        }
    }

    public void setModelActivated(boolean bl) {
        this.getFacesModel().setActivated(bl);
    }

    boolean isModelValid() {
        FacesModel facesModel = this.getFacesModel();
        if (facesModel == null) {
            return false;
        }
        MarkupUnit markupUnit = facesModel.getMarkupUnit();
        if (markupUnit == null) {
            return false;
        }
        return facesModel.isValid();
    }

    public boolean isModelBusted() {
        return this.getFacesModel().isBusted();
    }

    public void clearHtml() {
        this.getFacesModel().clearHtml();
    }

    public DataObject getJspDataObject() {
        FileObject fileObject = this.getMarkupFile();
        try {
            return DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            JsfForm.log(dataObjectNotFoundException);
            return null;
        }
    }

    public void deleteDesignBean(DesignBean designBean) {
        this.getFacesModel().getLiveUnit().deleteBean(designBean);
    }

    public void setUpdatesSuspended(Element element, boolean bl) {
        MarkupDesignBean markupDesignBean = MarkupUnit.getMarkupDesignBeanForElement((Element)element);
        this.setUpdatesSuspended(markupDesignBean, bl);
    }

    public boolean isWriteLocked() {
        return this.getFacesModel().isWriteLocked();
    }

    public void snapToGrid(Designer designer) {
        this.getDomDocumentImpl().snapToGrid(designer);
    }

    public void align(Designer designer, Alignment alignment) {
        this.getDomDocumentImpl().align(designer, alignment);
    }

    public boolean canPasteTransferable(Element[] elementArray, Transferable transferable) {
        if (transferable != null) {
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            int n = 0;
            if (dataFlavorArray != null) {
                n = dataFlavorArray.length;
            }
            for (int i = 0; i < n; ++i) {
                Object object;
                DataFlavor dataFlavor = dataFlavorArray[i];
                if (FLAVOR_DISPLAY_ITEM.equals(dataFlavor) || dataFlavor.getRepresentationClass() == String.class) {
                    return true;
                }
                if (!dataFlavor.getMimeType().startsWith("application/x-creator-")) continue;
                FacesModel facesModel = this.getFacesModel();
                if (facesModel == null) {
                    return false;
                }
                LiveUnit liveUnit = facesModel.getLiveUnit();
                if (liveUnit == null) {
                    return false;
                }
                MarkupDesignBean markupDesignBean = this.getPrimarySelectedBean(elementArray);
                if (markupDesignBean == null) {
                    markupDesignBean = object = this.getDefaultParentBean();
                }
                if (markupDesignBean == null) {
                    return false;
                }
                try {
                    String[] stringArray;
                    object = transferable.getTransferData(dataFlavor);
                    if (!(object instanceof LiveUnit.ClipImage)) continue;
                    LiveUnit.ClipImage clipImage = (LiveUnit.ClipImage)object;
                    for (String string : stringArray = clipImage.getTypes()) {
                        if (!liveUnit.canCreateBean(string, (DesignBean)markupDesignBean, null)) continue;
                        return true;
                    }
                    continue;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    Exceptions.printStackTrace((Throwable)unsupportedFlavorException);
                    continue;
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        return false;
    }

    private MarkupDesignBean getPrimarySelectedBean(Element[] elementArray) {
        for (Element element : elementArray) {
            MarkupDesignBean markupDesignBean = MarkupUnit.getMarkupDesignBeanForElement((Element)element);
            if (markupDesignBean == null) continue;
            return markupDesignBean;
        }
        return null;
    }

    public UndoRedo getUndoManager() {
        return this.getFacesModel().getUndoManager();
    }

    public int computeActions(Element element, Transferable transferable) {
        MarkupDesignBean markupDesignBean = MarkupUnit.getMarkupDesignBeanForElement((Element)element);
        return this.getDndSupport().computeActions((DesignBean)markupDesignBean, transferable);
    }

    public void attachContext() {
        LiveUnit liveUnit = this.getFacesModel().getLiveUnit();
        if (liveUnit != null) {
            this.updateDesignContextListening((DesignContext)liveUnit);
        }
    }

    public boolean hasRenderingErrors() {
        return this.getRenderFailureComponent() != null;
    }

    public JComponent getErrorPanel(ErrorPanelCallback errorPanelCallback) {
        FacesModel facesModel = this.getFacesModel();
        if (facesModel.isBusted()) {
            return new ErrorPanelImpl(facesModel, facesModel.getErrors(), errorPanelCallback);
        }
        return new RenderErrorPanelImpl(this, errorPanelCallback, new RenderErrorPanelImpl.RenderFailureProvider(){

            public Exception getRenderFailureException() {
                return JsfForm.this.getRenderFailureException();
            }

            public MarkupDesignBean getRenderFailureComponent() {
                return JsfForm.this.getRenderFailureComponent();
            }
        });
    }

    public boolean isSourceDirty() {
        MarkupUnit markupUnit = this.getFacesModel().getMarkupUnit();
        if (markupUnit != null) {
            return markupUnit.getState() == Unit.State.SOURCEDIRTY;
        }
        JsfForm.log(new IllegalStateException("The FacesModel is corrupted, its markup unit is null, facesModel=" + this.getFacesModel()));
        return false;
    }

    public void dumpHtmlMarkupForNode(Node node) {
        DesignBean designBean = (DesignBean)node.getLookup().lookup(DesignBean.class);
        if (designBean instanceof MarkupDesignBean) {
            MarkupDesignBean markupDesignBean = (MarkupDesignBean)designBean;
            Element element = markupDesignBean.getElement();
            Element element2 = MarkupService.getRenderedElementForElement((Element)element);
            if (element2 == null || element == element2) {
                JsfForm.log("Markup design bean not renderable, markup design bean=" + markupDesignBean);
                this.dumpHtmlMarkupDesignBeanHtml();
                return;
            }
            JsfForm.log("Rendered markup design bean=" + markupDesignBean + "\n" + Util.getHtmlStream((Element)element2));
        } else {
            JsfForm.log("Design bean not renderable, design bean=" + designBean);
            this.dumpHtmlMarkupDesignBeanHtml();
        }
    }

    private void dumpHtmlMarkupDesignBeanHtml() {
        DocumentFragment documentFragment = this.getHtmlDomFragment();
        Element element = Util.findDescendant((String)HtmlTag.HTML.name, (org.w3c.dom.Node)documentFragment);
        if (element == null) {
            element = this.getHtmlBody(false);
        }
        JsfForm.log("Rendered html element markup design bean=" + MarkupUnit.getMarkupDesignBeanForElement((Element)element) + "\n" + Util.getHtmlStream((Element)element));
    }

    private DocumentFragment getHtmlDomFragment() {
        return this.getFacesModel().getHtmlDomFragment();
    }

    MarkupDesignBean getDefaultParentBean() {
        DesignBean designBean;
        MarkupBean markupBean;
        LiveUnit liveUnit = this.getLiveUnit();
        if (liveUnit != null && (markupBean = this.getFacesPageUnit().getDefaultParent()) != null && (designBean = liveUnit.getDesignBean((Bean)markupBean)) instanceof MarkupDesignBean) {
            return (MarkupDesignBean)designBean;
        }
        return null;
    }

    public Element getDefaultParentComponent() {
        MarkupDesignBean markupDesignBean = this.getDefaultParentBean();
        return markupDesignBean == null ? null : JsfSupportUtilities.getComponentRootElementForMarkupDesignBean(markupDesignBean);
    }

    public Transferable copyComponents(Element[] liveUnit) {
        ArrayList<MarkupDesignBean> arrayList = new ArrayList<MarkupDesignBean>();
        for (Element element : liveUnit) {
            MarkupDesignBean markupDesignBean = MarkupUnit.getMarkupDesignBeanForElement((Element)element);
            if (markupDesignBean == null) continue;
            arrayList.add(markupDesignBean);
        }
        LiveUnit liveUnit2 = this.getFacesModel().getLiveUnit();
        return liveUnit2.copyBeans(arrayList.toArray(new DesignBean[arrayList.size()]));
    }

    public void deleteComponents(Element[] elementArray) {
        this.getDomDocumentImpl().deleteComponents(elementArray);
    }

    public boolean hasCachedExternalFrames() {
        return this.externalDomProviderCache.size() > 0;
    }

    Designer[] getExternalDesigners(URL uRL) {
        JsfForm jsfForm = this.findExternalForm(uRL);
        if (jsfForm == null) {
            return new Designer[0];
        }
        if (!this.hasRecursiveContextJsfForm(jsfForm)) {
            jsfForm.setContextJsfForm(this);
        }
        return JsfForm.getDesigners(jsfForm);
    }

    private JsfForm findExternalForm(URL uRL) {
        ExternalDomProviderCache externalDomProviderCache = this.externalDomProviderCache;
        JsfForm jsfForm = externalDomProviderCache.get(uRL);
        if (jsfForm != null) {
            if (jsfForm.isModelValid()) {
                return jsfForm;
            }
            externalDomProviderCache.remove(uRL);
        }
        if (uRL == null) {
            return null;
        }
        FileObject fileObject = URLMapper.findFileObject((URL)uRL);
        if (fileObject != null) {
            jsfForm = JsfForm.loadPage(fileObject);
        }
        if (jsfForm == null) {
            jsfForm = JsfForm.loadPage(uRL);
        }
        if (jsfForm != null) {
            externalDomProviderCache.put(uRL, jsfForm);
        }
        return jsfForm;
    }

    private static JsfForm loadPage(URL uRL) {
        return null;
    }

    private static JsfForm loadPage(FileObject fileObject) {
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
        JsfForm jsfForm = JsfForm.getJsfForm(dataObject);
        if (jsfForm != null) {
            jsfForm.syncModel();
        }
        return jsfForm;
    }

    JsfForm getContextJsfForm() {
        if (this.isFragment() && this.contextJsfForm == null) {
            for (FileObject fileObject : Util.getWebPages((Project)this.getFacesModel().getProject(), (boolean)true, (boolean)false)) {
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    if (!JsfSupportUtilities.isWebFormDataObject(dataObject)) continue;
                    this.contextJsfForm = JsfForm.getJsfForm(dataObject);
                    break;
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    JsfForm.log(dataObjectNotFoundException);
                }
            }
        }
        return this.contextJsfForm;
    }

    private void setContextJsfForm(JsfForm jsfForm) {
        if (!this.isFragment()) {
            return;
        }
        if (this.contextJsfForm != jsfForm && this.isValid()) {
            this.clearHtml();
        }
        this.contextJsfForm = jsfForm;
    }

    private boolean hasRecursiveContextJsfForm(JsfForm jsfForm) {
        if (jsfForm == null) {
            return false;
        }
        JsfForm jsfForm2 = this;
        while (jsfForm2 != null) {
            JsfForm jsfForm3 = jsfForm2.getContextJsfForm();
            if (jsfForm3 == jsfForm) {
                return true;
            }
            jsfForm2 = jsfForm3;
        }
        return false;
    }

    public boolean isBraveheartPage() {
        return Util.isBraveheartPage((Document)this.getJspDom());
    }

    public boolean isWoodstockPage() {
        return Util.isWoodstockPage((Document)this.getJspDom());
    }

    public void setRenderFailureShown(boolean bl) {
        this.renderFailureShown = bl;
    }

    public boolean isRenderFailureShown() {
        return this.renderFailureShown;
    }

    public boolean editEventHandlerForComponent(Element element) {
        MarkupDesignBean markupDesignBean = MarkupUnit.getMarkupDesignBeanForElement((Element)element);
        if (markupDesignBean == null) {
            this.getFacesModel().openDefaultHandler();
            return false;
        }
        if (JsfForm.isXhtmlComponent((DesignBean)markupDesignBean)) {
            MarkupBean markupBean = Util.getMarkupBean((DesignBean)markupDesignBean);
            MarkupUnit markupUnit = this.getFacesModel().getMarkupUnit();
            JsfForm.showLineAt(markupUnit.getFileObject(), markupUnit.computeLine(markupBean.getElement()), 0);
        } else {
            this.getFacesModel().openDefaultHandler((DesignBean)markupDesignBean);
        }
        return true;
    }

    private static boolean isXhtmlComponent(DesignBean designBean) {
        MarkupBean markupBean = Util.getMarkupBean((DesignBean)designBean);
        return markupBean != null && !(markupBean instanceof FacesBean);
    }

    private static void showLineAt(FileObject fileObject, int n, int n2) {
        Line.Set set;
        LineCookie lineCookie;
        DataObject dataObject;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            JsfForm.log(dataObjectNotFoundException);
            return;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie != null) {
            try {
                editorCookie.openDocument();
            }
            catch (IOException iOException) {
                JsfForm.log(iOException);
                return;
            }
        }
        if ((lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class)) != null && (set = lineCookie.getLineSet()) != null) {
            Line line = set.getCurrent(n - 1);
            line.show(2, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Designer[] getDesigners() {
        HashSet<Designer> hashSet;
        designersLock.readLock().lock();
        try {
            hashSet = new HashSet<Designer>(this.designers);
        }
        finally {
            designersLock.readLock().unlock();
        }
        return hashSet.toArray(new Designer[hashSet.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDesigner(Designer designer) {
        designersLock.writeLock().lock();
        try {
            this.designers.add(designer);
        }
        finally {
            designersLock.writeLock().unlock();
        }
    }

    public boolean isRenderedNode(org.w3c.dom.Node node) {
        if (node == null) {
            return false;
        }
        return node.getOwnerDocument() == this.getHtmlDom();
    }

    public void setVirtualFormsSupportEnabled(boolean bl) {
        this.virtualFormsSupportEnabled = bl;
        this.tcRepaint();
    }

    public boolean isVirtualFormsSupportEnabled() {
        return this.virtualFormsSupportEnabled;
    }

    public void setAjaxTransactionsSupportEnabled(boolean bl) {
        this.ajaxTransactionsSupportEnabled = bl;
        this.tcRepaint();
    }

    public boolean isAjaxTransactionsSupportEnabled() {
        return this.ajaxTransactionsSupportEnabled;
    }

    public void tcRepaint() {
        Designer[] designerArray;
        for (Designer designer : designerArray = JsfForm.findDesigners(this)) {
            JsfMultiViewElement jsfMultiViewElement = JsfForm.findJsfMultiViewElementForDesigner(designer);
            if (jsfMultiViewElement == null) continue;
            jsfMultiViewElement.getJsfTopComponent().repaint();
        }
    }

    DocumentFragment renderMarkupDesignBean(MarkupDesignBean markupDesignBean) {
        return this.renderMarkupDesignBean(markupDesignBean, true);
    }

    DocumentFragment renderMarkupDesignBean(MarkupDesignBean markupDesignBean, boolean bl) {
        return FacesPageUnit.renderHtml((FacesModel)this.getFacesModel(), (MarkupDesignBean)markupDesignBean, (boolean)bl);
    }

    LiveUnit getLiveUnit() {
        return this.getFacesModel().getLiveUnit();
    }

    Project getProject() {
        return this.getFacesModel().getProject();
    }

    FileObject getMarkupFile() {
        return this.getFacesModel().getMarkupFile();
    }

    FacesPageUnit getFacesPageUnit() {
        return this.getFacesModel().getFacesUnit();
    }

    void customizeCreation(DesignBean[] designBeanArray) {
        Util.customizeCreation((DesignBean[])designBeanArray, (FacesModel)this.getFacesModel());
    }

    void designBeanCreated(DesignBean designBean) {
        this.getFacesModel().beanCreated(designBean);
    }

    public void handleResult(Result result) {
        ResultHandler.handleResult((Result)result, (FacesModel)this.getFacesModel());
    }

    void linkDesignBeans(DesignBean designBean, DesignBean designBean2) {
        this.getFacesModel().linkBeans(designBean, designBean2);
    }

    DesignBean findParent(String string, DesignBean designBean, org.w3c.dom.Node node, boolean bl) {
        return Util.findParent((String)string, (DesignBean)designBean, (org.w3c.dom.Node)node, (boolean)bl, (FacesModel)this.getFacesModel());
    }

    public boolean isFormComponent(Element element) {
        MarkupDesignBean markupDesignBean = MarkupUnit.getMarkupDesignBeanForElement((Element)element);
        if (markupDesignBean == null) {
            return false;
        }
        return this.isFormDesignBean((DesignBean)markupDesignBean);
    }

    boolean isFormDesignBean(DesignBean designBean) {
        return Util.isFormBean((FacesModel)this.getFacesModel(), (DesignBean)designBean);
    }

    MarkupUnit getMarkupUnit() {
        return this.getFacesModel().getMarkupUnit();
    }

    public Node getRootBeanNode() {
        FacesModel facesModel = this.getFacesModel();
        DesignBean designBean = facesModel.getRootBean();
        if (designBean == null) {
            if (!facesModel.isBusted()) {
                JsfForm.log(new IllegalStateException("Invalid FacesModel, it is not busted and its root design bean is null, facesModel=" + facesModel));
            }
            return null;
        }
        return DesigntimeIdeBridgeProvider.getDefault().getNodeRepresentation(designBean);
    }

    private static void log(Throwable throwable) {
        Logger logger = JsfForm.getLogger();
        logger.log(Level.INFO, null, throwable);
    }

    private static void log(String string) {
        Logger logger = JsfForm.getLogger();
        logger.log(Level.INFO, string);
    }

    private static void notify(Throwable throwable) {
        Logger logger = JsfForm.getLogger();
        logger.log(Level.SEVERE, null, throwable);
    }

    private static Logger getLogger() {
        return Logger.getLogger(JsfForm.class.getName());
    }

    public boolean isValid() {
        return this.getFacesModel() != null;
    }

    private FacesModel loadFacesModel(DataObject dataObject) {
        FacesModel facesModel;
        try {
            facesModel = JsfForm.getFacesModel(dataObject);
        }
        catch (Exception exception) {
            this.loadingFailed(new IllegalStateException("FacesModel was not loaded for DataObject, dataObject=" + dataObject, exception));
            return null;
        }
        if (facesModel == null) {
            this.loadingFailed(new NullPointerException("No FacesModel for DataObject, dataObject=" + dataObject));
            return null;
        }
        return facesModel;
    }

    private void loadingFailed(Exception exception) {
        JsfForm.notify(exception);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JsfForm.this.notifyViewsModelLoadingFailed();
            }
        });
    }

    private void notifyViewsModelLoaded() {
        JsfMultiViewElement[] jsfMultiViewElementArray;
        for (JsfMultiViewElement jsfMultiViewElement : jsfMultiViewElementArray = JsfForm.findJsfMultiViewElements(this)) {
            jsfMultiViewElement.modelLoaded();
        }
    }

    private void notifyViewsModelLoadingFailed() {
        JsfMultiViewElement[] jsfMultiViewElementArray;
        for (JsfMultiViewElement jsfMultiViewElement : jsfMultiViewElementArray = JsfForm.findJsfMultiViewElements(this)) {
            jsfMultiViewElement.closeMultiView();
        }
    }

    private static class JsfDesignProjectListener
    implements DesignProjectListener {
        private JsfDesignProjectListener() {
        }

        public void contextOpened(DesignContext designContext) {
        }

        public void contextClosed(DesignContext designContext) {
            JsfMultiViewElement[] jsfMultiViewElementArray;
            JsfForm jsfForm = JsfForm.findJsfForm(designContext);
            for (JsfMultiViewElement jsfMultiViewElement : jsfMultiViewElementArray = JsfForm.findJsfMultiViewElements(jsfForm)) {
                jsfMultiViewElement.closeMultiView();
            }
        }
    }

    private static class JsfDesignContextListener
    implements DesignContextListener {
        private final JsfForm jsfForm;

        public JsfDesignContextListener(JsfForm jsfForm) {
            this.jsfForm = jsfForm;
        }

        public void contextActivated(DesignContext designContext) {
            this.jsfForm.getDomSynchronizer().contextActivated(designContext);
        }

        public void contextDeactivated(DesignContext designContext) {
            this.jsfForm.getDomSynchronizer().contextDeactivated(designContext);
        }

        public void contextChanged(DesignContext designContext) {
            this.jsfForm.getDomSynchronizer().contextChanged(designContext);
            this.jsfForm.designContextChanged(designContext);
        }

        public void beanCreated(DesignBean designBean) {
            this.jsfForm.getDomSynchronizer().beanCreated(designBean);
        }

        public void beanDeleted(DesignBean designBean) {
            this.jsfForm.getDomSynchronizer().beanDeleted(designBean);
        }

        public void beanMoved(DesignBean designBean, DesignBean designBean2, Position position) {
            this.jsfForm.getDomSynchronizer().beanMoved(designBean, designBean2, position);
        }

        public void beanContextActivated(DesignBean designBean) {
            this.jsfForm.getDomSynchronizer().beanContextActivated(designBean);
        }

        public void beanContextDeactivated(DesignBean designBean) {
            this.jsfForm.getDomSynchronizer().beanContextDeactivated(designBean);
        }

        public void instanceNameChanged(DesignBean designBean, String string) {
            this.jsfForm.getDomSynchronizer().instanceNameChanged(designBean, string);
        }

        public void beanChanged(DesignBean designBean) {
            this.jsfForm.getDomSynchronizer().beanChanged(designBean);
        }

        public void propertyChanged(DesignProperty designProperty, Object object) {
            this.jsfForm.getDomSynchronizer().propertyChanged(designProperty, object);
        }

        public void eventChanged(DesignEvent designEvent) {
            this.jsfForm.getDomSynchronizer().eventChanged(designEvent);
        }
    }

    public static interface ErrorPanelCallback {
        public void updateTopComponentForErrors();

        public void setRenderFailureShown(boolean var1);

        public void handleRefresh(boolean var1);
    }

    public static interface ErrorPanel {
        public void updateErrors();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Alignment {
        SNAP_TO_GRID,
        TOP,
        MIDDLE,
        BOTTOM,
        LEFT,
        CENTER,
        RIGHT;

    }
}

