/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.modules.welcome.WelcomeOptions;
import org.netbeans.modules.welcome.content.Constants;
import org.netbeans.modules.welcome.content.Utils;
import org.openide.util.Utilities;

class Tabs
extends JPanel
implements Constants {
    private JScrollPane leftComp;
    private JScrollPane rightComp;
    private JComponent leftTab;
    private JComponent rightTab;
    private JPanel tabContent;
    private Image imgStripWest;
    private Image imgStripCenter;
    private Image imgStripEast;

    public Tabs(String string, JComponent jComponent, String string2, JComponent jComponent2) {
        super(new BorderLayout());
        boolean bl;
        this.setOpaque(false);
        this.leftTab = jComponent;
        this.rightTab = jComponent2;
        this.imgStripCenter = Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/strip_bottom_center.png");
        this.imgStripWest = Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/strip_bottom_west.png");
        this.imgStripEast = Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/strip_bottom_east.png");
        final Tab tab = new Tab(string, true);
        final Tab tab2 = new Tab(string2, false);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = actionEvent.getSource() == tab;
                tab.setSelected(bl);
                tab2.setSelected(!bl);
                Tabs.this.switchTab(bl);
                WelcomeOptions.getDefault().setLastActiveTab(bl ? 0 : 1);
            }
        };
        tab.addActionListener(actionListener);
        tab2.addActionListener(actionListener);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setOpaque(true);
        jPanel.add(tab);
        jPanel.add(tab2);
        jPanel.setBackground(Utils.getColor("TabUnselectedBackgroundColor"));
        this.add((Component)jPanel, "North");
        this.tabContent = new JPanel(new CardLayout());
        this.tabContent.setOpaque(false);
        this.add((Component)this.tabContent, "Center");
        int n = WelcomeOptions.getDefault().getLastActiveTab();
        boolean bl2 = bl = n <= 0;
        if (WelcomeOptions.getDefault().isSecondStart() && n < 0) {
            bl = false;
            WelcomeOptions.getDefault().setLastActiveTab(1);
        }
        tab.setSelected(bl);
        tab2.setSelected(!bl);
        this.switchTab(bl);
    }

    private void switchTab(boolean bl) {
        JScrollPane jScrollPane;
        JScrollPane jScrollPane2 = bl ? this.leftComp : this.rightComp;
        JScrollPane jScrollPane3 = jScrollPane = bl ? this.rightComp : this.leftComp;
        if (null == jScrollPane2) {
            jScrollPane2 = new JScrollPane(bl ? this.leftTab : this.rightTab);
            jScrollPane2.setOpaque(false);
            jScrollPane2.getViewport().setOpaque(false);
            jScrollPane2.setBorder(BorderFactory.createEmptyBorder());
            if (bl) {
                this.leftComp = jScrollPane2;
                this.tabContent.add((Component)this.leftComp, "left");
            } else {
                this.rightComp = jScrollPane2;
                this.tabContent.add((Component)this.rightComp, "right");
            }
        }
        if (null != jScrollPane) {
            jScrollPane.setVisible(false);
        }
        jScrollPane2.setVisible(true);
        jScrollPane2.requestFocusInWindow();
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    private static class Tab
    extends JPanel {
        private boolean isLeftTab;
        private Image imgUnselBottom;
        private Image imgSelLeft;
        private Image imgSelUpperLeft;
        private Image imgSelLowerLeft;
        private Image imgSelRight;
        private Image imgSelUpperRight;
        private Image imgSelLowerRight;
        private boolean isSelected = false;
        private ActionListener actionListener;
        private JLabel lbl;

        public Tab(String string, boolean bl) {
            super(new GridBagLayout());
            this.isLeftTab = bl;
            this.imgUnselBottom = Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_unsel_bottom.png");
            if (bl) {
                this.imgSelLeft = Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_sel_right.png");
                this.imgSelUpperLeft = Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_sel_upper_right.png");
                this.imgSelLowerLeft = Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_sel_lower_right.png");
            } else {
                this.imgSelRight = Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_sel_left.png");
                this.imgSelUpperRight = Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_sel_upper_left.png");
                this.imgSelLowerRight = Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/tab_sel_lower_left.png");
            }
            this.lbl = new JLabel(string);
            this.lbl.setOpaque(false);
            this.add((Component)this.lbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 4, 0), 0, 0));
            this.lbl.setFont(Constants.TAB_FONT);
            this.lbl.setForeground(Utils.getColor(this.isSelected ? "TabSelForegroundColor" : "TabUnselForegroundColor"));
            this.lbl.setHorizontalAlignment(0);
            this.lbl.setFocusable(true);
            this.lbl.addKeyListener(new KeyListener(){

                public void keyTyped(KeyEvent keyEvent) {
                }

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 32 || keyEvent.getKeyCode() == 10) {
                        Tab.this.setSelected(!Tab.this.isSelected);
                        if (null != Tab.this.actionListener) {
                            Tab.this.actionListener.actionPerformed(new ActionEvent(Tab.this, 0, "clicked"));
                        }
                    }
                }

                public void keyReleased(KeyEvent keyEvent) {
                }
            });
            this.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    Tab.this.setSelected(!Tab.this.isSelected);
                    if (null != Tab.this.actionListener) {
                        Tab.this.actionListener.actionPerformed(new ActionEvent(Tab.this, 0, "clicked"));
                    }
                }

                public void mousePressed(MouseEvent mouseEvent) {
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    if (!Tab.this.isSelected) {
                        Tab.this.setCursor(Cursor.getPredefinedCursor(12));
                        Tab.this.lbl.setForeground(Utils.getColor("MouseOverTabColor"));
                    } else {
                        Tab.this.setCursor(Cursor.getDefaultCursor());
                    }
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    Tab.this.setCursor(Cursor.getDefaultCursor());
                    Tab.this.lbl.setForeground(Utils.getColor(Tab.this.isSelected ? "TabSelForegroundColor" : "TabUnselForegroundColor"));
                }
            });
            this.lbl.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    Tab.this.lbl.setForeground(Utils.getColor("MouseOverLinkColor"));
                }

                public void focusLost(FocusEvent focusEvent) {
                    Tab.this.lbl.setForeground(Utils.getColor(Tab.this.isSelected ? "TabSelForegroundColor" : "TabUnselForegroundColor"));
                }
            });
        }

        public void addActionListener(ActionListener actionListener) {
            assert (null == this.actionListener);
            this.actionListener = actionListener;
        }

        public void setSelected(boolean bl) {
            this.isSelected = bl;
            this.lbl.setForeground(Utils.getColor(this.lbl.isFocusOwner() ? "MouseOverLinkColor" : (this.isSelected ? "TabSelForegroundColor" : "TabUnselForegroundColor")));
            this.lbl.setFocusable(!bl);
            this.repaint();
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.setColor(Utils.getColor(this.isSelected ? "TabSelectedBackgroundColor" : "TabUnselectedBackgroundColor"));
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics.fillRect(0, 0, n, n2);
            if (this.isSelected) {
                if (this.isLeftTab) {
                    graphics.setColor(Utils.getColor("TabUnselectedBackgroundColor"));
                    graphics.fillRect(n - this.imgSelUpperLeft.getWidth(null), 0, n, n2);
                    graphics.setColor(Utils.getColor("TabSelectedBackgroundColor"));
                    int n3 = this.imgSelLeft.getWidth(null);
                    graphics.drawImage(this.imgSelUpperLeft, n - this.imgSelUpperLeft.getWidth(null), 0, null);
                    for (int i = 0; i < n2 - this.imgSelUpperLeft.getHeight(null); ++i) {
                        graphics.drawImage(this.imgSelLeft, n - n3 - 1, this.imgSelUpperLeft.getHeight(null) + i, null);
                    }
                    graphics.fillRect(n - this.imgSelUpperLeft.getWidth(null), this.imgSelUpperLeft.getHeight(null), this.imgSelUpperLeft.getWidth(null) - n3, n2 - this.imgSelUpperLeft.getHeight(null));
                } else {
                    graphics.setColor(Utils.getColor("TabUnselectedBackgroundColor"));
                    graphics.fillRect(0, 0, this.imgSelUpperRight.getWidth(null), n2);
                    graphics.setColor(Utils.getColor("TabSelectedBackgroundColor"));
                    graphics.drawImage(this.imgSelUpperRight, 0, 0, null);
                    for (int i = 0; i < n2 - this.imgSelUpperRight.getHeight(null); ++i) {
                        graphics.drawImage(this.imgSelRight, 1, this.imgSelUpperRight.getHeight(null) + i, null);
                    }
                    graphics.fillRect(this.imgSelRight.getWidth(null), this.imgSelUpperRight.getHeight(null), this.imgSelUpperRight.getWidth(null) - this.imgSelRight.getWidth(null), n2 - this.imgSelUpperRight.getHeight(null));
                }
            } else {
                int n4 = this.imgUnselBottom.getWidth(null);
                int n5 = this.imgUnselBottom.getHeight(null);
                for (int i = 0; i < n / n4 + 1; ++i) {
                    graphics.drawImage(this.imgUnselBottom, i * n4, n2 - n5, null);
                }
            }
        }

        protected void paintBorder(Graphics graphics) {
        }
    }
}

