/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.welcome.content.ActionButton;
import org.netbeans.modules.welcome.content.BundleSupport;
import org.netbeans.modules.welcome.content.Constants;
import org.netbeans.modules.welcome.content.Utils;
import org.netbeans.modules.welcome.content.WebLink;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;

class LearnMore
extends JPanel
implements Constants {
    public LearnMore() {
        super(new GridBagLayout());
        this.setOpaque(false);
        this.buildContent();
    }

    private void buildContent() {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("WelcomePage/LearnMoreLinks");
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        DataObject[] dataObjectArray = dataFolder.getChildren();
        JPanel jPanel = new JPanel(new GridLayout(0, 2, 15, 5));
        jPanel.setOpaque(false);
        for (int i = 0; i < dataObjectArray.length; ++i) {
            this.addLink(jPanel, dataObjectArray[i]);
        }
        this.add((Component)jPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        WebLink webLink = new WebLink("MoreTutorials", false);
        this.add((Component)webLink, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(20, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void addLink(JPanel jPanel, DataObject dataObject) {
        OpenCookie openCookie = (OpenCookie)dataObject.getCookie(InstanceCookie.class);
        if (null != openCookie) {
            LinkAction linkAction = new LinkAction(dataObject);
            ActionButton actionButton = new ActionButton(linkAction, true, Utils.getUrlString(dataObject));
            actionButton.getAccessibleContext().setAccessibleName(actionButton.getText());
            actionButton.getAccessibleContext().setAccessibleDescription(BundleSupport.getAccessibilityDescription("LearnMore", actionButton.getText()));
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel2.setOpaque(false);
            jPanel2.add((Component)actionButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            jPanel2.add((Component)new JLabel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            jPanel.add(jPanel2);
        }
    }

    private static class LinkAction
    extends AbstractAction {
        private DataObject dob;

        public LinkAction(DataObject dataObject) {
            super(dataObject.getNodeDelegate().getDisplayName());
            this.dob = dataObject;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OpenCookie openCookie = (OpenCookie)this.dob.getCookie(OpenCookie.class);
            if (null != openCookie) {
                openCookie.open();
            }
        }
    }
}

